/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.element;

import com.kms.katalon.composer.mobile.objectspy.element.Converter;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.mobile.keyword.internal.AndroidProperties;
import com.kms.katalon.core.mobile.keyword.internal.IOSProperties;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CapturedMobileElementConverterV2
implements Converter<CapturedMobileElement, MobileElementEntity> {
    @Override
    public MobileElementEntity convert(CapturedMobileElement capturedElement) {
        MobileElementEntity mobileElement = new MobileElementEntity();
        mobileElement.setName(capturedElement.getName());
        mobileElement.setLocator(capturedElement.getLocator());
        mobileElement.setLocatorStrategy(capturedElement.getLocatorStrategy());
        ArrayList<WebElementPropertyEntity> properties = new ArrayList<WebElementPropertyEntity>();
        for (Map.Entry<String, String> attributes : capturedElement.getAttributes().entrySet()) {
            WebElementPropertyEntity prop = new WebElementPropertyEntity(attributes.getKey(), attributes.getValue());
            properties.add(prop);
        }
        if (mobileElement.getLocatorStrategy() == MobileElementEntity.LocatorStrategy.ATTRIBUTES) {
            ArrayList<String> typicalProps = new ArrayList<String>();
            typicalProps.addAll(Arrays.asList(AndroidProperties.ANDROID_TYPICAL_PROPERTIES));
            typicalProps.addAll(Arrays.asList(IOSProperties.IOS_TYPICAL_PROPERTIES));
            properties.forEach(property -> property.setIsSelected(Boolean.valueOf(typicalProps.contains(property.getName()))));
        }
        mobileElement.setWebElementProperties(properties);
        return mobileElement;
    }

    public MobileElementEntity convert(CapturedMobileElement mobileElement, FolderEntity folder, MobileDriverType currentMobileType) throws Exception {
        MobileElementEntity newMobileElement = this.convert(mobileElement);
        newMobileElement.setName(ObjectRepositoryController.getInstance().getAvailableWebElementName(folder, ObjectRepositoryController.toValidFileName((String)StringUtils.trim((String)mobileElement.getName()))));
        newMobileElement.setParentFolder(folder);
        newMobileElement.setProject(folder.getProject());
        return newMobileElement;
    }

    public MobileElementEntity convert(CapturedMobileElement mobileElement, FolderEntity folder) throws Exception {
        MobileElementEntity newMobileElement = this.convert(mobileElement);
        newMobileElement.setName(ObjectRepositoryController.getInstance().getAvailableWebElementName(folder, ObjectRepositoryController.toValidFileName((String)StringUtils.trim((String)mobileElement.getName()))));
        newMobileElement.setParentFolder(folder);
        newMobileElement.setProject(folder.getProject());
        return newMobileElement;
    }

    @Override
    public CapturedMobileElement revert(MobileElementEntity mobileElement) {
        CapturedMobileElement capturedElement = new CapturedMobileElement();
        mobileElement.setName(mobileElement.getName());
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (WebElementPropertyEntity propertyEntity : mobileElement.getWebElementProperties()) {
            attributes.put(propertyEntity.getName(), propertyEntity.getValue());
        }
        capturedElement.setAttributes(attributes);
        capturedElement.setLocator(mobileElement.getLocator());
        capturedElement.setLocatorStrategy(mobileElement.getLocatorStrategy());
        return capturedElement;
    }

    public List<WebElementPropertyEntity> convertProperties(Map<String, String> attributes) {
        ArrayList<WebElementPropertyEntity> properties = new ArrayList<WebElementPropertyEntity>();
        ArrayList<String> typicalProps = new ArrayList<String>();
        typicalProps.addAll(Arrays.asList(AndroidProperties.ANDROID_TYPICAL_PROPERTIES));
        typicalProps.addAll(Arrays.asList(IOSProperties.IOS_TYPICAL_PROPERTIES));
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            WebElementPropertyEntity propEntity = new WebElementPropertyEntity(entry.getKey(), entry.getValue());
            propEntity.setIsSelected(Boolean.valueOf(typicalProps.contains(propEntity.getName())));
            properties.add(propEntity);
        }
        return properties;
    }
}

