/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.element.impl;

import com.kms.katalon.composer.mobile.objectspy.element.impl.RenderedTreeSnapshotMobileElement;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.mobile.keyword.internal.MobileSearchEngine;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.entity.repository.MobileElementEntity;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.ios.IOSDriver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.WebElement;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IosXCUISnapshotMobileElement
extends RenderedTreeSnapshotMobileElement<Element> {
    private static final long serialVersionUID = 1L;

    public IosXCUISnapshotMobileElement() {
    }

    public IosXCUISnapshotMobileElement(IosXCUISnapshotMobileElement parent) {
        super(parent);
    }

    @Override
    public void render(Element xmlElement) {
        if (xmlElement == null) {
            return;
        }
        this.convertXMLElementToWebElementForXCUITestElement(xmlElement);
        if (!xmlElement.hasChildNodes()) {
            return;
        }
        NodeList childElementNodes = xmlElement.getChildNodes();
        int count = childElementNodes.getLength();
        int i = 0;
        while (i < count) {
            Node node = childElementNodes.item(i);
            if (node instanceof Element) {
                IosXCUISnapshotMobileElement childNode = new IosXCUISnapshotMobileElement(this);
                this.getChildrenElement().add(childNode);
                childNode.render((Element)node);
            }
            ++i;
        }
    }

    public void convertXMLElementToWebElementForXCUITestElement(Element xmlElement) {
        Map<String, String> htmlMobileElementProps = this.getAttributes();
        NamedNodeMap attributesNodeMap = xmlElement.getAttributes();
        htmlMobileElementProps.put("type", xmlElement.getTagName());
        int index = 0;
        while (index < attributesNodeMap.getLength()) {
            String nodeValue;
            Node atrributeNode = attributesNodeMap.item(index);
            if (!(atrributeNode.getNodeType() != 2 || StringUtils.isEmpty((String)(nodeValue = atrributeNode.getNodeValue())) || nodeValue.length() == 1 && nodeValue.codePointAt(0) == 65532)) {
                htmlMobileElementProps.put(atrributeNode.getNodeName(), nodeValue);
            }
            ++index;
        }
        this.getAttributes().put("xpath", this.makeXpath());
        this.setName(this.getNameForElement(htmlMobileElementProps));
        this.doubleDimensionValues(htmlMobileElementProps);
    }

    private String getNameForElement(Map<String, String> htmlMobileElementProps) {
        String guiName = htmlMobileElementProps.get("type");
        String propName = htmlMobileElementProps.get("name");
        if (propName != null) {
            return String.valueOf(guiName) + " - " + propName;
        }
        String propLabel = htmlMobileElementProps.get("label");
        if (propLabel != null) {
            return String.valueOf(guiName) + " - " + propLabel;
        }
        String propValue = htmlMobileElementProps.get("value");
        if (propValue != null) {
            return String.valueOf(guiName) + " - " + propValue;
        }
        return guiName;
    }

    private void doubleDimensionValues(Map<String, String> htmlMobileElementProps) {
        this.doubleValue(htmlMobileElementProps, "x");
        this.doubleValue(htmlMobileElementProps, "y");
        this.doubleValue(htmlMobileElementProps, "height");
        this.doubleValue(htmlMobileElementProps, "width");
    }

    private void doubleValue(Map<String, String> htmlMobileElementProps, String propertyName) {
        String elementProperty = htmlMobileElementProps.get(propertyName);
        if (elementProperty == null) {
            return;
        }
        Double propertyDoubleValue = Double.parseDouble(elementProperty);
        htmlMobileElementProps.put(propertyName, String.valueOf(propertyDoubleValue * 2.0));
    }

    @Override
    public void buildLocator(AppiumDriver<?> appiumDriver) {
        List elements;
        List elements2;
        WebElement element;
        WebElement element2;
        IOSDriver driver = (IOSDriver)appiumDriver;
        MobileTestObject testObject = new MobileTestObject("");
        ArrayList<TestObjectProperty> properties = new ArrayList<TestObjectProperty>();
        for (Map.Entry<String, String> attr : this.getAttributes().entrySet()) {
            TestObjectProperty prop = new TestObjectProperty(attr.getKey(), ConditionType.EQUALS, attr.getValue());
            prop.setActive(true);
            if (attr.getKey().equals("visible")) {
                prop.setActive(false);
            }
            properties.add(prop);
        }
        testObject.setProperties(properties);
        MobileSearchEngine searchEngine = new MobileSearchEngine((AppiumDriver)driver, (TestObject)testObject);
        String attributesLocator = searchEngine.findIOSAttributesLocator();
        if (StringUtils.isNotEmpty((String)attributesLocator) && (element2 = driver.findElementByXPath(attributesLocator)) != null) {
            this.setLocator(attributesLocator);
            this.setLocatorStrategy(MobileElementEntity.LocatorStrategy.ATTRIBUTES);
            return;
        }
        String accessibilityLocator = searchEngine.findIOSAccessibilityId();
        if (StringUtils.isNotEmpty((String)accessibilityLocator) && (element = driver.findElementByXPath(accessibilityLocator)) != null) {
            this.setLocator(accessibilityLocator);
            this.setLocatorStrategy(MobileElementEntity.LocatorStrategy.ACCESSIBILITY);
            return;
        }
        String nameLocator = searchEngine.findIOSName();
        if (StringUtils.isNotEmpty((String)nameLocator) && (elements2 = driver.findElementsByName(nameLocator)) != null && elements2.size() == 1) {
            this.setLocator(nameLocator);
            this.setLocatorStrategy(MobileElementEntity.LocatorStrategy.NAME);
            return;
        }
        String iOSClassChainLocator = searchEngine.findIOSClassChain();
        if (StringUtils.isNotEmpty((String)iOSClassChainLocator) && (elements = driver.findElementsByIosClassChain(iOSClassChainLocator)) != null && elements.size() == 1) {
            this.setLocator(iOSClassChainLocator);
            this.setLocatorStrategy(MobileElementEntity.LocatorStrategy.IOS_CLASS_CHAIN);
            return;
        }
        this.setLocator(this.getXpath());
        this.setLocatorStrategy(MobileElementEntity.LocatorStrategy.XPATH);
    }

    @Override
    public MobileDriverType getMobileDriverType() {
        return MobileDriverType.IOS_DRIVER;
    }

    @Override
    public String getTagName() {
        return this.getAttributes().get("type");
    }
}

