/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.DataInput;
import java.io.IOException;
import net.lingala.zip4j.exception.ZipException;

public class Raw {
    public static long readLongLittleEndian(byte[] array, int pos) {
        long temp = 0L;
        temp |= (long)(array[pos + 7] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 6] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 5] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 4] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 3] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 2] & 0xFF);
        temp <<= 8;
        temp |= (long)(array[pos + 1] & 0xFF);
        temp <<= 8;
        return temp |= (long)(array[pos] & 0xFF);
    }

    public static int readLeInt(DataInput di, byte[] b) throws ZipException {
        try {
            di.readFully(b, 0, 4);
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF | (b[3] & 0xFF) << 8) << 16;
    }

    public static int readShortLittleEndian(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    public static final short readShortBigEndian(byte[] array, int pos) {
        short temp = 0;
        temp = (short)(temp | array[pos] & 0xFF);
        temp = (short)(temp << 8);
        temp = (short)(temp | array[pos + 1] & 0xFF);
        return temp;
    }

    public static int readIntLittleEndian(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8 | (b[off + 2] & 0xFF | (b[off + 3] & 0xFF) << 8) << 16;
    }

    public static byte[] toByteArray(int in, int outSize) {
        byte[] out = new byte[outSize];
        byte[] intArray = Raw.toByteArray(in);
        for (int i = 0; i < intArray.length && i < outSize; ++i) {
            out[i] = intArray[i];
        }
        return out;
    }

    public static byte[] toByteArray(int in) {
        byte[] out = new byte[]{(byte)in, (byte)(in >> 8), (byte)(in >> 16), (byte)(in >> 24)};
        return out;
    }

    public static final void writeShortLittleEndian(byte[] array, int pos, short value) {
        array[pos + 1] = (byte)(value >>> 8);
        array[pos] = (byte)(value & 0xFF);
    }

    public static final void writeIntLittleEndian(byte[] array, int pos, int value) {
        array[pos + 3] = (byte)(value >>> 24);
        array[pos + 2] = (byte)(value >>> 16);
        array[pos + 1] = (byte)(value >>> 8);
        array[pos] = (byte)(value & 0xFF);
    }

    public static void writeLongLittleEndian(byte[] array, int pos, long value) {
        array[pos + 7] = (byte)(value >>> 56);
        array[pos + 6] = (byte)(value >>> 48);
        array[pos + 5] = (byte)(value >>> 40);
        array[pos + 4] = (byte)(value >>> 32);
        array[pos + 3] = (byte)(value >>> 24);
        array[pos + 2] = (byte)(value >>> 16);
        array[pos + 1] = (byte)(value >>> 8);
        array[pos] = (byte)(value & 0xFFL);
    }

    public static byte bitArrayToByte(int[] bitArray) throws ZipException {
        if (bitArray == null) {
            throw new ZipException("bit array is null, cannot calculate byte from bits");
        }
        if (bitArray.length != 8) {
            throw new ZipException("invalid bit array length, cannot calculate byte");
        }
        if (!Raw.checkBits(bitArray)) {
            throw new ZipException("invalid bits provided, bits contain other values than 0 or 1");
        }
        int retNum = 0;
        for (int i = 0; i < bitArray.length; ++i) {
            retNum = (int)((double)retNum + Math.pow(2.0, i) * (double)bitArray[i]);
        }
        return (byte)retNum;
    }

    private static boolean checkBits(int[] bitArray) {
        for (int i = 0; i < bitArray.length; ++i) {
            if (bitArray[i] == 0 || bitArray[i] == 1) continue;
            return false;
        }
        return true;
    }
}

