/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.utils;

import com.kms.katalon.composer.integration.git.components.utils.CustomProjectTrackerMemento;
import com.kms.katalon.composer.integration.git.components.utils.CustomProjectTrackerPreferenceHelper;
import com.kms.katalon.composer.integration.git.components.utils.CustomProjectTrackerPreferenceSnapshot;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.egit.ui.internal.clone.ProjectUtils;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.StringUtils;

public class CustomBranchProjectTracker {
    private static final String REPO_ROOT = "/";
    private final Repository[] repositories;

    public CustomBranchProjectTracker(Repository[] repositories) {
        this.repositories = repositories;
    }

    public CustomBranchProjectTracker(Repository repository) {
        this.repositories = new Repository[]{repository};
    }

    private String getBranch(Repository repo) {
        try {
            return repo.getBranch();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public CustomProjectTrackerMemento snapshot() {
        CustomProjectTrackerMemento memento = new CustomProjectTrackerMemento();
        Stream.of(this.repositories).map(this::takeSnapshot).filter(Objects::nonNull).forEach(memento::addSnapshot);
        return memento;
    }

    private CustomProjectTrackerPreferenceSnapshot takeSnapshot(Repository repo) {
        String branch = this.getBranch(repo);
        if (StringUtils.isEmptyOrNull((String)branch)) {
            return null;
        }
        List<String> projectPaths = this.getAssociatedProjectsPaths(repo);
        if (projectPaths.isEmpty()) {
            return null;
        }
        return new CustomProjectTrackerPreferenceSnapshot(repo, branch, projectPaths);
    }

    @NonNull
    private List<String> getAssociatedProjectsPaths(Repository repo) {
        IProject[] projects = this.getValidOpenProjects(repo);
        if (projects == null) {
            return Collections.emptyList();
        }
        ArrayList<String> projectPaths = new ArrayList<String>();
        String workDir = repo.getWorkTree().getAbsolutePath();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String fullPath;
            IProject project = iProjectArray[n2];
            IPath path = project.getLocation();
            if (path != null && ResourceUtil.isSharedWithGit((IResource)project) && (fullPath = path.toOSString()).startsWith(workDir)) {
                String relative = fullPath.substring(workDir.length());
                if (relative.length() == 0) {
                    relative = REPO_ROOT;
                }
                projectPaths.add(relative);
            }
            ++n2;
        }
        return projectPaths;
    }

    private IProject[] getValidOpenProjects(Repository repo) {
        try {
            return ProjectUtil.getValidOpenProjects((Repository)repo);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public CustomBranchProjectTracker save(CustomProjectTrackerMemento snapshot) {
        snapshot.getSnapshots().stream().forEach(CustomBranchProjectTracker::savePreference);
        return this;
    }

    private static void savePreference(CustomProjectTrackerPreferenceSnapshot snapshot) {
        Repository repo = snapshot.getRepository();
        String branch = snapshot.getBranch();
        List<String> projects = snapshot.getAssociatedProjects();
        CustomProjectTrackerPreferenceHelper.saveToPreferences(repo, branch, projects);
    }

    public void restore(IProgressMonitor monitor) {
        Repository[] repositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repo = repositoryArray[n2];
            String branch = this.getBranch(repo);
            if (branch != null) {
                this.restore(repo, branch, monitor);
            }
            ++n2;
        }
    }

    public void restore(Repository repo, String branch, IProgressMonitor monitor) {
        List<String> paths = CustomProjectTrackerPreferenceHelper.restoreFromPreferences(repo, branch);
        if (paths.isEmpty()) {
            return;
        }
        LinkedHashSet<ProjectRecord> records = new LinkedHashSet<ProjectRecord>();
        File parent = repo.getWorkTree();
        for (String path : paths) {
            ProjectRecord record;
            File projectDescription;
            File root = !REPO_ROOT.equals(path) ? new File(parent, path) : parent;
            if (!root.isDirectory() || !(projectDescription = new File(root, ".project")).isFile() || (record = new ProjectRecord(projectDescription)).getProjectDescription() == null) continue;
            records.add(record);
        }
        if (records.isEmpty()) {
            return;
        }
        try {
            ProjectUtils.createProjects(records, (boolean)true, null, (IProgressMonitor)monitor);
        }
        catch (InvocationTargetException e) {
            Activator.logError((String)"Error restoring branch-project associations", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
    }
}

