/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.wizards;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WorkingSetGroup;

public class CustomCloneDestinationPage
extends WizardPage {
    private static final boolean DEFAULT_CLONE_SUBMODULES_FLAG = false;
    private final List<Ref> availableRefs = new ArrayList<Ref>();
    private RepositorySelection validatedRepoSelection;
    private List<Ref> validatedSelectedBranches;
    private Ref validatedHEAD;
    private ComboViewer initialBranch;
    private Text directoryText;
    private Button importProjectsButton;
    private WorkingSetGroup workingSetGroup;
    private File clonedDestination;
    private Ref clonedInitialBranch;
    private String clonedRemote;
    private boolean importKeywords;

    public CustomCloneDestinationPage() {
        this(false);
    }

    public CustomCloneDestinationPage(boolean importKeywords) {
        super(CustomCloneDestinationPage.class.getName());
        this.setTitle(UIText.CloneDestinationPage_title);
        this.importKeywords = importKeywords;
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)layout);
        this.createDestinationGroup(panel);
        Dialog.applyDialogFont((Control)panel);
        this.setControl((Control)panel);
        this.checkPage();
    }

    public void setVisible(boolean visible) {
        if (visible && this.availableRefs.isEmpty()) {
            this.initialBranch.getCombo().setEnabled(false);
        }
        super.setVisible(visible);
        if (visible) {
            this.directoryText.setFocus();
        }
    }

    public void setSelection(RepositorySelection repositorySelection, List<Ref> availableRefs, List<Ref> branches, Ref head) {
        this.availableRefs.clear();
        this.availableRefs.addAll(availableRefs);
        this.checkPreviousPagesSelections(repositorySelection, branches, head);
        this.revalidate(repositorySelection, branches, head);
    }

    private void checkPreviousPagesSelections(RepositorySelection repositorySelection, List<Ref> branches, Ref head) {
        if (!(Objects.equals(repositorySelection, this.validatedRepoSelection) && Objects.equals(branches, this.validatedSelectedBranches) && Objects.equals(head, this.validatedHEAD))) {
            this.setPageComplete(false);
        } else {
            this.checkPage();
        }
    }

    private void createDestinationGroup(Composite parent) {
        Group destinationGroup = CustomCloneDestinationPage.createGroup(parent, UIText.CloneDestinationPage_groupDestination);
        Label dirLabel = new Label((Composite)destinationGroup, 0);
        dirLabel.setText(String.valueOf(UIText.CloneDestinationPage_promptDirectory) + ":");
        dirLabel.setToolTipText(UIText.CloneDestinationPage_DefaultRepoFolderTooltip);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        Composite destinationGroupComposite = new Composite((Composite)destinationGroup, 0);
        destinationGroupComposite.setLayout((Layout)grid);
        destinationGroupComposite.setLayoutData((Object)CustomCloneDestinationPage.createFieldGridData());
        this.directoryText = new Text(destinationGroupComposite, 2048);
        this.directoryText.setLayoutData((Object)CustomCloneDestinationPage.createFieldGridData());
        this.directoryText.addModifyListener(event -> this.checkPage());
        if (!this.importKeywords) {
            Button browseBtn = new Button(destinationGroupComposite, 8);
            browseBtn.setText(UIText.CloneDestinationPage_browseButton);
            browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String filePath;
                    FileDialog fileDialog = new FileDialog(CustomCloneDestinationPage.this.getShell(), 73728);
                    if (CustomCloneDestinationPage.this.directoryText.getText().length() > 0) {
                        File file = new File(CustomCloneDestinationPage.this.directoryText.getText()).getAbsoluteFile();
                        fileDialog.setFilterPath(file.getParent());
                        fileDialog.setFileName(file.getName());
                    }
                    if ((filePath = fileDialog.open()) != null) {
                        CustomCloneDestinationPage.this.directoryText.setText(filePath);
                    }
                }
            });
        }
        CustomCloneDestinationPage.newLabel(destinationGroup, String.valueOf(UIText.CloneDestinationPage_promptInitialBranch) + ":");
        this.initialBranch = new ComboViewer((Composite)destinationGroup, 12);
        this.initialBranch.getCombo().setLayoutData((Object)CustomCloneDestinationPage.createFieldGridData());
        this.initialBranch.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCloneDestinationPage.this.checkPage();
            }
        });
        this.initialBranch.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.initialBranch.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            /*
             * WARNING - void declaration
             */
            public String getText(Object element) {
                void var3_2;
                Ref ref;
                Object object = element;
                if (object instanceof Ref && (ref = (Ref)object) == (Ref)var3_2) {
                    void elementRef;
                    String elementName = elementRef.getName();
                    if (elementName.startsWith("refs/heads/")) {
                        return elementName.substring("refs/heads/".length());
                    }
                    return elementName;
                }
                return "";
            }
        });
    }

    private static Group createGroup(Composite parent, String text) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)layout);
        group.setText(text);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        group.setLayoutData((Object)gridData);
        return group;
    }

    private static void newLabel(Group group, String text) {
        new Label((Composite)group, 0).setText(text);
    }

    private static GridData createFieldGridData() {
        return new GridData(4, -1, true, false);
    }

    public boolean isImportProjects() {
        return Objects.nonNull(this.importProjectsButton) && this.importProjectsButton.getSelection();
    }

    public boolean isCloneSubmodules() {
        return false;
    }

    public IWorkingSet[] getWorkingSets() {
        if (Objects.isNull(this.workingSetGroup)) {
            return new IWorkingSet[0];
        }
        return this.workingSetGroup.getSelectedWorkingSets();
    }

    public File getDestinationFile() {
        return FileUtils.canonicalize((File)new File(this.directoryText.getText()));
    }

    public Ref getInitialBranch() {
        IStructuredSelection selection = (IStructuredSelection)this.initialBranch.getSelection();
        return (Ref)selection.getFirstElement();
    }

    public String getRemote() {
        return "origin";
    }

    private void checkPage() {
        if (!this.cloneSettingsChanged()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            return;
        }
        String dstpath = this.directoryText.getText();
        if (dstpath.isBlank()) {
            this.setErrorMessage("Directory is required");
            this.setPageComplete(false);
            return;
        }
        File absoluteFile = new File(dstpath).getAbsoluteFile();
        if (!this.importKeywords && !CustomCloneDestinationPage.isEmptyDir(absoluteFile)) {
            this.setErrorMessage(NLS.bind((String)UIText.CloneDestinationPage_errorNotEmptyDir, (Object)absoluteFile.getPath()));
            this.setPageComplete(false);
            return;
        }
        if (!CustomCloneDestinationPage.canCreateSubdir(absoluteFile.getParentFile())) {
            this.setErrorMessage(NLS.bind((String)UIText.GitCloneWizard_errorCannotCreate, (Object)absoluteFile.getPath()));
            this.setPageComplete(false);
            return;
        }
        if (!this.availableRefs.isEmpty() && this.initialBranch.getCombo().getSelectionIndex() < 0) {
            this.setErrorMessage(UIText.CloneDestinationPage_errorInitialBranchRequired);
            this.setPageComplete(false);
            return;
        }
        String remoteName = this.getRemote();
        if (remoteName.isBlank()) {
            this.setErrorMessage(UIText.CloneDestinationPage_errorRemoteNameRequired);
            this.setPageComplete(false);
            return;
        }
        if (!Repository.isValidRefName((String)("refs/remotes/" + remoteName))) {
            this.setErrorMessage(NLS.bind((String)UIText.CloneDestinationPage_errorInvalidRemoteName, (Object)remoteName));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    void saveSettingsForClonedRepo() {
        this.clonedDestination = this.getDestinationFile();
        this.clonedInitialBranch = this.getInitialBranch();
        this.clonedRemote = this.getRemote();
    }

    public boolean cloneSettingsChanged() {
        return Objects.isNull(this.clonedDestination) || !Objects.equals(this.clonedDestination, this.getDestinationFile()) || Objects.isNull(this.clonedInitialBranch) || !Objects.equals(this.clonedInitialBranch, this.getInitialBranch()) || this.clonedRemote == null || !this.clonedRemote.equals(this.getRemote());
    }

    private static boolean isEmptyDir(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        return dir.listFiles().length == 0;
    }

    private static boolean canCreateSubdir(File parent) {
        if (Objects.isNull(parent)) {
            return true;
        }
        if (parent.exists()) {
            return parent.isDirectory() && parent.canWrite();
        }
        return CustomCloneDestinationPage.canCreateSubdir(parent.getParentFile());
    }

    private void revalidate(RepositorySelection repoSelection, List<Ref> branches, Ref head) {
        if (Objects.equals(repoSelection, this.validatedRepoSelection) && Objects.equals(branches, this.validatedSelectedBranches) && Objects.equals(head, this.validatedHEAD)) {
            this.checkPage();
            return;
        }
        if (!Objects.equals(repoSelection, this.validatedRepoSelection)) {
            this.validatedRepoSelection = repoSelection;
            String uriString = this.validatedRepoSelection.getURI().getHumanishName();
            this.setDescription(NLS.bind((String)UIText.CloneDestinationPage_description, (Object)uriString));
            if (this.importKeywords) {
                try {
                    String defaultRepoDir = FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject()).getLocation();
                    File parentDir = new File(defaultRepoDir);
                    this.directoryText.setText(parentDir.getAbsolutePath());
                    this.directoryText.setEnabled(false);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e, (String)"Could not get the default repo directory.");
                }
            } else {
                String defaultRepoDir = RepositoryUtil.getDefaultRepositoryDir();
                File parentDir = new File(defaultRepoDir);
                this.directoryText.setText(new File(parentDir, uriString).getAbsolutePath());
            }
        }
        this.validatedSelectedBranches = branches;
        this.validatedHEAD = head;
        this.initialBranch.setInput(branches);
        if (Objects.nonNull(head) && branches.contains(head)) {
            this.initialBranch.setSelection((ISelection)new StructuredSelection((Object)head));
        } else if (!branches.isEmpty()) {
            this.initialBranch.setSelection((ISelection)new StructuredSelection((Object)branches.get(0)));
        }
        this.checkPage();
    }
}

