/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.internal.fetch;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.git.components.utils.Protocol;
import com.kms.katalon.composer.integration.git.constants.GitStringConstants;
import com.kms.katalon.tracking.service.Trackings;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.core.op.FetchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.fetch.FetchResultDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class CustomFetchOperationUI {
    private final Repository repository;
    private final FetchOperation op;
    private final String sourceString;

    public CustomFetchOperationUI(Repository repository, RemoteConfig config, int timeout, boolean dryRun) {
        this.repository = repository;
        this.op = new FetchOperation(repository, config, timeout, dryRun);
        this.sourceString = NLS.bind((String)"{0} - {1}", (Object)repository.getDirectory().getParentFile().getName(), (Object)config.getName());
    }

    public CustomFetchOperationUI(Repository repository, URIish uri, List<RefSpec> specs, int timeout, boolean dryRun) {
        this.repository = repository;
        this.op = new FetchOperation(repository, uri, specs, timeout, dryRun);
        this.sourceString = uri.toPrivateString();
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.op.setCredentialsProvider(credentialsProvider);
    }

    public void setTagOpt(TagOpt tagOpt) {
        this.op.setTagOpt(tagOpt);
    }

    public FetchResult execute(IProgressMonitor monitor) throws CoreException {
        try {
            if (this.op.getCredentialsProvider() == null) {
                this.op.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
            }
            this.op.run(monitor);
            this.trackFetchOperation(this.op.getOperationResult());
            return this.op.getOperationResult();
        }
        catch (InvocationTargetException e) {
            throw new CoreException(Activator.createErrorStatus((String)e.getCause().getMessage(), (Throwable)e.getCause()));
        }
    }

    private void trackFetchOperation(FetchResult fetchResult) {
        try {
            URIish remoteUri = fetchResult.getURI();
            String protocol = Protocol.fromUri(remoteUri).getDefaultScheme();
            Trackings.trackGitOperation((String)"fetch", (String)protocol);
        }
        catch (Exception exception) {}
    }

    public void start() {
        WorkspaceJob job = new WorkspaceJob(NLS.bind((String)UIText.FetchOperationUI_FetchJobName, (Object)this.sourceString)){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    CustomFetchOperationUI.this.execute(monitor);
                }
                catch (CoreException e) {
                    Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                    if (rootCause instanceof UnknownHostException) {
                        return Activator.createErrorStatus((String)MessageFormat.format(GitStringConstants.HAND_ERROR_MSG_UNABLE_TO_ACCESS_COULD_NOT_RESOLVE_Y, rootCause.getMessage()), (Throwable)e);
                    }
                    return Activator.createErrorStatus((String)e.getStatus().getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.FETCH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    UISynchronizeService.syncExec(() -> {
                        FetchResultDialog dialog = new FetchResultDialog(Display.getCurrent().getActiveShell(), CustomFetchOperationUI.this.repository, CustomFetchOperationUI.this.op.getOperationResult(), CustomFetchOperationUI.this.getSourceString());
                        dialog.open();
                    });
                } else {
                    Activator.handleError((String)event.getResult().getMessage(), (Throwable)event.getResult().getException(), (boolean)true);
                }
            }
        });
    }

    public String getSourceString() {
        return this.sourceString;
    }
}

