/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.core.har;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import net.lightbody.bmp.core.har.HarCache;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;
import net.lightbody.bmp.core.har.HarTimings;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect
public class HarEntry {
    private volatile String pageref;
    private volatile Date startedDateTime;
    private volatile HarRequest request;
    private volatile HarResponse response;
    private volatile HarCache cache = new HarCache();
    private volatile HarTimings timings = new HarTimings();
    private volatile String serverIPAddress;
    private volatile String connection;
    private volatile String comment = "";

    public HarEntry() {
    }

    public HarEntry(String pageref) {
        this.pageref = pageref;
    }

    public String getPageref() {
        return this.pageref;
    }

    public void setPageref(String pageref) {
        this.pageref = pageref;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    public Date getStartedDateTime() {
        return this.startedDateTime;
    }

    public void setStartedDateTime(Date startedDateTime) {
        this.startedDateTime = startedDateTime;
    }

    public long getTime() {
        return this.getTime(TimeUnit.MILLISECONDS);
    }

    public long getTime(TimeUnit timeUnit) {
        HarTimings timings = this.getTimings();
        if (timings == null) {
            return -1L;
        }
        long timeNanos = 0L;
        if (timings.getBlocked(TimeUnit.NANOSECONDS) > 0L) {
            timeNanos += timings.getBlocked(TimeUnit.NANOSECONDS);
        }
        if (timings.getDns(TimeUnit.NANOSECONDS) > 0L) {
            timeNanos += timings.getDns(TimeUnit.NANOSECONDS);
        }
        if (timings.getConnect(TimeUnit.NANOSECONDS) > 0L) {
            timeNanos += timings.getConnect(TimeUnit.NANOSECONDS);
        }
        if (timings.getSend(TimeUnit.NANOSECONDS) > 0L) {
            timeNanos += timings.getSend(TimeUnit.NANOSECONDS);
        }
        if (timings.getWait(TimeUnit.NANOSECONDS) > 0L) {
            timeNanos += timings.getWait(TimeUnit.NANOSECONDS);
        }
        if (timings.getReceive(TimeUnit.NANOSECONDS) > 0L) {
            timeNanos += timings.getReceive(TimeUnit.NANOSECONDS);
        }
        return timeUnit.convert(timeNanos, TimeUnit.NANOSECONDS);
    }

    public HarRequest getRequest() {
        return this.request;
    }

    public void setRequest(HarRequest request) {
        this.request = request;
    }

    public HarResponse getResponse() {
        return this.response;
    }

    public void setResponse(HarResponse response) {
        this.response = response;
    }

    public HarCache getCache() {
        return this.cache;
    }

    public void setCache(HarCache cache) {
        this.cache = cache;
    }

    public HarTimings getTimings() {
        return this.timings;
    }

    public void setTimings(HarTimings timings) {
        this.timings = timings;
    }

    public String getServerIPAddress() {
        return this.serverIPAddress;
    }

    public void setServerIPAddress(String serverIPAddress) {
        this.serverIPAddress = serverIPAddress;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }
}

