/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.helper;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.application.constants.ApplicationStringConstants;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.userprofile.models.KatalonTour;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.MachineUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class UserProfileHelper {
    public static final String USER_PROFILES_FILE_LOCATION = ApplicationStringConstants.USER_PROFILES_FILE_LOCATION;
    private static Map<String, UserProfile> userProfiles;
    public static final String USER_PROFILES_KEY = "userProfiles";
    private static final String TIMESTAMP_FORMAT = "HH:mm:ss - dd/MM/yyyy";

    public static UserProfile getCurrentProfile() {
        return UserProfileHelper.getOrCreateProfile(ApplicationContext.getInstance().getUserId());
    }

    public static UserProfile getMachineProfile() {
        String machineId = MachineUtil.getMachineId();
        return UserProfileHelper.getOrCreateProfile(machineId);
    }

    public static UserProfile getOrCreateProfile(String email) {
        UserProfile userProfile = UserProfileHelper.getProfile(email);
        if (userProfile == null) {
            return UserProfileHelper.createProfile(email);
        }
        return userProfile;
    }

    public static UserProfile createProfile(String email) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIMESTAMP_FORMAT);
        String currentDate = dateFormat.format(new Date());
        UserProfile userProfile = new UserProfile();
        userProfile.setEmail(email);
        userProfile.setDoneFirstTimeUseSurvey(false);
        userProfile.setEnableKURecorderHint(true);
        userProfile.setFirstTimeActivate(currentDate);
        return userProfile;
    }

    public static UserProfile getProfile(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return null;
        }
        Map<String, UserProfile> profiles = UserProfileHelper.getUserProfiles();
        return profiles.getOrDefault(email, null);
    }

    public static void saveProfile(UserProfile userProfile) {
        if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getEmail())) {
            return;
        }
        Map<String, UserProfile> profiles = UserProfileHelper.getUserProfiles();
        profiles.put(userProfile.getEmail(), userProfile);
        UserProfileHelper.saveUserProfiles();
    }

    public static synchronized Map<String, UserProfile> getUserProfiles() {
        userProfiles = UserProfileHelper.loadUserProfiles();
        if (userProfiles == null) {
            userProfiles = new HashMap<String, UserProfile>();
        }
        return userProfiles;
    }

    private static synchronized Map<String, UserProfile> loadUserProfiles() {
        String jsonUserProfiles;
        block5: {
            File userProfilesFile;
            block4: {
                try {
                    userProfilesFile = new File(USER_PROFILES_FILE_LOCATION);
                    if (userProfilesFile.exists()) break block4;
                    return null;
                }
                catch (Exception error) {
                    LogUtil.logError((Throwable)error);
                    return null;
                }
            }
            jsonUserProfiles = FileUtils.readFileToString((File)userProfilesFile);
            if (!StringUtils.isBlank((CharSequence)jsonUserProfiles)) break block5;
            return null;
        }
        Type userProfileMapType = new TypeToken<Map<String, UserProfile>>(){}.getType();
        return (Map)JsonUtil.fromJson((String)jsonUserProfiles, (Type)userProfileMapType);
    }

    public static synchronized void saveUserProfiles() {
        if (userProfiles == null) {
            return;
        }
        try {
            String jsonUserProfiles = JsonUtil.toJson(userProfiles, (boolean)false);
            FileUtils.writeStringToFile((File)new File(USER_PROFILES_FILE_LOCATION), (String)jsonUserProfiles);
        }
        catch (Exception error) {
            LogUtil.logError((Throwable)error);
        }
    }

    public static void updateUserProfiles() {
        UserProfile userProfile = UserProfileHelper.getCurrentProfile();
        HashSet<String> completedTours = new HashSet<String>(userProfile.getCompletedTours());
        if (completedTours.contains(KatalonTour.TEST_PLANNING.name())) {
            completedTours.add(KatalonTour.API_TESTING.name());
            completedTours.add(KatalonTour.WEB_TESTING.name());
            completedTours.add(KatalonTour.MOBILE_TESTING.name());
            completedTours.add(KatalonTour.DESKTOP_TESTING.name());
            completedTours.add(KatalonTour.BDD_TESTING_ADDING_TO_TEST_CASE.name());
        }
        if (completedTours.contains(KatalonTour.API_TESTING.name()) || completedTours.contains(KatalonTour.WEB_TESTING.name()) || completedTours.contains(KatalonTour.MOBILE_TESTING.name()) || completedTours.contains(KatalonTour.DESKTOP_TESTING.name())) {
            completedTours.add(KatalonTour.CREATE_FIRST_PROJECT.name());
        }
        if (completedTours.contains(KatalonTour.BDD_TESTING_ADDING_TO_TEST_CASE.name())) {
            completedTours.add(KatalonTour.BDD_TESTING_STEP_DEFINITION.name());
        }
        if (completedTours.contains(KatalonTour.BDD_TESTING_STEP_DEFINITION.name())) {
            completedTours.add(KatalonTour.BDD_TESTING_FEATURE_FILE.name());
        }
        completedTours.forEach(tour -> userProfile.addCompletedTour((String)tour));
        UserProfileHelper.saveProfile(userProfile);
    }
}

