/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.amazonaws.util.EC2MetadataUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kms.katalon.application.KatalonApplication;
import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.AwsKatalonUtil;
import com.kms.katalon.application.utils.LinuxSystemInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.application.utils.MachineUtil;
import com.kms.katalon.application.utils.Organization;
import com.kms.katalon.application.utils.ProcessUtil;
import com.kms.katalon.application.utils.ServerAPICommunicationUtil;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.core.model.KatalonPackage;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganizations;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.TestOpsMessageError;
import com.kms.katalon.license.LicenseService;
import com.kms.katalon.license.models.AuthenticationCredential;
import com.kms.katalon.license.models.AuthenticationInfo;
import com.kms.katalon.license.models.AwsKatalonAmi;
import com.kms.katalon.license.models.CombinedAuthenticationToken;
import com.kms.katalon.license.models.Feature;
import com.kms.katalon.license.models.License;
import com.kms.katalon.license.models.LicenseResource;
import com.kms.katalon.license.models.LicenseType;
import com.kms.katalon.license.models.TestOpsPlan;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.runtime.Platform;

public class ActivationInfoCollector {
    public static final String MACHINE_ID_BYPASS = "katalon-special-license";
    public static final String DEFAULT_HOST_NAME = "can.not.get.host.name";
    public static final String DEFAULT_REASON = ApplicationMessageConstants.LICENSE_INVALID;
    private static final String DEFAULT_LICENSE_FOLDER = "license";
    private static final String DEFAULT_LICENSE_EXTENSION = "lic";
    private static final String ENV_KATALON_AMI = "KATALON_AMI";
    private static final String MACHINE_ID_KATALON_AMI = "katalon-ami";
    private static final String DEFAULT_KATALON_AMI = "true";
    private static final String ORG_ROLE_LICENSE_VALUE = "orgRole";
    private static boolean activated = false;
    private static ScheduledFuture<?> checkLicenseTask;
    private static LicenseType licenseType;
    private static boolean isLicenseOffline;
    private static Organization organization;
    private static String activationCode;
    private static String expirationDate;
    private static String publicKey;
    private static String amiLicense;
    private static int validOfflineLicenseNumber;
    private static TestOpsPlan testOpsPlan;
    private static ApplicationContext appContext;
    private static String accountId;
    private static String orgId;
    private static boolean isValidTestCloudLicense;

    static {
        appContext = ApplicationContext.getInstance();
    }

    protected ActivationInfoCollector() {
    }

    public static void setActivated(boolean activated) {
        ActivationInfoCollector.activated = activated;
    }

    public static boolean isActivated() {
        return activated;
    }

    public static boolean checkAndMarkActivatedForGUIMode() {
        return ActivationInfoCollector.checkAndMarkActivatedForGUIMode(new TestOpsMessageError());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkAndMarkActivatedForGUIMode(TestOpsMessageError errorMessage) {
        activated = false;
        try {
            License license;
            block16: {
                block18: {
                    int statusCode;
                    Organization org;
                    block17: {
                        boolean isOffline;
                        block15: {
                            license = null;
                            publicKey = ApplicationInfo.getAppProperty("publicKey");
                            if (!ActivationInfoCollector.isRunOnAmiMachine()) break block15;
                            if (!ActivationInfoCollector.getAndCheckAmiMachine()) {
                                activated = false;
                                return activated;
                            }
                            license = ActivationInfoCollector.getValidLicense();
                            isLicenseOffline = true;
                            break block16;
                        }
                        org = ApplicationInfo.getOrganization();
                        if (org.getId() == null) {
                            activated = false;
                            return activated;
                        }
                        license = ActivationInfoCollector.getValidLicense();
                        isLicenseOffline = isOffline = ActivationInfoCollector.isOffline(license);
                        if (!isOffline) break block17;
                        if (ApplicationInfo.isPlatformStudio()) {
                            license = null;
                            break block16;
                        } else {
                            CombinedAuthenticationToken storedAuthenToken = ApplicationInfo.getAuthenticationInfo();
                            if (storedAuthenToken != null && storedAuthenToken.isNotEmpty()) {
                                String machineId = MachineUtil.getMachineId();
                                ActivationInfoCollector.activate(storedAuthenToken, license.getOrganizationId(), machineId, errorMessage);
                            }
                        }
                        break block16;
                    }
                    CombinedAuthenticationToken storedAuthenToken = ApplicationInfo.getAuthenticationInfo();
                    if (storedAuthenToken == null || !storedAuthenToken.isNotEmpty()) break block18;
                    String machineId = MachineUtil.getMachineId();
                    LicenseResource licenseResource = ActivationInfoCollector.activate(storedAuthenToken, null, machineId, errorMessage);
                    if (licenseResource != null) {
                        String message;
                        Organization storedOrg;
                        license = licenseResource.getLicense();
                        if (license != null) {
                            Long orgId;
                            if (ApplicationInfo.isPlatformStudio()) {
                                ApplicationInfo.setTestOpsServer(license.getTestopsUrl());
                            }
                            if ((orgId = license.getOrganizationId()) != null && !orgId.equals(org.getId())) {
                                String organization = ActivationInfoCollector.getOrganization(orgId);
                                ActivationInfoCollector.saveOrganization(organization);
                            }
                        }
                        if (Objects.equals((storedOrg = ApplicationInfo.getOrganization()).getId(), license.getOrganizationId()) && StringUtils.isEmpty((CharSequence)storedOrg.getRole()) && StringUtils.isNotEmpty((CharSequence)license.getOrganizationRole()) && !StringUtils.equals((CharSequence)storedOrg.getRole(), (CharSequence)license.getOrganizationRole())) {
                            storedOrg.setRole(license.getOrganizationRole());
                            ActivationInfoCollector.saveOrganization(storedOrg);
                        }
                        if (!StringUtils.isEmpty((CharSequence)(message = licenseResource.getMessage()))) {
                            LogUtil.logError((String)message);
                        }
                        break block16;
                    } else if (StringUtils.isNotEmpty((CharSequence)errorMessage.getStatus()) && (statusCode = Integer.parseInt(errorMessage.getStatus())) >= 400 && statusCode <= 499) {
                        license = null;
                        LogUtil.printAndLogError((Throwable)errorMessage.getException(), (String)errorMessage.getMessage());
                    }
                    break block16;
                }
                license = null;
            }
            if (license == null) return activated;
            ActivationInfoCollector.enableFeatures(license);
            ActivationInfoCollector.markActivatedLicenseCode(license.getJwtCode());
            ActivationInfoCollector.saveLicenseType(license.getType());
            ActivationInfoCollector.saveExpirationDate(license.getExpirationDate());
            activated = true;
            return activated;
        }
        catch (Exception ex) {
            activated = false;
            LogUtil.logError((Throwable)ex, (String)ApplicationMessageConstants.ACTIVATION_GUI_FAIL);
        }
        return activated;
    }

    private static void saveLicenseType(LicenseType type) {
        licenseType = type;
    }

    public static boolean isLicenseOffline() {
        return isLicenseOffline;
    }

    private static void saveExpirationDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("MMMMM dd, yyyy HH:mm");
        expirationDate = formatter.format((Object)date);
    }

    public static String getExpirationDate() {
        return expirationDate;
    }

    private static void saveOrganization(String org) {
        Organization organization = (Organization)JsonUtil.fromJson((String)org, Organization.class);
        ActivationInfoCollector.saveOrganization(organization);
    }

    private static void saveOrganization(Organization org) {
        organization = org;
        ApplicationInfo.setOrg(org);
    }

    private static void savePublicKey(String publicKey) {
        ApplicationInfo.setAppProperty("publicKey", publicKey, true);
    }

    public static boolean checkTestCloudActivated(String organizationId) throws Exception {
        isValidTestCloudLicense = false;
        if (organizationId == null) {
            organizationId = ApplicationInfo.getOrganization().getId().toString();
        }
        isValidTestCloudLicense = ActivationInfoCollector.checkRunConsoleWithTC(organizationId);
        return isValidTestCloudLicense;
    }

    public static boolean checkAndMarkActivatedForConsoleMode(String apiKey, Long organizationId, TestOpsMessageError errorMessage) {
        activated = false;
        try {
            String machineId = MachineUtil.getMachineId();
            AuthenticationCredential credential = new AuthenticationCredential(apiKey);
            LicenseResource licenseResource = ActivationInfoCollector.activate(credential, organizationId, machineId, errorMessage, true);
            if (licenseResource != null) {
                License license = licenseResource.getLicense();
                String message = licenseResource.getMessage();
                if (!StringUtils.isEmpty((CharSequence)message)) {
                    LogUtil.logError((String)message);
                }
                if (license != null) {
                    ActivationInfoCollector.enableFeatures(license);
                    activationCode = license.getJwtCode();
                    ActivationInfoCollector.saveLicenseType(license.getType());
                    if (organizationId != null) {
                        String org = ActivationInfoCollector.getOrganization(license.getOrganizationId());
                        ActivationInfoCollector.saveOrganization(org);
                    }
                    activated = true;
                    appContext.setApiKey(apiKey);
                }
            }
        }
        catch (Exception ex) {
            activated = false;
            LogUtil.logError((Throwable)ex, (String)ApplicationMessageConstants.ACTIVATION_CLI_FAIL);
        }
        return activated;
    }

    private static int getHostNameHashValue() throws Exception {
        String ipAddress;
        String hostName = ActivationInfoCollector.getHostname();
        if (hostName.equals(ipAddress = InetAddress.getLocalHost().getHostAddress())) {
            hostName = DEFAULT_HOST_NAME;
        }
        return Objects.hash(hostName);
    }

    private static String collectActivationInfo(String username, String machineId, boolean isActivateSuccess, StringBuilder errorMessage, Integer retryCount, LoginMethod loginMethod) {
        JsonObject traits = ActivationInfoCollector.traitsWithAppInfo();
        traits.addProperty("activated", Boolean.valueOf(isActivateSuccess));
        traits.addProperty("machineId", machineId);
        if (retryCount != null) {
            traits.addProperty("numberRetry", (Number)retryCount);
        }
        if (loginMethod != null) {
            traits.addProperty("loginMethod", loginMethod.name);
        }
        JsonObject activationObject = new JsonObject();
        KatalonPackage katalonPackage = KatalonApplication.getKatalonPackage();
        activationObject.addProperty("katalonPackage", katalonPackage.getPackageName());
        traits.addProperty("katPackage", katalonPackage.getPackageName());
        if (isActivateSuccess) {
            LicenseType licenseType = ActivationInfoCollector.getLicenseType();
            activationObject.addProperty("licenseType", licenseType.name());
            traits.addProperty(DEFAULT_LICENSE_FOLDER, licenseType.name());
            Organization organization = ActivationInfoCollector.getOrganzation();
            if (organization == null) {
                organization = ApplicationInfo.getOrganization();
            }
            traits.addProperty("orgId", (Number)organization.getId());
        }
        activationObject.addProperty("errorMessage", errorMessage.toString());
        activationObject.addProperty("userId", username);
        activationObject.add("traits", (JsonElement)traits);
        return activationObject.toString();
    }

    public static JsonObject traitsWithAppInfo() {
        JsonObject traits = new JsonObject();
        String katVersion = String.valueOf(ApplicationInfo.versionNo()) + " build " + VersionUtil.getCurrentVersion().getBuildNumber();
        String osType = Platform.getOSArch().contains("64") ? "64" : "32";
        String host = "";
        host = ActivationInfoCollector.getHostname();
        traits.addProperty("hostName", host);
        traits.addProperty("os", Platform.getOS());
        traits.addProperty("osType", osType);
        traits.addProperty("osVersion", ActivationInfoCollector.getOSVersion());
        traits.addProperty("osArch", Platform.getOSArch());
        traits.addProperty("katVersion", katVersion);
        traits.addProperty("edition", ApplicationEdition.get().getName());
        traits.addProperty("katType", System.getProperty("sun.arch.data.model"));
        traits.addProperty("sessionId", KatalonApplication.USER_SESSION_ID);
        traits.addProperty("userKey", KatalonApplication.USER_KEY);
        return traits;
    }

    private static String getOSVersion() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return ActivationInfoCollector.getWindowsVersion();
        }
        if (SystemUtils.IS_OS_MAC) {
            return SystemUtils.OS_VERSION;
        }
        return LinuxSystemInfo.getInstance().getNameAndVersion();
    }

    private static String getWindowsVersion() {
        return StringUtils.trim((String)SystemUtils.OS_NAME.replaceFirst("Windows", ""));
    }

    private static String getHostname() {
        String host = "";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            host = "unknown";
        }
        return host;
    }

    public static void sendTrackingForActivate(String username, String machineId, boolean isActivatedSuccess, StringBuilder errorMessage, boolean needExecutedCompletely, Integer retryCount) {
        ActivationInfoCollector.sendTrackingForActivate(username, machineId, isActivatedSuccess, errorMessage, needExecutedCompletely, retryCount, LoginMethod.CREDENTIAL);
    }

    public static void sendTrackingForActivate(String username, String machineId, boolean isActivatedSuccess, StringBuilder errorMessage, boolean needExecutedCompletely, Integer retryCount, LoginMethod loginMethod) {
        Thread sendTracking = new Thread(() -> {
            try {
                String userInfo = ActivationInfoCollector.collectActivationInfo(username, machineId, isActivatedSuccess, errorMessage, retryCount, loginMethod);
                ServerAPICommunicationUtil.post("/activation-tracking", userInfo);
            }
            catch (IOException | GeneralSecurityException exception) {}
        });
        sendTracking.start();
        if (needExecutedCompletely) {
            try {
                sendTracking.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void sendTrackingToKatalonWebsiteForActivatedSuccess(String email) {
        try {
            String serverUrl = ServerAPICommunicationUtil.getUpdateContactWebUrl();
            String function = "/wp-json/restful_api/v1/hubspot/update-contact";
            JsonObject activation_status = new JsonObject();
            activation_status.addProperty("activation_status", "Activated");
            JsonObject content = new JsonObject();
            content.addProperty("email", email);
            content.add("properties", (JsonElement)activation_status);
            String data = content.toString();
            ServerAPICommunicationUtil.post(serverUrl, function, data, true);
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
        }
    }

    public static LicenseResource activate(AuthenticationInfo authenticationInfo, Long organizationId, String machineId, TestOpsMessageError errorMessage) {
        return ActivationInfoCollector.activate(authenticationInfo, organizationId, machineId, errorMessage, false);
    }

    public static LicenseResource activate(AuthenticationInfo authenticationInfo, Long organizationId, String machineId, TestOpsMessageError errorMessage, boolean isSilentLog) {
        publicKey = null;
        if (!StringUtils.isBlank((CharSequence)machineId)) {
            try {
                String type = ApplicationInfo.getAuthenticationType();
                String subDomain = ApplicationInfo.getAuthenticationSubDomain();
                Map<String, String> respond = ActivationInfoCollector.getLicenseFromTestOps(authenticationInfo, organizationId, machineId, type, subDomain, isSilentLog);
                String jwtCode = respond.get(DEFAULT_LICENSE_FOLDER);
                String publicKey = respond.get("publicKey");
                if (StringUtils.isNotBlank((CharSequence)publicKey)) {
                    ActivationInfoCollector.publicKey = publicKey;
                    if (KatalonApplication.getKatalonPackage() == KatalonPackage.KSE) {
                        ActivationInfoCollector.savePublicKey(publicKey);
                    }
                }
                License license = ActivationInfoCollector.parseLicense(jwtCode);
                ActivationInfoCollector.getTrackingData(respond.get("accountId"), license.getOrganizationId());
                String testOpsPlan = respond.get("testopsPlan");
                String testOpsUrl = respond.get("testopsUrl");
                if (StringUtils.isBlank((CharSequence)testOpsPlan)) {
                    testOpsPlan = Platform.getProduct().getId().equals("com.kms.katalon.product-platform-edition") ? TestOpsPlan.PLATFORM.getName() : TestOpsPlan.LEGACY.getName();
                }
                if (StringUtils.isNotBlank((CharSequence)testOpsUrl)) {
                    license.setTestopsUrl(testOpsUrl);
                }
                if (testOpsPlan.equals(TestOpsPlan.PLATFORM.getName())) {
                    ActivationInfoCollector.saveTestOpsPlan(TestOpsPlan.PLATFORM);
                } else {
                    ActivationInfoCollector.saveTestOpsPlan(TestOpsPlan.LEGACY);
                }
                if (ProcessUtil.isKRE()) {
                    testOpsPlan = TestOpsPlan.LEGACY.getName();
                    ActivationInfoCollector.saveTestOpsPlan(TestOpsPlan.LEGACY);
                }
                license.setTestopsPlan(testOpsPlan);
                if (StringUtils.isNotEmpty((CharSequence)respond.get(ORG_ROLE_LICENSE_VALUE))) {
                    license.setOrganizationRole(respond.get(ORG_ROLE_LICENSE_VALUE));
                }
                LicenseResource licenseResource = new LicenseResource();
                licenseResource.setLicense(license);
                licenseResource.setMessage(respond.get("errorMessage"));
                licenseResource.setNoticeCode(respond.get("noticeCode"));
                licenseResource.setNoticeMessage(respond.get("noticeMessage"));
                isLicenseOffline = false;
                return licenseResource;
            }
            catch (Exception ex) {
                LogUtil.logError((Throwable)ex, (String)ApplicationMessageConstants.ACTIVATION_COLLECT_FAIL_MESSAGE);
                try {
                    KatalonApplicationActivator.getFeatureActivator().getTestOpsErrorMessage(ex.getMessage(), errorMessage);
                    errorMessage.setException(ex);
                }
                catch (Exception exception) {
                    errorMessage.setMessage(ApplicationMessageConstants.ACTIVATION_ONLINE_INVALID);
                }
            }
        } else {
            errorMessage.append(ApplicationMessageConstants.BLANK_API_KEY_OR_MACHINE_ID);
        }
        return null;
    }

    public static void deactivate(String machineId) throws Exception {
        String jwsCode = ActivationInfoCollector.getActivationCode();
        Long orgId = null;
        if (StringUtils.isNotBlank((CharSequence)jwsCode)) {
            License license = ActivationInfoCollector.parseLicense(jwsCode);
            if (license == null) {
                license = ActivationInfoCollector.getLastUsedLicense();
            }
            orgId = license.getOrganizationId();
        }
        ApplicationInfo.clearActivationCode();
        ApplicationInfo.clearAuthenticationInfo();
        ApplicationInfo.clearAuthenticationType();
        ApplicationInfo.clearAuthenticationSubDomain();
        ApplicationInfo.clearOrg();
        ApplicationInfo.clearLoginMethod();
        ActivationInfoCollector.clearOrgId();
        KatalonApplicationActivator.getFeatureActivator().deactivate(machineId, orgId);
        appContext.clearUserData();
        accountId = null;
    }

    private static void initialData() {
        orgId = null;
        accountId = null;
    }

    private static void getTrackingData(String accId, Long organizationId) throws Exception {
        ActivationInfoCollector.initialData();
        if (accId == null || organizationId == null) {
            AnalyticsOrganization org = ActivationInfoCollector.getRandomOrgForUnpaidUsers();
            orgId = org.getId().toString();
            accountId = org.getAccountId().toString();
        } else {
            orgId = organizationId.toString();
            accountId = accId;
        }
    }

    private static AnalyticsOrganization getRandomOrgForUnpaidUsers() throws Exception {
        String json = KatalonApplicationActivator.getFeatureActivator().getOrganizations();
        AnalyticsOrganizations analyticsOrg = (AnalyticsOrganizations)JsonUtil.fromJson((String)json, AnalyticsOrganizations.class);
        Random rand = new Random();
        return (AnalyticsOrganization)analyticsOrg.getOgranizations().get(rand.nextInt(analyticsOrg.getOgranizations().size()));
    }

    public static boolean checkTestingLicense(String activationCode, StringBuilder errorMessage) throws Exception {
        License testingLicense = ActivationInfoCollector.parseTestingLicense(activationCode);
        if (testingLicense != null && testingLicense.isTesting()) {
            boolean isValidMachineId = ActivationInfoCollector.hasValidMachineId(testingLicense);
            if (isValidMachineId) {
                RunningMode runMode = ApplicationRunningMode.get();
                if (runMode == RunningMode.CONSOLE && testingLicense.isEngineLicense()) {
                    errorMessage.append(ApplicationMessageConstants.TESTING_LICENSE_MACHINE_ID_CORRECT);
                    return true;
                }
                if (runMode == RunningMode.GUI && testingLicense.isKSELicense()) {
                    errorMessage.append(ApplicationMessageConstants.TESTING_LICENSE_MACHINE_ID_CORRECT);
                    return true;
                }
            } else {
                errorMessage.append(ApplicationMessageConstants.TESTING_LICENSE_MACHINE_ID_INCORRECT);
                return true;
            }
            errorMessage.append(ApplicationMessageConstants.LICENSE_INVALID);
            return true;
        }
        return false;
    }

    private static License parseTestingLicense(String jwtCode) throws Exception {
        try {
            License license;
            if (jwtCode != null && !jwtCode.isEmpty() && (license = LicenseService.getInstance().parseJws(jwtCode)).isTesting()) {
                return license;
            }
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex, (String)ApplicationMessageConstants.KSE_ACTIVATE_INFOR_INVALID);
            throw ex;
        }
        return null;
    }

    private static License parseLicense(String jwtCode, String licenseFileName) throws Exception {
        try {
            License license;
            if (jwtCode != null && !jwtCode.isEmpty() && ActivationInfoCollector.isValidLicense(license = LicenseService.getInstance().parseJws(jwtCode), licenseFileName)) {
                return license;
            }
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex, (String)ApplicationMessageConstants.KSE_ACTIVATE_INFOR_INVALID);
            throw ex;
        }
        return null;
    }

    private static License parseLicense(String jwtCode) throws Exception {
        try {
            if (jwtCode != null && !jwtCode.isEmpty()) {
                License license = null;
                license = StringUtils.isNotBlank((CharSequence)publicKey) ? LicenseService.getInstance().parseJws(jwtCode, publicKey) : LicenseService.getInstance().parseJws(jwtCode);
                if (ActivationInfoCollector.isValidLicense(license)) {
                    return license;
                }
            }
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex, (String)ApplicationMessageConstants.KSE_ACTIVATE_INFOR_INVALID);
            throw ex;
        }
        return null;
    }

    private static Map<String, String> getLicenseFromTestOps(AuthenticationInfo authenticationInfo, Long organizationId, String machineId, String type, String subDomain, boolean isSilentLog) throws Exception {
        String hostname = ActivationInfoCollector.getHostname();
        return KatalonApplicationActivator.getFeatureActivator().activate(authenticationInfo, organizationId, KatalonApplication.USER_SESSION_ID, hostname, machineId, type, subDomain, isSilentLog);
    }

    private static boolean checkRunConsoleWithTC(String organizationId) throws Exception {
        return KatalonApplicationActivator.getTestCloudFeatureActivator().checkRunConsoleWithTCLicense(organizationId);
    }

    public static String getOrganization(long orgId) throws Exception {
        return KatalonApplicationActivator.getFeatureActivator().getOrganization(orgId);
    }

    public static boolean activateOffline(String activationCode, StringBuilder errorMessage, RunningMode runningMode) {
        try {
            publicKey = null;
            License license = ActivationInfoCollector.parseLicense(activationCode);
            if (license != null) {
                boolean isOffline;
                isLicenseOffline = isOffline = ActivationInfoCollector.isOffline(license);
                if (isOffline) {
                    ActivationInfoCollector.enableFeatures(license);
                    ActivationInfoCollector.saveLicenseType(license.getType());
                    if (runningMode == RunningMode.GUI) {
                        ActivationInfoCollector.markActivatedLicenseCode(activationCode);
                        ActivationInfoCollector.saveExpirationDate(license.getExpirationDate());
                        Organization org = new Organization();
                        org.setId(license.getOrganizationId());
                        ActivationInfoCollector.saveOrganization(org);
                    } else {
                        ActivationInfoCollector.activationCode = activationCode;
                    }
                    activated = true;
                    return activated;
                }
            }
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex, (String)ApplicationMessageConstants.ACTIVATION_OFFLINE_FAIL);
        }
        errorMessage.append(ApplicationMessageConstants.KSE_ACTIVATE_INFOR_INVALID);
        activated = false;
        return activated;
    }

    public static boolean activateOfflineForEngine(StringBuilder errorMessage) throws Exception {
        Set<String> validActivationCodes;
        block5: {
            int validOfflineLicenseSessionNumber;
            block4: {
                try {
                    validActivationCodes = ActivationInfoCollector.findValidEngineOfflineLinceseCodes();
                    LogUtil.logInfo((String)("The number of valid offline licenses: " + validActivationCodes.size()));
                    validOfflineLicenseSessionNumber = validActivationCodes.size();
                    if (validOfflineLicenseSessionNumber != 0) break block4;
                    return false;
                }
                catch (Exception error) {
                    LogUtil.printAndLogError((Throwable)error, (String)ApplicationMessageConstants.ACTIVATION_OFFLINE_FAIL);
                    return false;
                }
            }
            int runningSession = ProcessUtil.countKatalonRunningSession();
            LogUtil.logInfo((String)("The number of Runtime Engine running sessions: " + runningSession));
            if (validOfflineLicenseSessionNumber >= runningSession) break block5;
            errorMessage.append("License quota exceeded");
            return false;
        }
        String activationCode = (String)validActivationCodes.stream().findFirst().get();
        return ActivationInfoCollector.activateOffline(activationCode, errorMessage, RunningMode.CONSOLE);
    }

    public static boolean activateOfflineForEngineAmiMachine(StringBuilder errorMessage) {
        if (ActivationInfoCollector.isRunOnAmiMachine() && ActivationInfoCollector.getAndCheckAmiMachine()) {
            return ActivationInfoCollector.activateOffline(amiLicense, errorMessage, RunningMode.CONSOLE);
        }
        return false;
    }

    private static boolean isValidLicense(License license, String licenseFileName) {
        boolean isValidMachineId = ActivationInfoCollector.hasValidMachineId(license);
        boolean isExpired = ActivationInfoCollector.isExpired(license);
        RunningMode runMode = ApplicationRunningMode.get();
        if (license.isTesting()) {
            if (isValidMachineId) {
                if (runMode == RunningMode.CONSOLE && license.isEngineLicense()) {
                    LogUtil.logInfo((String)MessageFormat.format(ApplicationMessageConstants.TESTING_LICENSE_WITH_FILENAME_CORRECT, licenseFileName));
                } else if (runMode == RunningMode.GUI && license.isKSELicense()) {
                    LogUtil.logInfo((String)MessageFormat.format(ApplicationMessageConstants.TESTING_LICENSE_WITH_FILENAME_CORRECT, licenseFileName));
                }
            } else {
                LogUtil.logError((String)MessageFormat.format(ApplicationMessageConstants.TESTING_LICENSE_WITH_FILENAME_INCORRECT, licenseFileName));
            }
        } else if (isValidMachineId && !isExpired && !license.isTesting()) {
            if (runMode == RunningMode.CONSOLE && license.isEngineLicense()) {
                return true;
            }
            if (runMode == RunningMode.GUI && license.isKSELicense()) {
                return true;
            }
            if (runMode == RunningMode.CONSOLE) {
                LogUtil.logError((String)MessageFormat.format(ApplicationMessageConstants.LICENSE_INVALID_KSE_USE_TO_KRE, licenseFileName));
            } else if (runMode == RunningMode.GUI) {
                LogUtil.logError((String)MessageFormat.format(ApplicationMessageConstants.LICENSE_INVALID_KRE_USE_TO_KSE, licenseFileName));
            } else {
                LogUtil.logError((String)DEFAULT_REASON);
            }
        } else {
            if (!isValidMachineId) {
                LogUtil.logError((String)MessageFormat.format(ApplicationMessageConstants.LICENSE_INCORRECT_MACHINE_ID, licenseFileName));
            }
            if (isExpired) {
                LogUtil.logError((String)MessageFormat.format(ApplicationMessageConstants.LICENSE_EXPIRED_WITH_FILE_NAME, licenseFileName));
            }
        }
        return false;
    }

    private static boolean isValidLicense(License license) {
        boolean isValidMachineId = false;
        isValidMachineId = ActivationInfoCollector.isValidAmiMachineId(license) ? true : ActivationInfoCollector.hasValidMachineId(license);
        boolean isExpired = ActivationInfoCollector.isExpired(license);
        if (isValidMachineId && !isExpired && !license.isTesting()) {
            RunningMode runMode = ApplicationRunningMode.get();
            if (runMode == RunningMode.CONSOLE && license.isEngineLicense()) {
                return true;
            }
            if (runMode == RunningMode.GUI && license.isKSELicense()) {
                return true;
            }
            LogUtil.logError((String)DEFAULT_REASON);
        } else {
            if (!isValidMachineId) {
                LogUtil.logError((String)ApplicationMessageConstants.LICENSE_INVALID_MACHINE_ID);
            }
            if (isExpired) {
                LogUtil.logError((String)ApplicationMessageConstants.LICENSE_EXPIRED);
            }
        }
        return false;
    }

    private static boolean isValidAmiMachineId(License license) {
        return MACHINE_ID_KATALON_AMI.contains(license.getMachineId());
    }

    private static boolean hasValidMachineId(License license) {
        block3: {
            try {
                if (!MACHINE_ID_BYPASS.equals(license.getMachineId())) break block3;
                return true;
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
                return false;
            }
        }
        String machineId = MachineUtil.getMachineId();
        return machineId.equals(license.getMachineId());
    }

    private static boolean isExpired(License license) {
        Date currentDate = new Date();
        return currentDate.after(license.getExpirationDate());
    }

    public static boolean isReachRenewTime(License license) {
        Date currentDate = new Date();
        Date renewTime = license.getRenewTime();
        if (renewTime != null) {
            return currentDate.after(renewTime);
        }
        return false;
    }

    private static void enableFeatures(License license) {
        List<Feature> features = license.getFeatures();
        IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
        for (Feature feature : features) {
            featureService.enable(feature.getKey());
        }
    }

    public static void clearFeatures() {
        IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
        featureService.clear();
    }

    public static void releaseLicense() throws Exception {
        try {
            try {
                LogUtil.logInfo((String)"Start release license task");
                String jwsCode = ActivationInfoCollector.getActivationCode();
                if (StringUtils.isNotBlank((CharSequence)jwsCode)) {
                    boolean isOffline;
                    License license = ActivationInfoCollector.parseLicense(jwsCode);
                    if (license == null) {
                        license = ActivationInfoCollector.getLastUsedLicense();
                    }
                    if (!(isOffline = ActivationInfoCollector.isOffline(license))) {
                        String machineId = MachineUtil.getMachineId();
                        String ksVersion = VersionUtil.getCurrentVersion().getVersion();
                        Long orgId = license.getOrganizationId();
                        KatalonApplicationActivator.getFeatureActivator().releaseLicense(machineId, ksVersion, KatalonApplication.USER_SESSION_ID, orgId);
                        LogUtil.logInfo((String)"License released");
                    }
                }
                LogUtil.logInfo((String)"End release license task");
            }
            catch (Exception ex) {
                LogUtil.printAndLogError((Throwable)ex, (String)"Error when release license");
                throw ex;
            }
        }
        finally {
            KatalonApplication.refreshUserSession();
        }
    }

    public static void releaseLicense(Long orgId) throws Exception {
        try {
            LogUtil.logInfo((String)"Start release license task");
            String machineId = MachineUtil.getMachineId();
            String ksVersion = VersionUtil.getCurrentVersion().getVersion();
            String userSessionId = KatalonApplicationActivator.getFeatureActivator().getMostRecentUserSessionId(machineId, orgId);
            if (StringUtils.isNotBlank((CharSequence)userSessionId)) {
                KatalonApplicationActivator.getFeatureActivator().releaseLicense(machineId, ksVersion, userSessionId, orgId);
                LogUtil.logInfo((String)"License released");
            }
            LogUtil.logInfo((String)"End release license task");
        }
        catch (Exception ex) {
            LogUtil.printAndLogError((Throwable)ex, (String)"Error when release license");
            throw ex;
        }
    }

    public static void releaseLicense(String username, String password, Long orgId) throws Exception {
        try {
            LogUtil.logInfo((String)"Start release license task");
            String machineId = MachineUtil.getMachineId();
            String ksVersion = VersionUtil.getCurrentVersion().getVersion();
            String userSessionId = KatalonApplicationActivator.getFeatureActivator().getMostRecentUserSessionId(machineId, orgId);
            if (StringUtils.isNotBlank((CharSequence)userSessionId)) {
                KatalonApplicationActivator.getFeatureActivator().releaseLicense(machineId, ksVersion, userSessionId, orgId);
                LogUtil.logInfo((String)"License released");
            }
            LogUtil.logInfo((String)"End release license task");
        }
        catch (Exception ex) {
            LogUtil.printAndLogError((Throwable)ex, (String)"Error when release license");
            throw ex;
        }
    }

    public static void markActivated(AuthenticationInfo authInfo, String organization, License license) throws Exception {
        activated = true;
        if (license != null) {
            ActivationInfoCollector.enableFeatures(license);
        }
        ApplicationInfo.removeAppProperty("activatedRequestCode");
        if (authInfo instanceof CombinedAuthenticationToken) {
            ApplicationInfo.setAuthenticationInfo((CombinedAuthenticationToken)authInfo);
        }
        Organization org = (Organization)JsonUtil.fromJson((String)organization, Organization.class);
        if (license != null && org != null && StringUtils.isNotEmpty((CharSequence)license.getOrganizationRole())) {
            org.setRole(license.getOrganizationRole());
        }
        ActivationInfoCollector.saveOrganization(org);
        if (license != null) {
            ActivationInfoCollector.markActivatedLicenseCode(license.getJwtCode());
            ActivationInfoCollector.saveLicenseType(license.getType());
            ActivationInfoCollector.saveExpirationDate(license.getExpirationDate());
        }
    }

    private static void markActivatedLicenseCode(String activationCode) throws Exception {
        ActivationInfoCollector.setActivatedVal();
        ApplicationInfo.setActivationCode(activationCode);
    }

    private static void setActivatedVal() throws Exception {
        String activatedVal = Integer.toString(ActivationInfoCollector.getHostNameHashValue());
        String curVersion = new StringBuilder(ApplicationInfo.versionNo().replaceAll("\\.", "")).reverse().toString();
        ApplicationInfo.setAppProperty("activated", String.valueOf(curVersion) + "_" + activatedVal, true);
    }

    public static void markActivatedViaUpgradation(String versionNumber) {
        ApplicationInfo.setAppProperty("updatedVersion", ActivationInfoCollector.getVersionNo(versionNumber), true);
    }

    private static String getVersionNo(String versionNumber) {
        if (versionNumber == null) {
            return versionNumber;
        }
        Object[] numbers = versionNumber.split("\\.");
        while (numbers.length < 3) {
            numbers = (String[])ArrayUtils.add((Object[])numbers, (Object)"0");
        }
        return StringUtils.join((Object[])ArrayUtils.subarray((Object[])numbers, (int)0, (int)3), (String)".");
    }

    public static void scheduleCheckLicense(Runnable expiredHandler, Runnable renewHandler) {
        LogUtil.logInfo((String)"Start checking license task");
        checkLicenseTask = Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> {
            try {
                License license = ActivationInfoCollector.getValidLicense();
                if (license == null) {
                    license = ActivationInfoCollector.getLastUsedLicense();
                }
                boolean isOffline = ActivationInfoCollector.isOffline(license);
                boolean isTokenExpired = false;
                if (!isOffline) {
                    CombinedAuthenticationToken storedAuthenToken = ApplicationInfo.getAuthenticationInfo();
                    boolean bl = isTokenExpired = Objects.nonNull(storedAuthenToken) && storedAuthenToken.isTokenExpired();
                    if (license != null && ActivationInfoCollector.isReachRenewTime(license)) {
                        try {
                            renewHandler.run();
                            license = activated ? ActivationInfoCollector.getValidLicense() : null;
                        }
                        catch (Exception e) {
                            LogUtil.printAndLogError((Throwable)e, (String)ApplicationMessageConstants.LICENSE_UNABLE_RENEW);
                        }
                    }
                }
                if (isTokenExpired || license == null || !ActivationInfoCollector.isValidLicense(license)) {
                    expiredHandler.run();
                }
            }
            catch (Exception e) {
                LogUtil.printAndLogError((Throwable)e, (String)ApplicationMessageConstants.LICENSE_ERROR_RENEW);
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    public static void postEndSession() {
        LogUtil.logInfo((String)"Start clean up session");
        if (checkLicenseTask != null) {
            checkLicenseTask.cancel(true);
            LogUtil.logInfo((String)"End check license task");
        }
        LogUtil.logInfo((String)"End clean up session");
    }

    public static boolean isOffline(License license) {
        boolean isOffline = false;
        if (license != null) {
            isOffline = license.getFeatures().stream().map(Feature::getKey).anyMatch("offline"::equals);
        }
        return isOffline;
    }

    private static License getValidLicense() throws Exception {
        if (ActivationInfoCollector.isRunOnAmiMachine()) {
            License license = LicenseService.getInstance().parseJws(amiLicense);
            if (MACHINE_ID_KATALON_AMI.contains(license.getMachineId())) {
                return license;
            }
            return null;
        }
        String jwsCode = ActivationInfoCollector.getActivationCode();
        License license = ActivationInfoCollector.parseLicense(jwsCode);
        return license;
    }

    public static LicenseType getLicenseType() {
        return licenseType;
    }

    public static Organization getOrganzation() {
        return organization;
    }

    private static License getLastUsedLicense() {
        try {
            String jwtCode = ActivationInfoCollector.getActivationCode();
            if (jwtCode != null && !jwtCode.isEmpty()) {
                License license = null;
                license = StringUtils.isNotBlank((CharSequence)publicKey) ? LicenseService.getInstance().parseJws(jwtCode, publicKey) : LicenseService.getInstance().parseJws(jwtCode);
                if (ActivationInfoCollector.hasValidMachineId(license)) {
                    return license;
                }
            }
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex, (String)ApplicationMessageConstants.KSE_ACTIVATE_INFOR_INVALID);
        }
        return null;
    }

    private static String getActivationCode() {
        KatalonPackage katalonPackage = KatalonApplication.getKatalonPackage();
        if (katalonPackage == KatalonPackage.ENGINE) {
            return activationCode;
        }
        return ApplicationInfo.getActivationCode();
    }

    public static Set<String> findValidEngineOfflineLinceseCodes() {
        HashSet<String> validActivationCodes = new HashSet<String>();
        try {
            File licenseFolder = new File(ApplicationInfo.userDirLocation(), DEFAULT_LICENSE_FOLDER);
            LogUtil.logInfo((String)MessageFormat.format(ApplicationMessageConstants.RE_FIND_VAILD_OFFLINE_LICENSE_IN_FOLDER, licenseFolder.getAbsolutePath()));
            if (licenseFolder.exists() && licenseFolder.isDirectory()) {
                Files.walk(Paths.get(licenseFolder.getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && FilenameUtils.getExtension((String)p.toFile().getAbsolutePath()).equals(DEFAULT_LICENSE_EXTENSION)).forEach(p -> {
                    try {
                        File licenseFile = p.toFile();
                        LogUtil.logInfo((String)MessageFormat.format(ApplicationMessageConstants.RE_START_CHECK_LICENSE, licenseFile.getName()));
                        String activationCode = FileUtils.readFileToString((File)licenseFile, (Charset)Charset.forName("UTF-8"));
                        License license = ActivationInfoCollector.parseLicense(activationCode, licenseFile.getName());
                        if (license != null && license.isEngineLicense() && ActivationInfoCollector.isOffline(license)) {
                            LogUtil.logInfo((String)MessageFormat.format(ApplicationMessageConstants.RE_LICENSE_FILE_VAILD, licenseFile.getName()));
                            validActivationCodes.add(activationCode);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.logError((Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        validOfflineLicenseNumber = validActivationCodes.size();
        return validActivationCodes;
    }

    public static boolean isRunOnAmiMachine() {
        try {
            String hasKatalonAmi = System.getenv(ENV_KATALON_AMI);
            return DEFAULT_KATALON_AMI.equalsIgnoreCase(hasKatalonAmi);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public static boolean getAndCheckAmiMachine() {
        AwsKatalonAmi awsKatalonAmi;
        List productCodes;
        block6: {
            block5: {
                productCodes = EC2MetadataUtils.getProductCodes();
                if (productCodes != null) break block5;
                return false;
            }
            awsKatalonAmi = AwsKatalonUtil.getAwsKatalonAmi();
            if (awsKatalonAmi != null) break block6;
            return false;
        }
        try {
            productCodes.retainAll(awsKatalonAmi.getAmiIds());
            if (productCodes.size() > 0) {
                RunningMode runMode = ApplicationRunningMode.get();
                amiLicense = runMode == RunningMode.GUI ? awsKatalonAmi.getKseLicense() : awsKatalonAmi.getReLicense();
                return true;
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        return false;
    }

    public static String getAmiLicense() {
        return amiLicense;
    }

    public static int getValidOfflineLicenseNumber() {
        return validOfflineLicenseNumber;
    }

    public static TestOpsPlan getTestOpsPlan() {
        return testOpsPlan;
    }

    private static void saveTestOpsPlan(TestOpsPlan plan) {
        testOpsPlan = plan;
    }

    public static String getAccountId() {
        return accountId;
    }

    public static String getOrgId() {
        return orgId;
    }

    public static void clearOrgId() {
        orgId = null;
    }
}

