/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.util.PlatformUtil;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.preference.ProxyPreferences;
import com.kms.katalon.application.utils.ServerAPICommunicationUtil;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ApplicationProxyUtil {
    private static final String USE_SYSTEM_PROXY_PROP = "java.net.useSystemProxies";

    @Deprecated
    public static void saveProxyInformation(ProxyInformation proxyInfo) throws IOException {
        ProxyPreferences.saveProxyInformation(proxyInfo);
    }

    public static void saveAuthProxyInformation(ProxyInformation proxyInfo) throws IOException {
        ProxyPreferences.saveAuthProxyInformation(proxyInfo);
    }

    public static void saveSystemProxyInformation(ProxyInformation proxyInfo) throws IOException {
        ProxyPreferences.saveSystemProxyInformation(proxyInfo);
    }

    @Deprecated
    public static ProxyInformation getProxyInformation() {
        return ProxyPreferences.getProxyInformation();
    }

    public static ProxyInformation getAuthProxyInformation() {
        return ProxyPreferences.getAuthProxyInformation();
    }

    public static ProxyInformation getSystemProxyInformation() {
        return ProxyPreferences.getSystemProxyInformation();
    }

    public static Proxy getAuthProxy() throws IOException {
        return ApplicationProxyUtil.getProxy(ApplicationProxyUtil.getAuthProxyInformation());
    }

    public static Proxy getSystemProxy() throws IOException {
        return ApplicationProxyUtil.getProxy(ApplicationProxyUtil.getSystemProxyInformation());
    }

    @Deprecated
    public static Proxy getProxy() throws IOException {
        return ApplicationProxyUtil.getProxy(ApplicationProxyUtil.getProxyInformation());
    }

    public static Proxy getProxy(final ProxyInformation proxyInfo) throws IOException {
        Proxy proxy;
        block15: {
            ProxyOption proxyOption;
            block16: {
                proxy = Proxy.NO_PROXY;
                proxyOption = ProxyOption.valueOf((String)proxyInfo.getProxyOption());
                if (proxyOption != ProxyOption.USE_SYSTEM) break block16;
                proxy = ApplicationProxyUtil.getSystemProxyFor(ServerAPICommunicationUtil.getAPIUrl());
                break block15;
            }
            if (proxyOption != ProxyOption.MANUAL_CONFIG) break block15;
            System.setProperty(USE_SYSTEM_PROXY_PROP, "false");
            try {
                switch (proxyInfo.getProxyServerType()) {
                    case "SOCKS": {
                        proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyInfo.getProxyServerAddress(), proxyInfo.getProxyServerPort()));
                        break;
                    }
                    case "HTTP": 
                    case "HTTPS": {
                        proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyInfo.getProxyServerAddress(), proxyInfo.getProxyServerPort()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(ApplicationMessageConstants.PROXY_SERVER_TYPE_NOT_VALID_MESSAGE);
                    }
                }
            }
            catch (IllegalArgumentException | SecurityException ex) {
                throw new IOException(ex);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)proxyInfo.getUsername()) && StringUtils.isNotEmpty((CharSequence)proxyInfo.getPassword())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyInfo.getUsername(), proxyInfo.getPassword().toCharArray());
                }
            });
        }
        return proxy;
    }

    @Deprecated
    public static Proxy getRetryProxy() throws URISyntaxException {
        return ApplicationProxyUtil.getRetryProxy(ApplicationProxyUtil.getProxyInformation());
    }

    public static Proxy getAuthRetryProxy() throws URISyntaxException {
        return ApplicationProxyUtil.getRetryProxy(ApplicationProxyUtil.getAuthProxyInformation());
    }

    public static Proxy getSystemRetryProxy() throws URISyntaxException {
        return ApplicationProxyUtil.getRetryProxy(ApplicationProxyUtil.getSystemProxyInformation());
    }

    public static Proxy getRetryProxy(final ProxyInformation proxyInfo) throws URISyntaxException {
        if (StringUtils.isNotEmpty((CharSequence)proxyInfo.getUsername()) && StringUtils.isNotEmpty((CharSequence)proxyInfo.getPassword())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyInfo.getUsername(), proxyInfo.getPassword().toCharArray());
                }
            });
        }
        ProxySelector proxySelector = ApplicationProxyUtil.getProxySearch().getProxySelector();
        Proxy proxy = Proxy.NO_PROXY;
        if (proxySelector != null) {
            proxy = ApplicationProxyUtil.getProxy(proxySelector);
        }
        if (!Proxy.NO_PROXY.equals(proxy)) {
            LogUtil.printOutputLine((String)MessageFormat.format(ApplicationMessageConstants.PROXY_FOUND, proxy.toString()));
        } else {
            LogUtil.printOutputLine((String)ApplicationMessageConstants.NO_PROXY_FOUND);
        }
        return proxy;
    }

    private static ProxySearch getProxySearch() {
        ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
        if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
            proxySearch.addStrategy(ProxySearch.Strategy.IE);
            proxySearch.addStrategy(ProxySearch.Strategy.FIREFOX);
        } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.LINUX) {
            proxySearch.addStrategy(ProxySearch.Strategy.GNOME);
            proxySearch.addStrategy(ProxySearch.Strategy.KDE);
            proxySearch.addStrategy(ProxySearch.Strategy.FIREFOX);
        }
        return proxySearch;
    }

    private static Proxy getProxy(ProxySelector proxySelector) throws URISyntaxException {
        Proxy proxy = Proxy.NO_PROXY;
        List<Proxy> proxies = proxySelector.select(new URI(ServerAPICommunicationUtil.getAPIUrl()));
        if (proxySelector != null && proxies != null) {
            block4: for (Proxy p : proxies) {
                switch (p.type()) {
                    case HTTP: {
                        proxy = p;
                        break block4;
                    }
                    case DIRECT: {
                        proxy = p;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
        }
        return proxy;
    }

    public static Proxy getSystemProxyFor(String url) {
        try {
            System.setProperty(USE_SYSTEM_PROXY_PROP, "true");
            List<Proxy> systemProxies = ProxySelector.getDefault().select(new URI(url));
            Optional<Proxy> sysProxy = systemProxies.stream().filter(proxy -> proxy.address() != null).findFirst();
            return sysProxy.isPresent() ? sysProxy.get() : Proxy.NO_PROXY;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return Proxy.NO_PROXY;
        }
    }
}

