/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.kms.katalon.logging.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class LinuxSystemInfo {
    private static LinuxSystemInfo _instance;
    private Map<String, String> properties;
    private static final String KEY_VERSION_ID = "VERSION_ID";
    private static final String KEY_NAME = "NAME";

    private LinuxSystemInfo() {
        this.initLinuxInfo();
    }

    public static LinuxSystemInfo getInstance() {
        if (_instance == null) {
            _instance = new LinuxSystemInfo();
        }
        return _instance;
    }

    private void initLinuxInfo() {
        block6: {
            this.properties = new HashMap<String, String>();
            String[] cmd = new String[]{"/bin/sh", "-c", "cat /etc/*-release"};
            BufferedReader bri = null;
            try {
                try {
                    Process p = Runtime.getRuntime().exec(cmd);
                    bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = "";
                    while ((line = bri.readLine()) != null) {
                        String[] info = line.split("=");
                        if (info.length != 2) continue;
                        this.properties.put(info[0], this.removeQuotationMarks(info[1]));
                    }
                }
                catch (IOException e) {
                    LogUtil.logError((Throwable)e);
                    IOUtils.closeQuietly(bri);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bri);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)bri);
        }
    }

    public String getProperty(String key) {
        return this.properties.getOrDefault(key, "");
    }

    public String getNameAndVersion() {
        return StringUtils.trim((String)(String.valueOf(this.getProperty(KEY_NAME)) + " " + this.getProperty(KEY_VERSION_ID)));
    }

    private String removeQuotationMarks(String str) {
        if (str.charAt(0) == '\"') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }
}

