/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.kms.katalon.application.hardware.Hardware;
import com.kms.katalon.application.hardware.Hardware4Win;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class MachineUtil {
    private static final String MAC_GET_MACHINE_ID_FIELD = "IOPlatformUUID";
    private static final String MAC_GET_MACHINE_ID_DELIMITER = "=";
    private static final String[] MAC_GET_MACHINE_ID_COMMAND = new String[]{"ioreg", "-rd1", "-c", "IOPlatformExpertDevice", "|", "grep", "IOPlatformUUID"};
    private static final String[] LINUX_GET_MACHINE_ID_COMMAND_2 = new String[]{"cat", "/etc/machine-id"};
    private static final String[] LINUX_GET_MACHINE_ID_COMMAND_1 = new String[]{"cat", "/var/lib/dbus/machine-id"};
    private static final String WINDOWS_GET_MACHINE_ID_DELIMITER = "REG_SZ";
    private static final String[] WINDOWS_GET_MACHINE_ID_COMMAND = new String[]{"reg", "query", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Cryptography", "/v", "MachineGuid"};
    private static final String UNAVAILABLE = "N/A";
    private static final String UUID_REGEX = "[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}";
    private static String machineId = "";

    public static String getMachineId() {
        if (!machineId.equals("") && !machineId.equals(MachineUtil.hash(UNAVAILABLE))) {
            return machineId;
        }
        if (SystemUtils.IS_OS_MAC) {
            LogUtil.logInfo((String)"Start getting machine ID on Mac");
            machineId = MachineUtil.parseMachineIdForMac();
            machineId = MachineUtil.hash(machineId.matches(UUID_REGEX) ? MachineUtil.appendAdditionalSignatures(machineId) : UNAVAILABLE);
            LogUtil.logInfo((String)("End getting machine ID on Mac " + machineId));
        } else if (SystemUtils.IS_OS_LINUX) {
            LogUtil.logInfo((String)"Start getting machine ID on Linux");
            machineId = MachineUtil.parseMachineIdForLinux();
            LogUtil.logInfo((String)("End getting machine ID on Linux " + machineId));
            machineId = MachineUtil.hash(machineId.length() == 32 ? MachineUtil.appendAdditionalSignatures(machineId) : UNAVAILABLE);
        } else if (SystemUtils.IS_OS_WINDOWS) {
            LogUtil.logInfo((String)"Start getting machine ID on Windows");
            machineId = MachineUtil.parseMachineIdForWindows();
            machineId = machineId.matches(UUID_REGEX) ? machineId : Hardware4Win.getSerialNumber();
            machineId = MachineUtil.hash(MachineUtil.appendAdditionalSignatures(machineId));
            LogUtil.logInfo((String)("End getting machine ID on Windows " + machineId));
        }
        return machineId;
    }

    public static String getOsDependentUsername() {
        String result = "";
        try {
            String className = null;
            String methodName = "getUsername";
            if (SystemUtils.IS_OS_WINDOWS) {
                className = "com.sun.security.auth.module.NTSystem";
                methodName = "getName";
            } else if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
                className = "com.sun.security.auth.module.UnixSystem";
            }
            if (className != null) {
                Class<?> c = Class.forName(className);
                Method method = c.getDeclaredMethod(methodName, new Class[0]);
                Object o = c.newInstance();
                result = (String)method.invoke(o, new Object[0]);
            }
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            LogUtil.logInfo((String)"OS username is empty");
            result = Optional.ofNullable(System.getProperty("user.name")).orElse("");
        }
        return result;
    }

    private static String appendAdditionalSignatures(String str) {
        LogUtil.logInfo((String)"Start appending additional signatures");
        String hardwareSerialNumber = Hardware.getSerialNumber().toLowerCase();
        String osDependentUsername = MachineUtil.getOsDependentUsername().toLowerCase();
        String signature = String.valueOf(str) + "_" + "_" + osDependentUsername;
        LogUtil.logInfo((String)("hardwareSerialNumber " + hardwareSerialNumber));
        LogUtil.logInfo((String)("osDependentUsername " + osDependentUsername));
        LogUtil.logInfo((String)("End appending additional signatures " + signature));
        return signature;
    }

    private static String hash(String str) {
        try {
            MessageDigest md1 = MessageDigest.getInstance("MD5");
            md1.update(str.getBytes());
            byte[] bd1 = md1.digest();
            StringBuffer hexString = new StringBuffer();
            int i = 0;
            while (i < bd1.length) {
                String hex = Integer.toHexString(0xFF & bd1[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
                ++i;
            }
            return hexString.toString().substring(0, 32);
        }
        catch (Exception e) {
            LogUtil.logError((String)(" Cannot hash the Machine ID because: " + e.getMessage()));
            return str;
        }
    }

    private static String parseMachineIdForWindows() {
        try {
            List commandLineResults = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])WINDOWS_GET_MACHINE_ID_COMMAND);
            String commandLineResult = commandLineResults.stream().filter(item -> item.indexOf(WINDOWS_GET_MACHINE_ID_DELIMITER) > 0).findFirst().orElse(UNAVAILABLE);
            String parsedResult = Arrays.asList(commandLineResult.split(WINDOWS_GET_MACHINE_ID_DELIMITER)).stream().map(result -> result.trim()).map(result -> result.toLowerCase()).filter(result -> result.matches(UUID_REGEX)).findAny().orElse(UNAVAILABLE);
            return parsedResult;
        }
        catch (IOException | InterruptedException e) {
            LogUtil.logError((Throwable)e);
            return UNAVAILABLE;
        }
    }

    private static String parseMachineIdForLinux() {
        try {
            String commandLineResult = ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])LINUX_GET_MACHINE_ID_COMMAND_1);
            if (commandLineResult.length() != 32) {
                commandLineResult = ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])LINUX_GET_MACHINE_ID_COMMAND_2);
            }
            return commandLineResult;
        }
        catch (IOException | InterruptedException e) {
            LogUtil.logError((Throwable)e);
            return UNAVAILABLE;
        }
    }

    private static String parseMachineIdForMac() {
        try {
            List commandLineResult = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])MAC_GET_MACHINE_ID_COMMAND);
            String parsedResult = commandLineResult.stream().filter(result -> result.contains(MAC_GET_MACHINE_ID_FIELD)).findAny().orElse(UNAVAILABLE);
            parsedResult = Arrays.asList(parsedResult.split(MAC_GET_MACHINE_ID_DELIMITER)).stream().map(result -> result.trim()).map(result -> result.replace("\"", "")).map(result -> result.toLowerCase()).filter(result -> result.matches(UUID_REGEX)).findAny().orElse(UNAVAILABLE);
            return parsedResult;
        }
        catch (IOException | InterruptedException e) {
            LogUtil.logError((Throwable)e);
            return UNAVAILABLE;
        }
    }
}

