/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.google.gson.JsonObject;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.ServerAPICommunicationUtil;
import com.kms.katalon.application.utils.VersionInfo;
import com.kms.katalon.application.utils.VersionRange;
import com.kms.katalon.logging.LogUtil;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.program.Program;

public class VersionUtil {
    public static final String URL_NEW_VERSION = "http://goo.gl/bNWyP0";
    private static final String VERSION_SEPARATOR_REGEX = "[,;]";

    public static boolean hasNewVersion() {
        VersionInfo currentVersion = VersionUtil.getCurrentVersion();
        return VersionUtil.isNewer(ApplicationInfo.officialReleaseVersion(), currentVersion.getVersion());
    }

    public static VersionInfo getCurrentVersion() {
        VersionInfo curVersion = new VersionInfo();
        curVersion.setVersion(ApplicationInfo.officialReleaseVersion());
        try {
            curVersion.setBuildNumber(Integer.parseInt(ApplicationInfo.buildNo()));
        }
        catch (NumberFormatException numberFormatException) {
            curVersion.setBuildNumber(0);
        }
        return curVersion;
    }

    public static VersionInfo getLatestVersion() {
        VersionInfo newVersion = new VersionInfo();
        JsonObject versionInfo = ServerAPICommunicationUtil.getJsonInformation("/server/key?value=KATALON_LASTEST_BUILD");
        if (versionInfo == null) {
            return VersionUtil.getCurrentVersion();
        }
        newVersion.setVersion(versionInfo.get("version").getAsString());
        try {
            newVersion.setBuildNumber(Integer.parseInt(versionInfo.get("build_number").getAsString().replaceAll("build", "").trim()));
        }
        catch (NumberFormatException numberFormatException) {
            newVersion.setBuildNumber(0);
        }
        return newVersion;
    }

    public static void gotoDownloadPage() {
        try {
            Program.launch((String)URL_NEW_VERSION);
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
        }
    }

    public static boolean isDevelopmentBuild() {
        return "dev".equals(ApplicationInfo.profile()) || "${build.profile}".equals(ApplicationInfo.profile());
    }

    public static boolean isStagingBuild() {
        return "stag".equals(ApplicationInfo.profile()) || "dev".equals(ApplicationInfo.profile());
    }

    public static boolean isNewer(String version, String comparedVersion) {
        if (StringUtils.equals((CharSequence)version, (CharSequence)comparedVersion)) {
            return false;
        }
        int[] thisVer = Arrays.stream(StringUtils.split((String)version, (char)'.')).mapToInt(Integer::parseInt).toArray();
        int[] thatVer = Arrays.stream(StringUtils.split((String)comparedVersion, (char)'.')).mapToInt(Integer::parseInt).toArray();
        int maxLength = Math.max(thisVer.length, thatVer.length);
        while (thisVer.length < maxLength) {
            thisVer = ArrayUtils.add((int[])thisVer, (int)0);
        }
        while (thatVer.length < maxLength) {
            thatVer = ArrayUtils.add((int[])thatVer, (int)0);
        }
        int i = 0;
        while (i < maxLength) {
            if (thisVer[i] != thatVer[i]) {
                if (thisVer[i] > thatVer[i]) {
                    return true;
                }
                if (thisVer[i] < thatVer[i]) {
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean isCurrentVersionAppliedToUpdate(String currentVersion, String latestVersion, String appliedToUpdateVersions) {
        String[] strVersionRanges;
        if (appliedToUpdateVersions == null || appliedToUpdateVersions.isEmpty()) {
            return true;
        }
        appliedToUpdateVersions = appliedToUpdateVersions.replaceAll("\\s", "");
        String[] stringArray = strVersionRanges = appliedToUpdateVersions.split(VERSION_SEPARATOR_REGEX);
        int n = strVersionRanges.length;
        int n2 = 0;
        while (n2 < n) {
            String strVersionRange = stringArray[n2];
            VersionRange versionRange = new VersionRange(strVersionRange, latestVersion);
            if (versionRange.contains(currentVersion)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int getMajorVersion() {
        int[] version = Arrays.stream(StringUtils.split((String)VersionUtil.getCurrentVersion().getVersion(), (char)'.')).mapToInt(Integer::parseInt).toArray();
        if (version.length > 0) {
            return version[0];
        }
        return -1;
    }
}

