/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.crypto;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.google.api.client.util.PemReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LicenseHelper {
    private static LicenseHelper serviceInstance;

    private LicenseHelper() {
    }

    public static LicenseHelper getInstance() {
        if (serviceInstance == null) {
            serviceInstance = new LicenseHelper();
        }
        return serviceInstance;
    }

    public Map<String, Claim> parseJws(String jws) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return this.parseJws(jws, "-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAljznsPZafPzlRo+NyyVTb4ZJaLYtSghoi0lNDOEyHNJhROWi7roPcK0mMkVz+2tCE0OXL+Aps0IS5zHwTZpNMSu7t7IEgFUfUJ7ZSUNM1HGo/kcwJc4knBdK2Zi0QS0bu30VIp9zBmvtuGsxrGTfmV8TI091SHAQfWWJjD2UPfHxz0xeyGNwInSEjJhhV67Cl1r9RlrDUt5Ai2/r5s1AtFD/UDLHObAkGKY4CO7Ei/PnH8OJi9S6MtW5o6NWAjBY4qj1brUGl/IX46KRIny7zJ1zoVSsy8plBBGs9VFAyky7sq7fkjZFvbBw46PWWTFZCuSYeFiXul2IKTVLWaqE0wIDAQAB\n-----END PUBLIC KEY-----");
    }

    public Map<String, Claim> parseJws(String jws, String publicKeyString) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        if (jws.isEmpty()) {
            return Collections.emptyMap();
        }
        if (StringUtils.isBlank((CharSequence)publicKeyString)) {
            return Collections.emptyMap();
        }
        RSAPublicKey publicKey = (RSAPublicKey)this.getPublicKey(publicKeyString);
        Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)publicKey, null);
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
        return verifier.verify(jws).getClaims();
    }

    public PublicKey getDefaultPublicKey() throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        return this.getPublicKey("-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAljznsPZafPzlRo+NyyVTb4ZJaLYtSghoi0lNDOEyHNJhROWi7roPcK0mMkVz+2tCE0OXL+Aps0IS5zHwTZpNMSu7t7IEgFUfUJ7ZSUNM1HGo/kcwJc4knBdK2Zi0QS0bu30VIp9zBmvtuGsxrGTfmV8TI091SHAQfWWJjD2UPfHxz0xeyGNwInSEjJhhV67Cl1r9RlrDUt5Ai2/r5s1AtFD/UDLHObAkGKY4CO7Ei/PnH8OJi9S6MtW5o6NWAjBY4qj1brUGl/IX46KRIny7zJ1zoVSsy8plBBGs9VFAyky7sq7fkjZFvbBw46PWWTFZCuSYeFiXul2IKTVLWaqE0wIDAQAB\n-----END PUBLIC KEY-----");
    }

    public PublicKey getPublicKey(String publicKeyString) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        if (StringUtils.isBlank((CharSequence)publicKeyString)) {
            return null;
        }
        KeyFactory kf = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(this.readPemString(publicKeyString));
        return kf.generatePublic(keySpec);
    }

    private byte[] readPemString(String string) throws IOException {
        return PemReader.readFirstSectionAndClose((Reader)new StringReader(string)).getBase64DecodedBytes();
    }
}

