/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.license;

import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.license.models.ConsoleLicenseType;
import java.text.MessageFormat;

public class ConsoleLicenseService {
    private ConsoleLicenseType licenseType;
    private static ConsoleLicenseService serviceInstance;

    private ConsoleLicenseService() {
    }

    public static ConsoleLicenseService getInstance() {
        if (serviceInstance == null) {
            serviceInstance = new ConsoleLicenseService();
        }
        return serviceInstance;
    }

    public void setLicenseType(ConsoleLicenseType licenseType) {
        this.licenseType = licenseType;
    }

    public ConsoleLicenseType getLicenseType() {
        return this.licenseType;
    }

    public boolean isValidTestCloudLicense() {
        return this.licenseType != null && this.licenseType != ConsoleLicenseType.KRE_LICENSE;
    }

    public boolean isValidKRELicense() {
        return this.licenseType != null && this.licenseType != ConsoleLicenseType.TESTCLOUD_LICENSE;
    }

    public boolean isValidRunConfig(String runConfigurationId) {
        if (this.licenseType == ConsoleLicenseType.ALL) {
            return true;
        }
        if (runConfigurationId.equalsIgnoreCase(GlobalMessageConstants.TESTCLOUD_NAME)) {
            return this.licenseType == ConsoleLicenseType.TESTCLOUD_LICENSE;
        }
        return this.licenseType == ConsoleLicenseType.KRE_LICENSE;
    }

    public String getMsgAfterCheckingTSCLicense() {
        return this.getLicenseMessagePattern(ApplicationMessageConstants.THERE_IS_NO_X_LICENSE_AVAILABLE);
    }

    private String getLicenseMessagePattern(String msgPattern) {
        if (this.licenseType == ConsoleLicenseType.TESTCLOUD_LICENSE) {
            return MessageFormat.format(msgPattern, GlobalMessageConstants.KATALON_RUNTIME_ENGINE_NAME);
        }
        if (this.licenseType == ConsoleLicenseType.KRE_LICENSE) {
            return MessageFormat.format(msgPattern, GlobalMessageConstants.TESTCLOUD_NAME);
        }
        return "";
    }

    public String getReasonTerminateTestSuiteCollection() {
        return this.getLicenseMessagePattern(ApplicationMessageConstants.TERMINATE_TSC_NO_X_LICENSE_AVAILABLE);
    }
}

