/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.filters.AlreadyAddedTestCaseViewerFilter;
import com.kms.katalon.composer.testsuite.providers.TestCaseTableViewer;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class TestCaseSelectionDialog
extends TreeEntitySelectionDialog {
    private static final String ENABLE_FILTER_ALREADY_ADDED_TEST_CASES_MODE_PREFERENCE = "enableFilterAlreadyAddedTestCasesMode";
    private TestCaseTableViewer tableViewer;
    private List<Object> tcTreeEntities;
    private List<Object> checkedItems;
    private Button chckFilterAlreadyAddedTestCases;
    private AlreadyAddedTestCaseViewerFilter alreadyAddedTestCasesfilter;
    private ScopedPreferenceStore store;

    public TestCaseSelectionDialog(Shell parent, IEntityLabelProvider labelProvider, ITreeContentProvider contentProvider, AlreadyAddedTestCaseViewerFilter entityViewerFilter, TestCaseTableViewer tableViewer) {
        super(parent, labelProvider, contentProvider, (AbstractEntityViewerFilter)entityViewerFilter);
        this.tableViewer = tableViewer;
        this.alreadyAddedTestCasesfilter = entityViewerFilter;
        this.setTitle(ComposerTestsuiteMessageConstants.DIA_TITLE_TEST_CASE_BROWSER);
        this.setAllowMultiple(false);
        this.store = PreferenceStoreManager.getPreferenceStore(TestCaseSelectionDialog.class);
        this.setDoubleClickSelects(false);
        this.updateTestCaseTreeEntities();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 20, ComposerTestsuiteMessageConstants.DIA_BTN_ADD_N_CONTINUE, false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (this.store != null) {
            try {
                this.store.save();
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        if (20 == buttonId) {
            this.doAddAndContinue();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        if (!DialogUtil.getCanClickOK((Shell)this.getShell())) {
            return;
        }
        this.computeResult();
        this.setReturnCode(0);
        try {
            this.doAddCheckedEntitiesToTestSuite();
        }
        catch (Exception exception) {}
        this.close();
    }

    private void doAddAndContinue() {
        this.computeResult();
        if (this.getResult() == null || this.getResult().length == 0) {
            MessageDialog.openWarning((Shell)this.getParentShell(), (String)StringConstants.WARN_TITLE, (String)ComposerTestsuiteMessageConstants.DIA_WARN_NO_TEST_CASE_SELECTION);
            return;
        }
        this.setReturnCode(20);
        try {
            this.doAddCheckedEntitiesToTestSuite();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void computeResult() {
        ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)this.getTreeViewer();
        List<Object> grayedItems = Arrays.asList(treeViewer.getGrayedElements());
        this.checkedItems.removeAll(grayedItems);
        this.setResult(this.checkedItems);
    }

    public void doAddCheckedEntitiesToTestSuite() throws Exception {
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                TestCaseSelectionDialog.this.doAddCheckedTestCasesToTestSuite(monitor);
            }
        });
        this.updateTestCaseTreeEntities();
    }

    private void doAddCheckedTestCasesToTestSuite(IProgressMonitor monitor) {
        ArrayList<Object> selectedObjects = new ArrayList<Object>(Arrays.asList(this.getResult()));
        int selectedObjectsSize = selectedObjects.size();
        monitor.beginTask("", selectedObjectsSize);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask("", selectedObjectsSize);
        for (Object e : selectedObjects) {
            try {
                SubMonitor subSubMonitor = subMonitor.split(1, 0);
                if (!(e instanceof ITreeEntity)) continue;
                ITreeEntity treeEntity = (ITreeEntity)e;
                if (treeEntity instanceof FolderTreeEntity) {
                    FolderEntity fEntity = (FolderEntity)treeEntity.getObject();
                    this.doAddTestCasesInCheckedFolderToTestSuite(fEntity);
                    continue;
                }
                if (!(treeEntity instanceof TestCaseTreeEntity)) continue;
                TestCaseEntity tcEntity = (TestCaseEntity)treeEntity.getObject();
                subSubMonitor.beginTask("Adding test case " + tcEntity.getIdForDisplay() + " to test suite", 1);
                UISynchronizeService.syncExec(() -> {
                    try {
                        this.tableViewer.addTestCase(tcEntity);
                    }
                    catch (Exception exception) {}
                });
                subSubMonitor.done();
            }
            catch (Exception e2) {
                LoggerSingleton.logError((Throwable)e2);
            }
        }
        monitor.done();
    }

    private void doAddTestCasesInCheckedFolderToTestSuite(FolderEntity folderEntity) throws Exception {
        if (folderEntity.getFolderType() == FolderEntity.FolderType.TESTCASE) {
            FolderController folderController = FolderController.getInstance();
            for (Object childObject : folderController.getChildren(folderEntity)) {
                if (childObject instanceof TestCaseEntity) {
                    this.tableViewer.addTestCase((TestCaseEntity)childObject);
                    continue;
                }
                if (!(childObject instanceof FolderEntity)) continue;
                this.doAddTestCasesInCheckedFolderToTestSuite((FolderEntity)childObject);
            }
        }
    }

    private void updateTestCaseTreeEntities() {
        try {
            this.tcTreeEntities = new ArrayList<Object>(Arrays.asList(this.getAddedTestCase(this.tableViewer.getTestCasesPKs())));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite parent1 = (Composite)super.createDialogArea(parent);
        this.addAlreadyAddedTestCaseFilterControl(parent1);
        this.initializeFilterAlreadyAddedTestCasesMode();
        return parent1;
    }

    private void initializeFilterAlreadyAddedTestCasesMode() {
        boolean shouldEnableAlreadyAddedTestCasesControl;
        if (this.store != null && (shouldEnableAlreadyAddedTestCasesControl = this.store.getBoolean(ENABLE_FILTER_ALREADY_ADDED_TEST_CASES_MODE_PREFERENCE))) {
            this.chckFilterAlreadyAddedTestCases.setSelection(shouldEnableAlreadyAddedTestCasesControl);
            UISynchronizeService.syncExec(() -> {
                this.alreadyAddedTestCasesfilter.enableAlreadyAddedTestCases();
                this.getTreeViewer().refresh();
            });
        }
    }

    private void addAlreadyAddedTestCaseFilterControl(Composite parent1) {
        this.chckFilterAlreadyAddedTestCases = new Button(parent1, 32);
        this.chckFilterAlreadyAddedTestCases.setText("Hide Test Cases already added to Test Suites");
        this.chckFilterAlreadyAddedTestCases.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
                if (!featureService.canUse(KSEFeature.FILTER_ALREADY_ADDED_TEST_CASES)) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.FILTER_ALREADY_ADDED_TEST_CASES);
                    TestCaseSelectionDialog.this.chckFilterAlreadyAddedTestCases.setSelection(false);
                    return;
                }
                boolean filterAlreadyAddedTestCases = TestCaseSelectionDialog.this.chckFilterAlreadyAddedTestCases.getSelection();
                UISynchronizeService.syncExec(() -> {
                    if (filterAlreadyAddedTestCases) {
                        TestCaseSelectionDialog.this.alreadyAddedTestCasesfilter.enableAlreadyAddedTestCases();
                    } else {
                        TestCaseSelectionDialog.this.alreadyAddedTestCasesfilter.disableAlreadyAddedTestCases();
                    }
                });
                TestCaseSelectionDialog.this.store.setValue(TestCaseSelectionDialog.ENABLE_FILTER_ALREADY_ADDED_TEST_CASES_MODE_PREFERENCE, filterAlreadyAddedTestCases);
                TestCaseSelectionDialog.this.getTreeViewer().refresh();
                ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)TestCaseSelectionDialog.this.getTreeViewer();
                TestCaseSelectionDialog.this.checkedItems.forEach(item -> {
                    boolean bl = treeViewer.setChecked(item, true);
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblInfo = new Label(parent1, 0);
        lblInfo.setText(" * This filter only retrieves data from saved test suites");
    }

    public TreeViewer createTreeViewer(Composite parent) {
        final ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)super.createTreeViewer(parent);
        treeViewer.getTree().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem item = (TreeItem)event.item;
                    treeViewer.getTree().setSelection(item);
                    TestCaseSelectionDialog.this.onStageChangedTreeItem(item.getData(), item.getChecked());
                }
            }
        });
        Object[] addedTestCases = this.getAddedTestCase(this.tableViewer.getTestCasesPKs());
        treeViewer.setCheckedElements(addedTestCases);
        this.checkedItems = new ArrayList<Object>(Arrays.asList(addedTestCases));
        return treeViewer;
    }

    private void onStageChangedTreeItem(Object element, boolean isChecked) {
        if (element instanceof TestCaseTreeEntity) {
            if (isChecked) {
                if (!this.checkedItems.contains(element)) {
                    this.checkedItems.add(element);
                }
            } else {
                this.checkedItems.remove(element);
            }
            return;
        }
        if (element instanceof FolderTreeEntity) {
            try {
                ITreeEntity[] iTreeEntityArray = TreeEntityUtil.getChildren((FolderTreeEntity)((FolderTreeEntity)element));
                int n = iTreeEntityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeEntity childElement = iTreeEntityArray[n2];
                    this.onStageChangedTreeItem(childElement, isChecked);
                    ++n2;
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new ContainerCheckedTreeViewer(new Tree(parent, 0x20 | style));
    }

    protected void filterSearchedText() {
        super.filterSearchedText();
        ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)this.getTreeViewer();
        treeViewer.setCheckedElements(this.checkedItems.toArray());
    }

    private Object[] getAddedTestCase(List<String> ids) {
        ArrayList testCaseList = new ArrayList();
        try {
            TestCaseController c = TestCaseController.getInstance();
            for (String id : ids) {
                TestCaseEntity tc = c.getTestCase(id);
                TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)tc, (ProjectEntity)tc.getProject());
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return testCaseList.toArray();
    }

    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    protected void handleShellCloseEvent() {
        if (!DialogUtil.getCanClose((Shell)this.getShell())) {
            return;
        }
        super.handleShellCloseEvent();
    }
}

