/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.integration;

import com.kms.katalon.integration.analytics.entity.AnalyticsTestCase;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestSuitePlatformAnalysis {
    private static TestSuitePlatformAnalysis _instance;
    private Map<String, Map<String, AnalyticsTestCase>> analyticsTestCasesMap = new HashMap<String, Map<String, AnalyticsTestCase>>();

    public void setAnalyticsTestCasesMap(String testSuiteId, List<AnalyticsTestCase> analyticsTestCases) {
        HashMap<String, AnalyticsTestCase> testCaseMap = new HashMap<String, AnalyticsTestCase>();
        for (AnalyticsTestCase testCase : analyticsTestCases) {
            String key = String.valueOf(testCase.getPath()) + "/" + testCase.getName();
            testCaseMap.put(key, testCase);
        }
        this.analyticsTestCasesMap.put(testSuiteId, testCaseMap);
    }

    public static TestSuitePlatformAnalysis getInstance() {
        if (_instance == null) {
            _instance = new TestSuitePlatformAnalysis();
        }
        return _instance;
    }

    public Map<String, AnalyticsTestCase> getAnalyticsTestCase(String testSuiteId) {
        Map<String, AnalyticsTestCase> analyticsTestCases = this.analyticsTestCasesMap.get(testSuiteId);
        if (analyticsTestCases == null || analyticsTestCases.isEmpty()) {
            return Collections.emptyMap();
        }
        return analyticsTestCases;
    }

    public AnalyticsTestCase getAnalyticsTestCase(String testSuiteId, String testCaseId) {
        Map<String, AnalyticsTestCase> testCaseMap = this.analyticsTestCasesMap.get(testSuiteId);
        if (testCaseMap == null) {
            return null;
        }
        return testCaseMap.get(testCaseId);
    }

    public void clearTestSuiteData(String testSuiteId) {
        this.analyticsTestCasesMap.remove(testSuiteId);
    }
}

