/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.providers;

import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.ImageConstants;
import com.kms.katalon.composer.testsuite.integration.TestSuitePlatformAnalysis;
import com.kms.katalon.composer.testsuite.providers.TestCaseTableViewer;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.analytics.entity.AnalyticsExecution;
import com.kms.katalon.integration.analytics.entity.AnalyticsExecutionStatus;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestCase;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;

public class TestCaseTableLabelProvider
extends StyledCellLabelProvider {
    public static final int COLUMN_NOTIFICATION_INDEX = 0;
    public static final int COLUMN_ORDER_INDEX = 1;
    public static final int COLUMN_ID_INDEX = 2;
    public static final int COLUMN_DESCRIPTION_INDEX = 3;
    public static final int COLUMN_FLAKINESS_INDEX = 4;
    public static final int COLUMN_LATEST_RUN_INDEX = 5;
    public static final int COLUMN_AVG_DURATION_INDEX = 6;
    public static final int COLUMN_RUN_INDEX = 7;
    private static TestCaseController testCaseController = TestCaseController.getInstance();
    private int columnIndex;

    public TestCaseTableLabelProvider(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    private Image getStatusImage(AnalyticsExecutionStatus status, boolean isLastRun) {
        switch (status) {
            case PASSED: {
                return isLastRun ? ImageConstants.IMG_PASSED_LAST_RUN : ImageConstants.IMG_PASSED_RUN;
            }
            case FAILED: {
                return isLastRun ? ImageConstants.IMG_FAILED_LAST_RUN : ImageConstants.IMG_FAILED_RUN;
            }
            case ERROR: {
                return isLastRun ? ImageConstants.IMG_ERROR_LAST_RUN : ImageConstants.IMG_ERROR_RUN;
            }
            case INCOMPLETE: {
                return isLastRun ? ImageConstants.IMG_INCOMPLETE_LAST_RUN : ImageConstants.IMG_INCOMPLETE_RUN;
            }
            case SKIPPED: {
                return isLastRun ? ImageConstants.IMG_SKIPPED_LAST_RUN : ImageConstants.IMG_SKIPPED_RUN;
            }
        }
        return null;
    }

    private void drawLastRunIcon(Event event, GC gc, List<AnalyticsExecution> analyticsExecutions) {
        if (analyticsExecutions.size() < 1) {
            return;
        }
        int drawPosition = analyticsExecutions.size() - 1;
        int i = 0;
        while (i < analyticsExecutions.size()) {
            if (i == 0) {
                gc.drawImage(this.getStatusImage(analyticsExecutions.get(i).getStatus(), true), event.getBounds().x + ImageConstants.IMG_FAILED_RUN.getBounds().width * drawPosition - 5 * drawPosition, event.getBounds().y);
            } else {
                gc.drawImage(this.getStatusImage(analyticsExecutions.get(i).getStatus(), false), event.getBounds().x + ImageConstants.IMG_FAILED_RUN.getBounds().width * (drawPosition - i) - 5 * (drawPosition - i), event.getBounds().y);
            }
            ++i;
        }
    }

    protected void paint(Event event, Object element) {
        if (element == null || !(element instanceof TestSuiteTestCaseLink)) {
            return;
        }
        GC gc = event.gc;
        String testSuiteId = this.getTestCaseTableViewer().getTestSuite();
        String testCaseId = ((TestSuiteTestCaseLink)element).getTestCaseId();
        AnalyticsTestCase analyticsTestCase = TestSuitePlatformAnalysis.getInstance().getAnalyticsTestCase(testSuiteId, testCaseId);
        TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)element;
        Object allTestCaseLinks = this.getTestCaseTableViewer().getInput();
        if (this.columnIndex == 7) {
            if (((TestSuiteTestCaseLink)element).getIsRun()) {
                gc.drawImage(ImageConstants.IMG_16_CHECKBOX_CHECKED, event.getBounds().x + 5, event.getBounds().y);
            } else {
                gc.drawImage(ImageConstants.IMG_16_CHECKBOX_UNCHECKED, event.getBounds().x + 5, event.getBounds().y);
            }
        } else if (this.columnIndex == 5 && analyticsTestCase != null && allTestCaseLinks.indexOf(testCaseLink) < 30) {
            List executionTestCases = analyticsTestCase.getExecutionTestCases();
            this.drawLastRunIcon(event, gc, executionTestCases);
        } else if (this.columnIndex == 0) {
            if (this.getTestCase(element) == null) {
                gc.drawImage(ImageConstants.IMG_16_NOTIFICATION_HEADER, event.getBounds().x + 2, event.getBounds().y);
            }
        } else {
            super.paint(event, element);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getColumnText(Object element) {
        TestCaseEntity testCase = this.getTestCase(element);
        String testSuiteId = this.getTestCaseTableViewer().getTestSuite();
        String testCaseId = ((TestSuiteTestCaseLink)element).getTestCaseId();
        AnalyticsTestCase analyticsTestCase = TestSuitePlatformAnalysis.getInstance().getAnalyticsTestCase(testSuiteId, testCaseId);
        try {
            TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)element;
            Object allTestCaseLinks = this.getTestCaseTableViewer().getInput();
            switch (this.columnIndex) {
                case 1: {
                    return Integer.toString(allTestCaseLinks.indexOf(testCaseLink) + 1);
                }
                case 2: {
                    return testCaseLink.getTestCaseId();
                }
                case 3: {
                    if (testCase != null) return testCase.getDescription();
                    return "";
                }
                case 7: {
                    return "";
                }
                case 5: {
                    if (analyticsTestCase == null) return "--";
                    if (allTestCaseLinks.indexOf(testCaseLink) < 30) return "";
                    return "--";
                }
            }
            return "";
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return "";
    }

    public String getToolTipText(Object element) {
        if (this.columnIndex == 0 && this.getTestCase(element) == null) {
            TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)element;
            return MessageFormat.format(ComposerTestsuiteMessageConstants.LP_WARN_MSG_TEST_CASE_MISSING, testCaseLink.getTestCaseId());
        }
        return StringUtils.defaultIfEmpty((String)this.getColumnText(element), null);
    }

    public void update(ViewerCell cell) {
        String searchString;
        String cellText = this.getColumnText(cell.getElement());
        cell.setText(cellText);
        cell.setImage(null);
        if (this.columnIndex == 2) {
            TextLayout textLayout = new TextLayout((Device)cell.getControl().getDisplay());
            textLayout.setText(cellText);
            Table table = (Table)this.getViewer().getControl();
            if (textLayout.getBounds().width + 5 > table.getColumn(this.columnIndex).getWidth()) {
                int textNameIdx = Math.max(0, cellText.lastIndexOf("/"));
                cell.setText(".." + cellText.substring(textNameIdx, cellText.length()));
            }
        }
        if (this.getTestCase(cell.getElement()) == null) {
            if (this.columnIndex == 2) {
                cell.setForeground(ColorUtil.getErrorTableItemForegroundColor());
            }
        } else {
            cell.setForeground(ColorUtil.getDefaultTextColor());
        }
        ArrayList<StyleRange> range = new ArrayList<StyleRange>();
        if (this.columnIndex != 1 && (searchString = this.getTestCaseTableViewer().getSearchedString().trim().toLowerCase()) != null && !searchString.isEmpty()) {
            String highlightedString = this.getHighlightedString(searchString);
            if (cell.getText().toLowerCase().contains(highlightedString) && !highlightedString.isEmpty()) {
                Matcher m = Pattern.compile(Pattern.quote(highlightedString)).matcher(cell.getText().toLowerCase());
                while (m.find()) {
                    StyleRange myStyledRange = new StyleRange(m.start(), highlightedString.length(), null, ColorUtil.getHighlightBackgroundColor());
                    range.add(myStyledRange);
                }
            }
        }
        cell.setStyleRanges(range.toArray(new StyleRange[range.size()]));
        super.update(cell);
    }

    private TestCaseTableViewer getTestCaseTableViewer() {
        return (TestCaseTableViewer)this.getViewer();
    }

    private TestCaseEntity getTestCase(Object element) {
        if (!(element instanceof TestSuiteTestCaseLink)) {
            return null;
        }
        try {
            TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)element;
            return testCaseController.getTestCaseByDisplayId(testCaseLink.getTestCaseId());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getHighlightedString(String searchedString) {
        Map tagMap = EntityViewerFilter.parseSearchedString((String[])TestCaseTreeEntity.SEARCH_TAGS, (String)searchedString);
        String highlightedString = null;
        switch (this.columnIndex) {
            case 2: {
                highlightedString = (String)tagMap.get("id");
                break;
            }
            case 3: {
                highlightedString = (String)tagMap.get("description");
            }
        }
        return highlightedString == null || highlightedString.isEmpty() ? searchedString : highlightedString;
    }
}

