/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.javalite.http.FileField;
import org.javalite.http.FormField;
import org.javalite.http.Http;
import org.javalite.http.HttpException;
import org.javalite.http.Request;

public class Multipart
extends Request<Multipart> {
    private static final String LINE_FEED = "\r\n";
    private PrintWriter writer;
    private String boundary;
    private OutputStream outputStream;
    private List<FormField> formFields = new ArrayList<FormField>();

    public Multipart(String url, int connectTimeout, int readTimeout) {
        super(url, connectTimeout, readTimeout);
    }

    @Override
    protected Multipart doConnect() {
        try {
            this.boundary = "===" + System.currentTimeMillis() + "===";
            this.connection.setUseCaches(false);
            this.connection.setDoOutput(true);
            this.connection.setDoInput(true);
            this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
            this.connection.setInstanceFollowRedirects(this.redirect);
            this.outputStream = this.connection.getOutputStream();
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream), true);
            this.sendData();
            this.finish();
            return this;
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
    }

    private void sendData() {
        for (FormField f : this.formFields) {
            if (f.isFile()) {
                this.sendFile((FileField)f);
                continue;
            }
            this.sendField(f);
        }
    }

    private void finish() {
        this.writer.append(LINE_FEED);
        this.writer.append("--").append(this.boundary).append("--").append(LINE_FEED);
        this.writer.close();
    }

    private void sendField(FormField f) {
        this.writer.append("--").append(this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"").append(f.getName()).append("\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(f.getValue()).append(LINE_FEED);
        this.writer.flush();
    }

    private void sendFile(FileField f) {
        try {
            int bytesRead;
            String fileName = f.getFile().getName();
            this.writer.append("--").append(this.boundary).append(LINE_FEED);
            this.writer.append("Content-Disposition: form-data; name=\"").append(f.getName()).append("\"; filename=\"").append(fileName).append("\"").append(LINE_FEED);
            this.writer.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(fileName)).append(LINE_FEED);
            this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
            this.writer.append(LINE_FEED);
            this.writer.flush();
            FileInputStream inputStream = new FileInputStream(f.getFile());
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.outputStream.write(buffer, 0, bytesRead);
            }
            this.outputStream.flush();
            inputStream.close();
            this.writer.append(LINE_FEED);
            this.writer.flush();
        }
        catch (Exception e) {
            throw new HttpException(e);
        }
    }

    public Multipart field(FormField field) {
        this.formFields.add(field);
        return this;
    }

    public Multipart field(String name, String value) {
        this.formFields.add(new FormField(name, value));
        return this;
    }

    public Multipart fields(String ... namesAndValues) {
        if (namesAndValues == null) {
            throw new NullPointerException("'names and values' cannot be null");
        }
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("mus pas even number of arguments");
        }
        for (int i = 0; i < namesAndValues.length - 1; i += 2) {
            if (namesAndValues[i] == null) {
                throw new IllegalArgumentException("parameter names cannot be nulls");
            }
            this.formFields.add(new FormField(namesAndValues[i], namesAndValues[i + 1]));
        }
        return this;
    }

    public Multipart file(String fieldName, String filePath) {
        this.formFields.add(new FileField(fieldName, new File(filePath)));
        return this;
    }

    public static void main(String[] args) {
        Multipart mp = Http.multipart("http://localhost:8080/upload/save").field("name1", "val1").file("file1", "/home/igor/tmp/test.txt");
        System.out.println(mp.text());
    }
}

