/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.rewriter;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.antlr.LineColumn;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.core.rewriter.ASTWriterHelper;
import org.codehaus.groovy.eclipse.refactoring.core.utils.FilePartReader;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ImportResolver;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ASTWriter
extends CodeVisitorSupport
implements GroovyClassVisitor {
    protected StringBuilder groovyCode;
    private String lineDelimiter;
    protected Deque<ASTNode> nodeStack = new ArrayDeque<ASTNode>();
    private final ModuleNode root;
    private int lineOfPreviousNode = 1;
    private int lineOfCurrentNode = 1;
    private int columnOffset;
    private int caseCount;
    private boolean inElseBlock;
    private final IDocument currentDocument;
    private int lineOffset;
    private boolean explizitModifier;
    private String modifier = "";
    private int linesSinceFirstAnnotation;
    private DeclarationExpression previousDeclaration;

    public ASTWriter(ModuleNode root, int lineOffset, IDocument currentDocument) {
        this(root, currentDocument);
        this.setLineOffset(lineOffset);
    }

    public ASTWriter(ModuleNode root, IDocument currentDocument) {
        this.groovyCode = new StringBuilder();
        try {
            if (currentDocument != null) {
                this.lineDelimiter = currentDocument.getLineDelimiter(0);
            }
        }
        catch (BadLocationException e) {
            GroovyCore.logException((String)"Error writing AST", (Throwable)e);
        }
        if (this.lineDelimiter == null) {
            this.lineDelimiter = System.getProperty("line.separator");
        }
        this.root = root;
        this.currentDocument = currentDocument;
    }

    public ASTWriter(Expression e) {
        this(ASTWriter.createModuleNode(e), null);
    }

    private static ModuleNode createModuleNode(Expression e) {
        ModuleNode module = new ModuleNode(null);
        module.addStatement((Statement)new ExpressionStatement(e));
        module.setDescription("DummyModule.groovy");
        return module;
    }

    public void setStartOffset(int startOffset) {
        this.columnOffset = startOffset;
        this.printColumnOffset();
    }

    public void setLineOffset(int offset) {
        this.lineOffset = offset;
    }

    public void setModifierToUse(String mod) {
        this.modifier = mod;
        this.explizitModifier = true;
    }

    public void insertLineFeed() {
        this.groovyCode.append(this.lineDelimiter);
    }

    public String getGroovyCode() {
        return this.groovyCode.toString();
    }

    public void visitRoot() {
        this.preVisitStatement((ASTNode)this.root);
        if (this.root.getPackageName() != null) {
            this.groovyCode.append("package ");
            String packageName = this.root.getPackageName();
            this.groovyCode.append(packageName.substring(0, packageName.length() - 1));
        }
        this.printImports(this.root.getStarImports());
        this.printImports(this.root.getImports());
        this.printImports(this.root.getStaticImports().values());
        this.printImports(this.root.getStaticStarImports().values());
        if (!this.root.getStatementBlock().isEmpty()) {
            this.visitBlockStatement(this.root.getStatementBlock());
        }
        List classes = this.root.getClasses();
        for (ClassNode classNode : classes) {
            if (!classNode.isScript()) {
                this.visitClass(classNode);
                continue;
            }
            List methods = this.root.getMethods();
            for (MethodNode method : methods) {
                this.visitMethod(method);
            }
        }
        this.postVisitStatement((ASTNode)this.root);
    }

    private void printImports(Collection<ImportNode> imports) {
        Iterator<ImportNode> impIter = imports.iterator();
        while (impIter.hasNext()) {
            ImportNode imp = impIter.next();
            this.groovyCode.append(imp.getText());
            if (!impIter.hasNext()) continue;
            this.insertLineFeed();
            ++this.lineOfPreviousNode;
        }
    }

    public void visitClass(ClassNode node) {
        this.visitAnnotations((AnnotatedNode)node);
        this.preVisitStatement((ASTNode)node);
        this.linesSinceFirstAnnotation = 0;
        if (node.getSuperClass().getName().equals("java.lang.Enum")) {
            this.writeEnum(node);
            return;
        }
        if (node.isInterface()) {
            this.groovyCode.append("interface ");
        } else {
            this.groovyCode.append(ASTWriterHelper.getAccModifier(node.getModifiers(), 2));
            this.groovyCode.append("class ");
        }
        this.printType(node);
        if (!node.getSuperClass().getNameWithoutPackage().equals("Object")) {
            this.groovyCode.append(" extends ");
            this.groovyCode.append(node.getSuperClass().getNameWithoutPackage());
        }
        if (node.getInterfaces().length > 0) {
            this.groovyCode.append(" implements ");
            ClassNode[] theInterfaces = node.getInterfaces();
            int i = 0;
            while (i < theInterfaces.length) {
                this.groovyCode.append(theInterfaces[i].getNameWithoutPackage());
                if (i < theInterfaces.length - 1) {
                    this.groovyCode.append(", ");
                }
                ++i;
            }
        }
        this.preVisitStatementOpenBlock((ASTNode)node);
        node.visitContents((GroovyClassVisitor)this);
        this.postVisitStatementCloseBlock((ASTNode)node);
        this.postVisitStatement((ASTNode)node);
    }

    private void writeEnum(ClassNode node) {
        this.groovyCode.append("enum ");
        this.groovyCode.append(String.valueOf(node.getName()) + " ");
        this.groovyCode.append('{');
        int i = 0;
        while (i < node.getFields().size()) {
            FieldNode fn = (FieldNode)node.getFields().get(i);
            if (i == 0) {
                this.groovyCode.append(fn.getName());
            } else if (!fn.getName().startsWith("$")) {
                this.groovyCode.append(", " + fn.getName());
            }
            ++i;
        }
        this.groovyCode.append('}');
        this.postVisitStatement((ASTNode)node);
    }

    public void visitAnnotations(AnnotatedNode node) {
        boolean first = true;
        List annotionMap = node.getAnnotations();
        if (annotionMap.isEmpty()) {
            return;
        }
        for (AnnotationNode an : annotionMap) {
            int extra = 1;
            this.linesSinceFirstAnnotation += an.getLastLineNumber() + extra - an.getLineNumber();
            this.preVisitStatement((ASTNode)an);
            this.groovyCode.append("@");
            this.groovyCode.append(an.getClassNode().getNameWithoutPackage());
            if (an.isBuiltIn()) continue;
            for (Map.Entry member : an.getMembers().entrySet()) {
                Expression memberValue = (Expression)member.getValue();
                this.preVisitExpression((ASTNode)memberValue);
                if (first) {
                    first = false;
                    this.groovyCode.append("(value = ");
                } else {
                    this.groovyCode.append(", value = ");
                }
                memberValue.visit((GroovyCodeVisitor)this);
                if (!first) {
                    this.groovyCode.append(")");
                }
                this.postVisitExpression((ASTNode)memberValue);
            }
            this.postVisitStatement((ASTNode)an);
        }
    }

    protected void visitClassCodeContainer(Statement code) {
        if (code != null) {
            code.visit((GroovyCodeVisitor)this);
        }
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.visitAnnotations((AnnotatedNode)node);
        this.preVisitStatement((ASTNode)node);
        this.linesSinceFirstAnnotation = 0;
        this.printMethodHead(node);
        Statement code = node.getCode();
        if (code != null) {
            code.setSourcePosition((ASTNode)node);
            this.visitClassCodeContainer(code);
        }
        this.postVisitStatement((ASTNode)node);
    }

    public void printMethodHead(MethodNode node) {
        if (node.isVoidMethod()) {
            if (this.explizitModifier) {
                this.groovyCode.append(this.modifier);
                this.groovyCode.append(" ");
            }
            this.groovyCode.append("void ");
        } else {
            if (this.explizitModifier) {
                this.groovyCode.append(this.modifier);
                this.groovyCode.append(" ");
            } else {
                this.groovyCode.append(ASTWriterHelper.getAccModifier(node.getModifiers(), 3));
            }
            if (!node.isDynamicReturnType()) {
                this.printType(node.getReturnType());
                this.groovyCode.append(" ");
            }
        }
        this.groovyCode.append(node.getName());
        this.groovyCode.append("(");
        Parameter[] parameters = node.getParameters();
        this.printParameters(parameters);
        this.groovyCode.append(")");
        if (node.getExceptions() != null && node.getExceptions().length > 0) {
            this.groovyCode.append(" throws ");
            int i = 0;
            while (i < node.getExceptions().length) {
                if (i == 0) {
                    this.groovyCode.append(node.getExceptions()[i].getNameWithoutPackage());
                } else {
                    this.groovyCode.append(", " + node.getExceptions()[i].getNameWithoutPackage());
                }
                ++i;
            }
        }
    }

    private void printParameters(Parameter[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            Parameter parameter = parameters[i];
            this.visitAnnotations((AnnotatedNode)parameter);
            if (!parameter.getAnnotations().isEmpty()) {
                this.groovyCode.append(" ");
            }
            this.linesSinceFirstAnnotation = 0;
            if (!parameter.isDynamicTyped()) {
                this.printType(parameter.getOriginType());
                this.groovyCode.append(" ");
            }
            this.groovyCode.append(parameter.getName());
            if (parameter.hasInitialExpression()) {
                this.groovyCode.append("=");
                parameter.getInitialExpression().visit((GroovyCodeVisitor)this);
            }
            if (i < parameters.length - 1) {
                this.groovyCode.append(", ");
            }
            ++i;
        }
    }

    public void visitConstructor(ConstructorNode node) {
        this.visitConstructorOrMethod((MethodNode)node, true);
    }

    public void visitMethod(MethodNode node) {
        this.visitConstructorOrMethod(node, false);
    }

    public void visitField(FieldNode node) {
        if (!node.getName().startsWith("$")) {
            this.visitAnnotations((AnnotatedNode)node);
            this.preVisitStatement((ASTNode)node);
            if (ASTWriterHelper.isProperty(node)) {
                if (!node.isDynamicTyped()) {
                    if (node.isStatic()) {
                        this.groovyCode.append("static ");
                    }
                    this.printType(node.getOriginType());
                } else {
                    this.groovyCode.append("def");
                    if (node.isStatic()) {
                        this.groovyCode.append(" static");
                    }
                }
                this.groovyCode.append(" ");
            } else {
                this.groovyCode.append(ASTWriterHelper.getAccModifier(node.getModifiers(), 1));
                if (!node.isDynamicTyped()) {
                    this.printType(node.getOriginType());
                    this.groovyCode.append(" ");
                }
            }
            this.groovyCode.append(node.getName());
            Expression init = node.getInitialExpression();
            if (init != null && init.getLineNumber() != -1) {
                this.groovyCode.append(" = ");
                init.visit((GroovyCodeVisitor)this);
            }
            this.postVisitStatement((ASTNode)node);
        }
    }

    public void visitProperty(PropertyNode node) {
    }

    public void visitAssertStatement(AssertStatement statement) {
        this.preVisitStatement((ASTNode)statement);
        this.groovyCode.append("assert ");
        super.visitAssertStatement(statement);
        this.postVisitStatement((ASTNode)statement);
    }

    public void visitBlockStatement(BlockStatement block) {
        if (this.getTop() instanceof CaseStatement || this.getTop() instanceof SwitchStatement || this.getTop() instanceof BlockStatement || this.getTop() instanceof ModuleNode) {
            this.preVisitStatement((ASTNode)block);
            super.visitBlockStatement(block);
            this.postVisitStatement((ASTNode)block);
        } else {
            this.preVisitStatementOpenBlock((ASTNode)block);
            if (this.getParent() instanceof ClosureExpression) {
                ClosureExpression closure = (ClosureExpression)this.getParent();
                Parameter[] parameters = closure.getParameters();
                if (parameters == null) {
                    this.groovyCode.append(" -> ");
                } else if (parameters.length > 0) {
                    this.printParameters(parameters);
                    this.groovyCode.append(" -> ");
                }
            }
            super.visitBlockStatement(block);
            this.postVisitStatementCloseBlock((ASTNode)block);
        }
    }

    public void visitBreakStatement(BreakStatement statement) {
        this.preVisitStatement((ASTNode)statement);
        this.groovyCode.append("break");
        if (statement.getLabel() != null) {
            this.groovyCode.append(" " + statement.getLabel());
        }
        super.visitBreakStatement(statement);
        this.postVisitStatement((ASTNode)statement);
    }

    public void visitCaseStatement(CaseStatement statement) {
        this.preVisitStatement((ASTNode)statement);
        this.groovyCode.append("case ");
        super.visitCaseStatement(statement);
        this.postVisitStatement((ASTNode)statement);
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.preVisitStatement((ASTNode)statement);
        this.groovyCode.append(" catch (");
        ClassNode typOfException = statement.getExceptionType();
        Parameter eVariable = statement.getVariable();
        if (!eVariable.isDynamicTyped()) {
            this.printType(typOfException);
            this.groovyCode.append(" ");
        }
        this.groovyCode.append(eVariable.getName());
        this.groovyCode.append(")");
        super.visitCatchStatement(statement);
        this.postVisitStatement((ASTNode)statement);
    }

    public void visitContinueStatement(ContinueStatement statement) {
        this.preVisitStatement((ASTNode)statement);
        this.groovyCode.append("continue");
        super.visitContinueStatement(statement);
        this.postVisitStatement((ASTNode)statement);
    }

    public void visitDoWhileLoop(DoWhileStatement loop) {
        this.preVisitStatementOpenBlock((ASTNode)loop);
        super.visitDoWhileLoop(loop);
        this.postVisitStatementCloseBlock((ASTNode)loop);
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        this.preVisitStatement((ASTNode)statement);
        if (statement.getStatementLabel() != null) {
            this.groovyCode.append(String.valueOf(statement.getStatementLabel()) + ": ");
        }
        if (statement.getExpression() instanceof MethodCallExpression) {
            MethodCallExpression methCallExpr = (MethodCallExpression)statement.getExpression();
            if (!methCallExpr.isImplicitThis()) {
                methCallExpr.getObjectExpression().visit((GroovyCodeVisitor)this);
                this.printArgumentsOfaMethodCall(methCallExpr, (TupleExpression)methCallExpr.getArguments());
            } else {
                super.visitExpressionStatement(statement);
            }
        } else {
            super.visitExpressionStatement(statement);
        }
        this.postVisitStatement((ASTNode)statement);
    }

    private void printArgumentsOfaMethodCall(MethodCallExpression methCallExpr, TupleExpression args) {
        if (args != null) {
            this.groovyCode.append('.');
            this.groovyCode.append(methCallExpr.getMethod().getText());
            if (!args.getExpressions().isEmpty()) {
                List listOfAllExpressions = args.getExpressions();
                ArgumentListExpression listOfMethodArguments = new ArgumentListExpression();
                ClosureExpression closure = null;
                for (Expression expr : listOfAllExpressions) {
                    if (expr instanceof ClosureExpression) {
                        closure = (ClosureExpression)expr;
                        continue;
                    }
                    listOfMethodArguments.addExpression(expr);
                }
                if (!listOfMethodArguments.getExpressions().isEmpty()) {
                    this.printArgumentsOfaMethod(listOfMethodArguments);
                }
                if (closure != null) {
                    closure.visit((GroovyCodeVisitor)this);
                }
            } else {
                this.groovyCode.append("()");
            }
        }
    }

    private void printArgumentsOfaMethod(ArgumentListExpression methCallExpr) {
        this.groovyCode.append('(');
        methCallExpr.visit((GroovyCodeVisitor)this);
        this.groovyCode.append(')');
    }

    public void visitForLoop(ForStatement forLoop) {
        this.preVisitStatement((ASTNode)forLoop);
        this.groovyCode.append("for ");
        if (!forLoop.getVariable().getName().equals("forLoopDummyParameter")) {
            this.groovyCode.append("(");
            this.groovyCode.append(forLoop.getVariable().getName());
            this.groovyCode.append(" in ");
            forLoop.getCollectionExpression().visit((GroovyCodeVisitor)this);
            this.groovyCode.append(")");
            forLoop.getLoopBlock().visit((GroovyCodeVisitor)this);
        } else {
            forLoop.getCollectionExpression().visit((GroovyCodeVisitor)this);
            if (forLoop.getLoopBlock() instanceof BlockStatement) {
                forLoop.getLoopBlock().visit((GroovyCodeVisitor)this);
            } else {
                ++this.columnOffset;
                forLoop.getLoopBlock().visit((GroovyCodeVisitor)this);
                --this.columnOffset;
            }
        }
        this.postVisitStatement((ASTNode)forLoop);
    }

    public void visitIfElse(IfStatement ifElse) {
        this.preVisitStatement((ASTNode)ifElse);
        this.groovyCode.append("if (");
        ifElse.getBooleanExpression().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(")");
        if (!(ifElse.getIfBlock() instanceof BlockStatement)) {
            ++this.columnOffset;
            ifElse.getIfBlock().visit((GroovyCodeVisitor)this);
            --this.columnOffset;
        } else {
            ifElse.getIfBlock().visit((GroovyCodeVisitor)this);
        }
        if (!(ifElse.getElseBlock() instanceof EmptyStatement)) {
            if (!(ifElse.getElseBlock() instanceof BlockStatement) && !(ifElse.getElseBlock() instanceof IfStatement)) {
                this.positioningCursor();
                this.insertLineFeed();
                this.groovyCode.append("else");
                ++this.lineOfPreviousNode;
                ++this.columnOffset;
                ifElse.getElseBlock().visit((GroovyCodeVisitor)this);
                --this.columnOffset;
            } else {
                this.inElseBlock = true;
                ifElse.getElseBlock().visit((GroovyCodeVisitor)this);
            }
        }
        this.postVisitStatement((ASTNode)ifElse);
    }

    public void visitReturnStatement(ReturnStatement statement) {
        if (!this.shouldIgnoreReturn()) {
            this.preVisitStatement((ASTNode)statement);
            this.groovyCode.append("return ");
            super.visitReturnStatement(statement);
            this.postVisitStatement((ASTNode)statement);
        }
    }

    private boolean shouldIgnoreReturn() {
        BlockStatement body;
        Statement s;
        MethodNode runMethod;
        ClassNode clazz;
        if (this.root.getClasses().size() == 1 && (clazz = (ClassNode)this.root.getClasses().get(0)).isScript() && (runMethod = clazz.getMethod("run", Parameter.EMPTY_ARRAY)) != null && (s = runMethod.getCode()) instanceof BlockStatement && (body = (BlockStatement)s).getStatements().size() == 1 && body.getStatements().get(0) instanceof ReturnStatement) {
            ReturnStatement ret = (ReturnStatement)body.getStatements().get(0);
            return ret.getExpression() instanceof ConstantExpression && ((ConstantExpression)ret.getExpression()).getText().equals("null");
        }
        return false;
    }

    public void visitSwitch(SwitchStatement statement) {
        this.preVisitStatement((ASTNode)statement);
        this.groovyCode.append("switch (");
        statement.getExpression().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(")");
        List list = statement.getCaseStatements();
        if (list != null) {
            for (CaseStatement caseStatement : list) {
                caseStatement.visit((GroovyCodeVisitor)this);
            }
        }
        statement.getDefaultStatement().visit((GroovyCodeVisitor)this);
        this.postVisitStatementCloseBlock((ASTNode)statement);
    }

    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.preVisitStatement((ASTNode)statement);
        this.groovyCode.append("synchronized (");
        statement.getExpression().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(")");
        statement.getCode().visit((GroovyCodeVisitor)this);
        this.postVisitStatement((ASTNode)statement);
    }

    public void visitThrowStatement(ThrowStatement statement) {
        this.preVisitStatement((ASTNode)statement);
        this.groovyCode.append("throw ");
        super.visitThrowStatement(statement);
        this.postVisitStatement((ASTNode)statement);
    }

    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.preVisitStatement((ASTNode)statement);
        this.groovyCode.append("try");
        statement.getTryStatement().visit((GroovyCodeVisitor)this);
        List list = statement.getCatchStatements();
        if (list != null) {
            for (CatchStatement catchStatement : list) {
                catchStatement.visit((GroovyCodeVisitor)this);
            }
        }
        if (!statement.getFinallyStatement().isEmpty()) {
            this.groovyCode.append(" finally");
            statement.getFinallyStatement().visit((GroovyCodeVisitor)this);
        }
        this.postVisitStatement((ASTNode)statement);
    }

    public void visitWhileLoop(WhileStatement loop) {
        this.preVisitStatement((ASTNode)loop);
        this.groovyCode.append("while (");
        loop.getBooleanExpression().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(")");
        if (loop.getLoopBlock() instanceof BlockStatement) {
            loop.getLoopBlock().visit((GroovyCodeVisitor)this);
        } else {
            ++this.columnOffset;
            loop.getLoopBlock().visit((GroovyCodeVisitor)this);
            --this.columnOffset;
        }
        this.postVisitStatement((ASTNode)loop);
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        this.preVisitExpression((ASTNode)call);
        if (!call.getText().contains("this")) {
            call.getObjectExpression().visit((GroovyCodeVisitor)this);
            this.groovyCode.append(".");
        }
        call.getMethod().visit((GroovyCodeVisitor)this);
        this.groovyCode.append("(");
        call.getArguments().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(")");
        this.postVisitExpression((ASTNode)call);
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        this.preVisitExpression((ASTNode)call);
        this.groovyCode.append(call.getMethod());
        this.groovyCode.append("(");
        call.getArguments().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(")");
        this.postVisitExpression((ASTNode)call);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        this.preVisitExpression((ASTNode)call);
        this.groovyCode.append("new ");
        this.printType(call.getType());
        this.groovyCode.append("(");
        call.getArguments().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(")");
        this.postVisitExpression((ASTNode)call);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        boolean writeParanthesis = false;
        this.preVisitExpression((ASTNode)expression);
        if (expression.getOperation().getType() == 30) {
            expression.getLeftExpression().visit((GroovyCodeVisitor)this);
            this.groovyCode.append("[");
            expression.getRightExpression().visit((GroovyCodeVisitor)this);
            this.groovyCode.append("]");
        } else {
            LineColumn coords = new LineColumn(expression.getLineNumber(), expression.getColumnNumber());
            try {
                if (!(this.getParent() instanceof DeclarationExpression) && FilePartReader.readForwardFromCoordinate(this.currentDocument, coords).startsWith("(")) {
                    this.groovyCode.append("(");
                    writeParanthesis = true;
                }
            }
            catch (BadLocationException e) {
                GroovyCore.logException((String)"Error in refactoring", (Throwable)e);
            }
            expression.getLeftExpression().visit((GroovyCodeVisitor)this);
            if (!"null".equals(expression.getRightExpression().getText())) {
                this.groovyCode.append(" ");
                this.groovyCode.append(expression.getOperation().getText());
                this.groovyCode.append(" ");
                expression.getRightExpression().visit((GroovyCodeVisitor)this);
            }
            if (writeParanthesis) {
                this.groovyCode.append(")");
            }
        }
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitTernaryExpression(TernaryExpression expression) {
        expression.getBooleanExpression().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(" ? ");
        expression.getTrueExpression().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(" : ");
        expression.getFalseExpression().visit((GroovyCodeVisitor)this);
    }

    public void visitPostfixExpression(PostfixExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        super.visitPostfixExpression(expression);
        this.groovyCode.append(expression.getOperation().getText());
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitPrefixExpression(PrefixExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        this.groovyCode.append(expression.getOperation().getText());
        super.visitPrefixExpression(expression);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitBooleanExpression(BooleanExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        super.visitBooleanExpression(expression);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitNotExpression(NotExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        this.printExpression("!", (ASTNode)expression, "");
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitClosureExpression(ClosureExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        expression.getCode().setSourcePosition((ASTNode)expression);
        expression.getCode().visit((GroovyCodeVisitor)this);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitTupleExpression(TupleExpression expression) {
        this.visitListOfExpressions(expression.getExpressions());
    }

    public void visitListExpression(ListExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        this.groovyCode.append("[");
        this.visitListOfExpressions(expression.getExpressions(), ",");
        this.groovyCode.append("]");
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitArrayExpression(ArrayExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        this.visitListOfExpressions(expression.getExpressions());
        this.groovyCode.append("new ");
        String typeName = expression.getType().getNameWithoutPackage();
        if (typeName.startsWith("[")) {
            typeName = Signature.getElementType((String)typeName);
            typeName = Signature.getSignatureSimpleName((String)typeName);
        }
        this.groovyCode.append(typeName);
        this.visitListOfExpressions(expression.getSizeExpression(), "");
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitMapExpression(MapExpression expression) {
        boolean isMapList = !(expression instanceof NamedArgumentListExpression);
        this.preVisitExpression((ASTNode)expression);
        List mapEntries = expression.getMapEntryExpressions();
        if (isMapList) {
            this.groovyCode.append("[");
        }
        if (!mapEntries.isEmpty()) {
            this.visitListOfExpressions(mapEntries, ",");
        } else {
            this.groovyCode.append(":");
        }
        if (isMapList) {
            this.groovyCode.append("]");
        }
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        expression.getKeyExpression().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(":");
        expression.getValueExpression().visit((GroovyCodeVisitor)this);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitRangeExpression(RangeExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        expression.getFrom().visit((GroovyCodeVisitor)this);
        this.groovyCode.append("..");
        if (!expression.isInclusive()) {
            this.groovyCode.append("<");
        }
        expression.getTo().visit((GroovyCodeVisitor)this);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitSpreadExpression(SpreadExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        this.groovyCode.append("*");
        super.visitSpreadExpression(expression);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        this.groovyCode.append("*");
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        this.preVisitStatement((ASTNode)expression);
        expression.getExpression().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(".&");
        expression.getMethodName().visit((GroovyCodeVisitor)this);
        this.postVisitStatement((ASTNode)expression);
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        this.groovyCode.append("~");
        expression.getExpression().visit((GroovyCodeVisitor)this);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitCastExpression(CastExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        this.groovyCode.append("(");
        this.printType(expression.getType());
        this.groovyCode.append(")");
        super.visitCastExpression(expression);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitConstantExpression(ConstantExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        String pre = "";
        String post = "";
        ASTNode parent = this.getParent();
        if (parent instanceof AssertStatement && !"null".equals(expression.getText())) {
            pre = " , ";
        }
        if (parent instanceof DeclarationExpression || parent instanceof FieldNode) {
            if (expression.getType().equals((Object)ClassHelper.Float_TYPE)) {
                post = String.valueOf(post) + "f";
            } else if (expression.getType().equals((Object)ClassHelper.Double_TYPE)) {
                post = String.valueOf(post) + "d";
            } else if (expression.getType().equals((Object)ClassHelper.BigInteger_TYPE)) {
                post = String.valueOf(post) + "g";
            } else if (expression.getType().equals((Object)ClassHelper.Long_TYPE)) {
                post = String.valueOf(post) + "l";
            }
        }
        if (this.constExprIsAString(expression)) {
            LineColumn coords = new LineColumn(expression.getLineNumber(), expression.getColumnNumber());
            String stringMarker = ASTWriterHelper.getStringMarker(this.currentDocument, coords);
            pre = String.valueOf(pre) + stringMarker;
            this.printExpression(pre, (ASTNode)expression, stringMarker);
            if (stringMarker.length() == 3) {
                this.lineOfPreviousNode += expression.getLastLineNumber() - expression.getLineNumber();
            }
        } else {
            this.printExpression(pre, (ASTNode)expression, post);
        }
        this.postVisitExpression((ASTNode)expression);
    }

    private boolean constExprIsAString(ConstantExpression expression) {
        return "java.lang.String".equals(expression.getType().getName()) && !(this.getParent() instanceof MethodCallExpression) && !(this.getParent() instanceof GStringExpression) && !(this.getParent() instanceof MethodPointerExpression);
    }

    public void visitClassExpression(ClassExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        this.printType(expression.getType());
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitVariableExpression(VariableExpression expression) {
        this.getParent();
        this.preVisitExpression((ASTNode)expression);
        LineColumn coords = new LineColumn(expression.getLineNumber(), expression.getColumnNumber());
        try {
            if (FilePartReader.readForwardFromCoordinate(this.currentDocument, coords).startsWith("(")) {
                this.printExpression("(", (ASTNode)expression, ")");
            } else {
                this.printExpression((ASTNode)expression);
            }
        }
        catch (BadLocationException e) {
            GroovyCore.logException((String)"Error in refactoring", (Throwable)e);
        }
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        VariableExpression accessedVariable;
        this.preVisitExpression((ASTNode)expression);
        VariableExpression variable = (VariableExpression)expression.getLeftExpression();
        Object object = accessedVariable = variable.getAccessedVariable() == null ? variable : variable.getAccessedVariable();
        if (this.previousDeclaration != null) {
            if (this.previousDeclaration.getVariableExpression().getLineNumber() != expression.getVariableExpression().getLineNumber()) {
                if (!accessedVariable.isDynamicTyped()) {
                    this.printType(variable.getOriginType());
                } else {
                    this.groovyCode.append("def");
                }
            } else {
                this.groovyCode.append(",");
            }
        } else if (!accessedVariable.isDynamicTyped()) {
            this.printType(variable.getOriginType());
        } else {
            this.groovyCode.append("def");
        }
        this.groovyCode.append(" ");
        this.visitBinaryExpression((BinaryExpression)expression);
        this.previousDeclaration = expression;
        this.postVisitExpression((ASTNode)expression);
    }

    private void printType(ClassNode type) {
        if (type.isArray()) {
            this.printArray(type);
        } else {
            GenericsType[] genericTypes;
            this.groovyCode.append(ImportResolver.getResolvedClassName(this.root, type, true));
            if (type.isUsingGenerics() && (genericTypes = type.getGenericsTypes()) != null) {
                this.groovyCode.append("<");
                for (GenericsType generic : Arrays.asList(genericTypes)) {
                    this.printGenericsType(generic);
                }
                this.groovyCode.append(">");
            }
        }
    }

    public void printGenericsType(GenericsType genericType) {
        ClassNode[] upperBounds = genericType.getUpperBounds();
        ClassNode lowerBound = genericType.getLowerBound();
        this.groovyCode.append(genericType.getName());
        if (upperBounds != null) {
            this.groovyCode.append(" extends ");
            int i = 0;
            while (i < upperBounds.length) {
                this.printType(upperBounds[i]);
                if (i + 1 < upperBounds.length) {
                    this.groovyCode.append(" & ");
                }
                ++i;
            }
        } else if (lowerBound != null) {
            this.groovyCode.append(" super ");
            this.printType(lowerBound);
        }
    }

    private void printArray(ClassNode compType) {
        ClassNode componentType = compType;
        int dimension = 0;
        while (componentType.isArray()) {
            ++dimension;
            componentType = componentType.getComponentType();
        }
        this.printType(componentType);
        int i = 0;
        while (i < dimension) {
            this.groovyCode.append("[]");
            ++i;
        }
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        String alias = ImportResolver.asAlias(this.root, expression.getObjectExpression().getType());
        String fieldName = ImportResolver.asFieldName(this.root, expression.getObjectExpression().getType(), expression.getPropertyAsString());
        if (StringGroovyMethods.asBoolean((CharSequence)alias)) {
            this.groovyCode.append(alias);
        } else if (StringGroovyMethods.asBoolean((CharSequence)fieldName)) {
            this.groovyCode.append(fieldName);
        } else {
            expression.getObjectExpression().visit((GroovyCodeVisitor)this);
            this.groovyCode.append(".");
            expression.getProperty().visit((GroovyCodeVisitor)this);
        }
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitAttributeExpression(AttributeExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        expression.getObjectExpression().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(".@");
        expression.getProperty().visit((GroovyCodeVisitor)this);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitFieldExpression(FieldExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        ClassNode classNode = expression.getField().getOwner();
        this.groovyCode.append(ImportResolver.getResolvedClassName(this.root, classNode, true));
        this.groovyCode.append(".");
        this.groovyCode.append(expression.getFieldName());
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitGStringExpression(GStringExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        List values = expression.getValues();
        Iterator<Expression> it = values.iterator();
        LineColumn coords = new LineColumn(expression.getLineNumber(), expression.getColumnNumber());
        String stringMarker = ASTWriterHelper.getStringMarker(this.currentDocument, coords);
        this.groovyCode.append(stringMarker);
        for (ConstantExpression stringExpression : expression.getStrings()) {
            stringExpression.visit((GroovyCodeVisitor)this);
            if (!it.hasNext()) continue;
            this.visitValueInGString(it);
        }
        while (it.hasNext()) {
            this.visitValueInGString(it);
        }
        this.groovyCode.append(stringMarker);
        if (stringMarker.length() == 3) {
            this.lineOfPreviousNode += expression.getLastLineNumber() - expression.getLineNumber();
        }
        this.postVisitExpression((ASTNode)expression);
    }

    private void visitValueInGString(Iterator<Expression> it) {
        char firstChar;
        Expression valueExpression = it.next();
        LineColumn coords = new LineColumn(valueExpression.getLineNumber(), valueExpression.getColumnNumber());
        try {
            firstChar = FilePartReader.readForwardFromCoordinate(this.currentDocument, coords).charAt(0);
        }
        catch (BadLocationException e) {
            GroovyCore.logException((String)"Error during refactoring...trying to recover", (Throwable)e);
            firstChar = '\u0000';
        }
        this.groovyCode.append("$");
        if (firstChar == '{') {
            this.groovyCode.append("{");
            valueExpression.visit((GroovyCodeVisitor)this);
            this.groovyCode.append("}");
        } else {
            valueExpression.visit((GroovyCodeVisitor)this);
        }
    }

    protected void visitListOfExpressions(List<? extends Expression> list, String separator) {
        if (list == null) {
            return;
        }
        Iterator<? extends Expression> iterator = list.iterator();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            this.preVisitExpression((ASTNode)expression);
            if (this.getParent() instanceof ArrayExpression) {
                this.groovyCode.append("[");
            }
            expression.visit((GroovyCodeVisitor)this);
            if (this.getParent() instanceof ArrayExpression) {
                this.groovyCode.append("]");
            } else if (iterator.hasNext()) {
                this.groovyCode.append(String.valueOf(separator) + " ");
            }
            this.postVisitExpression((ASTNode)expression);
        }
    }

    public void visitArgumentlistExpression(ArgumentListExpression ale) {
        this.visitListOfExpressions(ale.getExpressions(), ",");
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        expression.getBooleanExpression().visit((GroovyCodeVisitor)this);
        this.groovyCode.append(" ?: ");
        expression.getFalseExpression().visit((GroovyCodeVisitor)this);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        this.groovyCode.append('+');
        super.visitUnaryPlusExpression(expression);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        this.preVisitExpression((ASTNode)expression);
        this.groovyCode.append('-');
        super.visitUnaryMinusExpression(expression);
        this.postVisitExpression((ASTNode)expression);
    }

    public void visitClosureListExpression(ClosureListExpression cle) {
        this.preVisitExpression((ASTNode)cle);
        this.groovyCode.append("(");
        this.visitListOfExpressions(cle.getExpressions(), ";");
        this.groovyCode.append(")");
        this.postVisitExpression((ASTNode)cle);
    }

    protected void preVisitStatement(ASTNode statement) {
        ASTNode parent = this.getTop();
        if (statement instanceof CaseStatement) {
            ++this.caseCount;
        }
        if (parent instanceof SwitchStatement && this.caseCount == 1) {
            this.nodeStack.pop();
            this.preVisitStatementOpenBlock(parent);
        }
        this.nodeStack.push(statement);
        if (statement.getLineNumber() != -1) {
            this.lineOfCurrentNode = statement.getLineNumber() - this.lineOffset;
        }
        if (!(statement instanceof AnnotationNode)) {
            this.lineOfCurrentNode += this.linesSinceFirstAnnotation;
        }
        this.positioningCursor();
        if (parent instanceof SwitchStatement && !(statement instanceof CaseStatement)) {
            this.groovyCode.append("default : ");
        } else if (this.inElseBlock) {
            this.groovyCode.append("else ");
            this.inElseBlock = false;
        }
    }

    protected void preVisitStatementOpenBlock(ASTNode statement) {
        this.nodeStack.push(statement);
        this.lineOfCurrentNode = statement.getLineNumber() - this.lineOffset;
        this.positioningCursor();
        ++this.columnOffset;
        if (this.inElseBlock) {
            this.groovyCode.append("else");
            this.inElseBlock = false;
        }
        this.groovyCode.append(" {");
    }

    protected void postVisitStatement(ASTNode statement) {
        this.nodeStack.pop();
        this.lineOfCurrentNode = statement.getLastLineNumber() - this.lineOffset;
        if (statement instanceof SwitchStatement) {
            this.caseCount = 0;
        }
    }

    protected void postVisitStatementCloseBlock(ASTNode statement) {
        this.nodeStack.pop();
        this.lineOfCurrentNode = statement.getLastLineNumber() - this.lineOffset;
        --this.columnOffset;
        this.positioningCursor();
        this.groovyCode.append("}");
    }

    protected void preVisitExpression(ASTNode expression) {
        this.nodeStack.push(expression);
        this.lineOfCurrentNode = expression.getLineNumber() - this.lineOffset;
        this.positioningCursor();
    }

    protected void postVisitExpression(ASTNode expression) {
        this.nodeStack.pop();
    }

    protected void printExpression(ASTNode expression) {
        if (!"null".equals(expression.getText())) {
            this.printExpression("", expression, "");
        }
    }

    protected void printExpression(String pre, ASTNode expression, String post) {
        String printExpression = expression.getText();
        if ("null".equals(expression.getText())) {
            printExpression = "";
        }
        if (pre.length() > 0) {
            printExpression = pre.charAt(0) != '/' && expression.getLineNumber() == expression.getLastLineNumber() ? ASTWriter.escapeJava(printExpression) : printExpression.replaceAll("\r\n|\n", System.getProperty("line.separator"));
        }
        this.groovyCode.append(pre);
        this.groovyCode.append(printExpression);
        this.groovyCode.append(post);
        if (this.getParent() instanceof CaseStatement) {
            this.groovyCode.append(" : ");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void positioningCursor() {
        block2: {
            onNewLine = false;
            if (this.lineOfPreviousNode != this.lineOfCurrentNode || !(this.getTop() instanceof BreakStatement)) ** GOTO lbl10
            this.groovyCode.append(" ; ");
            break block2;
lbl-1000:
            // 1 sources

            {
                this.groovyCode.append(this.lineDelimiter);
                ++this.lineOfPreviousNode;
                onNewLine = true;
lbl10:
                // 2 sources

                ** while (this.lineOfPreviousNode < this.lineOfCurrentNode)
            }
        }
        if (onNewLine) {
            this.printColumnOffset();
        }
    }

    private void printColumnOffset() {
        int i = 0;
        while (i < this.columnOffset) {
            this.groovyCode.append("    ");
            ++i;
        }
    }

    private ASTNode getTop() {
        if (this.nodeStack.isEmpty()) {
            return null;
        }
        return this.nodeStack.peek();
    }

    private ASTNode getParent() {
        if (this.nodeStack.size() > 1) {
            ASTNode topNode = this.nodeStack.pop();
            ASTNode parrentNode = this.nodeStack.peek();
            this.nodeStack.push(topNode);
            return parrentNode;
        }
        return null;
    }

    private static String escapeJava(String str) {
        return ASTWriter.escapeJavaStyleString(str, false);
    }

    private static String escapeJavaStyleString(String str, boolean escapeSingleQuotes) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            ASTWriter.escapeJavaStyleString(writer, str, escapeSingleQuotes);
            return writer.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private static void escapeJavaStyleString(Writer out, String str, boolean escapeSingleQuote) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.write("\\u" + ASTWriter.hex(ch));
            } else if (ch > '\u00ff') {
                out.write("\\u0" + ASTWriter.hex(ch));
            } else if (ch > '\u007f') {
                out.write("\\u00" + ASTWriter.hex(ch));
            } else if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92);
                        out.write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92);
                        out.write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + ASTWriter.hex(ch));
                            break;
                        }
                        out.write("\\u000" + ASTWriter.hex(ch));
                        break;
                    }
                }
            } else {
                switch (ch) {
                    case '\'': {
                        if (escapeSingleQuote) {
                            out.write(92);
                        }
                        out.write(39);
                        break;
                    }
                    case '\"': {
                        out.write(92);
                        out.write(34);
                        break;
                    }
                    case '\\': {
                        out.write(92);
                        out.write(92);
                        break;
                    }
                    default: {
                        out.write(ch);
                    }
                }
            }
            ++i;
        }
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }
}

