/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindSurroundingNode;
import org.codehaus.groovy.eclipse.core.compiler.GroovySnippetParser;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTVisitorDecorator;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ASTTools {
    public static final int SPACE = 1;
    public static final int TAB = 2;

    public static String getLineDelimeter(CompilationUnit unit) {
        try {
            return unit.findRecommendedLineSeparator();
        }
        catch (JavaModelException e) {
            return Util.LINE_SEPARATOR;
        }
    }

    public static Region getPositionOfBlockStatements(BlockStatement block) {
        if (!block.getStatements().isEmpty()) {
            int until;
            int start = ASTTools.getPositionOfStatement((Statement)block.getStatements().get(0)).getOffset();
            if (start >= (until = ASTTools.getPositionOfStatement((Statement)block.getStatements().get(block.getStatements().size() - 1)).getEnd())) {
                throw new IllegalStateException(String.format("Block statement start offset (%d) >= end offset (%d)%nfirst statement: %s%nlast statement: %s", start, until, block.getStatements().get(0), block.getStatements().get(block.getStatements().size() - 1)));
            }
            return new Region(start, until - start);
        }
        return new Region(0, 0);
    }

    public static Region getPositionOfStatement(Statement statement) {
        if (!ASTTools.hasValidPosition((ASTNode)statement) && statement instanceof ReturnStatement) {
            Expression expression = ((ReturnStatement)statement).getExpression();
            return new Region(expression.getStart(), expression.getLength());
        }
        return new Region(statement.getStart(), statement.getLength());
    }

    public static boolean hasValidPosition(ASTNode node) {
        return node.getEnd() > 0;
    }

    public static String trimLeadingGap(String text) {
        return text.replaceFirst("[ \t\f]*", "");
    }

    public static String getLeadingGap(String text) {
        return text.replace(ASTTools.trimLeadingGap(text), "");
    }

    public static String setIndentationTo(String text, int intentation, int modus) {
        StringBuilder retString = new StringBuilder();
        String patternStr = ".+?(\n|\r\n|\r|\\z)";
        Pattern pattern = Pattern.compile(patternStr, 32);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String space;
            String line = matcher.group(0);
            int currentIntetnation = ASTTools.getCurrentIntentation(line);
            switch (modus) {
                case 1: {
                    space = "    ";
                    break;
                }
                default: {
                    space = "\t";
                }
            }
            int i = 0;
            while (i < currentIntetnation + intentation) {
                retString.append(space);
                ++i;
            }
            retString.append(ASTTools.trimLeadingGap(line));
        }
        return retString.toString();
    }

    public static int getCurrentIntentation(String line) {
        String leadingGap = ASTTools.getLeadingGap(line);
        int tabs = 0;
        int spaces = 0;
        int i = 0;
        int n = leadingGap.length();
        while (i < n) {
            switch (leadingGap.charAt(i)) {
                case '\t': {
                    ++tabs;
                    break;
                }
                case ' ': {
                    ++spaces;
                    break;
                }
            }
            ++i;
        }
        int currentIntetnation = tabs + spaces / 4;
        return currentIntetnation;
    }

    public static IDocument getDocumentWithSystemLineBreak(String text) {
        Document document = new Document();
        String linebreak = document.getDefaultLineDelimiter();
        document.set(text);
        try {
            int lineCount = document.getNumberOfLines();
            MultiTextEdit multiEdit = new MultiTextEdit();
            int i = 0;
            while (i < lineCount) {
                String delimiter = document.getLineDelimiter(i);
                if (delimiter != null && delimiter.length() > 0 && !delimiter.equals(linebreak)) {
                    IRegion region = document.getLineInformation(i);
                    multiEdit.addChild((TextEdit)new ReplaceEdit(region.getOffset() + region.getLength(), delimiter.length(), linebreak));
                }
                ++i;
            }
            multiEdit.apply((IDocument)document);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    public static ModuleNode getASTNodeFromSource(String source) {
        GroovySnippetParser parser = new GroovySnippetParser();
        ModuleNode node = parser.parse((CharSequence)source);
        return node;
    }

    public static boolean hasMultipleReturnStatements(Statement statement) {
        ArrayList<ReturnStatement> returns = new ArrayList<ReturnStatement>();
        statement.visit((GroovyCodeVisitor)new FindReturns((List<ReturnStatement>)returns));
        return returns.size() > 1;
    }

    public static String getTextofNode(ASTNode node, IDocument document) {
        TextSelection sel = new TextSelection(document, node.getStart(), node.getEnd() - node.getStart());
        try {
            return document.get(sel.getOffset(), sel.getLength());
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public static Set<Variable> getVariablesInScope(ModuleNode moduleNode, ASTNode node) {
        FindSurroundingNode find = new FindSurroundingNode(new Region(node), FindSurroundingNode.VisitKind.PARENT_STACK);
        find.doVisitSurroundingNode(moduleNode);
        ArrayList parentStack = new ArrayList(find.getParentStack());
        Collections.reverse(parentStack);
        HashSet<Variable> vars = new HashSet<Variable>();
        for (IASTFragment fragment : parentStack) {
            ASTNode astNode = fragment.getAssociatedNode();
            Object scope = astNode instanceof BlockStatement ? ((BlockStatement)astNode).getVariableScope() : (astNode instanceof MethodNode ? ((MethodNode)astNode).getVariableScope() : (astNode instanceof ClosureExpression ? ((ClosureExpression)astNode).getVariableScope() : null));
            if (scope == null) continue;
            Iterator declaredVariables = scope.getDeclaredVariablesIterator();
            while (declaredVariables.hasNext()) {
                vars.add((Variable)declaredVariables.next());
            }
        }
        return vars;
    }

    public static ClassNode getContainingClassNode(ModuleNode moduleNode, int offset) {
        ClassNode containingClassNode = null;
        ClassNode scriptClass = null;
        for (ClassNode classNode : moduleNode.getClasses()) {
            if (classNode.isScript()) {
                scriptClass = classNode;
                continue;
            }
            if (classNode.getStart() > offset || classNode.getEnd() < offset) continue;
            containingClassNode = classNode;
        }
        if (containingClassNode == null) {
            containingClassNode = scriptClass != null && scriptClass.getStart() <= offset && scriptClass.getEnd() >= offset ? scriptClass : moduleNode.getScriptClassDummy();
        } else {
            Iterator it = containingClassNode.getInnerClasses();
            while (it.hasNext()) {
                InnerClassNode innerClass = (InnerClassNode)it.next();
                if (innerClass.getStart() > offset || innerClass.getEnd() < offset || innerClass.isSynthetic()) continue;
                containingClassNode = innerClass;
                it = innerClass.getInnerClasses();
            }
        }
        return containingClassNode;
    }

    public static IASTFragment getSelectionFragment(ModuleNode moduleNode, int selectionStart, int selectionLength) {
        FindSurroundingNode finder = new FindSurroundingNode(new Region(selectionStart, selectionLength), FindSurroundingNode.VisitKind.SURROUNDING_NODE);
        IASTFragment selectionFragment = null;
        IASTFragment fragment = finder.doVisitSurroundingNode(moduleNode);
        if (ASTFragmentKind.isExpressionKind((IASTFragment)fragment)) {
            selectionFragment = fragment;
        }
        return selectionFragment;
    }

    private static class FindReturns
    extends ASTVisitorDecorator<List<ReturnStatement>> {
        FindReturns(List<ReturnStatement> container) {
            super(container);
        }

        public void visitReturnStatement(ReturnStatement statement) {
            ((List)this.container).add(statement);
            super.visitReturnStatement(statement);
        }
    }
}

