/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.ui.extract;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.eclipse.refactoring.core.extract.ExtractGroovyMethodRefactoring;
import org.codehaus.groovy.eclipse.refactoring.core.utils.GroovyConventionsBuilder;
import org.codehaus.groovy.eclipse.refactoring.core.utils.StatusHelper;
import org.codehaus.groovy.eclipse.refactoring.ui.extract.ExtractMethodMouseAdapter;
import org.codehaus.groovy.eclipse.refactoring.ui.extract.ExtractMethodPage;
import org.codehaus.groovy.eclipse.refactoring.ui.extract.GroovyRefactoringMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Signature;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ExtractMethodPageContent
extends Composite
implements Observer {
    private final ExtractGroovyMethodRefactoring extractMethodRefactoring;
    private final ExtractMethodPage extractMethodPage;
    private Text txtNewMethodName;
    private Text txtPreviewCall;
    private Table tblParameters;
    private static final String MODIFIER_DEF = "def";
    private static final String MODIFIER_PROTECTED = "protected";
    private static final String MODIFIER_PRIVATE = "private";
    private static final String MODIFIER_NONE = "none";
    private final String[] possibleModifiers = new String[]{"def", "protected", "private", "none"};
    private static final int DEFAULT_MODIFIER = 2;
    private Composite accessModifierComposite;
    private Composite newMethodNameComposite;
    private Composite parameterComposite;
    private Composite previewComposite;
    private Button btnDown;
    private Button btnUp;
    private TableEditor editor;
    private final Map<String, String> renameVariablesMap = new HashMap<String, String>();
    private boolean firstPreviewEver = true;

    public ExtractMethodPageContent(Composite parent, ExtractGroovyMethodRefactoring refactoring, ExtractMethodPage extractMethodPage) {
        super(parent, 0);
        this.extractMethodRefactoring = refactoring;
        this.extractMethodPage = extractMethodPage;
        if (refactoring != null) {
            refactoring.addObserver(this);
        }
        this.setLayout((Layout)new GridLayout());
        GridData compositeLData = new GridData();
        compositeLData.horizontalAlignment = 4;
        compositeLData.grabExcessHorizontalSpace = true;
        this.setLayoutData(compositeLData);
        this.createNewMethodNameComposite(this);
        this.createAccessModifierComposite(this);
        this.createParameterComposite(this);
        this.createPreviewComposite(this);
        this.initializeValues(-1);
        this.layout();
    }

    private void initializeValues(int selectionIndex) {
        if (this.extractMethodRefactoring != null) {
            this.setModifier();
            if (this.extractMethodRefactoring.getCallAndMethHeadParameters().length > 0) {
                this.tblParameters.removeAll();
                Parameter[] parameterArray = this.extractMethodRefactoring.getCallAndMethHeadParameters();
                int n = parameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter param = parameterArray[n2];
                    TableItem tblItem = new TableItem(this.tblParameters, 0);
                    tblItem.setText(0, this.createSimpleTypeName(param.getType()));
                    this.setVariableNameInTable(param, tblItem);
                    ++n2;
                }
                this.tblParameters.setSelection(selectionIndex);
                this.updateButtonsEnabled(this.tblParameters);
            }
            this.updateView();
        }
    }

    private String createSimpleTypeName(ClassNode node) {
        String name = node.getName();
        if (name.startsWith("[")) {
            int arrayCount = Signature.getArrayCount((String)name);
            String noArrayName = Signature.getElementType((String)name);
            String simpleName = Signature.getSignatureSimpleName((String)noArrayName);
            StringBuilder sb = new StringBuilder();
            sb.append(simpleName);
            int i = 0;
            while (i < arrayCount) {
                sb.append("[]");
                ++i;
            }
            return sb.toString();
        }
        return node.getNameWithoutPackage();
    }

    private void setVariableNameInTable(Parameter param, TableItem tblItem) {
        String variableName = param.getName();
        if (this.renameVariablesMap.containsKey(variableName)) {
            tblItem.setText(1, this.renameVariablesMap.get(variableName));
        } else {
            tblItem.setText(1, variableName);
        }
    }

    private void updateView() {
        String methodHead = this.extractMethodRefactoring.getMethodHead();
        if (this.firstPreviewEver) {
            this.createDummyMethodHead(methodHead);
        } else {
            this.txtPreviewCall.setText(methodHead);
        }
        RefactoringStatus status = this.validateGroovyIdentifiers();
        this.checkForDuplicateVariableNames(status);
        this.extractMethodPage.setPageComplete(status);
    }

    private void checkForDuplicateVariableNames(RefactoringStatus status) {
        HashSet<String> uniquenessTestSet = new HashSet<String>();
        Parameter[] parameterArray = this.extractMethodRefactoring.getCallAndMethHeadParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            if (!uniquenessTestSet.add(p.getName())) {
                String errorMsg = MessageFormat.format(GroovyRefactoringMessages.ExtractMethodWizard_DuplicateVariableName, p.getName());
                status.addFatalError(errorMsg);
            }
            ++n2;
        }
    }

    private void createDummyMethodHead(String methodHead) {
        String dummyMethodName = GroovyRefactoringMessages.ExtractMethodWizard_DefaultMethodName;
        int paraStartPos = methodHead.indexOf(40);
        String partOne = methodHead.substring(0, paraStartPos);
        String partTwo = methodHead.substring(paraStartPos, methodHead.length());
        this.txtPreviewCall.setText(String.valueOf(partOne) + dummyMethodName + partTwo);
    }

    private RefactoringStatus validateGroovyIdentifiers() {
        LinkedList<String> variablesToCheck = new LinkedList<String>();
        variablesToCheck.add(this.txtNewMethodName.getText());
        Parameter[] parameterArray = this.extractMethodRefactoring.getCallAndMethHeadParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            variablesToCheck.add(p.getName());
            ++n2;
        }
        IStatus statusOfUsedGroovyIdentifiers = new GroovyConventionsBuilder(variablesToCheck, "method").validateGroovyIdentifier().validateLowerCase(2).done();
        return StatusHelper.convertStatus(statusOfUsedGroovyIdentifiers);
    }

    private void setModifier() {
        this.extractMethodRefactoring.setModifier(2);
    }

    private void setModifier(MouseEvent e) {
        if (e.getSource() instanceof Button) {
            Button selectedButton = (Button)e.getSource();
            if (selectedButton.getText().equals(MODIFIER_PRIVATE)) {
                this.extractMethodRefactoring.setModifier(2);
            } else if (selectedButton.getText().equals(MODIFIER_DEF)) {
                this.extractMethodRefactoring.setModifier(1);
            } else if (selectedButton.getText().equals(MODIFIER_PROTECTED)) {
                this.extractMethodRefactoring.setModifier(4);
            } else if (selectedButton.getText().equals(MODIFIER_NONE)) {
                this.extractMethodRefactoring.setModifier(0);
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateView();
    }

    private void createAccessModifierComposite(Composite parent) {
        this.accessModifierComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.marginHeight = 0;
        GridData compositeLData = new GridData();
        compositeLData.horizontalAlignment = 4;
        compositeLData.grabExcessHorizontalSpace = true;
        this.accessModifierComposite.setLayoutData((Object)compositeLData);
        this.accessModifierComposite.setLayout((Layout)gridLayout);
        Label lbAccessModifier = new Label(this.accessModifierComposite, 0);
        lbAccessModifier.setText(GroovyRefactoringMessages.ExtractMethodWizard_LB_AcessModifier);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        lbAccessModifier.setLayoutData((Object)data);
        MouseAdapter btnClick = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                super.mouseUp(e);
                ExtractMethodPageContent.this.setModifier(e);
            }
        };
        this.createRadioButtons(btnClick);
    }

    private void createRadioButtons(MouseAdapter btnClick) {
        String[] stringArray = this.possibleModifiers;
        int n = this.possibleModifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String buttonName = stringArray[n2];
            Button btnModifier = new Button(this.accessModifierComposite, 16);
            btnModifier.setText(buttonName);
            btnModifier.addMouseListener((MouseListener)btnClick);
            this.enableAndSelectButtons(buttonName, btnModifier);
            ++n2;
        }
    }

    private void enableAndSelectButtons(String buttonName, Button btnModifier) {
        if (buttonName.equals(this.possibleModifiers[2])) {
            btnModifier.setSelection(true);
        }
        if (buttonName.equals(MODIFIER_NONE)) {
            btnModifier.setEnabled(this.extractMethodRefactoring.isStatic());
        }
    }

    private void createNewMethodNameComposite(Composite parent) {
        this.newMethodNameComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 10;
        GridData compositeLData = new GridData();
        compositeLData.horizontalAlignment = 4;
        compositeLData.grabExcessHorizontalSpace = true;
        this.newMethodNameComposite.setLayoutData((Object)compositeLData);
        this.newMethodNameComposite.setLayout((Layout)gridLayout);
        Label lbMethodName = new Label(this.newMethodNameComposite, 0);
        lbMethodName.setText(GroovyRefactoringMessages.ExtractMethodWizard_LB_NewMethodName);
        this.txtNewMethodName = new Text(this.newMethodNameComposite, 2048);
        this.txtNewMethodName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExtractMethodPageContent.this.firstPreviewEver = false;
                ExtractMethodPageContent.this.extractMethodRefactoring.setNewMethodname(ExtractMethodPageContent.this.txtNewMethodName.getText());
            }
        });
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.txtNewMethodName.setLayoutData((Object)data);
    }

    private void createParameterComposite(Composite parent) {
        if (this.extractMethodRefactoring.getCallAndMethHeadParameters().length > 0) {
            this.initParameterComposite(parent);
            Label lbParameters = new Label(this.parameterComposite, 0);
            lbParameters.setText(GroovyRefactoringMessages.ExtractMethodWizard_LB_Parameters);
            Composite parameterTableAndButtons = this.createTableAndButtonComposite();
            Composite tableframe = this.createTableComposite(parameterTableAndButtons);
            this.createParameterTable(tableframe);
            Composite buttonframe = new Composite(parameterTableAndButtons, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            buttonframe.setLayout((Layout)gridLayout);
            GridData buttonData = new GridData();
            buttonData.widthHint = 90;
            this.createUpButton(buttonframe, buttonData);
            this.createDownButton(buttonframe, buttonData);
            this.createTableSelectionListener();
        }
    }

    private void createTableSelectionListener() {
        this.createTableEditor();
        this.tblParameters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean EDITABLECOLUMN = true;
                TableItem currentTableItem = (TableItem)e.item;
                if (currentTableItem == null) {
                    return;
                }
                ExtractMethodPageContent.this.updateButtonsEnabled(ExtractMethodPageContent.this.tblParameters);
                ExtractMethodPageContent.this.disposeTableEditor();
                Text newEditor = new Text((Composite)ExtractMethodPageContent.this.tblParameters, 0);
                newEditor.setText(currentTableItem.getText(1));
                this.addListenerToEditor(1, newEditor);
                newEditor.selectAll();
                newEditor.setFocus();
                ExtractMethodPageContent.this.editor.setEditor((Control)newEditor, currentTableItem, 1);
            }

            private void addListenerToEditor(final int EDITABLECOLUMN, Text newEditor) {
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        this.saveRenamedVariable(EDITABLECOLUMN);
                    }

                    private void saveRenamedVariable(int EDITABLECOLUMN2) {
                        Text text = (Text)ExtractMethodPageContent.this.editor.getEditor();
                        int selectionIndex = ExtractMethodPageContent.this.tblParameters.getSelectionIndex();
                        String before = ExtractMethodPageContent.this.extractMethodRefactoring.getOriginalParameterName(selectionIndex);
                        ExtractMethodPageContent.this.editor.getItem().setText(EDITABLECOLUMN2, text.getText());
                        String after = ExtractMethodPageContent.this.editor.getItem().getText(EDITABLECOLUMN2);
                        ExtractMethodPageContent.this.renameVariablesMap.put(before, after);
                        ExtractMethodPageContent.this.extractMethodRefactoring.setParameterRename(ExtractMethodPageContent.this.renameVariablesMap);
                    }
                });
            }
        });
    }

    private void createTableEditor() {
        this.editor = new TableEditor(this.tblParameters);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 200;
    }

    private Button createPushButton(Composite buttonframe, GridData buttonData, String text, boolean enabled, boolean visible) {
        Button pushButton = new Button(buttonframe, 8);
        pushButton.setText(text);
        pushButton.setLayoutData((Object)buttonData);
        pushButton.setEnabled(enabled);
        pushButton.setVisible(visible);
        return pushButton;
    }

    private void createDownButton(Composite buttonframe, GridData buttonData) {
        this.btnDown = this.createPushButton(buttonframe, buttonData, GroovyRefactoringMessages.ExtractMethodWizard_LB_BTN_Down, false, true);
        this.btnDown.addMouseListener((MouseListener)new ExtractMethodMouseAdapter(this, 2));
    }

    private void createUpButton(Composite buttonframe, GridData buttonData) {
        this.btnUp = this.createPushButton(buttonframe, buttonData, GroovyRefactoringMessages.ExtractMethodWizard_LB_BTN_UP, false, true);
        this.btnUp.addMouseListener((MouseListener)new ExtractMethodMouseAdapter(this, 3));
    }

    private void createParameterTable(Composite tableframe) {
        int tableParams = 68096;
        this.tblParameters = new Table(tableframe, tableParams);
        this.tblParameters.setLinesVisible(true);
        this.tblParameters.setHeaderVisible(true);
        this.createTableColumn(GroovyRefactoringMessages.ExtractMethodWizard_LB_Col_Type);
        this.createTableColumn(GroovyRefactoringMessages.ExtractMethodWizard_LB_Col_Name);
    }

    private Composite createTableComposite(Composite parameterTableAndButtons) {
        Composite tableframe = new Composite(parameterTableAndButtons, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 0;
        tableframe.setLayout((Layout)gridLayout);
        return tableframe;
    }

    private Composite createTableAndButtonComposite() {
        Composite parameterTableAndButtons = new Composite(this.parameterComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        parameterTableAndButtons.setLayout((Layout)gridLayout);
        return parameterTableAndButtons;
    }

    private void initParameterComposite(Composite parent) {
        this.parameterComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 10;
        gridLayout.verticalSpacing = 0;
        GridData compositeLData = new GridData();
        compositeLData.horizontalAlignment = 4;
        compositeLData.grabExcessHorizontalSpace = true;
        this.parameterComposite.setLayoutData((Object)compositeLData);
        this.parameterComposite.setLayout((Layout)gridLayout);
    }

    private void createTableColumn(String title) {
        TableColumn column = new TableColumn(this.tblParameters, 0);
        column.setText(title);
        column.setWidth(200);
        column.setMoveable(false);
        column.setResizable(false);
    }

    private void createPreviewComposite(Composite parent) {
        this.previewComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        GridData compositeLData = new GridData();
        compositeLData.horizontalAlignment = 4;
        compositeLData.grabExcessHorizontalSpace = true;
        this.previewComposite.setLayoutData((Object)compositeLData);
        this.previewComposite.setLayout((Layout)gridLayout);
        Label lbPreview = new Label(this.previewComposite, 0);
        lbPreview.setText(GroovyRefactoringMessages.ExtractMethodWizard_LB_MethodSignaturePreview);
        this.txtPreviewCall = new Text(this.previewComposite, 10);
        this.txtPreviewCall.setText(GroovyRefactoringMessages.ExtractMethodWizard_MethodCall);
        GridData data = new GridData();
        data.heightHint = 60;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.txtPreviewCall.setLayoutData((Object)data);
    }

    protected void handleUpDownEvent(boolean upEvent) {
        String variName = "";
        if (this.tblParameters.getSelectionCount() > 0) {
            variName = this.tblParameters.getSelection()[0].getText(1);
        }
        int indexOfSelectedParam = this.extractMethodRefactoring.setMoveParameter(variName, upEvent, 1);
        this.initializeValues(indexOfSelectedParam);
        this.disposeTableEditor();
    }

    private void disposeTableEditor() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
    }

    private void updateButtonsEnabled(Table tbl) {
        int lastElementIndex = this.extractMethodRefactoring.getCallAndMethHeadParameters().length - 1;
        int selectionIndex = tbl.getSelectionIndex();
        if (tbl.getItemCount() == 1) {
            this.btnDown.setEnabled(false);
            this.btnUp.setEnabled(false);
        } else if (selectionIndex == 0) {
            this.btnDown.setEnabled(true);
            this.btnUp.setEnabled(false);
        } else if (selectionIndex == lastElementIndex) {
            this.btnDown.setEnabled(false);
            this.btnUp.setEnabled(true);
        } else {
            this.btnDown.setEnabled(true);
            this.btnUp.setEnabled(true);
        }
    }
}

