/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.dialog;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.explorer.handlers.deletion.AbstractDeleteReferredEntityDialog;
import com.kms.katalon.composer.testdata.constants.ComposerTestdataMessageConstants;
import com.kms.katalon.composer.testdata.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TestDataReferencesDialog
extends AbstractDeleteReferredEntityDialog {
    private Map<String, List<TestSuiteTestCaseLink>> referencesInTestSuite;
    private List<TestSuiteTestCaseLink> allAffectedTestCase;
    private TableViewer testCaseLinkTableViewer;

    public TestDataReferencesDialog(Shell parentShell, String testDataId, Map<String, List<TestSuiteTestCaseLink>> referencesInTestSuite, List<TestCaseEntity> referencesInTestCase, boolean showYesNoToAllButtons) {
        super(parentShell);
        this.setDialogTitle(ComposerTestdataMessageConstants.DIA_TITLE_TEST_DATA_REFERENCES);
        this.setEntityId(testDataId);
        this.referencesInTestSuite = referencesInTestSuite;
        this.setAllAffectedTestCase(referencesInTestCase);
        this.setShowYesNoToAllButtons(showYesNoToAllButtons);
    }

    protected Control createDialogBody(Composite parent) {
        SashForm sashForm = new SashForm(parent, 0);
        sashForm.setSashWidth(5);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createSourceTable((Composite)sashForm);
        this.createTestCaseLinkTable((Composite)sashForm);
        sashForm.setWeights(new int[]{45, 55});
        return parent;
    }

    protected void registerControlModifyListeners() {
        super.registerControlModifyListeners();
        this.tableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestDataReferencesDialog.this.updateTestCaseLinkTableInput();
            }
        });
    }

    private void updateTestCaseLinkTableInput() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        String testSuiteId = (String)selection.getFirstElement();
        if (StringUtils.equals((String)testSuiteId, (String)ComposerTestdataMessageConstants.DIA_LBL_REFERENCED_TEST_CASES)) {
            this.testCaseLinkTableViewer.setInput(this.allAffectedTestCase);
        } else {
            this.testCaseLinkTableViewer.setInput(this.referencesInTestSuite.get(testSuiteId));
        }
    }

    protected void setInput() {
        ArrayList<String> sources = new ArrayList<String>();
        sources.add(ComposerTestdataMessageConstants.DIA_LBL_REFERENCED_TEST_CASES);
        sources.addAll(this.referencesInTestSuite.keySet());
        this.tableViewer.setInput(sources);
        this.tableViewer.getTable().setSelection(0);
        this.updateTestCaseLinkTableInput();
        this.mainComposite.layout(true, true);
    }

    private void createSourceTable(Composite parent) {
        Composite compositeSourceTable = new Composite(parent, 0);
        this.tableViewer = new TableViewer(compositeSourceTable, 65536);
        Table tableTestSuite = this.tableViewer.getTable();
        tableTestSuite.setHeaderVisible(true);
        TableViewerColumn tableViewerColumnTestSuiteID = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnTestSuiteID = tableViewerColumnTestSuiteID.getColumn();
        tblclmnTestSuiteID.setWidth(200);
        tblclmnTestSuiteID.setText(ComposerTestdataMessageConstants.DIA_COL_REFERENCED_BY);
        tableViewerColumnTestSuiteID.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tblclmnTestSuiteID, (ColumnLayoutData)new ColumnWeightData(98, 190));
        compositeSourceTable.setLayout((Layout)tableLayout);
    }

    private void createTestCaseLinkTable(Composite parent) {
        Composite compositeTestCaseLinkTable = new Composite(parent, 0);
        this.testCaseLinkTableViewer = new TableViewer(compositeTestCaseLinkTable, 65536);
        Table tableTestCaseLink = this.testCaseLinkTableViewer.getTable();
        tableTestCaseLink.setHeaderVisible(true);
        tableTestCaseLink.setLinesVisible(ControlUtils.shouldLineVisble((Display)tableTestCaseLink.getDisplay()));
        TableViewerColumn tableViewerColumnTestCaseOrder = new TableViewerColumn(this.testCaseLinkTableViewer, 0);
        TableColumn tblclmnTestCaseLinkOrder = tableViewerColumnTestCaseOrder.getColumn();
        tblclmnTestCaseLinkOrder.setText(StringConstants.NO_);
        tableViewerColumnTestCaseOrder.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        tableViewerColumnTestCaseOrder.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element == null || !(element instanceof TestSuiteTestCaseLink)) {
                    return StringConstants.EMPTY;
                }
                TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)element;
                Object o = TestDataReferencesDialog.this.getSelectedSource();
                if (o != null && o instanceof TestSuiteEntity) {
                    TestSuiteEntity testSuite = (TestSuiteEntity)o;
                    return Integer.toString(testSuite.getTestSuiteTestCaseLinks().indexOf(testCaseLink) + 1);
                }
                if (o != null) {
                    return Integer.toString(TestDataReferencesDialog.this.allAffectedTestCase.indexOf(testCaseLink) + 1);
                }
                return StringConstants.EMPTY;
            }
        });
        TableViewerColumn tableViewerColumnTestCaseID = new TableViewerColumn(this.testCaseLinkTableViewer, 0);
        TableColumn tblclmnTestCaseID = tableViewerColumnTestCaseID.getColumn();
        tblclmnTestCaseID.setWidth(190);
        tblclmnTestCaseID.setText(ComposerTestdataMessageConstants.DIA_COL_TEST_CASE_ID);
        tableViewerColumnTestCaseID.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        tableViewerColumnTestCaseID.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element == null || !(element instanceof TestSuiteTestCaseLink)) {
                    return StringConstants.EMPTY;
                }
                TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)element;
                return testCaseLink.getTestCaseId();
            }
        });
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tblclmnTestCaseLinkOrder, (ColumnLayoutData)new ColumnWeightData(0, 40));
        tableLayout.setColumnData((Widget)tblclmnTestCaseID, (ColumnLayoutData)new ColumnWeightData(80, 190));
        compositeTestCaseLinkTable.setLayout((Layout)tableLayout);
        this.testCaseLinkTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    private Object getSelectedSource() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection == null || selection.size() != 1) {
            return null;
        }
        String testSuiteId = (String)selection.getFirstElement();
        try {
            if (StringUtils.equals((String)testSuiteId, (String)ComposerTestdataMessageConstants.DIA_LBL_REFERENCED_TEST_CASES)) {
                return ComposerTestdataMessageConstants.DIA_LBL_REFERENCED_TEST_CASES;
            }
            return TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, ProjectController.getInstance().getCurrentProject());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    private void setAllAffectedTestCase(List<TestCaseEntity> testCases) {
        if (testCases == null || testCases.isEmpty()) {
            return;
        }
        this.allAffectedTestCase = new ArrayList<TestSuiteTestCaseLink>();
        for (TestCaseEntity tc : testCases) {
            TestSuiteTestCaseLink link = new TestSuiteTestCaseLink();
            link.setTestCaseId(tc.getIdForDisplay());
            this.allAffectedTestCase.add(link);
        }
    }
}

