/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.handlers;

import com.kms.katalon.composer.components.dialogs.MessageDialogWithLink;
import com.kms.katalon.composer.testdata.constants.ComposerTestdataMessageConstants;
import com.kms.katalon.composer.testdata.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.db.DatabaseSettings;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenProjectHandler {
    private static final int DEFAULT_INDEX = 0;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        eventBroker.subscribe("PROJECT/OPENED", new EventHandler(){

            public void handleEvent(Event event) {
                String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                try {
                    DatabaseSettings settings = new DatabaseSettings(projectDir);
                    if (settings.shouldShowWarning() && StringUtils.startsWith((CharSequence)settings.getUrl(), (CharSequence)"jdbc:mysql")) {
                        OpenProjectHandler.this.checkDriverExisted(projectDir, parent, settings);
                    }
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)parent, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
                }
            }
        });
    }

    private void checkDriverExisted(String projectDir, Shell parent, DatabaseSettings settings) throws IOException {
        block2: {
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                MessageDialogWithLink dialog = new MessageDialogWithLink(parent, ComposerTestdataMessageConstants.DIA_TITLE_DRIVER_NOT_FOUND, null, ComposerTestdataMessageConstants.DIA_MSG_DRIVER_NOT_FOUND, 4, new String[]{ComposerTestdataMessageConstants.DIA_BTN_DRIVER_NOT_FOUND}, 0);
                int btnIndex = dialog.open();
                if (btnIndex != 0) break block2;
                settings.setShowWarning(false);
                PropertySettingStoreUtil.saveExternalSettings((String)projectDir, (String)DatabaseSettings.class.getName(), (Properties)settings.getSettings(), (String)ComposerTestdataMessageConstants.DIA_DB_SETTING_COMMENT);
            }
        }
    }
}

