/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.handlers;

import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testdata.constants.ImageConstants;
import com.kms.katalon.composer.testdata.parts.CSVTestDataPart;
import com.kms.katalon.composer.testdata.parts.DBTestDataPart;
import com.kms.katalon.composer.testdata.parts.ExcelTestDataPart;
import com.kms.katalon.composer.testdata.parts.InternalTestDataPart;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.tracking.service.Trackings;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenTestDataHandler {
    private static final String TEST_DATA_BUNDLE_URI = "bundleclass://com.kms.katalon.composer.testdata/";
    private static final String EXCEL_TEST_DATA_PART_URI = "bundleclass://com.kms.katalon.composer.testdata/" + ExcelTestDataPart.class.getName();
    private static final String INTERNAL_TEST_DATA_PART_URI = "bundleclass://com.kms.katalon.composer.testdata/" + InternalTestDataPart.class.getName();
    private static final String CSV_TEST_DATA_PART_URI = "bundleclass://com.kms.katalon.composer.testdata/" + CSVTestDataPart.class.getName();
    private static final String DB_TEST_DATA_PART_URI = "bundleclass://com.kms.katalon.composer.testdata/" + DBTestDataPart.class.getName();
    @Inject
    MApplication application;
    @Inject
    EPartService partService;
    @Inject
    EModelService modelService;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof DataFileEntity) {
                    OpenTestDataHandler.this.execute((DataFileEntity)object);
                }
            }
        });
    }

    @Inject
    @Optional
    private void getNotifications(@UIEventTopic(value="TESTDATA/OPEN") DataFileEntity entity) {
        this.execute(entity);
    }

    public void execute(DataFileEntity testDataObject) {
        try {
            if (testDataObject != null) {
                String partId = EntityPartUtil.getTestDataPartId((String)testDataObject.getId());
                MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
                MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
                if (mPart == null) {
                    mPart = (MPart)this.modelService.createModelElement(MPart.class);
                    mPart.setElementId(partId);
                    mPart.setLabel(testDataObject.getName());
                    mPart.setIconURI(ImageConstants.URL_16_TEST_DATA);
                    if (testDataObject.getDriver() == DataFileEntity.DataFileDriverType.ExcelFile) {
                        mPart.setContributionURI(EXCEL_TEST_DATA_PART_URI);
                    } else if (testDataObject.getDriver() == DataFileEntity.DataFileDriverType.InternalData) {
                        mPart.setContributionURI(INTERNAL_TEST_DATA_PART_URI);
                    } else if (testDataObject.getDriver() == DataFileEntity.DataFileDriverType.CSV) {
                        mPart.setContributionURI(CSV_TEST_DATA_PART_URI);
                    } else if (testDataObject.getDriver() == DataFileEntity.DataFileDriverType.DBData) {
                        mPart.setContributionURI(DB_TEST_DATA_PART_URI);
                    }
                    mPart.setCloseable(true);
                    mPart.setTooltip(testDataObject.getIdForDisplay());
                    stack.getChildren().add(mPart);
                }
                if (mPart.getObject() == null) {
                    mPart.setObject((Object)testDataObject);
                }
                this.partService.showPart(mPart, EPartService.PartState.ACTIVATE);
                stack.setSelectedElement((MUIElement)mPart);
                Trackings.trackOpenObject((String)"testData");
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

