/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.impl.control.ImageButton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.testdata.constants.ComposerTestdataMessageConstants;
import com.kms.katalon.composer.testdata.constants.ImageConstants;
import com.kms.katalon.composer.testdata.constants.StringConstants;
import com.kms.katalon.composer.testdata.job.LoadExcelFileJob;
import com.kms.katalon.composer.testdata.parts.TestDataMainPart;
import com.kms.katalon.composer.testdata.parts.WarnLargeFileUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.core.testdata.ExcelData;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.DataFilePropertyInputEntity;
import java.io.IOException;
import java.text.MessageFormat;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ExcelTestDataPart
extends TestDataMainPart {
    private static final String[] FILTER_NAMES = new String[]{"Microsoft Excel Spreadsheet Files (*.xls, *.xlsx)"};
    private static final String[] FILTER_EXTS = new String[]{"*.xlsx; *.xls"};
    @Inject
    private EPartService partService;
    @Inject
    private UISynchronize sync;
    private Text txtFileName;
    private Combo cbbSheets;
    private TableViewer tableViewer;
    private Label lblSheetName;
    private Button ckcbEnableHeader;
    private Button ckcbUseRelativePath;
    private Button ckcbReadAsString;
    private Button btnBrowse;
    private ImageButton btnExpandFileInfo;
    private Composite compositeFileInfoDetails;
    private Composite compositeFileInfoHeader;
    private Composite compositeTable;
    private Composite compositeFileInfo;
    private boolean isFileInfoExpanded;
    private boolean ableToReload;
    private String fCurrentPath;
    private String fCurrentSheetName;
    private String[][] fData;
    private LoadExcelFileJob loadFileJob;
    private ExcelData excelData;
    private Label lblFileInfoStatus;
    private Listener layoutFileInfoCompositeListener = new Listener(){

        public void handleEvent(Event event) {
            ExcelTestDataPart.this.layoutFileInfoComposite();
        }
    };
    private Label lblFileInfo;
    private IJobChangeListener readExcelJobListener = new JobChangeAdapter(){

        public void done(final IJobChangeEvent event) {
            ExcelTestDataPart.this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (event.getResult() == Status.OK_STATUS) {
                        (this).ExcelTestDataPart.this.excelData = (this).ExcelTestDataPart.this.loadFileJob.getExcelData();
                        if ((this).ExcelTestDataPart.this.excelData == null) {
                            (this).ExcelTestDataPart.this.cbbSheets.setItems(new String[0]);
                            ExcelTestDataPart.this.clearTable();
                            return;
                        }
                        ExcelTestDataPart.this.loadSheetNames((this).ExcelTestDataPart.this.excelData.getSheetNames());
                        ExcelTestDataPart.this.loadExcelDataToTable();
                    }
                }
            });
        }
    };

    @Override
    @PostConstruct
    public void createControls(Composite parent, MPart mpart) {
        this.ableToReload = true;
        new HelpToolBarForMPart(mpart, DocumentationMessageConstants.TEST_DATA_EXCEL);
        super.createControls(parent, mpart);
    }

    protected void layoutFileInfoComposite() {
        Display.getDefault().timerExec(10, new Runnable(){

            @Override
            public void run() {
                ExcelTestDataPart.this.isFileInfoExpanded = !ExcelTestDataPart.this.isFileInfoExpanded;
                ExcelTestDataPart.this.compositeFileInfoDetails.setVisible(ExcelTestDataPart.this.isFileInfoExpanded);
                if (!ExcelTestDataPart.this.isFileInfoExpanded) {
                    ((GridData)ExcelTestDataPart.this.compositeFileInfoDetails.getLayoutData()).exclude = true;
                    ExcelTestDataPart.this.compositeFileInfo.setSize(ExcelTestDataPart.this.compositeFileInfo.getSize().x, ExcelTestDataPart.this.compositeFileInfo.getSize().y - ExcelTestDataPart.this.compositeTable.getSize().y);
                } else {
                    ((GridData)ExcelTestDataPart.this.compositeFileInfoDetails.getLayoutData()).exclude = false;
                }
                ExcelTestDataPart.this.compositeFileInfo.layout(true, true);
                ExcelTestDataPart.this.compositeFileInfo.getParent().layout();
                ExcelTestDataPart.this.redrawBtnExpandFileInfo();
            }
        });
    }

    @Override
    public Composite createFileInfoPart(Composite parent) {
        this.compositeFileInfo = new Composite(parent, 0);
        this.compositeFileInfo.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout glFileComposite = new GridLayout(1, true);
        glFileComposite.marginWidth = 0;
        glFileComposite.marginHeight = 0;
        this.compositeFileInfo.setLayout((Layout)glFileComposite);
        this.compositeFileInfo.setBackground(ColorUtil.getCompositeBackgroundColor());
        this.compositeFileInfoHeader = new Composite(this.compositeFileInfo, 0);
        this.compositeFileInfoHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glFileCompositeHeader = new GridLayout(3, false);
        glFileCompositeHeader.marginWidth = 0;
        glFileCompositeHeader.marginHeight = 0;
        this.compositeFileInfoHeader.setLayout((Layout)glFileCompositeHeader);
        this.compositeFileInfoHeader.setCursor(this.compositeFileInfoHeader.getDisplay().getSystemCursor(21));
        this.btnExpandFileInfo = new ImageButton(this.compositeFileInfoHeader, 0);
        this.lblFileInfo = new Label(this.compositeFileInfoHeader, 0);
        this.lblFileInfo.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblFileInfo.setText(ComposerTestdataMessageConstants.PA_LBL_FILE_INFO);
        ControlUtils.setFontToBeBold((Control)this.lblFileInfo);
        this.lblFileInfoStatus = new Label(this.compositeFileInfoHeader, 0);
        this.lblFileInfoStatus.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblFileInfoStatus.setForeground(ColorUtil.getWarningForegroudColor());
        ControlUtils.setFontToBeBold((Control)this.lblFileInfoStatus);
        this.compositeFileInfoDetails = new Composite(this.compositeFileInfo, 0);
        this.compositeFileInfoDetails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glFileCompositeDetails = new GridLayout(2, true);
        glFileCompositeDetails.marginHeight = 0;
        glFileCompositeDetails.horizontalSpacing = 30;
        glFileCompositeDetails.marginRight = 40;
        glFileCompositeDetails.marginLeft = 40;
        this.compositeFileInfoDetails.setLayout((Layout)glFileCompositeDetails);
        Composite compositeFileName = new Composite(this.compositeFileInfoDetails, 0);
        compositeFileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glCompositeFileName = new GridLayout(3, false);
        glCompositeFileName.marginRight = 5;
        glCompositeFileName.marginWidth = 0;
        compositeFileName.setLayout((Layout)glCompositeFileName);
        Label lblFileName = new Label(compositeFileName, 0);
        GridData gdLblFileName = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblFileName.widthHint = 70;
        lblFileName.setLayoutData((Object)gdLblFileName);
        lblFileName.setText(ComposerTestdataMessageConstants.PA_LBL_FILE_NAME);
        this.txtFileName = new Text(compositeFileName, 2048);
        GridData gdTxtFileName = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtFileName.heightHint = 20;
        this.txtFileName.setLayoutData((Object)gdTxtFileName);
        this.txtFileName.setEditable(false);
        this.btnBrowse = new Button(compositeFileName, 0x800000);
        this.btnBrowse.setText(StringConstants.PA_BTN_BROWSE);
        Composite compositeSheetName = new Composite(this.compositeFileInfoDetails, 0);
        compositeSheetName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeSheetName.setLayout((Layout)new GridLayout(2, false));
        this.lblSheetName = new Label(compositeSheetName, 0);
        this.lblSheetName.setText(ComposerTestdataMessageConstants.PA_LBL_SHEET_NAME);
        this.cbbSheets = new Combo(compositeSheetName, 8);
        GridData gdCbbSheets = new GridData(4, 4, true, false, 1, 1);
        gdCbbSheets.heightHint = 20;
        this.cbbSheets.setLayoutData((Object)gdCbbSheets);
        Composite compositeCheckBoxes = new Composite(this.compositeFileInfoDetails, 0);
        compositeCheckBoxes.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        GridLayout glCompositeCheckBoxes = new GridLayout(3, false);
        glCompositeCheckBoxes.horizontalSpacing = 15;
        glCompositeCheckBoxes.marginWidth = 0;
        compositeCheckBoxes.setLayout((Layout)glCompositeCheckBoxes);
        this.ckcbEnableHeader = new Button(compositeCheckBoxes, 32);
        this.ckcbEnableHeader.setText(ComposerTestdataMessageConstants.PA_CHKBOX_USE_FIRST_ROW_AS_HEADER);
        this.ckcbUseRelativePath = new Button(compositeCheckBoxes, 32);
        this.ckcbUseRelativePath.setText(ComposerTestdataMessageConstants.PA_CHKBOX_USE_RELATIVE_PATH);
        this.ckcbReadAsString = new Button(compositeCheckBoxes, 32);
        this.ckcbReadAsString.setText(ComposerTestdataMessageConstants.VIEW_LBL_READ_AS_STRING);
        this.isFileInfoExpanded = true;
        this.redrawBtnExpandFileInfo();
        this.addControlListeners();
        return this.compositeFileInfo;
    }

    private String getSourceUrlAbsolutePath() {
        String sourceUrl = this.txtFileName.getText();
        if (this.ckcbUseRelativePath.getSelection()) {
            sourceUrl = PathUtil.relativeToAbsolutePath((String)sourceUrl, (String)this.getProjectFolderLocation());
        }
        return sourceUrl;
    }

    @Override
    protected void initValues() {
        String strReadAsString = this.getDataFile().getProperty("readAsString");
        this.ckcbReadAsString.setSelection(strReadAsString == null || strReadAsString.isEmpty() ? true : Boolean.valueOf(strReadAsString));
    }

    @Override
    public Composite createDataTablePart(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compositeTable = new Composite(parent, 2048);
        GridLayout glTableViewerComposite = new GridLayout(1, true);
        glTableViewerComposite.marginWidth = 0;
        glTableViewerComposite.marginHeight = 0;
        this.compositeTable.setLayout((Layout)glTableViewerComposite);
        this.compositeTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = new TableViewer(this.compositeTable, 0x10010000);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.getTable().setLinesVisible(ControlUtils.shouldLineVisble((Display)this.tableViewer.getTable().getDisplay()));
        TableViewerColumn tbviewerClmnNo = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tbclmnNo = tbviewerClmnNo.getColumn();
        tbclmnNo.setText(StringConstants.NO_);
        tbclmnNo.setWidth(40);
        tbviewerClmnNo.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                int order = ExcelTestDataPart.this.tableViewer.getTable().indexOf((TableItem)cell.getItem()) + 1;
                cell.setText(Integer.toString(order));
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        return this.compositeTable;
    }

    private void loadInput(DataFileEntity dataFile) {
        this.fCurrentPath = dataFile.getDataSourceUrl();
        this.txtFileName.setText(this.fCurrentPath);
        this.ckcbEnableHeader.setSelection(dataFile.isContainsHeaders());
        this.ckcbUseRelativePath.setSelection(dataFile.getIsInternalPath());
        this.fCurrentSheetName = dataFile.getSheetName();
        this.readExcelFile();
    }

    private void readExcelFile() {
        if (this.ableToReload) {
            if (this.loadFileJob != null && this.loadFileJob.getState() == 4) {
                this.loadFileJob.cancel();
                this.loadFileJob.removeJobChangeListener(this.readExcelJobListener);
            }
            this.loadFileJob = new LoadExcelFileJob(this.getSourceUrlAbsolutePath(), this.ckcbEnableHeader.getSelection());
            this.loadFileJob.setUser(true);
            this.loadFileJob.schedule();
            this.loadFileJob.addJobChangeListener(this.readExcelJobListener);
        }
    }

    private void addControlListeners() {
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExcelTestDataPart.this.btnBrowse.getShell());
                dialog.setFilterNames(FILTER_NAMES);
                dialog.setFilterExtensions(FILTER_EXTS);
                dialog.setFilterPath(ExcelTestDataPart.this.getProjectFolderLocation());
                this.changeExcelFile(dialog.open());
                ExcelTestDataPart.this.enableRelativePath();
            }

            private void changeExcelFile(String absoluteFilePath) {
                if (absoluteFilePath == null || absoluteFilePath.equals(ExcelTestDataPart.this.fCurrentPath)) {
                    return;
                }
                ExcelTestDataPart.this.executeOperation((IUndoableOperation)new ChangeExcelFileOperation(absoluteFilePath));
            }
        });
        this.cbbSheets.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelTestDataPart.this.executeOperation((IUndoableOperation)new ChangeSheetOperation(ExcelTestDataPart.this.cbbSheets.getText()));
            }
        });
        this.ckcbEnableHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelTestDataPart.this.executeOperation((IUndoableOperation)new ChangeUseFirstRowAsHeaderOperation(ExcelTestDataPart.this.ckcbEnableHeader.getSelection()));
            }
        });
        this.ckcbUseRelativePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelTestDataPart.this.executeOperation((IUndoableOperation)new ChangeUseRelativePathOperation(ExcelTestDataPart.this.ckcbUseRelativePath.getSelection()));
            }
        });
        this.ckcbReadAsString.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelTestDataPart.this.getDataFile().setProperty("readAsString", String.valueOf(ExcelTestDataPart.this.ckcbReadAsString.getSelection()));
                ExcelTestDataPart.this.dirtyable.setDirty(true);
            }
        });
        this.btnExpandFileInfo.addListener(3, this.layoutFileInfoCompositeListener);
        this.lblFileInfo.addListener(3, this.layoutFileInfoCompositeListener);
        this.lblFileInfoStatus.addListener(3, this.layoutFileInfoCompositeListener);
    }

    private void redrawBtnExpandFileInfo() {
        this.btnExpandFileInfo.getParent().setRedraw(false);
        if (this.isFileInfoExpanded) {
            this.btnExpandFileInfo.setImage(ImageConstants.IMG_16_ARROW_DOWN);
        } else {
            this.btnExpandFileInfo.setImage(ImageConstants.IMG_16_ARROW);
        }
        this.btnExpandFileInfo.getParent().setRedraw(true);
    }

    private void selectDefaultSheet(String[] sheetNames) {
        if (sheetNames.length > 0) {
            this.fCurrentSheetName = sheetNames[0];
            this.cbbSheets.select(0);
        }
    }

    private void loadSheetNames(String[] sheetNames) {
        try {
            if (this.cbbSheets.isDisposed()) {
                return;
            }
            this.cbbSheets.setItems(sheetNames);
            if (StringUtils.isBlank((String)this.fCurrentSheetName)) {
                this.selectDefaultSheet(sheetNames);
                this.setDirty(true);
            } else {
                int currentIdx = this.cbbSheets.indexOf(this.fCurrentSheetName);
                if (currentIdx < 0) {
                    MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)MessageFormat.format(ComposerTestdataMessageConstants.PA_WARN_MSG_SHEET_NOT_FOUND, this.fCurrentSheetName));
                    this.selectDefaultSheet(sheetNames);
                    this.setDirty(true);
                } else {
                    this.cbbSheets.select(this.cbbSheets.indexOf(this.fCurrentSheetName));
                }
            }
        }
        catch (Exception exception) {
            MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)ComposerTestdataMessageConstants.PA_WARN_MSG_UNABLE_TO_LOAD_SHEET_NAME);
        }
    }

    private void clearTable() {
        Table table = this.tableViewer.getTable();
        while (table.getColumnCount() > 1) {
            table.getColumns()[1].dispose();
        }
        table.clearAll();
        this.tableViewer.setItemCount(0);
        table.setHeaderVisible(false);
    }

    private void loadExcelDataToTable() {
        try {
            this.tableViewer.getTable().setRedraw(false);
            this.clearTable();
            String[] headers = null;
            if (this.cbbSheets.getSelectionIndex() < 0) {
                return;
            }
            try {
                this.excelData.changeSheet(this.cbbSheets.getText());
                this.excelData.activeHeaders(this.ckcbEnableHeader.getSelection());
                headers = this.excelData.getColumnNames();
                int rowNumbers = this.excelData.getRowNumbers();
                int columnNumbers = this.excelData.getColumnNumbers();
                if (columnNumbers > 100) {
                    WarnLargeFileUtil.showDialog();
                    columnNumbers = 100;
                }
                this.fData = new String[rowNumbers][columnNumbers];
                this.tableViewer.getTable().setItemCount(rowNumbers);
                int numEmptyHeader = 0;
                int i = 0;
                while (i < columnNumbers) {
                    String header;
                    TableViewerColumn columnViewer = new TableViewerColumn(this.tableViewer, 0);
                    String string = header = headers == null ? "" : headers[i];
                    if (!StringUtils.isBlank((String)header)) {
                        columnViewer.getColumn().setText(header);
                    } else {
                        columnViewer.getColumn().setImage(ImageConstants.IMG_16_WARN_TABLE_ITEM);
                        columnViewer.getColumn().setToolTipText(ComposerTestdataMessageConstants.PA_TOOLTIP_WARNING_COLUMN_HEADER);
                        columnViewer.getColumn().setText("");
                        ++numEmptyHeader;
                    }
                    columnViewer.getColumn().setWidth(200);
                    columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        private String getCellText(ExcelData excelData, int columnIndex, int rowIndex) {
                            try {
                                return excelData.getValue(columnIndex + 1, rowIndex + 1);
                            }
                            catch (IOException iOException) {
                                return "";
                            }
                        }

                        public void update(final ViewerCell cell) {
                            final int columnIndex = cell.getColumnIndex() - 1;
                            final int rowIndex = ExcelTestDataPart.this.tableViewer.getTable().indexOf((TableItem)cell.getItem());
                            String text = "...";
                            cell.setText(text);
                            ExcelTestDataPart.this.sync.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if ((this).ExcelTestDataPart.this.fData == null || cell.getItem().isDisposed()) {
                                        return;
                                    }
                                    if ((this).ExcelTestDataPart.this.fData[rowIndex][columnIndex] == null) {
                                        (this).ExcelTestDataPart.this.fData[rowIndex][columnIndex] = this.getCellText((this).ExcelTestDataPart.this.excelData, columnIndex, rowIndex);
                                    }
                                    cell.setText((this).ExcelTestDataPart.this.fData[rowIndex][columnIndex]);
                                }
                            });
                        }
                    });
                    ++i;
                }
                if (numEmptyHeader > 0 && this.ckcbEnableHeader.getSelection()) {
                    this.lblFileInfoStatus.setText(MessageFormat.format(ComposerTestdataMessageConstants.PA_LBL_WARNING_COLUMN_HEADER, numEmptyHeader, columnNumbers));
                }
                this.tableViewer.setInput((Object)this.fData);
                this.tableViewer.getTable().setHeaderVisible(this.ckcbEnableHeader.getSelection());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fData = null;
            }
            catch (Exception e) {
                this.fData = null;
                LoggerSingleton.logError((Throwable)e);
            }
        }
        finally {
            this.tableViewer.getTable().setRedraw(true);
        }
    }

    @Persist
    public void save() {
        try {
            try {
                this.ableToReload = false;
                this.originalDataFile = this.updateDataFileProperty(this.originalDataFile.getLocation(), this.originalDataFile.getName(), this.originalDataFile.getDescription(), DataFileEntity.DataFileDriverType.ExcelFile, this.txtFileName.getText(), this.cbbSheets.getText(), this.ckcbUseRelativePath.getSelection(), this.ckcbEnableHeader.getSelection());
                this.updateDataFile(this.originalDataFile);
                this.dirtyable.setDirty(false);
                this.refreshTreeEntity();
                this.sendTestDataUpdatedEvent(this.originalDataFile.getId());
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerTestdataMessageConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_TEST_DATA, (String)e.getClass().getSimpleName());
                this.ableToReload = true;
            }
        }
        finally {
            this.ableToReload = true;
        }
    }

    public DataFileEntity updateDataFileProperty(String pk, String name, String description, DataFileEntity.DataFileDriverType dataFileDriver, String dataSourceURL, String sheetName, boolean isInternalPath, boolean isHeaderEnabled) throws Exception {
        DataFilePropertyInputEntity dataFileInputPro = new DataFilePropertyInputEntity();
        dataFileInputPro.setPk(pk);
        dataFileInputPro.setName(name);
        dataFileInputPro.setDescription(description);
        dataFileInputPro.setDataFileDriver(dataFileDriver.name());
        dataFileInputPro.setdataSourceURL(dataSourceURL);
        dataFileInputPro.setSheetName(sheetName);
        dataFileInputPro.setIsInternalPath(isInternalPath);
        dataFileInputPro.setEnableHeader(isHeaderEnabled);
        DataFileEntity dataFileEntity = TestDataController.getInstance().updateDataFile(dataFileInputPro);
        return dataFileEntity;
    }

    private String getProjectFolderLocation() {
        return ProjectController.getInstance().getCurrentProject().getFolderLocation();
    }

    @Override
    protected void updateChildInfo(DataFileEntity dataFile) {
        this.loadInput(dataFile);
        this.enableRelativePath();
    }

    private void enableRelativePath() {
        this.ckcbUseRelativePath.setEnabled(StringUtils.isNotBlank((String)this.txtFileName.getText()));
    }

    @Override
    protected EPartService getPartService() {
        return this.partService;
    }

    @Override
    @PreDestroy
    public void onClose() {
        this.fCurrentPath = "";
        this.fCurrentSheetName = "";
        this.fData = null;
        super.onClose();
    }

    private class ChangeExcelFileOperation
    extends AbstractOperation {
        private String oldExcelFilePath;
        private String oldSheetName;
        private String newExcelFilePath;

        public ChangeExcelFileOperation(String newExcelFilePath) {
            super(ChangeExcelFileOperation.class.getName());
            this.newExcelFilePath = newExcelFilePath;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.newExcelFilePath == null) {
                return Status.CANCEL_STATUS;
            }
            this.oldExcelFilePath = ExcelTestDataPart.this.fCurrentPath;
            this.oldSheetName = ExcelTestDataPart.this.fCurrentSheetName;
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doLoadExcelFile(this.newExcelFilePath, "");
            return Status.OK_STATUS;
        }

        private void doLoadExcelFile(String excelFileAbsolutePath, String sheetName) {
            ExcelTestDataPart.this.lblFileInfoStatus.setText("");
            ExcelTestDataPart.this.fCurrentPath = excelFileAbsolutePath;
            ExcelTestDataPart.this.fCurrentSheetName = sheetName;
            if (ExcelTestDataPart.this.ckcbUseRelativePath.getSelection()) {
                ExcelTestDataPart.this.txtFileName.setText(PathUtil.absoluteToRelativePath((String)ExcelTestDataPart.this.fCurrentPath, (String)ExcelTestDataPart.this.getProjectFolderLocation()));
            } else {
                ExcelTestDataPart.this.txtFileName.setText(ExcelTestDataPart.this.fCurrentPath);
            }
            ExcelTestDataPart.this.readExcelFile();
            ExcelTestDataPart.this.dirtyable.setDirty(true);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doLoadExcelFile(this.oldExcelFilePath, this.oldSheetName);
            return Status.OK_STATUS;
        }
    }

    private class ChangeSheetOperation
    extends AbstractOperation {
        private String oldSheetName;
        private String newSheetName;

        public ChangeSheetOperation(String newSheetName) {
            super(ChangeSheetOperation.class.getName());
            this.newSheetName = newSheetName;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.newSheetName.equals(ExcelTestDataPart.this.fCurrentSheetName)) {
                return Status.CANCEL_STATUS;
            }
            this.oldSheetName = ExcelTestDataPart.this.fCurrentSheetName;
            this.doSetSheetName(this.newSheetName);
            return Status.OK_STATUS;
        }

        private void doSetSheetName(String selectedSheetName) {
            ExcelTestDataPart.this.lblFileInfoStatus.setText("");
            ExcelTestDataPart.this.fCurrentSheetName = selectedSheetName;
            ExcelTestDataPart.this.cbbSheets.setText(ExcelTestDataPart.this.fCurrentSheetName);
            ExcelTestDataPart.this.loadExcelDataToTable();
            ExcelTestDataPart.this.dirtyable.setDirty(true);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doSetSheetName(this.newSheetName);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doSetSheetName(this.oldSheetName);
            return Status.OK_STATUS;
        }
    }

    private class ChangeUseFirstRowAsHeaderOperation
    extends AbstractOperation {
        boolean oldCheckedValue;

        public ChangeUseFirstRowAsHeaderOperation(boolean oldCheckedValue) {
            super(ChangeUseFirstRowAsHeaderOperation.class.getName());
            this.oldCheckedValue = oldCheckedValue;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doChangeCheckValue(this.oldCheckedValue);
            return Status.OK_STATUS;
        }

        private void doChangeCheckValue(boolean isSelected) {
            ExcelTestDataPart.this.ckcbEnableHeader.setSelection(isSelected);
            ExcelTestDataPart.this.loadExcelDataToTable();
            ExcelTestDataPart.this.dirtyable.setDirty(true);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doChangeCheckValue(!this.oldCheckedValue);
            return Status.OK_STATUS;
        }
    }

    private class ChangeUseRelativePathOperation
    extends AbstractOperation {
        boolean oldCheckedValue;

        public ChangeUseRelativePathOperation(boolean oldCheckedValue) {
            super(ChangeUseRelativePathOperation.class.getName());
            this.oldCheckedValue = oldCheckedValue;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doChangeCheckValue(this.oldCheckedValue);
            return Status.OK_STATUS;
        }

        private void doChangeCheckValue(boolean isSelected) {
            ExcelTestDataPart.this.ckcbUseRelativePath.setSelection(isSelected);
            ExcelTestDataPart.this.dirtyable.setDirty(true);
            if (ExcelTestDataPart.this.txtFileName.getText() == null) {
                return;
            }
            String sourceUrl = ExcelTestDataPart.this.txtFileName.getText();
            if (isSelected) {
                ExcelTestDataPart.this.txtFileName.setText(PathUtil.absoluteToRelativePath((String)sourceUrl, (String)ExcelTestDataPart.this.getProjectFolderLocation()));
            } else {
                ExcelTestDataPart.this.txtFileName.setText(PathUtil.relativeToAbsolutePath((String)sourceUrl, (String)ExcelTestDataPart.this.getProjectFolderLocation()));
            }
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doChangeCheckValue(!this.oldCheckedValue);
            return Status.OK_STATUS;
        }
    }
}

