/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.parts.provider;

import com.kms.katalon.composer.components.impl.support.TypeCheckedEditingSupport;
import com.kms.katalon.composer.testdata.parts.InternalDataCell;
import com.kms.katalon.composer.testdata.parts.InternalDataRow;
import com.kms.katalon.composer.testdata.parts.InternalTestDataPart;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class InternalDataEditingSupport
extends TypeCheckedEditingSupport<InternalDataRow> {
    private InternalTestDataPart testDataPart;

    public InternalDataEditingSupport(InternalTestDataPart testDataPart, ColumnViewer viewer) {
        super(viewer);
        this.testDataPart = testDataPart;
    }

    protected Class<InternalDataRow> getElementType() {
        return InternalDataRow.class;
    }

    protected CellEditor getCellEditorByElement(InternalDataRow element) {
        return new TextCellEditor((Composite)this.getViewer().getControl());
    }

    protected boolean canEditElement(InternalDataRow element) {
        return !element.isLastRow();
    }

    protected Object getElementValue(InternalDataRow element) {
        return this.getCellData(element).getValue();
    }

    protected void setElementValue(InternalDataRow element, Object value) {
        if (!(value instanceof String)) {
            return;
        }
        this.testDataPart.executeOperation((IUndoableOperation)new EditCellOperation(element, (String)value));
    }

    private InternalDataCell getCellData(InternalDataRow element) {
        return element.getCells().get(this.columnIndex - 1);
    }

    private class EditCellOperation
    extends AbstractOperation {
        private int rowIndex;
        private String newValue;
        private String oldValue;

        public EditCellOperation(InternalDataRow rowElement, String newValue) {
            super(EditCellOperation.class.getName());
            this.rowIndex = InternalDataEditingSupport.this.testDataPart.getInput().indexOf(rowElement);
            this.newValue = newValue;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            List<InternalDataRow> input = InternalDataEditingSupport.this.testDataPart.getInput();
            if (this.rowIndex < 0 || this.rowIndex > input.size()) {
                return Status.CANCEL_STATUS;
            }
            InternalDataCell internalDataCell = InternalDataEditingSupport.this.getCellData(input.get(this.rowIndex));
            if (this.newValue.equals(internalDataCell.getValue())) {
                return Status.CANCEL_STATUS;
            }
            this.oldValue = internalDataCell.getValue();
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doSetValue(this.newValue);
            return Status.OK_STATUS;
        }

        private void doSetValue(String value) {
            List<InternalDataRow> input = InternalDataEditingSupport.this.testDataPart.getInput();
            InternalDataRow rowElement = input.get(this.rowIndex);
            InternalDataCell internalDataCell = InternalDataEditingSupport.this.getCellData(rowElement);
            internalDataCell.setValue(Objects.toString(value));
            InternalDataEditingSupport.this.getViewer().refresh((Object)rowElement);
            InternalDataEditingSupport.this.getViewer().setSelection((ISelection)new StructuredSelection((Object)rowElement));
            InternalDataEditingSupport.this.testDataPart.setDirty(true);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doSetValue(this.oldValue);
            return Status.OK_STATUS;
        }
    }
}

