/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.views;

import com.kms.katalon.composer.testdata.constants.ComposerTestdataMessageConstants;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewTestDataColumnDialog
extends Dialog {
    private String[] currentNames;
    private String name;
    private Text txtName;
    private ControlDecoration controlDecoration;

    public NewTestDataColumnDialog(Shell parentShell, String[] currentNames) {
        super(parentShell);
        this.setCurrentNames(currentNames);
    }

    public NewTestDataColumnDialog(Shell parentShell, String name, String[] currentNames) {
        super(parentShell);
        this.setName(name);
        this.setCurrentNames(currentNames);
        this.setCurrentNames(currentNames);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)area.getLayout();
        gridLayout.marginWidth = 0;
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 128, true, true));
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.horizontalSpacing = 15;
        container.setLayout((Layout)gl_container);
        Label theLabel = new Label(container, 0);
        theLabel.setText(ComposerTestdataMessageConstants.VIEW_COL_COL_NAME);
        this.txtName = new Text(container, 2048);
        GridData gdTxtName = new GridData(4, 128, true, true);
        gdTxtName.minimumWidth = 300;
        this.txtName.setLayoutData((Object)gdTxtName);
        this.controlDecoration = new ControlDecoration((Control)this.txtName, 16512);
        Image imgNotification = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
        this.controlDecoration.setImage(imgNotification);
        this.controlDecoration.setShowHover(true);
        Label separator = new Label(area, 258);
        separator.setLayoutData((Object)new GridData(768));
        return area;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ComposerTestdataMessageConstants.VIEW_SHELL_DATA_COL_DEFINITION);
    }

    protected void okPressed() {
        if (this.txtName.getText().trim().isEmpty()) {
            MessageDialog.openInformation((Shell)this.getParentShell(), (String)ComposerTestdataMessageConstants.VIEW_INFO_TITLE_INVALID_DATA, (String)ComposerTestdataMessageConstants.VIEW_INFO_MSG_ENTER_COL_NAME);
            return;
        }
        this.name = this.txtName.getText();
        super.okPressed();
    }

    public void create() {
        super.create();
        this.loadInput();
        this.addSelectionListener();
    }

    private void addSelectionListener() {
        if (this.currentNames != null) {
            this.txtName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewTestDataColumnDialog.this.validate();
                }
            });
        }
    }

    private void showNotification(String message) {
        this.controlDecoration.setDescriptionText(message);
        this.controlDecoration.show();
    }

    private void validate() {
        String text = this.txtName.getText();
        if (text.isEmpty()) {
            this.showNotification(ComposerTestdataMessageConstants.VIEW_WARN_MSG_NAME_IS_EMPTY);
            this.getButton(0).setEnabled(false);
            return;
        }
        if (ArrayUtils.contains((Object[])this.currentNames, (Object)text)) {
            this.showNotification(ComposerTestdataMessageConstants.VIEW_WARN_MSG_DUPLICATED_NAME);
            this.getButton(0).setEnabled(false);
        } else {
            this.controlDecoration.hide();
            this.getButton(0).setEnabled(true);
        }
    }

    private void loadInput() {
        if (this.name != null) {
            this.txtName.setText(this.name);
            this.txtName.selectAll();
        }
        this.validate();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private void setCurrentNames(String[] currentNames) {
        this.currentNames = currentNames;
        Arrays.sort(currentNames);
    }

    protected boolean isResizable() {
        return true;
    }
}

