/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.cucumber.dialog;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.entity.file.FileEntity;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameFeatureEntityDialog
extends CustomTitleAreaDialog {
    private Text txtName;
    private List<FileEntity> siblingFeatures;
    private String newName;
    private FileEntity currentFeature;

    public RenameFeatureEntityDialog(Shell parentShell, FileEntity listenerEntity, List<FileEntity> siblingListeners) {
        super(parentShell);
        this.siblingFeatures = siblingListeners;
        this.currentFeature = listenerEntity;
    }

    protected void setInput() {
        this.txtName.setText(this.currentFeature.getName());
        int dotIndex = this.txtName.getText().indexOf(".");
        if (dotIndex < 0) {
            this.txtName.selectAll();
        } else {
            this.txtName.setSelection(0, dotIndex);
        }
        this.txtName.forceFocus();
        this.setMessage("Rename Feature file", 1);
    }

    private boolean isNameDupplicated(String newName) {
        return this.siblingFeatures.parallelStream().filter(l -> l.getName().equals(newName)).findAny().isPresent();
    }

    private void checkNewName(String newName) {
        if (this.isNameDupplicated(newName)) {
            this.setMessage(StringConstants.DIA_NAME_EXISTED, 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        try {
            EntityNameController.getInstance().validateName(newName);
            this.setMessage("Rename Feature file", 1);
            this.getButton(0).setEnabled(true);
        }
        catch (Exception e) {
            this.setMessage(e.getMessage(), 3);
            this.getButton(0).setEnabled(false);
        }
    }

    protected void registerControlModifyListeners() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameFeatureEntityDialog.this.checkNewName(RenameFeatureEntityDialog.this.txtName.getText());
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Rename Feature File");
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected void okPressed() {
        this.newName = this.txtName.getText();
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(400, 250);
    }

    public String getNewName() {
        return this.newName;
    }

    protected Composite createContentArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite nameComposite = new Composite(container, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        nameComposite.setLayout((Layout)layout);
        Label lblName = new Label(nameComposite, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText(GlobalMessageConstants.NAME);
        this.txtName = new Text(nameComposite, 2048);
        GridData gdTxtName = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtName.minimumWidth = 200;
        this.txtName.setLayoutData((Object)gdTxtName);
        return container;
    }
}

