/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.cucumber.handler;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.explorer.util.TransferTypeCollection;
import com.kms.katalon.composer.testcase.providers.TestObjectScriptDropListener;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenFeatureEntityHandler {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object instanceof SystemFileEntity) {
                    OpenFeatureEntityHandler.this.openEditor((SystemFileEntity)object);
                }
            }
        });
    }

    ITextEditor openEditor(SystemFileEntity object) {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        IFile iFile = GroovyUtil.getGroovyProject((ProjectEntity)currentProject).getFile(object.getRelativePath());
        try {
            IWorkbenchPage activePage;
            ITextEditor editor;
            iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFile.getName());
            if (desc == null) {
                desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.DefaultTextEditor");
            }
            if ((editor = (ITextEditor)(activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findEditor((IEditorInput)new FileEditorInput(iFile))) != null) {
                activePage.activate((IWorkbenchPart)editor);
            } else {
                editor = (ITextEditor)activePage.openEditor((IEditorInput)new FileEditorInput(iFile), desc.getId());
            }
            Trackings.trackOpenObject((String)"bddFeatureFile");
            this.addTestObjectDropListener(editor);
            return editor;
        }
        catch (CoreException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    private void addTestObjectDropListener(ITextEditor editor) {
        Control control = (Control)editor.getAdapter(Control.class);
        if (!(control instanceof StyledText)) {
            return;
        }
        DropTarget dropTarget = null;
        Object existingDropTarget = control.getData("DropTarget");
        dropTarget = existingDropTarget != null ? (DropTarget)existingDropTarget : new DropTarget(control, 1);
        Transfer[] transfers = dropTarget.getTransfer();
        List treeEntityTransfers = TransferTypeCollection.getInstance().getTreeEntityTransfer();
        if (transfers.length != 0) {
            treeEntityTransfers.addAll(Arrays.asList(transfers));
        }
        dropTarget.setTransfer(treeEntityTransfers.toArray(new Transfer[treeEntityTransfers.size()]));
        dropTarget.addDropListener((DropTargetListener)new TestObjectScriptDropListener((StyledText)editor.getAdapter(Control.class)));
    }
}

