/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist;

import org.codehaus.groovy.eclipse.core.ISourceBuffer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DocumentSourceBuffer
implements ISourceBuffer {
    private IDocument document;

    public DocumentSourceBuffer(IDocument document) {
        this.document = document;
    }

    public char charAt(int offset) {
        try {
            return this.document.getChar(offset);
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public int length() {
        return this.document.getLength();
    }

    public CharSequence subSequence(int start, int end) {
        try {
            return this.document.get(start, end - start);
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public int[] toLineColumn(int offset) {
        try {
            int line = this.document.getLineOfOffset(offset);
            int lineOffset = this.document.getLineOffset(line);
            return new int[]{line + 1, offset - lineOffset + 1};
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public int toOffset(int line, int column) {
        try {
            int offset = this.document.getLineOffset(line - 1);
            return offset + column - 1;
        }
        catch (BadLocationException e) {
            try {
                return this.document.getLineOffset(this.document.getNumberOfLines() - 1);
            }
            catch (BadLocationException e1) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }
    }
}

