/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.eclipse.codeassist.CharArraySourceBuffer;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalProvider;
import org.codehaus.groovy.eclipse.codeassist.processors.ProposalProviderRegistry;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.core.ISourceBuffer;
import org.codehaus.groovy.eclipse.core.util.ExpressionFinder;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class NewFieldCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    public NewFieldCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        ContentAssistContext context = this.getContext();
        List<String> unimplementedFieldNames = this.getAllSuggestedFieldNames(context);
        LinkedList<ICompletionProposal> proposals = new LinkedList<ICompletionProposal>();
        IType enclosingType = context.getEnclosingType();
        if (enclosingType != null) {
            for (String fieldName : unimplementedFieldNames) {
                proposals.add(this.createProposal(fieldName, context, enclosingType));
            }
            ExpressionFinder.NameAndLocation nameAndLocation = this.findCompletionTypeName(context.unit, context.completionLocation);
            if (nameAndLocation != null) {
                String[] suggestedNames;
                String typeName = nameAndLocation.toTypeName();
                if ("def".equals(typeName)) {
                    typeName = "value";
                }
                if ((suggestedNames = NamingConventions.suggestVariableNames((int)2, (int)2, (String)typeName, (IJavaProject)context.unit.getJavaProject(), (int)nameAndLocation.dims(), null, (boolean)true)) != null) {
                    String[] stringArray = suggestedNames;
                    int n = suggestedNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String suggestedName = stringArray[n2];
                        if (suggestedName.startsWith(context.completionExpression)) {
                            proposals.add(this.createProposal(suggestedName, nameAndLocation.name, context, enclosingType, false, true, nameAndLocation.location, context.completionLocation - nameAndLocation.location));
                        }
                        ++n2;
                    }
                }
            }
        }
        return proposals;
    }

    private ExpressionFinder.NameAndLocation findCompletionTypeName(GroovyCompilationUnit unit, int completionLocation) {
        return new ExpressionFinder().findPreviousTypeNameToken((ISourceBuffer)new CharArraySourceBuffer(unit.getContents()), completionLocation);
    }

    private List<String> getAllSuggestedFieldNames(ContentAssistContext context) {
        LinkedList<String> allNewFieldNames = new LinkedList<String>();
        try {
            List<IProposalProvider> providers = ProposalProviderRegistry.getRegistry().getProvidersFor(context.unit);
            for (IProposalProvider provider : providers) {
                List<String> newFieldNames = provider.getNewFieldProposals(context);
                if (newFieldNames == null) continue;
                allNewFieldNames.addAll(newFieldNames);
            }
        }
        catch (CoreException e) {
            GroovyContentAssist.logError("Exception looking for proposal providers in " + context.unit.getElementName(), e);
        }
        return allNewFieldNames;
    }

    private ICompletionProposal createProposal(String fieldName, ContentAssistContext context, IType enclosingType) {
        boolean isStatic;
        if (fieldName.startsWith("NONSTATIC ")) {
            fieldName = fieldName.substring("NONSTATIC ".length());
            isStatic = false;
        } else {
            isStatic = true;
        }
        boolean useKeywordBeforeReplacement = !context.completionExpression.isEmpty() && (context.completionNode instanceof FieldNode || "def".startsWith(context.completionExpression) || "static".startsWith(context.completionExpression));
        int replaceStart = context.completionNode instanceof FieldNode ? context.completionNode.getStart() : context.completionLocation - context.completionExpression.length();
        int replaceLength = context.completionNode instanceof FieldNode ? context.completionLocation - replaceStart : context.completionExpression.length();
        return this.createProposal(fieldName, null, context, enclosingType, isStatic, useKeywordBeforeReplacement, replaceStart, replaceLength);
    }

    private ICompletionProposal createProposal(String fieldName, String typeName, ContentAssistContext context, IType enclosingType, boolean isStatic, boolean useKeywordBeforeReplacement, int replaceStart, int replaceLength) {
        return new NewGroovyFieldCompletionProposal(fieldName, replaceStart, replaceLength, Relevance.VERY_HIGH.getRelevance(), isStatic, useKeywordBeforeReplacement, typeName);
    }

    private static class NewGroovyFieldCompletionProposal
    extends JavaCompletionProposal {
        private NewGroovyFieldCompletionProposal(String fieldName, int replacementOffset, int replacementLength, int relevance, boolean isStatic, boolean useKeywordBeforeReplacement, String typeName) {
            super(NewGroovyFieldCompletionProposal.createReplacementString(fieldName, typeName, isStatic), replacementOffset, replacementLength, NewGroovyFieldCompletionProposal.createImage(isStatic), NewGroovyFieldCompletionProposal.createDisplayString(fieldName, typeName, isStatic, useKeywordBeforeReplacement), relevance);
        }

        private static String createReplacementString(String fieldName, String typeName, boolean isStatic) {
            if (isStatic) {
                if (typeName != null) {
                    return "static " + typeName + fieldName + " = null";
                }
                return "static " + fieldName + " = null";
            }
            if (typeName != null) {
                return String.valueOf(typeName) + fieldName;
            }
            return "def " + fieldName;
        }

        private static Image createImage(boolean isStatic) {
            CompletionProposal dummy = CompletionProposal.create((int)2, (int)-1);
            if (isStatic) {
                dummy.setFlags(8);
            }
            return ProposalUtils.getImage(dummy);
        }

        private static StyledString createDisplayString(String fieldName, String typeName, boolean isStatic, boolean useKeywordBeforeReplacement) {
            StyledString ss = new StyledString();
            if (useKeywordBeforeReplacement) {
                if (isStatic) {
                    ss.append("static ", StyledString.createColorRegistryStyler((String)"HYPERLINK_COLOR", null));
                    if (typeName != null) {
                        ss.append(typeName);
                    }
                } else if (typeName == null) {
                    ss.append("def ", StyledString.createColorRegistryStyler((String)"HYPERLINK_COLOR", null));
                } else {
                    ss.append(typeName);
                }
            }
            if (isStatic) {
                ss.append(fieldName);
                ss.append(" - New static property", StyledString.QUALIFIER_STYLER);
            } else {
                ss.append(fieldName);
                ss.append(" - New property", StyledString.QUALIFIER_STYLER);
            }
            return ss;
        }
    }
}

