/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.model.SSLClientCertificateSettings;
import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.testobject.authorization.RequestAuthorization;
import com.kms.katalon.core.webservice.common.DefaultKeepAliveStrategy;
import com.kms.katalon.core.webservice.common.DefaultRedirectStrategy;
import com.kms.katalon.core.webservice.exception.ConnectionTimeoutException;
import com.kms.katalon.core.webservice.exception.ResponseSizeLimitException;
import com.kms.katalon.core.webservice.exception.SendRequestException;
import com.kms.katalon.core.webservice.exception.SocketTimeoutException;
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper;
import com.kms.katalon.core.webservice.setting.SSLCertificateOption;
import com.kms.katalon.core.webservice.util.WebServiceCommonUtil;
import com.kms.katalon.util.CryptoUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final String TLS = "TLS";
    private static PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private static final String SOCKET_FACTORY_REGISTRY = "http.socket-factory-registry";

    static {
        connectionManager.setValidateAfterInactivity(1);
        connectionManager.setMaxTotal(2000);
        connectionManager.setDefaultMaxPerRoute(500);
    }

    private HttpUtil() {
    }

    public static HttpResponse sendRequest(HttpUriRequest request) throws SendRequestException {
        return HttpUtil.sendRequest(request, null);
    }

    public static HttpResponse sendRequest(HttpUriRequest request, ProxyInformation proxyInformation) throws SendRequestException {
        return HttpUtil.sendRequest(request, true, proxyInformation, SSLCertificateOption.BYPASS, null);
    }

    public static HttpResponse sendRequest(HttpUriRequest request, boolean followRedirects, ProxyInformation proxyInformation, SSLCertificateOption certOption, SSLClientCertificateSettings clientCertSettings) throws SendRequestException {
        return HttpUtil.sendRequest(request, followRedirects, proxyInformation, 0, 0, 0L, certOption, clientCertSettings, null);
    }

    public static HttpResponse sendRequest(HttpUriRequest request, boolean followRedirects, ProxyInformation proxyInformation, int connectionTimeout, int socketTimeout, long maxResponseSize, SSLCertificateOption certificateOption, SSLClientCertificateSettings clientCertSettings, RequestAuthorization requestAuthorization) throws SendRequestException {
        try {
            String url = request.getURI().toURL().toString();
            HttpClientBuilder clientBuilder = HttpUtil.getClientBuilder(url, followRedirects, proxyInformation, connectionTimeout, socketTimeout);
            if (requestAuthorization != null && requestAuthorization.getAuthorizationType() != null && requestAuthorization.getAuthorizationType().equals("NTLM")) {
                clientBuilder = HttpUtil.configureNTLM(clientBuilder, requestAuthorization.getAuthorizationInfo());
            }
            CloseableHttpClient httpClient = clientBuilder.build();
            HttpContext httpContext = HttpUtil.getDefaultHttpContext(certificateOption, clientCertSettings);
            CloseableHttpResponse response = null;
            try {
                response = httpClient.execute(request, httpContext);
            }
            catch (ConnectTimeoutException exception) {
                throw new ConnectionTimeoutException(exception);
            }
            catch (java.net.SocketTimeoutException exception) {
                throw new SocketTimeoutException((Throwable)exception);
            }
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                long headerLength = WebServiceCommonHelper.calculateHeaderLength((HttpResponse)response);
                long bodyLength = responseEntity.getContentLength();
                long totalResponseSize = headerLength + bodyLength;
                boolean isLimitResponseSize = WebServiceCommonUtil.isLimitedRequestResponseSize(maxResponseSize);
                if (isLimitResponseSize && totalResponseSize > maxResponseSize) {
                    request.abort();
                    throw new ResponseSizeLimitException();
                }
            }
            IOUtils.closeQuietly((Closeable)httpClient);
            return response;
        }
        catch (ConnectionTimeoutException | ResponseSizeLimitException | SocketTimeoutException | IOException | URISyntaxException | GeneralSecurityException e) {
            throw new SendRequestException(e);
        }
    }

    public static String getStringContent(String url) throws SendRequestException {
        try {
            HttpGet get = new HttpGet(url);
            HttpResponse response = HttpUtil.sendRequest((HttpUriRequest)get);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException | ParseException e) {
            throw new SendRequestException((Exception)e);
        }
    }

    public static byte[] getBytes(String url) throws SendRequestException {
        try {
            HttpGet get = new HttpGet(url);
            HttpResponse response = HttpUtil.sendRequest((HttpUriRequest)get);
            return EntityUtils.toByteArray((HttpEntity)response.getEntity());
        }
        catch (SendRequestException | IOException e) {
            throw new SendRequestException(e);
        }
    }

    private static HttpClientBuilder getClientBuilder(String url, boolean followRedirects, ProxyInformation proxyInformation, int connectionTimeout, int socketTimeout) throws URISyntaxException, IOException {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        if (followRedirects) {
            clientBuilder.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
        } else {
            clientBuilder.disableRedirectHandling();
        }
        clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        clientBuilder.setConnectionManagerShared(true);
        HttpClientProxyBuilder.configureProxy((HttpClientBuilder)clientBuilder, (ProxyInformation)proxyInformation);
        HttpUtil.configTimeout(clientBuilder, connectionTimeout, socketTimeout);
        clientBuilder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultKeepAliveStrategy());
        return clientBuilder;
    }

    private static void configTimeout(HttpClientBuilder httpClientBuilder, int connectionTimeout, int socketTimeout) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(WebServiceCommonUtil.getValidRequestTimeout(connectionTimeout)).setSocketTimeout(WebServiceCommonUtil.getValidRequestTimeout(socketTimeout)).build();
        httpClientBuilder.setDefaultRequestConfig(config);
    }

    private static HttpContext getDefaultHttpContext(SSLCertificateOption certificateOption, SSLClientCertificateSettings clientCertSettings) throws KeyManagementException, GeneralSecurityException, IOException {
        BasicHttpContext httpContext = new BasicHttpContext();
        SSLContext sc = SSLContext.getInstance(HttpUtil.getHttpsProtocol());
        sc.init(HttpUtil.getKeyManagers(clientCertSettings), HttpUtil.getTrustManagers(certificateOption), null);
        Registry reg = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sc, HttpUtil.getHostnameVerifier(certificateOption))).build();
        httpContext.setAttribute(SOCKET_FACTORY_REGISTRY, (Object)reg);
        return httpContext;
    }

    private static String getHttpsProtocol() {
        if (RunConfiguration.getProperty((String)"httpsProtocol") != null) {
            return (String)RunConfiguration.getProperty((String)"httpsProtocol");
        }
        return TLS;
    }

    private static TrustManager[] getTrustManagers(SSLCertificateOption certificateOption) throws IOException {
        if (certificateOption == SSLCertificateOption.BYPASS) {
            return new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
        }
        return new TrustManager[0];
    }

    private static KeyManager[] getKeyManagers(SSLClientCertificateSettings clientCertSettings) throws GeneralSecurityException, IOException {
        if (clientCertSettings == null) {
            return new KeyManager[0];
        }
        String keyStoreFilePath = clientCertSettings.getKeyStoreFile();
        if (!StringUtils.isBlank((String)keyStoreFilePath)) {
            String keyStorePassword;
            File keyStoreFile = new File(keyStoreFilePath);
            String string = keyStorePassword = !StringUtils.isBlank((String)clientCertSettings.getKeyStorePassword()) ? clientCertSettings.getKeyStorePassword() : "";
            if (keyStoreFile.exists()) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyMaterial km = new KeyMaterial(keyStoreFile, keyStorePassword.toCharArray());
                keyManagerFactory.init(km.getKeyStore(), keyStorePassword.toCharArray());
                return keyManagerFactory.getKeyManagers();
            }
        }
        return new KeyManager[0];
    }

    private static HostnameVerifier getHostnameVerifier(final SSLCertificateOption certificateOption) {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return certificateOption == SSLCertificateOption.BYPASS;
            }
        };
    }

    private static HttpClientBuilder configureNTLM(HttpClientBuilder clientBuilder, Map<String, String> ntlmAuthorization) throws IOException, GeneralSecurityException {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)ntlmAuthorization.get("password"));
        String password = "";
        password = CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
        NTCredentials ntlmCredential = new NTCredentials(ntlmAuthorization.get("username"), password, ntlmAuthorization.get("workstation"), ntlmAuthorization.get("domain"));
        credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "NTLM"), (Credentials)ntlmCredential);
        Registry authSchemeRegistry = RegistryBuilder.create().register("NTLM", (Object)new NTLMSchemeFactory()).register("Negotiate", (Object)new SPNegoSchemeFactory()).register("Kerberos", (Object)new KerberosSchemeFactory()).build();
        clientBuilder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        return clientBuilder;
    }
}

