/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.webservice.common.BasicRequestor;
import com.kms.katalon.core.webservice.common.CustomHttpMethodRequest;
import com.kms.katalon.core.webservice.common.DefaultHttpEntityEnclosingRequest;
import com.kms.katalon.core.webservice.common.DefaultHttpRequest;
import com.kms.katalon.core.webservice.common.HttpUriRequest;
import com.kms.katalon.core.webservice.support.UrlEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ByteArrayEntity;

public class RestfulClient
extends BasicRequestor {
    public RestfulClient(String projectDir, ProxyInformation proxyInfomation) {
        super(projectDir, proxyInfomation);
    }

    protected HttpUriRequest buildHttpRequest(RequestObject requestObject) throws Exception {
        String url = requestObject.getRestUrl();
        HttpUriRequest httpRequest = requestObject.getBodyContent() != null ? this.buildHttpRequestWithBody(requestObject) : new DefaultHttpRequest(url);
        RestfulClient.setRequestMethod(httpRequest, requestObject);
        this.setHttpConnectionHeaders((HttpRequest)httpRequest, requestObject);
        return httpRequest;
    }

    private HttpUriRequest buildHttpRequestWithBody(RequestObject request) throws IOException {
        String url = request.getRestUrl();
        DefaultHttpEntityEnclosingRequest httpRequest = new DefaultHttpEntityEnclosingRequest(url);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        request.getBodyContent().writeTo((OutputStream)outstream);
        byte[] bytes = outstream.toByteArray();
        ByteArrayEntity entity = new ByteArrayEntity(bytes);
        entity.setChunked(false);
        httpRequest.setEntity((HttpEntity)entity);
        return httpRequest;
    }

    private static void setRequestMethod(CustomHttpMethodRequest httpRequest, RequestObject requestObject) {
        String method = requestObject.getRestRequestMethod();
        httpRequest.setMethod(method);
    }

    public static void processRequestParams(RequestObject request) throws MalformedURLException {
        StringBuilder paramString = new StringBuilder();
        for (TestObjectProperty property : request.getRestParameters()) {
            if (StringUtils.isEmpty((String)property.getName())) continue;
            if (!StringUtils.isEmpty((String)paramString.toString())) {
                paramString.append("&");
            }
            paramString.append(UrlEncoder.encode(property.getName()));
            paramString.append("=");
            paramString.append(UrlEncoder.encode(property.getValue()));
        }
        if (!StringUtils.isEmpty((String)paramString.toString())) {
            URL url = new URL(request.getRestUrl());
            request.setRestUrl(String.valueOf(request.getRestUrl()) + (StringUtils.isEmpty((String)url.getQuery()) ? "?" : "&") + paramString.toString());
        }
    }
}

