/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.helper;

import com.kms.katalon.util.TransformerFactoryProvider;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlHelper {
    private XmlHelper() {
    }

    public static Collection<Node> wrapNodeList(final NodeList nodeList) throws IllegalArgumentException {
        if (nodeList == null) {
            throw new IllegalArgumentException("Cannot wrap null NodeList");
        }
        return new Collection<Node>(){

            @Override
            public int size() {
                return nodeList.getLength();
            }

            @Override
            public boolean isEmpty() {
                return nodeList.getLength() > 0;
            }

            @Override
            public boolean contains(Object o) {
                if (o == null || !(o instanceof Node)) {
                    return false;
                }
                int i = 0;
                while (i < nodeList.getLength()) {
                    if (o == nodeList.item(i)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return nodeList.getLength() > this.index;
                    }

                    @Override
                    public Node next() {
                        if (this.index >= nodeList.getLength()) {
                            throw new NoSuchElementException();
                        }
                        return nodeList.item(this.index++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] array = new Node[nodeList.getLength()];
                int i = 0;
                while (i < array.length) {
                    array[i] = nodeList.item(i);
                    ++i;
                }
                return array;
            }

            @Override
            public <T> T[] toArray(T[] a) throws ArrayStoreException {
                if (!a.getClass().getComponentType().isAssignableFrom(Node.class)) {
                    throw new ArrayStoreException(String.valueOf(a.getClass().getComponentType().getName()) + " is not the same or a supertype of Node");
                }
                if (a.length >= nodeList.getLength()) {
                    int i = 0;
                    while (i < nodeList.getLength()) {
                        a[i] = nodeList.item(i);
                        ++i;
                    }
                    if (a.length > nodeList.getLength()) {
                        a[nodeList.getLength()] = null;
                    }
                    return a;
                }
                return this.toArray();
            }

            @Override
            public boolean add(Node node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Node> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String prettyFormat(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactoryProvider.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Throwable throwable) {
            try {
                StreamSource xmlInput = new StreamSource(new StringReader(input));
                StringWriter stringWriter = new StringWriter();
                StreamResult xmlOutput = new StreamResult(stringWriter);
                TransformerFactory transformerFactory = TransformerFactoryProvider.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
                transformer.transform(xmlInput, xmlOutput);
                return xmlOutput.getWriter().toString();
            }
            catch (Throwable throwable2) {
                return input;
            }
        }
    }

    public static String prettyFormat(String input) {
        return XmlHelper.prettyFormat(input, 2);
    }
}

