/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.util;

import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.logging.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import org.apache.commons.lang3.StringUtils;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.SoapOperation;
import org.reficio.ws.builder.SoapOperationBuilder;
import org.reficio.ws.builder.core.Wsdl;
import org.reficio.ws.legacy.SoapLegacyFacade;

public class WsdlUtil {
    private static final String SOAP = "SOAP";
    private static final String SOAP12 = "SOAP12";

    public static Definition getDefinition(WSDLLocator wsdlLocator) throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        Definition definition = reader.readWSDL(wsdlLocator);
        return definition;
    }

    public static Port getFirstPortByBindingMethod(Definition definition, String method) {
        Collection services = definition.getAllServices().values();
        if (services != null && !services.isEmpty()) {
            for (Service service : services) {
                Collection ports = service.getPorts().values();
                if (ports == null || ports.isEmpty()) continue;
                for (Port port : ports) {
                    Binding binding = port.getBinding();
                    String bindingMethod = WsdlUtil.getBindingMethod(binding);
                    if (!bindingMethod.equals(method)) continue;
                    return port;
                }
            }
        }
        return null;
    }

    public static Binding getFirstBindingByMethod(Definition definition, String method) {
        Collection bindings = definition.getAllBindings().values();
        for (Binding binding : bindings) {
            String bindingMethod = WsdlUtil.getBindingMethod(binding);
            if (!StringUtils.isNotBlank((CharSequence)bindingMethod) || !bindingMethod.equals(method)) continue;
            return binding;
        }
        return null;
    }

    public static String getPortAddressLocation(Port port) {
        List extensibilityElements = port.getExtensibilityElements();
        SOAPAddress soapAddress = WsdlUtil.getExtensiblityElement(extensibilityElements, SOAPAddress.class);
        if (soapAddress != null) {
            return soapAddress.getLocationURI();
        }
        SOAP12Address soap12Address = WsdlUtil.getExtensiblityElement(extensibilityElements, SOAP12Address.class);
        if (soap12Address != null) {
            return soap12Address.getLocationURI();
        }
        HTTPAddress httpAddress = WsdlUtil.getExtensiblityElement(extensibilityElements, HTTPAddress.class);
        return httpAddress.getLocationURI();
    }

    public static WebServiceRequestEntity generateRequestEntity(Supplier<WebServiceRequestEntity> requestSupplier, String requestName, String wsdlLocation, String serviceEndpoint, String requestMethod, String operationName, String operationUri, String requestMessage) throws Exception {
        WebServiceRequestEntity entity = requestSupplier.get();
        entity.setElementGuidId(Util.generateGuid());
        entity.setName(requestName);
        entity.setSoapRequestMethod(requestMethod);
        entity.setWsdlAddress(wsdlLocation);
        entity.setSoapServiceFunction(operationName);
        entity.setKatalonVersion(System.getProperty("application.version"));
        entity.setUseServiceInfoFromWsdl(false);
        if (StringUtils.isNotBlank((CharSequence)serviceEndpoint)) {
            entity.setSoapServiceEndpoint(serviceEndpoint);
        }
        ArrayList<WebElementPropertyEntity> headers = new ArrayList<WebElementPropertyEntity>();
        if (SOAP.equals(requestMethod) && StringUtils.isNotBlank((CharSequence)operationUri)) {
            WebElementPropertyEntity soapActionHeader = new WebElementPropertyEntity();
            soapActionHeader.setName("SOAPAction");
            soapActionHeader.setValue(operationUri);
            headers.add(soapActionHeader);
        }
        WebElementPropertyEntity contentTypeHeader = new WebElementPropertyEntity();
        contentTypeHeader.setName("Content-Type");
        contentTypeHeader.setValue("text/xml; charset=utf-8");
        headers.add(contentTypeHeader);
        entity.setHttpHeaderProperties(headers);
        entity.setSoapBody(requestMessage != null ? requestMessage : "");
        return entity;
    }

    public static String getBindingMethod(Binding binding) {
        ExtensibilityElement bindingExElement = WsdlUtil.getBindingExtensiblityElement(binding);
        if (bindingExElement == null) {
            throw new IllegalArgumentException("Port has no binding extensibility element.");
        }
        if (bindingExElement instanceof SOAPBinding) {
            return SOAP;
        }
        if (bindingExElement instanceof SOAP12Binding) {
            return SOAP12;
        }
        if (bindingExElement instanceof HTTPBinding) {
            return ((HTTPBinding)bindingExElement).getVerb().toUpperCase();
        }
        throw new IllegalStateException("Unknown type of binding extensibility element");
    }

    private static ExtensibilityElement getBindingExtensiblityElement(Binding binding) {
        List extensibilityElements = binding.getExtensibilityElements();
        SOAPBinding objBinding = WsdlUtil.getExtensiblityElement(extensibilityElements, SOAPBinding.class);
        if (objBinding == null) {
            objBinding = WsdlUtil.getExtensiblityElement(extensibilityElements, SOAP12Binding.class);
        }
        if (objBinding == null) {
            objBinding = WsdlUtil.getExtensiblityElement(extensibilityElements, HTTPBinding.class);
        }
        return objBinding;
    }

    public static BindingOperation getBindingOperation(Binding binding, String operationName) {
        List operations = binding.getBindingOperations();
        if (operations != null && !operations.isEmpty()) {
            return operations.stream().filter(o -> o.getName().equals(operationName)).findFirst().orElse(null);
        }
        return null;
    }

    public static String getOperationUri(BindingOperation operation) {
        List extensibilityElements = operation.getExtensibilityElements();
        SOAPOperation soapOperation = WsdlUtil.getExtensiblityElement(extensibilityElements, SOAPOperation.class);
        if (soapOperation != null) {
            return soapOperation.getSoapActionURI();
        }
        SOAP12Operation soap12Operation = WsdlUtil.getExtensiblityElement(extensibilityElements, SOAP12Operation.class);
        if (soap12Operation != null) {
            return soap12Operation.getSoapActionURI();
        }
        HTTPOperation httpOperation = WsdlUtil.getExtensiblityElement(extensibilityElements, HTTPOperation.class);
        if (httpOperation != null) {
            return httpOperation.getLocationURI();
        }
        throw new IllegalStateException("Unknown type of binding operation");
    }

    public static <T extends ExtensibilityElement> T getExtensiblityElement(List<?> list, Class<T> clazz) {
        List<T> elements = WsdlUtil.getExtensiblityElements(list, clazz);
        return (T)(elements.isEmpty() ? null : (ExtensibilityElement)elements.get(0));
    }

    public static <T extends ExtensibilityElement> List<T> getExtensiblityElements(List list, Class<T> clazz) {
        ArrayList<ExtensibilityElement> result = new ArrayList<ExtensibilityElement>();
        for (ExtensibilityElement elm : list) {
            if (!clazz.isAssignableFrom(elm.getClass())) continue;
            result.add(elm);
        }
        return result;
    }

    public static String getSampleRequestMessage(String wsdlLocation, String bindingName, String operationName) {
        try {
            Thread.currentThread().setContextClassLoader(SoapLegacyFacade.class.getClassLoader());
            Wsdl wsdl = Wsdl.parse((String)wsdlLocation);
            SoapBuilder builder = wsdl.binding().name(bindingName).find();
            SoapOperationBuilder operation = builder.operation().name(operationName).find();
            String message = builder.buildInputMessage((SoapOperation)operation);
            return message;
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e);
            return "";
        }
    }
}

