/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.verification;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.ObjectRepository;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import java.io.File;
import java.lang.reflect.Type;

public class WSResponseManager {
    private static final String REQUEST_OBJECT_FILE_EXTENSION = ".rs";
    private RequestObject request;
    private ResponseObject response;
    private static WSResponseManager instance;

    private WSResponseManager() {
    }

    public static WSResponseManager getInstance() {
        if (instance == null) {
            instance = new WSResponseManager();
        }
        return instance;
    }

    public ResponseObject getCurrentResponse() throws Exception {
        if (this.response == null) {
            String responseObjectJson = (String)RunConfiguration.getProperty((String)"responseObject");
            Gson gson = new GsonBuilder().registerTypeAdapter(ResponseObject.class, (Object)new ResponseObjectInstanceCreator()).create();
            this.response = (ResponseObject)gson.fromJson(responseObjectJson, ResponseObject.class);
            String responseText = null;
            JsonObject jsonObject = (JsonObject)gson.fromJson(responseObjectJson, JsonObject.class);
            responseText = jsonObject.get("responseText").getAsString();
            if (responseText != null) {
                HttpTextBodyContent textBodyContent = new HttpTextBodyContent(responseText);
                this.response.setBodyContent((HttpBodyContent)textBodyContent);
            }
        }
        return this.response;
    }

    public void setCurrentResponse(ResponseObject response) {
        this.response = response;
    }

    public RequestObject getCurrentRequest() throws Exception {
        if (this.request == null) {
            String requestObjectId = (String)RunConfiguration.getProperty((String)"requestObjectId");
            File objectFile = new File(RunConfiguration.getProjectDir(), String.valueOf(requestObjectId) + REQUEST_OBJECT_FILE_EXTENSION);
            this.request = ObjectRepository.findRequestObject((String)requestObjectId, (File)objectFile);
        }
        return this.request;
    }

    public void setCurrentRequest(RequestObject request) {
        this.request = request;
    }

    private static class ResponseObjectInstanceCreator
    implements JsonDeserializer<ResponseObject> {
        private ResponseObjectInstanceCreator() {
        }

        public ResponseObject deserialize(JsonElement arg0, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
            ResponseObject response = new ResponseObject();
            JsonObject jsObject = arg0.getAsJsonObject();
            response.setContentType(jsObject.get("contentType").getAsString());
            response.setResponseText(jsObject.get("responseText").getAsString());
            response.setStatusCode(jsObject.get("statusCode").getAsInt());
            response.setContentCharset(jsObject.get("contentCharset").getAsString());
            return response;
        }
    }
}

