/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Collections;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyClassScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class GroovyCompilationUnitScope
extends CompilationUnitScope {
    private static final char[][] javaLang = TypeConstants.JAVA_LANG;
    private static final char[][] javaIo = CharOperation.splitOn((char)'.', (char[])"java.io".toCharArray());
    private static final char[][] javaNet = CharOperation.splitOn((char)'.', (char[])"java.net".toCharArray());
    private static final char[][] javaUtil = CharOperation.splitOn((char)'.', (char[])"java.util".toCharArray());
    private static final char[][] groovyLang = CharOperation.splitOn((char)'.', (char[])"groovy.lang".toCharArray());
    private static final char[][] groovyUtil = CharOperation.splitOn((char)'.', (char[])"groovy.util".toCharArray());
    private static final char[][] javaMathBigDecimal = CharOperation.splitOn((char)'.', (char[])"java.math.BigDecimal".toCharArray());
    private static final char[][] javaMathBigInteger = CharOperation.splitOn((char)'.', (char[])"java.math.BigInteger".toCharArray());
    static final char[][] GROOVY_LANG_METACLASS = CharOperation.splitOn((char)'.', (char[])"groovy.lang.MetaClass".toCharArray());
    static final char[][] GROOVY_LANG_GROOVYOBJECT = CharOperation.splitOn((char)'.', (char[])"groovy.lang.GroovyObject".toCharArray());
    static final char[][] GROOVY_TRANSFORM_INTERNAL = CharOperation.splitOn((char)'.', (char[])"groovy.transform.Internal".toCharArray());
    static final char[][] GROOVY_TRANSFORM_GENERATED = CharOperation.splitOn((char)'.', (char[])"groovy.transform.Generated".toCharArray());
    private boolean isScript;
    private ImportBinding[] defaultGroovyImports;
    private volatile boolean verified;

    public GroovyCompilationUnitScope(GroovyCompilationUnitDeclaration compilationUnitDeclaration, LookupEnvironment lookupEnvironment) {
        super((CompilationUnitDeclaration)compilationUnitDeclaration, lookupEnvironment);
    }

    public boolean isScript() {
        return this.isScript;
    }

    public void setIsScript(boolean isScript) {
        this.isScript = isScript;
    }

    protected ImportBinding[] getDefaultImports() {
        if (this.defaultGroovyImports == null) {
            ArrayList<ImportBinding> importBindings = new ArrayList<ImportBinding>(8);
            Collections.addAll(importBindings, super.getDefaultImports());
            importBindings.add(new ImportBinding(javaIo, true, (Binding)this.environment.getPackage(javaIo, this.module()), null));
            importBindings.add(new ImportBinding(javaNet, true, (Binding)this.environment.getPackage(javaNet, this.module()), null));
            importBindings.add(1, new ImportBinding(javaUtil, true, (Binding)this.environment.getPackage(javaUtil, this.module()), null));
            importBindings.add(new ImportBinding(groovyLang, true, (Binding)this.environment.getPackage(groovyLang, this.module()), null));
            importBindings.add(new ImportBinding(groovyUtil, true, (Binding)this.environment.getPackage(groovyUtil, this.module()), null));
            importBindings.add(new ImportBinding(javaMathBigDecimal, false, (Binding)this.environment.getType(javaMathBigDecimal), null));
            importBindings.add(new ImportBinding(javaMathBigInteger, false, (Binding)this.environment.getType(javaMathBigInteger), null));
            SourceTypeBinding[] sourceTypeBindingArray = this.topLevelTypes;
            int n = this.topLevelTypes.length;
            int n2 = 0;
            while (n2 < n) {
                SourceTypeBinding topLevelType = sourceTypeBindingArray[n2];
                if (topLevelType.hasMemberTypes()) {
                    importBindings.add(new ImportBinding(topLevelType.compoundName, true, (Binding)topLevelType, null));
                }
                ++n2;
            }
            this.defaultGroovyImports = importBindings.toArray(new ImportBinding[importBindings.size()]);
        }
        return this.defaultGroovyImports;
    }

    protected ClassScope buildClassScope(Scope parent, TypeDeclaration typeDecl) {
        return new GroovyClassScope(parent, typeDecl);
    }

    protected void buildTypeBindings(AccessRestriction accessRestriction) {
        super.buildTypeBindings(accessRestriction);
    }

    public void augmentTypeHierarchy() {
        ReferenceBinding groovyObjectType = null;
        SourceTypeBinding[] sourceTypeBindingArray = this.topLevelTypes;
        int n = this.topLevelTypes.length;
        int n2 = 0;
        while (n2 < n) {
            SourceTypeBinding topLevelType = sourceTypeBindingArray[n2];
            if (!topLevelType.isInterface() && topLevelType.superInterfaces != null) {
                if (groovyObjectType == null) {
                    groovyObjectType = this.environment.getResolvedType(GROOVY_LANG_GROOVYOBJECT, (Scope)this);
                }
                if (!topLevelType.implementsInterface(groovyObjectType, true)) {
                    int n3 = topLevelType.superInterfaces.length;
                    if (n3 == 0) {
                        topLevelType.superInterfaces = new ReferenceBinding[1];
                    } else {
                        ReferenceBinding[] types = topLevelType.superInterfaces;
                        topLevelType.superInterfaces = new ReferenceBinding[n3 + 1];
                        System.arraycopy(types, 0, topLevelType.superInterfaces, 0, n3);
                    }
                    topLevelType.superInterfaces[n3] = groovyObjectType;
                    this.recordQualifiedReference(GROOVY_LANG_GROOVYOBJECT);
                }
            }
            ++n2;
        }
    }

    protected void checkPublicTypeNameMatchesFilename(TypeDeclaration typeDecl) {
    }

    protected boolean reportPackageIsNotExpectedPackage(CompilationUnitDeclaration compUnitDecl) {
        char[][] declaredPackage;
        char[][] cArray = declaredPackage = compUnitDecl.currentPackage != null ? compUnitDecl.currentPackage.tokens : CharOperation.NO_CHAR_CHAR;
        if (!(CharOperation.equals((char[][])declaredPackage, (char[][])new char[][]{{'?'}}) || declaredPackage.length == 0 && this.isScript)) {
            this.problemReporter().packageIsNotExpectedPackage(compUnitDecl);
            return true;
        }
        return false;
    }

    protected void checkParameterizedTypes() {
    }

    public boolean reportInvalidType(TypeReference typeReference, TypeBinding resolvedType) {
        return resolvedType.problemId() > 1;
    }

    protected void reportImportProblem(ImportReference importReference, Binding importBinding) {
        if (importBinding instanceof ProblemReferenceBinding && ((ProblemReferenceBinding)importBinding).problemId() == 1) {
            return;
        }
        super.reportImportProblem(importReference, importBinding);
    }

    public boolean canSeeEverything() {
        return true;
    }

    public boolean checkTargetCompatibility() {
        return false;
    }

    protected boolean canBeSeenBy(ReferenceBinding type, PackageBinding fPackage) {
        return true;
    }

    public boolean scannerAvailable() {
        return false;
    }

    public ReferenceBinding selectBinding(ReferenceBinding newlyFound, ReferenceBinding originallyFound, boolean isDeclaredImport) {
        if (isDeclaredImport && originallyFound.fPackage != null) {
            char[][] packageName = originallyFound.fPackage.compoundName;
            if (CharOperation.equals((char[][])javaLang, (char[][])packageName) || CharOperation.equals((char[][])javaUtil, (char[][])packageName) || CharOperation.equals((char[][])javaIo, (char[][])packageName) || CharOperation.equals((char[][])javaNet, (char[][])packageName) || CharOperation.equals((char[][])groovyLang, (char[][])packageName) || CharOperation.equals((char[][])groovyUtil, (char[][])packageName)) {
                return newlyFound;
            }
            return originallyFound;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyMethods(MethodVerifier verifier) {
        if (!this.verified) {
            GroovyCompilationUnitScope groovyCompilationUnitScope = this;
            synchronized (groovyCompilationUnitScope) {
                if (!this.verified) {
                    this.verified = true;
                    super.verifyMethods(verifier);
                }
            }
        }
    }
}

