/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.jdt.groovy.integration.internal.MultiplexingSourceElementRequestorParser;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.model.CodeSelectHelperFactory;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnitStructureRequestor;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.codehaus.jdt.groovy.model.GroovyReconcileWorkingCopyOperation;
import org.codehaus.jdt.groovy.model.ICodeCompletionDelegate;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.ASTHolderCUInfo;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.CompilationUnitProblemFinder;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.ReconcileWorkingCopyOperation;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyCompilationUnit
extends CompilationUnit {
    private String mainTypeName;
    private static final ThreadLocalAtomicInteger depth = new ThreadLocalAtomicInteger();

    public GroovyCompilationUnit(PackageFragment parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner);
    }

    public char[] getMainTypeName() {
        if (this.mainTypeName == null) {
            String unitName = Util.getNameWithoutJavaLikeExtension((String)this.name);
            this.mainTypeName = GeneratorContext.encodeAsValidClassName((String)unitName);
        }
        return this.mainTypeName.toCharArray();
    }

    public ModuleNode getModuleNode() {
        ModuleNodeMapper.ModuleNodeInfo moduleInfo = this.getModuleInfo(true);
        return moduleInfo != null ? moduleInfo.module : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleNodeMapper.ModuleNodeInfo getModuleInfo(boolean force) {
        try {
            if (!this.isConsistent()) {
                this.makeConsistent(null);
            }
            boolean becameWorkingCopy = false;
            ModuleNodeMapper.getInstance().lock();
            try {
                JavaModelManager.PerWorkingCopyInfo info;
                boolean bl = becameWorkingCopy = force && !this.isWorkingCopy();
                if (becameWorkingCopy) {
                    this.becomeWorkingCopy(null);
                }
                if ((info = this.getPerWorkingCopyInfo()) == null) return null;
                ModuleNodeMapper.ModuleNodeInfo moduleNodeInfo = ModuleNodeMapper.getInstance().get(info);
                return moduleNodeInfo;
            }
            finally {
                try {
                    if (becameWorkingCopy) {
                        this.discardWorkingCopy();
                    }
                }
                finally {
                    ModuleNodeMapper.getInstance().unlock();
                }
            }
        }
        catch (JavaModelException e) {
            Util.log((Throwable)e, (String)("Exception thrown when trying to get Groovy module node for " + this.name));
        }
        return null;
    }

    public ModuleNodeMapper.ModuleNodeInfo getNewModuleInfo() {
        try {
            this.openWhenClosed(this.createElementInfo(), false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            Util.log((Throwable)e, (String)("Exception thrown when trying to get Groovy module node for " + this.name));
        }
        return this.getModuleInfo(true);
    }

    public void discardWorkingCopy() throws JavaModelException {
        ModuleNodeMapper.getInstance().lock();
        try {
            JavaModelManager.PerWorkingCopyInfo info = this.getPerWorkingCopyInfo();
            if (this.workingCopyInfoWillBeDiscarded(info)) {
                ModuleNodeMapper.getInstance().remove(info);
            }
            super.discardWorkingCopy();
        }
        finally {
            ModuleNodeMapper.getInstance().unlock();
        }
    }

    private boolean workingCopyInfoWillBeDiscarded(JavaModelManager.PerWorkingCopyInfo info) {
        return info != null && (Integer)ReflectionUtils.getPrivateField(JavaModelManager.PerWorkingCopyInfo.class, "useCount", info) <= 1;
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        depth.increment();
        try {
            block38: {
                GroovyCompilationUnitDeclaration compilationUnitDeclaration;
                block37: {
                    HashMap problems;
                    int reconcileFlags;
                    boolean resolveBindings;
                    boolean createAST;
                    IBuffer buffer;
                    if (GroovyLogManager.manager.hasLoggers()) {
                        GroovyLogManager.manager.log(TraceCategory.COMPILER, "Build Structure starting for " + this.name);
                        GroovyLogManager.manager.logStart("Build structure: " + this.name + " : " + Thread.currentThread().getName());
                    }
                    if ((buffer = this.getBufferManager().getBuffer((IOpenable)this)) == null) {
                        this.openBuffer(pm, info);
                    }
                    GroovyCompilationUnitStructureRequestor requestor = new GroovyCompilationUnitStructureRequestor((org.eclipse.jdt.core.ICompilationUnit)this, (CompilationUnitElementInfo)info, newElements);
                    JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = this.getPerWorkingCopyInfo();
                    JavaProject project = this.getJavaProject();
                    if (info instanceof ASTHolderCUInfo) {
                        ASTHolderCUInfo astHolder = (ASTHolderCUInfo)info;
                        createAST = astHolder.astLevel != 0;
                        resolveBindings = astHolder.resolveBindings;
                        reconcileFlags = astHolder.reconcileFlags;
                        problems = astHolder.problems;
                    } else {
                        createAST = false;
                        resolveBindings = false;
                        reconcileFlags = 0;
                        problems = null;
                    }
                    boolean hasJavaNature = project != null && JavaProject.hasJavaNature((IProject)project.getProject());
                    boolean computeProblems = hasJavaNature && perWorkingCopyInfo != null && perWorkingCopyInfo.isActive();
                    Hashtable options = hasJavaNature ? project.getOptions(true) : JavaCore.getOptions();
                    options.put("org.eclipse.jdt.core.compiler.groovy.groovyProjectName", project.getElementName());
                    options.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "enabled");
                    if (!computeProblems) {
                        options.remove("org.eclipse.jdt.core.compiler.taskTags");
                    }
                    options.putAll(this.getCustomOptions());
                    CompilerOptions compilerOptions = new CompilerOptions((Map)options);
                    compilerOptions.ignoreMethodBodies = (reconcileFlags & 8) != 0;
                    ProblemReporter reporter = new ProblemReporter((IErrorHandlingPolicy)new GroovyErrorHandlingPolicy(!computeProblems), compilerOptions, (IProblemFactory)new DefaultProblemFactory());
                    MultiplexingSourceElementRequestorParser parser = new MultiplexingSourceElementRequestorParser(reporter, (ISourceElementRequestor)requestor, reporter.problemFactory, compilerOptions, true, !createAST);
                    parser.reportOnlyOneSyntaxError = !computeProblems;
                    parser.setMethodsFullRecovery(true);
                    parser.setStatementsRecovery((reconcileFlags & 2) != 0);
                    if (!(computeProblems || resolveBindings || createAST)) {
                        parser.javadocParser.checkDocComment = false;
                    }
                    requestor.setParser(parser);
                    if (underlyingResource == null) {
                        underlyingResource = this.getResource();
                    }
                    if (underlyingResource != null) {
                        ReflectionUtils.setPrivateField(CompilationUnitElementInfo.class, "timestamp", info, underlyingResource.getModificationStamp());
                    }
                    compilationUnitDeclaration = null;
                    GroovyCompilationUnit source = this.cloneCachingContents();
                    try {
                        if (computeProblems || depth.intValue() < 2) {
                            if (problems == null) {
                                problems = new HashMap();
                                compilationUnitDeclaration = (GroovyCompilationUnitDeclaration)CompilationUnitProblemFinder.process((CompilationUnit)source, (SourceElementParser)parser, (WorkingCopyOwner)this.owner, problems, (boolean)createAST, (int)reconcileFlags, (IProgressMonitor)pm);
                                if (computeProblems) {
                                    try {
                                        perWorkingCopyInfo.beginReporting();
                                        for (CategorizedProblem[] categorizedProblems : problems.values()) {
                                            if (categorizedProblems == null) continue;
                                            int i = 0;
                                            int n = categorizedProblems.length;
                                            while (i < n) {
                                                perWorkingCopyInfo.acceptProblem((IProblem)categorizedProblems[i]);
                                                ++i;
                                            }
                                        }
                                    }
                                    finally {
                                        perWorkingCopyInfo.endReporting();
                                    }
                                }
                            } else {
                                compilationUnitDeclaration = (GroovyCompilationUnitDeclaration)CompilationUnitProblemFinder.process((CompilationUnit)source, (SourceElementParser)parser, (WorkingCopyOwner)this.owner, problems, (boolean)createAST, (int)reconcileFlags, (IProgressMonitor)pm);
                            }
                        } else {
                            compilationUnitDeclaration = (GroovyCompilationUnitDeclaration)parser.parseCompilationUnit((ICompilationUnit)source, true, pm);
                        }
                        this.maybeCacheModuleNode(perWorkingCopyInfo, compilationUnitDeclaration);
                        if (!createAST) break block37;
                        try {
                            ASTHolderCUInfo astHolder = (ASTHolderCUInfo)info;
                            astHolder.ast = AST.convertCompilationUnit((int)astHolder.astLevel, (CompilationUnitDeclaration)compilationUnitDeclaration, (Map)options, (boolean)computeProblems, (CompilationUnit)source, (int)reconcileFlags, (IProgressMonitor)pm);
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (IllegalArgumentException e) {
                            Util.log((Throwable)e, (String)("Problem with build structure: Offset for AST node is incorrect in " + this.getParent().getElementName() + "." + this.name));
                        }
                        catch (Exception e) {
                            Util.log((Throwable)e, (String)("Problem with build structure for " + this.name));
                        }
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (JavaModelException e) {
                        if (e.getStatus().getCode() != 969 || this.getJavaProject().exists()) {
                            Util.log((Throwable)e, (String)("Problem with build structure for " + this.name));
                        }
                        if (compilationUnitDeclaration != null) {
                            ((CompilationUnitElementInfo)info).hasFunctionalTypes = compilationUnitDeclaration.hasFunctionalTypes();
                            compilationUnitDeclaration.cleanUp();
                        }
                        break block38;
                    }
                    catch (Exception e) {
                        try {
                            Util.log((Throwable)e, (String)("Problem with build structure for " + this.name));
                            break block38;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (compilationUnitDeclaration != null) {
                                ((CompilationUnitElementInfo)info).hasFunctionalTypes = compilationUnitDeclaration.hasFunctionalTypes();
                                compilationUnitDeclaration.cleanUp();
                            }
                        }
                    }
                }
                if (compilationUnitDeclaration == null) break block38;
                ((CompilationUnitElementInfo)info).hasFunctionalTypes = compilationUnitDeclaration.hasFunctionalTypes();
                compilationUnitDeclaration.cleanUp();
            }
            boolean bl = info.isStructureKnown();
            return bl;
        }
        finally {
            depth.decrement();
            if (GroovyLogManager.manager.hasLoggers()) {
                GroovyLogManager.manager.logEnd("Build structure: " + this.name + " : " + Thread.currentThread().getName(), TraceCategory.COMPILER);
            }
        }
    }

    protected void maybeCacheModuleNode(JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo, GroovyCompilationUnitDeclaration compilationUnitDeclaration) {
        ModuleNodeMapper.getInstance().maybeCacheModuleNode(perWorkingCopyInfo, compilationUnitDeclaration);
    }

    public org.eclipse.jdt.core.dom.CompilationUnit reconcile(int astLevel, int reconcileFlags, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) throws JavaModelException {
        if (!this.isWorkingCopy() || monitor != null && monitor.isCanceled()) {
            return null;
        }
        PerformanceStats stats = null;
        if (ReconcileWorkingCopyOperation.PERF) {
            stats = PerformanceStats.getStats((String)"org.eclipse.jdt.core/perf/reconcile", (Object)((Object)this));
            stats.startRun(String.valueOf(this.getFileName()));
        }
        GroovyReconcileWorkingCopyOperation op = new GroovyReconcileWorkingCopyOperation((IJavaElement)this, astLevel, reconcileFlags, (WorkingCopyOwner)(workingCopyOwner != null ? workingCopyOwner : DefaultWorkingCopyOwner.PRIMARY));
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles((Object)this);
            if (monitor == null || !monitor.isCanceled()) {
                op.runOperation(monitor);
            }
        }
        finally {
            manager.flushZipFiles((Object)this);
        }
        if (ReconcileWorkingCopyOperation.PERF) {
            stats.endRun();
        }
        return op.ast;
    }

    public IType findPrimaryType() {
        block5: {
            IType type;
            if (this.mainTypeName == null) {
                this.getMainTypeName();
            }
            if ((type = this.getType(this.mainTypeName)).exists()) {
                return type;
            }
            try {
                IType[] types;
                if (this.getResource().exists() && (types = this.getTypes()) != null && types.length > 0) {
                    return types[0];
                }
            }
            catch (JavaModelException e) {
                if (e.getStatus().getCode() == 1006) break block5;
                Util.log((Throwable)e, (String)("Error finding all types of " + this.name));
            }
        }
        return null;
    }

    public boolean isOnBuildPath() {
        JavaProject project = this.getJavaProject();
        if (!project.isOnClasspath((IJavaElement)this)) {
            return false;
        }
        IProject resourceProject = project.getProject();
        return resourceProject != null && resourceProject.isAccessible() && GroovyNature.hasGroovyNature(resourceProject);
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (this.isOnBuildPath()) {
            return super.getUnderlyingResource();
        }
        IResource rsrc = this.getResource();
        try {
            Assert.isTrue((boolean)rsrc.getFullPath().toString().endsWith(this.name));
        }
        catch (Throwable e) {
            Util.log((Throwable)e);
            return super.getUnderlyingResource();
        }
        return rsrc;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (GroovyCompilationUnit.class.equals(adapter)) {
            return (T)((Object)this);
        }
        if (ModuleNode.class.equals(adapter)) {
            return (T)this.getModuleNode();
        }
        return (T)super.getAdapter(adapter);
    }

    protected void codeComplete(ICompilationUnit unit, ICompilationUnit skip, int position, CompletionRequestor requestor, WorkingCopyOwner owner, ITypeRoot typeRoot, IProgressMonitor monitor) throws JavaModelException {
        ICodeCompletionDelegate delegate = (ICodeCompletionDelegate)Adapters.adapt((Object)((Object)this), ICodeCompletionDelegate.class);
        if (delegate != null && delegate.shouldCodeComplete(requestor, typeRoot)) {
            delegate.codeComplete(unit, skip, position, requestor, owner, typeRoot, monitor);
        } else {
            super.codeComplete(unit, skip, position, requestor, owner, typeRoot, monitor);
        }
    }

    protected IJavaElement[] codeSelect(ICompilationUnit unit, int offset, int length, WorkingCopyOwner owner) throws JavaModelException {
        if (CodeSelectHelperFactory.selectHelper != null) {
            return CodeSelectHelperFactory.selectHelper.select(this, offset, length);
        }
        return new IJavaElement[0];
    }

    public IJavaElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws JavaModelException {
        return this.codeSelect((ICompilationUnit)this, offset, length, owner);
    }

    public IJavaElement[] codeSelect(int offset, int length) throws JavaModelException {
        return this.codeSelect(offset, length, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public GroovyCompilationUnit cloneCachingContents() {
        return new CompilationUnitClone();
    }

    public GroovyCompilationUnit cloneCachingContents(char[] source) {
        return new CompilationUnitClone(source);
    }

    private class CompilationUnitClone
    extends GroovyCompilationUnit {
        private char[] cachedContents;

        CompilationUnitClone(char[] cachedContents) {
            this();
            this.cachedContents = cachedContents;
        }

        CompilationUnitClone() {
            super((PackageFragment)GroovyCompilationUnit.this.getParent(), GroovyCompilationUnit.this.name, GroovyCompilationUnit.this.owner);
        }

        public char[] getContents() {
            if (this.cachedContents == null) {
                this.cachedContents = GroovyCompilationUnit.this.getContents();
            }
            return this.cachedContents;
        }

        public CompilationUnit originalFromClone() {
            return GroovyCompilationUnit.this;
        }

        public char[] getFileName() {
            return GroovyCompilationUnit.this.getFileName();
        }
    }

    private static class GroovyErrorHandlingPolicy
    implements IErrorHandlingPolicy {
        private final boolean stopOnFirst;

        GroovyErrorHandlingPolicy(boolean stopOnFirst) {
            this.stopOnFirst = stopOnFirst;
        }

        public boolean stopOnFirstError() {
            return this.stopOnFirst;
        }

        public boolean proceedOnErrors() {
            return !this.stopOnFirst;
        }

        public boolean ignoreAllErrors() {
            return false;
        }
    }

    private static class ThreadLocalAtomicInteger
    extends ThreadLocal<AtomicInteger> {
        private ThreadLocalAtomicInteger() {
        }

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger();
        }

        int intValue() {
            return ((AtomicInteger)this.get()).get();
        }

        void increment() {
            ((AtomicInteger)this.get()).incrementAndGet();
        }

        void decrement() {
            ((AtomicInteger)this.get()).decrementAndGet();
        }
    }
}

