/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice;

import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.exception.InvalidNameException;
import com.kms.katalon.dal.fileservice.EntityCache;
import com.kms.katalon.dal.fileservice.adapter.CheckpointDataXmlAdapter;
import com.kms.katalon.dal.fileservice.adapter.TestSuiteReferenceXmlAdapter;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import com.kms.katalon.entity.checkpoint.CsvCheckpointSourceInfo;
import com.kms.katalon.entity.checkpoint.DatabaseCheckpointSourceInfo;
import com.kms.katalon.entity.checkpoint.ExcelCheckpointSourceInfo;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.SourceContent;
import com.kms.katalon.entity.project.SourceFolderConfiguration;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementSelectorMethod;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.InternalDataColumnEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.entity.variable.VariableEntityWrapper;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

public final class EntityService {
    private static EntityService singleton;
    private EntityCache cache = new EntityCache();
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private JAXBContext jaxbContext;
    private static final String BIDING_FILES_LOCATION = "res/mapping";

    public static EntityService getInstance() throws Exception {
        if (singleton == null) {
            singleton = new EntityService();
        }
        return singleton;
    }

    private EntityService() throws Exception {
        this.initializeJAXB();
    }

    private void initializeJAXB() throws Exception {
        HashMap properties = new HashMap();
        ArrayList<Object> bindingSources = new ArrayList<Object>();
        String path = this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
        path = URLDecoder.decode(path, "utf-8");
        try (ZipFile jar = null;){
            File jarFile = new File(path);
            if (jarFile.isFile()) {
                jar = new JarFile(jarFile);
                Enumeration<JarEntry> entries = ((JarFile)jar).entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    String name = jarEntry.getName();
                    if (!name.startsWith(BIDING_FILES_LOCATION) || !name.endsWith(".xml")) continue;
                    bindingSources.add(((JarFile)jar).getInputStream(jarEntry));
                }
            } else {
                File mapping = new File(path, BIDING_FILES_LOCATION);
                File[] fileArray = mapping.listFiles(EntityFileServiceManager.fileFilter);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File xmlFile = fileArray[n2];
                    bindingSources.add(xmlFile);
                    ++n2;
                }
            }
            System.setProperty("javax.xml.bind.context.factory", JAXBContextFactory.class.getName());
            properties.put("eclipselink.oxm.metadata-source", bindingSources);
            this.jaxbContext = JAXBContextFactory.createContext((Class[])this.getEntityClasses(), properties);
            this.marshaller = this.jaxbContext.createMarshaller();
            this.unmarshaller = this.jaxbContext.createUnmarshaller();
        }
    }

    private Class[] getEntityClasses() {
        return new Class[]{Entity.class, FolderEntity.class, ProjectEntity.class, WebElementEntity.class, WebElementPropertyEntity.class, WebElementSelectorMethod.class, WindowsElementEntity.class, MobileElementEntity.class, TestCaseEntity.class, DataFileEntity.class, InternalDataColumnEntity.class, TestSuiteEntity.class, FilteringTestSuiteEntity.class, VariableEntity.class, TestSuiteTestCaseLink.class, VariableLink.class, WebServiceRequestEntity.class, ExecutionProfileEntity.class, GlobalVariableEntity.class, IntegratedEntity.class, IntegratedFileEntity.class, ReportEntity.class, TestSuiteCollectionEntity.class, TestSuiteReferenceXmlAdapter.class, ReportCollectionEntity.class, CheckpointEntity.class, ExcelCheckpointSourceInfo.class, CsvCheckpointSourceInfo.class, DatabaseCheckpointSourceInfo.class, CheckpointSourceInfo.class, CheckpointDataXmlAdapter.class, SourceContent.class, VariableEntityWrapper.class, SourceFolderConfiguration.class};
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public EntityCache getEntityCache() {
        return this.cache;
    }

    public FileEntity getEntityByPath(String path) throws Exception {
        if (path.isEmpty()) {
            return null;
        }
        FileEntity entity = this.findEntityInCache(path);
        if ((entity == null || this.isFileModified(path, entity)) && (entity = this.loadEntityFromFile(path)) != null) {
            this.getEntityCache().put(path, entity);
        }
        return entity;
    }

    public FileEntity getEntityByPathWithoutCache(String path) throws Exception {
        if (path.isEmpty()) {
            return null;
        }
        return this.loadEntityFromFile(path);
    }

    public FileEntity findEntityInCache(String path) {
        return this.cache.get(path.trim());
    }

    public synchronized FileEntity loadEntityFromFile(String path) throws Exception {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        FileEntity entity = (FileEntity)this.unmarshaller.unmarshal(file);
        this.setEntityTimeAttributes(path, entity);
        return entity;
    }

    private void setEntityTimeAttributes(String path, FileEntity entity) throws IOException {
        FileTime modifyTime;
        Path filePath = Paths.get(path, new String[0]);
        BasicFileAttributeView basicView = Files.getFileAttributeView(filePath, BasicFileAttributeView.class, new LinkOption[0]);
        BasicFileAttributes basicAttr = basicView.readAttributes();
        FileTime creationTime = basicAttr.creationTime();
        if (creationTime != null) {
            entity.setDateCreated(new Date(creationTime.toMillis()));
        }
        if ((modifyTime = basicAttr.lastModifiedTime()) != null) {
            entity.setDateModified(new Date(modifyTime.toMillis()));
        }
    }

    public boolean saveEntity(FileEntity entity) throws Exception {
        this.saveEntityWithoutCache(entity);
        this.getEntityCache().put(entity.getLocation(), entity);
        this.setEntityTimeAttributes(entity.getLocation(), entity);
        return true;
    }

    public boolean saveEntity(FileEntity entity, String location) throws Exception {
        if (entity instanceof ProjectEntity) {
            this.saveProjectFolder((ProjectEntity)entity);
        }
        if (location.length() > 255) {
            throw new FilePathTooLongException(location.length(), 255);
        }
        if (entity instanceof FolderEntity) {
            File folder = new File(location);
            if (!folder.exists()) {
                folder.mkdir();
            }
        } else {
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.marshaller.marshal((Object)entity, new File(location));
        }
        return true;
    }

    public boolean saveIntergratedFolderMetadataEntity(IntegratedFileEntity entity) throws Exception {
        String metaDataFileLocation = String.valueOf(entity.getLocation()) + File.separator + FolderEntity.getMetaDataFileExtension();
        if (metaDataFileLocation.length() > 255) {
            throw new FilePathTooLongException(metaDataFileLocation.length(), 255);
        }
        File folder = new File(entity.getLocation());
        if (!folder.exists()) {
            folder.mkdir();
        }
        File folderMetaFile = new File(metaDataFileLocation);
        this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        this.marshaller.marshal((Object)entity, folderMetaFile);
        this.cache.put(entity.getLocation(), (FileEntity)entity);
        return true;
    }

    public boolean saveFolderMetadataEntity(FileEntity entity) throws Exception {
        String metaDataFileLocation = String.valueOf(entity.getLocation()) + File.separator + FolderEntity.getMetaDataFileExtension();
        if (metaDataFileLocation.length() > 255) {
            throw new FilePathTooLongException(metaDataFileLocation.length(), 255);
        }
        File folder = new File(entity.getLocation());
        if (!folder.exists()) {
            folder.mkdir();
        }
        File folderMetaFile = new File(metaDataFileLocation);
        this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        this.marshaller.marshal((Object)entity, folderMetaFile);
        this.cache.put(entity.getLocation(), entity);
        return true;
    }

    public boolean saveEntityWithoutCache(FileEntity entity) throws Exception {
        return this.saveEntity(entity, entity.getLocation());
    }

    private boolean saveProjectFolder(ProjectEntity projectEntity) throws Exception {
        if (projectEntity.getFolderLocation().length() > 255) {
            throw new FilePathTooLongException(projectEntity.getFolderLocation().length(), 255);
        }
        File folder = new File(projectEntity.getFolderLocation());
        if (!folder.exists()) {
            return folder.mkdirs();
        }
        return false;
    }

    public boolean deleteEntity(FileEntity entity) throws Exception {
        String path = entity.getLocation();
        return this.deleteEntity(path);
    }

    public boolean deleteEntity(String path) {
        File file = new File(path);
        if (FileUtils.deleteQuietly((File)file)) {
            this.getEntityCache().remove(path);
        }
        return true;
    }

    public String getAvailableName(String folderPk, String name, boolean isFile) {
        String newName = name;
        File parentFolder = new File(folderPk);
        ArrayList<String> fileNames = new ArrayList<String>();
        if (parentFolder.exists() && parentFolder.isDirectory()) {
            File[] fileArray = parentFolder.listFiles(EntityFileServiceManager.fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    fileNames.add(FilenameUtils.removeExtension((String)file.getName()).toLowerCase());
                }
                if (!isFile && file.isDirectory()) {
                    fileNames.add(file.getName().toLowerCase());
                }
                ++n2;
            }
        }
        if (fileNames.contains(newName.toLowerCase())) {
            int i = 1;
            while (fileNames.contains(newName.toLowerCase())) {
                newName = String.valueOf(name) + " (" + i + ")";
                ++i;
            }
        }
        return newName;
    }

    public void validateName(String name) throws InvalidNameException {
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidNameException(StringConstants.FS_INVALID_FILE_NAME_BY_BLANK);
        }
        Pattern pattern = Pattern.compile("^[\\w]+[\\w,\\s-().]*$", 256);
        Matcher matcher = pattern.matcher(name);
        if (!matcher.matches()) {
            throw new InvalidNameException(StringConstants.FS_INVALID_FILE_NAME_BY_SPECIAL_CHAR);
        }
        if (name.contains("..") || StringUtils.endsWith((String)name.trim(), (String)".")) {
            throw new InvalidNameException(StringConstants.FS_INVALID_FILE_NAME_BY_DOTS);
        }
    }

    private boolean isFileModified(String path, FileEntity entity) throws IOException {
        Path filePath = Paths.get(path, new String[0]);
        BasicFileAttributeView basicView = Files.getFileAttributeView(filePath, BasicFileAttributeView.class, new LinkOption[0]);
        BasicFileAttributes basicAttr = basicView.readAttributes();
        FileTime modifyTime = basicAttr.lastModifiedTime();
        Date dateModifyTime = new Date(modifyTime.toMillis());
        return modifyTime != null && entity.getDateModified() != null && dateModifyTime.compareTo(entity.getDateModified()) != 0;
    }

    public Unmarshaller newUnmarshaller() throws DALException {
        try {
            return this.jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new DALException((Exception)((Object)e));
        }
    }

    public Unmarshaller changeUnmarshaller(Unmarshaller unmashaller) {
        this.unmarshaller = unmashaller;
        return this.unmarshaller;
    }

    public String toXmlString(Object entity) {
        try {
            StringWriter sw = new StringWriter();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.marshaller.marshal(entity, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return "";
        }
    }

    public <T> T toEntity(String xmlString, Class<T> clazz) throws JAXBException {
        T obj = clazz.cast(JAXBIntrospector.getValue((Object)this.unmarshaller.unmarshal((Reader)new StringReader(xmlString))));
        return obj;
    }
}

