/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.dataprovider;

import com.kms.katalon.dal.IImportDataProvider;
import com.kms.katalon.dal.fileservice.manager.ImportFileServiceManager;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectImportingEntity;
import com.kms.katalon.entity.util.ImportDuplicateEntityResult;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;

public class ImportFileServiceDataProvider
implements IImportDataProvider {
    private static Map<String, ImportFileServiceManager> importMapping;

    public ImportFileServiceDataProvider() {
        if (importMapping == null) {
            importMapping = new HashMap<String, ImportFileServiceManager>();
        }
    }

    public ProjectEntity importProject(ProjectImportingEntity projectImportingInfomation, PropertyChangeListener propertyChangeListener) throws Exception {
        ImportFileServiceManager importManager = new ImportFileServiceManager(projectImportingInfomation.getIsCreateNewProject(), projectImportingInfomation.getProjectName(), projectImportingInfomation.getCurrentProject());
        importManager.addPropertyChangeListener(propertyChangeListener);
        importMapping.put(projectImportingInfomation.getImportGUID(), importManager);
        return importManager.executeImport(projectImportingInfomation.getImportDirectory());
    }

    public Integer getImportProgress(String importGUID) throws Exception {
        ImportFileServiceManager importManager = importMapping.get(importGUID);
        if (importManager != null) {
            return importManager.getProgress();
        }
        return 0;
    }

    public void cancelImport(String importGUID) throws Exception {
        ImportFileServiceManager importManager = importMapping.get(importGUID);
        if (importManager != null) {
            importManager.setCancelImportTask(true);
        }
    }

    public void setImportDuplicateEntityResult(ImportDuplicateEntityResult importDuplicateEntityResult, String importGUID) throws Exception {
        ImportFileServiceManager importManager = importMapping.get(importGUID);
        if (importManager != null) {
            importManager.setImportDuplicateEntityResult(importDuplicateEntityResult);
        }
    }

    public void setWaitingConfirmation(Boolean isConfirmed, String importGUID) {
        ImportFileServiceManager importManager = importMapping.get(importGUID);
        if (importManager != null) {
            importManager.setWaitingConfirmation(isConfirmed);
        }
    }
}

