/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.sc;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.apache.groovy.util.BeanUtils;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.CallSiteWriter;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.MethodCallerMultiAdapter;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.TypeChooser;
import org.codehaus.groovy.classgen.asm.VariableSlotLoader;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.classgen.asm.sc.StaticInvocationWriter;
import org.codehaus.groovy.classgen.asm.sc.StaticTypesWriterController;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class StaticTypesCallSiteWriter
extends CallSiteWriter
implements Opcodes {
    private static final ClassNode COLLECTION_TYPE = ClassHelper.make(Collection.class);
    private static final ClassNode INVOKERHELPER_TYPE = ClassHelper.make(InvokerHelper.class);
    private static final MethodNode COLLECTION_SIZE_METHOD = COLLECTION_TYPE.getMethod("size", Parameter.EMPTY_ARRAY);
    private static final MethodNode CLOSURE_GETTHISOBJECT_METHOD = ClassHelper.CLOSURE_TYPE.getMethod("getThisObject", Parameter.EMPTY_ARRAY);
    private static final MethodNode MAP_GET_METHOD = ClassHelper.MAP_TYPE.getMethod("get", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "key")});
    private static final MethodNode GROOVYOBJECT_GETPROPERTY_METHOD = ClassHelper.GROOVY_OBJECT_TYPE.getMethod("getProperty", new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "propertyName")});
    private static final MethodNode INVOKERHELPER_GETPROPERTY_METHOD = INVOKERHELPER_TYPE.getMethod("getProperty", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "object"), new Parameter(ClassHelper.STRING_TYPE, "propertyName")});
    private static final MethodNode INVOKERHELPER_GETPROPERTYSAFE_METHOD = INVOKERHELPER_TYPE.getMethod("getPropertySafe", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "object"), new Parameter(ClassHelper.STRING_TYPE, "propertyName")});
    private final StaticTypesWriterController controller;

    public StaticTypesCallSiteWriter(StaticTypesWriterController controller) {
        super((WriterController)controller);
        this.controller = controller;
    }

    public void generateCallSiteArray() {
        CallSiteWriter regularCallSiteWriter = this.controller.getRegularCallSiteWriter();
        if (regularCallSiteWriter.hasCallSiteUse()) {
            regularCallSiteWriter.generateCallSiteArray();
        }
    }

    public void makeCallSite(Expression receiver, String message, Expression arguments, boolean safe, boolean implicitThis, boolean callCurrent, boolean callStatic) {
    }

    public void makeGetPropertySite(Expression receiver, String propertyName, boolean safe, boolean implicitThis) {
        boolean isStaticProperty;
        Object dynamic = receiver.getNodeMetaData((Object)StaticCompilationMetadataKeys.RECEIVER_OF_DYNAMIC_PROPERTY);
        if (dynamic != null) {
            this.makeDynamicGetProperty(receiver, propertyName, safe);
            return;
        }
        boolean[] isClassReceiver = new boolean[1];
        ClassNode receiverType = this.getPropertyOwnerType(receiver, isClassReceiver);
        if (receiverType.isArray() && "length".equals(propertyName)) {
            receiver.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
            ClassNode arrayGetReturnType = this.controller.getTypeChooser().resolveType(receiver, this.controller.getClassNode());
            this.controller.getOperandStack().doGroovyCast(arrayGetReturnType);
            this.controller.getMethodVisitor().visitInsn(190);
            this.controller.getOperandStack().replace(ClassHelper.int_TYPE);
            return;
        }
        if (GeneralUtils.isOrImplements((ClassNode)receiverType, (ClassNode)COLLECTION_TYPE) && ("size".equals(propertyName) || "length".equals(propertyName))) {
            MethodCallExpression expr = GeneralUtils.callX((Expression)receiver, (String)"size");
            expr.setMethodTarget(COLLECTION_SIZE_METHOD);
            expr.setImplicitThis(implicitThis);
            expr.setSafe(safe);
            expr.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
            return;
        }
        boolean bl = isStaticProperty = receiver instanceof ClassExpression && (receiverType.isDerivedFrom(receiver.getType()) || receiverType.implementsInterface(receiver.getType()));
        if (!isStaticProperty && GeneralUtils.isOrImplements((ClassNode)receiverType, (ClassNode)ClassHelper.MAP_TYPE)) {
            this.writeMapDotProperty(receiver, propertyName, safe);
            return;
        }
        if (this.makeGetPropertyWithGetter(receiver, receiverType, propertyName, safe, implicitThis)) {
            return;
        }
        if (this.makeGetField(receiver, receiverType, propertyName, safe, implicitThis)) {
            return;
        }
        if (receiver instanceof ClassExpression) {
            if (this.makeGetField(receiver, receiver.getType(), propertyName, safe, implicitThis)) {
                return;
            }
            if (this.makeGetPropertyWithGetter(receiver, receiver.getType(), propertyName, safe, implicitThis)) {
                return;
            }
            if (this.makeGetPrivateFieldWithBridgeMethod(receiver, receiver.getType(), propertyName, safe, implicitThis)) {
                return;
            }
        }
        if (isClassReceiver[0]) {
            if (this.makeGetPropertyWithGetter(receiver, ClassHelper.CLASS_Type, propertyName, safe, implicitThis)) {
                return;
            }
            if (this.makeGetField(receiver, ClassHelper.CLASS_Type, propertyName, safe, false)) {
                return;
            }
        }
        if (this.makeGetPrivateFieldWithBridgeMethod(receiver, receiverType, propertyName, safe, implicitThis)) {
            return;
        }
        String getterName = "get" + BeanUtils.capitalize((String)propertyName);
        String altGetterName = "is" + BeanUtils.capitalize((String)propertyName);
        if (receiverType.isInterface()) {
            MethodNode getterMethod = null;
            for (ClassNode anInterface : receiverType.getAllInterfaces()) {
                getterMethod = anInterface.getGetterMethod(getterName);
                if (getterMethod == null) {
                    getterMethod = anInterface.getGetterMethod(altGetterName);
                }
                if (getterMethod != null) break;
            }
            if (getterMethod == null) {
                getterMethod = ClassHelper.OBJECT_TYPE.getGetterMethod(getterName);
            }
            if (getterMethod != null) {
                MethodCallExpression call = GeneralUtils.callX((Expression)receiver, (String)getterName);
                call.setImplicitThis(false);
                call.setMethodTarget(getterMethod);
                call.setSafe(safe);
                call.setSourcePosition((ASTNode)receiver);
                call.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
                return;
            }
        }
        if (!isStaticProperty && GeneralUtils.isOrImplements((ClassNode)receiverType, (ClassNode)ClassHelper.LIST_TYPE)) {
            this.writeListDotProperty(receiver, propertyName, safe);
            return;
        }
        this.addPropertyAccessError(receiver, propertyName, receiverType);
        this.controller.getMethodVisitor().visitInsn(1);
        this.controller.getOperandStack().push(ClassHelper.OBJECT_TYPE);
    }

    private void makeDynamicGetProperty(Expression receiver, String propertyName, boolean safe) {
        MethodNode target = safe ? INVOKERHELPER_GETPROPERTYSAFE_METHOD : INVOKERHELPER_GETPROPERTY_METHOD;
        MethodCallExpression call = GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)INVOKERHELPER_TYPE), (String)target.getName(), (Expression)GeneralUtils.args((Expression[])new Expression[]{receiver, GeneralUtils.constX((Object)propertyName)}));
        call.setImplicitThis(false);
        call.setMethodTarget(target);
        call.setSafe(false);
        call.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
    }

    private void writeMapDotProperty(Expression receiver, String propertyName, boolean safe) {
        receiver.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
        MethodVisitor mv = this.controller.getMethodVisitor();
        Label exit = new Label();
        if (safe) {
            Label doGet = new Label();
            mv.visitJumpInsn(199, doGet);
            this.controller.getOperandStack().remove(1);
            mv.visitInsn(1);
            mv.visitJumpInsn(167, exit);
            mv.visitLabel(doGet);
            receiver.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
        }
        mv.visitLdcInsn((Object)propertyName);
        mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        if (safe) {
            mv.visitLabel(exit);
        }
        this.controller.getOperandStack().replace(ClassHelper.OBJECT_TYPE);
    }

    private void writeListDotProperty(Expression receiver, String propertyName, boolean safe) {
        ClassNode componentType = (ClassNode)receiver.getNodeMetaData((Object)StaticCompilationMetadataKeys.COMPONENT_TYPE);
        if (componentType == null) {
            componentType = ClassHelper.OBJECT_TYPE;
        }
        CompileStack compileStack = this.controller.getCompileStack();
        MethodVisitor mv = this.controller.getMethodVisitor();
        Label exit = new Label();
        if (safe) {
            receiver.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
            Label doGet = new Label();
            mv.visitJumpInsn(199, doGet);
            this.controller.getOperandStack().remove(1);
            mv.visitInsn(1);
            mv.visitJumpInsn(167, exit);
            mv.visitLabel(doGet);
        }
        VariableExpression tmpList = GeneralUtils.varX((String)"tmpList", (ClassNode)ClassHelper.make(ArrayList.class));
        int var = compileStack.defineTemporaryVariable((Variable)tmpList, false);
        VariableExpression iterator = GeneralUtils.varX((String)"iterator", (ClassNode)ClassHelper.Iterator_TYPE);
        int it = compileStack.defineTemporaryVariable((Variable)iterator, false);
        VariableExpression nextVar = GeneralUtils.varX((String)"next", (ClassNode)componentType);
        int next = compileStack.defineTemporaryVariable((Variable)nextVar, false);
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        receiver.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
        mv.visitMethodInsn(185, "java/util/List", "size", "()I", true);
        this.controller.getOperandStack().remove(1);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "(I)V", false);
        mv.visitVarInsn(58, var);
        Label l1 = new Label();
        mv.visitLabel(l1);
        receiver.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
        mv.visitMethodInsn(185, "java/util/List", "iterator", "()Ljava/util/Iterator;", true);
        this.controller.getOperandStack().remove(1);
        mv.visitVarInsn(58, it);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitVarInsn(25, it);
        mv.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        Label l3 = new Label();
        mv.visitJumpInsn(153, l3);
        mv.visitVarInsn(25, it);
        mv.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        mv.visitTypeInsn(192, BytecodeHelper.getClassInternalName((ClassNode)componentType));
        mv.visitVarInsn(58, next);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitVarInsn(25, var);
        PropertyExpression pexp = GeneralUtils.propX((Expression)GeneralUtils.bytecodeX((ClassNode)componentType, v -> v.visitVarInsn(25, next)), (String)propertyName);
        pexp.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
        this.controller.getOperandStack().box();
        this.controller.getOperandStack().remove(1);
        mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
        mv.visitInsn(87);
        Label l5 = new Label();
        mv.visitLabel(l5);
        mv.visitJumpInsn(167, l2);
        mv.visitLabel(l3);
        mv.visitVarInsn(25, var);
        if (safe) {
            mv.visitLabel(exit);
        }
        this.controller.getOperandStack().push(ClassHelper.make(ArrayList.class));
        this.controller.getCompileStack().removeVar(next);
        this.controller.getCompileStack().removeVar(it);
        this.controller.getCompileStack().removeVar(var);
    }

    private boolean makeGetPrivateFieldWithBridgeMethod(Expression receiver, ClassNode receiverType, String fieldName, boolean safe, boolean implicitThis) {
        ClassNode outerClass;
        FieldNode field = receiverType.getField(fieldName);
        if (field != null) {
            MethodNode methodNode;
            Map accessors;
            ClassNode classNode = this.controller.getClassNode();
            if (field.isPrivate() && !receiverType.equals(classNode) && (StaticInvocationWriter.isPrivateBridgeMethodsCallAllowed(receiverType, classNode) || StaticInvocationWriter.isPrivateBridgeMethodsCallAllowed(classNode, receiverType)) && (accessors = (Map)receiverType.redirect().getNodeMetaData(StaticCompilationMetadataKeys.PRIVATE_FIELDS_ACCESSORS)) != null && (methodNode = (MethodNode)accessors.get(fieldName)) != null) {
                Object thisObject = field.isStatic() ? GeneralUtils.nullX() : (!ExpressionUtils.isThisExpression(receiver) ? receiver : GeneralUtils.propX((Expression)GeneralUtils.classX((ClassNode)receiverType), (String)"this"));
                MethodCallExpression call = GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)receiverType), (String)methodNode.getName(), (Expression)thisObject);
                call.setMethodTarget(methodNode);
                call.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
                return true;
            }
        } else if (implicitThis && (outerClass = receiverType.getOuterClass()) != null && !receiverType.isStaticClass()) {
            PropertyExpression expr;
            ClassNode thisType = outerClass;
            if (this.controller.isInGeneratedFunction()) {
                while (ClassHelper.isGeneratedFunction(thisType)) {
                    thisType = thisType.getOuterClass();
                }
                MethodCallExpression call = GeneralUtils.callThisX((String)"getThisObject");
                call.setImplicitThis(true);
                call.setMethodTarget(CLOSURE_GETTHISOBJECT_METHOD);
                call.putNodeMetaData(StaticTypesMarker.INFERRED_TYPE, thisType);
                expr = GeneralUtils.castX((ClassNode)thisType, (Expression)call);
            } else {
                expr = GeneralUtils.propX((Expression)GeneralUtils.classX((ClassNode)outerClass), (String)"this");
            }
            expr.setSourcePosition((ASTNode)receiver);
            expr.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, (Object)thisType);
            return this.makeGetPrivateFieldWithBridgeMethod((Expression)expr, outerClass, fieldName, safe, true);
        }
        return false;
    }

    public void makeGroovyObjectGetPropertySite(Expression receiver, String propertyName, boolean safe, boolean implicitThis) {
        String implicitReceiver;
        MethodCallExpression currentCall;
        ClassNode receiverType = this.controller.getClassNode();
        if (!ExpressionUtils.isThisExpression(receiver) || this.controller.isInGeneratedFunction()) {
            receiverType = this.getPropertyOwnerType(receiver, new boolean[0]);
        }
        if (implicitThis && this.controller.getInvocationWriter() instanceof StaticInvocationWriter && (currentCall = ((StaticInvocationWriter)this.controller.getInvocationWriter()).getCurrentCall()) != null && (implicitReceiver = (String)currentCall.getNodeMetaData(StaticTypesMarker.IMPLICIT_RECEIVER)) != null) {
            String[] pathElements = implicitReceiver.split("\\.");
            BytecodeExpression thisLoader = GeneralUtils.bytecodeX((ClassNode)ClassHelper.CLOSURE_TYPE, mv -> mv.visitVarInsn(25, 0));
            PropertyExpression pexp = GeneralUtils.propX((Expression)thisLoader, (Expression)GeneralUtils.constX((Object)pathElements[0]), (boolean)safe);
            int i = 1;
            int n = pathElements.length;
            while (i < n) {
                pexp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, (Object)ClassHelper.CLOSURE_TYPE);
                pexp = GeneralUtils.propX((Expression)pexp, (String)pathElements[i]);
                ++i;
            }
            pexp.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
            return;
        }
        if (this.makeGetPropertyWithGetter(receiver, receiverType, propertyName, safe, implicitThis)) {
            return;
        }
        if (this.makeGetPrivateFieldWithBridgeMethod(receiver, receiverType, propertyName, safe, implicitThis)) {
            return;
        }
        if (this.makeGetField(receiver, receiverType, propertyName, safe, implicitThis)) {
            return;
        }
        MethodCallExpression call = GeneralUtils.callX((Expression)receiver, (String)"getProperty", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)propertyName)}));
        call.setImplicitThis(implicitThis);
        call.setMethodTarget(GROOVYOBJECT_GETPROPERTY_METHOD);
        call.setSafe(safe);
        call.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
    }

    public void makeCallSiteArrayInitializer() {
    }

    private boolean makeGetPropertyWithGetter(Expression receiver, ClassNode receiverType, String propertyName, boolean safe, boolean implicitThis) {
        String getterName = "get" + BeanUtils.capitalize((String)propertyName);
        MethodNode getterNode = receiverType.getGetterMethod(getterName);
        if (getterNode == null) {
            getterName = "is" + BeanUtils.capitalize((String)propertyName);
            getterNode = receiverType.getGetterMethod(getterName);
        }
        if (getterNode != null && receiver instanceof ClassExpression && !ClassHelper.CLASS_Type.equals(receiverType) && !getterNode.isStatic()) {
            return false;
        }
        PropertyNode propertyNode = receiverType.getProperty(propertyName);
        if (getterNode == null && propertyNode != null) {
            String prefix = "get";
            if (ClassHelper.boolean_TYPE.equals(propertyNode.getOriginType())) {
                prefix = "is";
            }
            getterName = String.valueOf(prefix) + BeanUtils.capitalize((String)propertyName);
            getterNode = new MethodNode(getterName, 1 | (propertyNode.isStatic() ? 8 : 0), propertyNode.getOriginType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)EmptyStatement.INSTANCE);
            getterNode.setDeclaringClass(receiverType);
        }
        if (getterNode != null) {
            BiPredicate<MethodNode, ClassNode> accessible = (method, sender) -> {
                if (method.isPublic()) {
                    return true;
                }
                ClassNode declaringClass = method.getDeclaringClass();
                if (sender.equals(declaringClass)) {
                    return true;
                }
                if (method.isPrivate()) {
                    return false;
                }
                if (method.isProtected() && sender.isDerivedFrom(declaringClass)) {
                    return true;
                }
                return Objects.equals(sender.getPackageName(), declaringClass.getPackageName());
            };
            if (!accessible.test(getterNode, this.controller.getClassNode())) {
                return false;
            }
            MethodCallExpression call = GeneralUtils.callX((Expression)receiver, (String)getterName);
            call.setImplicitThis(implicitThis);
            call.setMethodTarget(getterNode);
            call.setSafe(safe);
            call.setSourcePosition((ASTNode)receiver);
            call.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
            return true;
        }
        if (receiverType instanceof InnerClassNode && !receiverType.isStaticClass() && this.makeGetPropertyWithGetter(receiver, receiverType.getOuterClass(), propertyName, safe, implicitThis)) {
            return true;
        }
        ClassNode[] classNodeArray = receiverType.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode node = classNodeArray[n2];
            if (this.makeGetPropertyWithGetter(receiver, node, propertyName, safe, implicitThis)) {
                return true;
            }
            ++n2;
        }
        ClassNode superClass = receiverType.getSuperClass();
        if (superClass != null) {
            return this.makeGetPropertyWithGetter(receiver, superClass, propertyName, safe, implicitThis);
        }
        return false;
    }

    boolean makeGetField(Expression receiver, ClassNode receiverType, String fieldName, boolean safe, boolean implicitThis) {
        FieldNode field = ClassNodeUtils.getField((ClassNode)receiverType, (String)fieldName);
        if (field != null && AsmClassGenerator.isValidFieldNodeForByteCodeAccess(field, this.controller.getClassNode())) {
            CompileStack compileStack = this.controller.getCompileStack();
            MethodVisitor mv = this.controller.getMethodVisitor();
            ClassNode replacementType = field.getOriginType();
            OperandStack operandStack = this.controller.getOperandStack();
            if (field.isStatic()) {
                mv.visitFieldInsn(178, BytecodeHelper.getClassInternalName((ClassNode)receiverType), fieldName, BytecodeHelper.getTypeDescription((ClassNode)replacementType));
                operandStack.push(replacementType);
            } else {
                if (implicitThis) {
                    compileStack.pushImplicitThis(implicitThis);
                    receiver.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
                    compileStack.popImplicitThis();
                } else {
                    receiver.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
                }
                Label exit = new Label();
                if (safe) {
                    mv.visitInsn(89);
                    Label doGet = new Label();
                    mv.visitJumpInsn(199, doGet);
                    mv.visitInsn(87);
                    mv.visitInsn(1);
                    mv.visitJumpInsn(167, exit);
                    mv.visitLabel(doGet);
                }
                if (!operandStack.getTopOperand().isDerivedFrom(field.getOwner())) {
                    mv.visitTypeInsn(192, BytecodeHelper.getClassInternalName((ClassNode)field.getOwner()));
                }
                mv.visitFieldInsn(180, BytecodeHelper.getClassInternalName((ClassNode)field.getOwner()), fieldName, BytecodeHelper.getTypeDescription((ClassNode)replacementType));
                if (safe) {
                    if (ClassHelper.isPrimitiveType(replacementType)) {
                        operandStack.replace(replacementType);
                        operandStack.box();
                        replacementType = operandStack.getTopOperand();
                    }
                    mv.visitLabel(exit);
                }
            }
            operandStack.replace(replacementType);
            return true;
        }
        return false;
    }

    public void makeSiteEntry() {
    }

    public void prepareCallSite(String message) {
    }

    public void makeSingleArgumentCall(Expression receiver, String message, Expression arguments, boolean safe) {
        ClassNode aType;
        ClassNode classNode;
        TypeChooser typeChooser = this.controller.getTypeChooser();
        ClassNode rType = typeChooser.resolveType(receiver, classNode = this.controller.getClassNode());
        if (this.trySubscript(receiver, message, arguments, rType, aType = typeChooser.resolveType(arguments, classNode), safe)) {
            return;
        }
        rType = (ClassNode)receiver.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (receiver instanceof VariableExpression && rType == null) {
            ASTNode node = (ASTNode)((VariableExpression)receiver).getAccessedVariable();
            rType = (ClassNode)node.getNodeMetaData(StaticTypesMarker.INFERRED_TYPE);
        }
        if (rType != null && this.trySubscript(receiver, message, arguments, rType, aType, safe)) {
            return;
        }
        throw new GroovyBugError("At line " + receiver.getLineNumber() + " column " + receiver.getColumnNumber() + "\n" + "On receiver: " + receiver.getText() + " with message: " + message + " and arguments: " + arguments.getText() + "\n" + "This method should not have been called. Please try to create a simple example reproducing\n" + "this error and file a bug report at https://issues.apache.org/jira/browse/GROOVY");
    }

    private boolean trySubscript(Expression receiver, String message, Expression arguments, ClassNode rType, ClassNode aType, boolean safe) {
        if (ClassHelper.getWrapper(rType).isDerivedFrom(ClassHelper.Number_TYPE) && ClassHelper.getWrapper(aType).isDerivedFrom(ClassHelper.Number_TYPE)) {
            if ("plus".equals(message) || "minus".equals(message) || "multiply".equals(message) || "div".equals(message)) {
                this.writeNumberNumberCall(receiver, message, arguments);
                return true;
            }
            if ("power".equals(message)) {
                this.writePowerCall(receiver, arguments, rType, aType);
                return true;
            }
            if ("mod".equals(message) || "leftShift".equals(message) || "rightShift".equals(message) || "rightShiftUnsigned".equals(message) || "and".equals(message) || "or".equals(message) || "xor".equals(message)) {
                this.writeOperatorCall(receiver, arguments, message);
                return true;
            }
        } else {
            if (ClassHelper.STRING_TYPE.equals(rType) && "plus".equals(message)) {
                this.writeStringPlusCall(receiver, message, arguments);
                return true;
            }
            if ("getAt".equals(message)) {
                if (rType.isArray() && ClassHelper.getWrapper(aType).isDerivedFrom(ClassHelper.Number_TYPE) && !safe) {
                    this.writeArrayGet(receiver, arguments, rType, aType);
                    return true;
                }
                ClassNode current = rType;
                MethodNode getAtNode = null;
                while (current != null && getAtNode == null) {
                    getAtNode = current.getDeclaredMethod("getAt", new Parameter[]{new Parameter(aType, "index")});
                    if (getAtNode == null) {
                        getAtNode = this.getCompatibleMethod(current, "getAt", aType);
                    }
                    if (getAtNode == null && ClassHelper.isPrimitiveType(aType)) {
                        getAtNode = current.getDeclaredMethod("getAt", new Parameter[]{new Parameter(ClassHelper.getWrapper(aType), "index")});
                        if (getAtNode == null) {
                            getAtNode = this.getCompatibleMethod(current, "getAt", ClassHelper.getWrapper(aType));
                        }
                    } else if (getAtNode == null && aType.isDerivedFrom(ClassHelper.Number_TYPE) && (getAtNode = current.getDeclaredMethod("getAt", new Parameter[]{new Parameter(ClassHelper.getUnwrapper(aType), "index")})) == null) {
                        getAtNode = this.getCompatibleMethod(current, "getAt", ClassHelper.getUnwrapper(aType));
                    }
                    current = current.getSuperClass();
                }
                if (getAtNode != null) {
                    MethodCallExpression call = GeneralUtils.callX((Expression)receiver, (String)"getAt", (Expression)arguments);
                    call.setImplicitThis(false);
                    call.setMethodTarget(getAtNode);
                    call.setSafe(safe);
                    call.setSourcePosition((ASTNode)arguments);
                    call.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
                    return true;
                }
                ClassNode[] args = new ClassNode[]{aType};
                boolean acceptAnyMethod = ClassHelper.MAP_TYPE.equals(rType) || rType.implementsInterface(ClassHelper.MAP_TYPE) || ClassHelper.LIST_TYPE.equals(rType) || rType.implementsInterface(ClassHelper.LIST_TYPE);
                List<MethodNode> nodes = StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments((ClassLoader)this.controller.getSourceUnit().getClassLoader(), rType, message, args);
                if (nodes.isEmpty()) {
                    rType = rType.getPlainNodeReference();
                    nodes = StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments((ClassLoader)this.controller.getSourceUnit().getClassLoader(), rType, message, args);
                }
                if (nodes.size() == 1 || nodes.size() > 1 && acceptAnyMethod) {
                    MethodCallExpression call = GeneralUtils.callX((Expression)receiver, (String)message, (Expression)arguments);
                    call.setImplicitThis(false);
                    call.setMethodTarget(nodes.get(0));
                    call.setSafe(safe);
                    call.setSourcePosition((ASTNode)arguments);
                    call.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
                    return true;
                }
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(rType, ClassHelper.MAP_TYPE)) {
                    MethodCallExpression call = GeneralUtils.callX((Expression)receiver, (String)"get", (Expression)arguments);
                    call.setImplicitThis(false);
                    call.setMethodTarget(MAP_GET_METHOD);
                    call.setSafe(safe);
                    call.setSourcePosition((ASTNode)arguments);
                    call.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
                    return true;
                }
            }
        }
        return false;
    }

    private MethodNode getCompatibleMethod(ClassNode current, String getAt, ClassNode aType) {
        for (MethodNode methodNode : current.getDeclaredMethods("getAt")) {
            ClassNode paramType;
            if (methodNode.getParameters().length != 1 || !aType.isDerivedFrom(paramType = methodNode.getParameters()[0].getType()) && !aType.declaresInterface(paramType)) continue;
            return methodNode;
        }
        return null;
    }

    private void writeArrayGet(Expression receiver, Expression arguments, ClassNode rType, ClassNode aType) {
        OperandStack operandStack = this.controller.getOperandStack();
        int m1 = operandStack.getStackLength();
        receiver.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
        arguments.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
        operandStack.doGroovyCast(ClassHelper.int_TYPE);
        int m2 = operandStack.getStackLength();
        this.controller.getMethodVisitor().visitInsn(50);
        operandStack.replace(rType.getComponentType(), m2 - m1);
    }

    private void writeOperatorCall(Expression receiver, Expression arguments, String operator) {
        this.prepareSiteAndReceiver(receiver, operator, false, this.controller.getCompileStack().isLHS());
        this.controller.getOperandStack().doGroovyCast(ClassHelper.Number_TYPE);
        this.visitBoxedArgument(arguments);
        this.controller.getOperandStack().doGroovyCast(ClassHelper.Number_TYPE);
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/typehandling/NumberMath", operator, "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;", false);
        this.controller.getOperandStack().replace(ClassHelper.Number_TYPE, 2);
    }

    private void writePowerCall(Expression receiver, Expression arguments, ClassNode rType, ClassNode aType) {
        OperandStack operandStack = this.controller.getOperandStack();
        int m1 = operandStack.getStackLength();
        this.prepareSiteAndReceiver(receiver, "power", false, this.controller.getCompileStack().isLHS());
        operandStack.doGroovyCast(ClassHelper.getWrapper(rType));
        this.visitBoxedArgument(arguments);
        operandStack.doGroovyCast(ClassHelper.getWrapper(aType));
        int m2 = operandStack.getStackLength();
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (ClassHelper.BigDecimal_TYPE.equals(rType) && ClassHelper.Integer_TYPE.equals(ClassHelper.getWrapper(aType))) {
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "power", "(Ljava/math/BigDecimal;Ljava/lang/Integer;)Ljava/lang/Number;", false);
        } else if (ClassHelper.BigInteger_TYPE.equals(rType) && ClassHelper.Integer_TYPE.equals(ClassHelper.getWrapper(aType))) {
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "power", "(Ljava/math/BigInteger;Ljava/lang/Integer;)Ljava/lang/Number;", false);
        } else if (ClassHelper.Long_TYPE.equals(ClassHelper.getWrapper(rType)) && ClassHelper.Integer_TYPE.equals(ClassHelper.getWrapper(aType))) {
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "power", "(Ljava/lang/Long;Ljava/lang/Integer;)Ljava/lang/Number;", false);
        } else if (ClassHelper.Integer_TYPE.equals(ClassHelper.getWrapper(rType)) && ClassHelper.Integer_TYPE.equals(ClassHelper.getWrapper(aType))) {
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "power", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Number;", false);
        } else {
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "power", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;", false);
        }
        this.controller.getOperandStack().replace(ClassHelper.Number_TYPE, m2 - m1);
    }

    private void writeStringPlusCall(Expression receiver, String message, Expression arguments) {
        OperandStack operandStack = this.controller.getOperandStack();
        int m1 = operandStack.getStackLength();
        this.prepareSiteAndReceiver(receiver, message, false, this.controller.getCompileStack().isLHS());
        this.visitBoxedArgument(arguments);
        int m2 = operandStack.getStackLength();
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "plus", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;", false);
        this.controller.getOperandStack().replace(ClassHelper.STRING_TYPE, m2 - m1);
    }

    private void writeNumberNumberCall(Expression receiver, String message, Expression arguments) {
        OperandStack operandStack = this.controller.getOperandStack();
        int m1 = operandStack.getStackLength();
        this.prepareSiteAndReceiver(receiver, message, false, this.controller.getCompileStack().isLHS());
        this.controller.getOperandStack().doGroovyCast(ClassHelper.Number_TYPE);
        this.visitBoxedArgument(arguments);
        this.controller.getOperandStack().doGroovyCast(ClassHelper.Number_TYPE);
        int m2 = operandStack.getStackLength();
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/dgmimpl/NumberNumber" + BeanUtils.capitalize((String)message), message, "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;", false);
        this.controller.getOperandStack().replace(ClassHelper.Number_TYPE, m2 - m1);
    }

    public void fallbackAttributeOrPropertySite(PropertyExpression expression, Expression objectExpression, String name, MethodCallerMultiAdapter adapter) {
        CompileStack compileStack = this.controller.getCompileStack();
        OperandStack operandStack = this.controller.getOperandStack();
        if (name != null && compileStack.isLHS()) {
            boolean[] isClassReceiver = new boolean[1];
            ClassNode receiverType = this.getPropertyOwnerType(objectExpression, isClassReceiver);
            if ((adapter == AsmClassGenerator.setField || adapter == AsmClassGenerator.setGroovyObjectField) && this.setField(expression, objectExpression, receiverType, name)) {
                return;
            }
            if (ExpressionUtils.isThisExpression(objectExpression)) {
                MethodNode methodNode;
                Map mutators;
                ClassNode classNode = this.controller.getClassNode();
                FieldNode fieldNode = receiverType.getField(name);
                if (fieldNode != null && fieldNode.isPrivate() && !receiverType.equals(classNode) && StaticInvocationWriter.isPrivateBridgeMethodsCallAllowed(receiverType, classNode) && (mutators = (Map)receiverType.redirect().getNodeMetaData(StaticCompilationMetadataKeys.PRIVATE_FIELDS_MUTATORS)) != null && (methodNode = (MethodNode)mutators.get(name)) != null) {
                    ClassNode rhsType = operandStack.getTopOperand();
                    int i = compileStack.defineTemporaryVariable("$rhsValue", rhsType, true);
                    VariableSlotLoader rhsValue = new VariableSlotLoader(rhsType, i, operandStack);
                    MethodCallExpression call = GeneralUtils.callX((Expression)objectExpression, (String)methodNode.getName(), (Expression)GeneralUtils.args((Expression[])new Expression[]{fieldNode.isStatic() ? GeneralUtils.nullX() : objectExpression, rhsValue}));
                    call.setImplicitThis(expression.isImplicitThis());
                    call.setSpreadSafe(expression.isSpreadSafe());
                    call.setSafe(expression.isSafe());
                    call.setMethodTarget(methodNode);
                    call.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
                    compileStack.removeVar(i);
                    operandStack.pop();
                    return;
                }
            }
            if (GeneralUtils.isOrImplements((ClassNode)receiverType, (ClassNode)ClassHelper.MAP_TYPE) && !isClassReceiver[0]) {
                MethodVisitor mv = this.controller.getMethodVisitor();
                ClassNode rhsType = operandStack.getTopOperand();
                int rhs = compileStack.defineTemporaryVariable("$rhs", rhsType, true);
                compileStack.pushLHS(false);
                objectExpression.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
                compileStack.popLHS();
                Label skip = new Label();
                if (expression.isSafe()) {
                    mv.visitInsn(89);
                    mv.visitJumpInsn(198, skip);
                }
                mv.visitLdcInsn((Object)name);
                BytecodeHelper.load((MethodVisitor)mv, (ClassNode)rhsType, (int)rhs);
                if (ClassHelper.isPrimitiveType(rhsType)) {
                    BytecodeHelper.doCastToWrappedType((MethodVisitor)mv, (ClassNode)rhsType, (ClassNode)ClassHelper.getWrapper(rhsType));
                }
                mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                if (expression.isSafe()) {
                    mv.visitLabel(skip);
                }
                operandStack.pop();
                compileStack.removeVar(rhs);
                return;
            }
        }
        super.fallbackAttributeOrPropertySite(expression, objectExpression, name, adapter);
    }

    private ClassNode getPropertyOwnerType(Expression receiver, boolean ... isClassReceiver) {
        ClassNode receiverType;
        Variable variable;
        Object inferredType = receiver.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (inferredType == null && receiver instanceof VariableExpression && (variable = ((VariableExpression)receiver).getAccessedVariable()) instanceof Expression) {
            inferredType = ((Expression)variable).getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        }
        if (inferredType instanceof ClassNode) {
            receiverType = (ClassNode)inferredType;
        } else {
            receiverType = (ClassNode)receiver.getNodeMetaData((Object)StaticCompilationMetadataKeys.PROPERTY_OWNER);
            if (receiverType == null) {
                receiverType = this.controller.getTypeChooser().resolveType(receiver, this.controller.getClassNode());
            }
        }
        if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiverType)) {
            if (isClassReceiver.length > 0) {
                isClassReceiver[0] = true;
            }
            receiverType = receiverType.getGenericsTypes()[0].getType();
        }
        if (ClassHelper.isPrimitiveType(receiverType)) {
            receiverType = ClassHelper.getWrapper(receiverType);
        }
        return receiverType;
    }

    private boolean setField(PropertyExpression expression, Expression objectExpression, ClassNode receiverType, String name) {
        if (expression.isSafe()) {
            return false;
        }
        FieldNode fn = AsmClassGenerator.getDeclaredFieldOfCurrentClassOrAccessibleFieldOfSuper(this.controller.getClassNode(), receiverType, name, false);
        if (fn == null) {
            return false;
        }
        OperandStack stack = this.controller.getOperandStack();
        stack.doGroovyCast(fn.getType());
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (!fn.isStatic()) {
            this.controller.getCompileStack().pushLHS(false);
            objectExpression.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
            this.controller.getCompileStack().popLHS();
            if (!receiverType.equals(stack.getTopOperand())) {
                BytecodeHelper.doCast((MethodVisitor)mv, (ClassNode)receiverType);
                stack.replace(receiverType);
            }
            stack.swap();
            mv.visitFieldInsn(181, BytecodeHelper.getClassInternalName((ClassNode)fn.getOwner()), name, BytecodeHelper.getTypeDescription((ClassNode)fn.getType()));
            stack.remove(1);
        } else {
            mv.visitFieldInsn(179, BytecodeHelper.getClassInternalName((ClassNode)receiverType), name, BytecodeHelper.getTypeDescription((ClassNode)fn.getType()));
        }
        return true;
    }

    private void addPropertyAccessError(Expression receiver, String propertyName, ClassNode receiverType) {
        String receiverName = (receiver instanceof ClassExpression ? receiver.getType() : receiverType).toString(false);
        String message = "Access to " + receiverName + "#" + propertyName + " is forbidden";
        this.controller.getSourceUnit().addError(new SyntaxException(message, (ASTNode)receiver));
    }
}

