/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.sc;

import groovyjarjarasm.asm.Handle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodReferenceExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.ParameterUtils;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.MethodReferenceExpressionWriter;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.classgen.asm.sc.AbstractFunctionalInterfaceWriter;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.syntax.RuntimeParserException;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class StaticTypesMethodReferenceExpressionWriter
extends MethodReferenceExpressionWriter
implements AbstractFunctionalInterfaceWriter {
    public StaticTypesMethodReferenceExpressionWriter(WriterController controller) {
        super(controller);
    }

    public void writeMethodReferenceExpression(MethodReferenceExpression methodReferenceExpression) {
        Parameter[] parameterArray;
        MethodNode methodRefMethod;
        ClassNode functionalInterfaceType = this.getFunctionalInterfaceType((Expression)methodReferenceExpression);
        MethodNode abstractMethod = ClassHelper.findSAM(functionalInterfaceType);
        if (abstractMethod == null || !functionalInterfaceType.isInterface()) {
            super.writeMethodReferenceExpression(methodReferenceExpression);
            return;
        }
        ClassNode classNode = this.controller.getClassNode();
        Expression typeOrTargetRef = methodReferenceExpression.getExpression();
        boolean isClassExpression = typeOrTargetRef instanceof ClassExpression;
        ClassNode typeOrTargetRefType = isClassExpression ? typeOrTargetRef.getType() : this.controller.getTypeChooser().resolveType(typeOrTargetRef, classNode);
        ClassNode[] methodReferenceParamTypes = (ClassNode[])methodReferenceExpression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
        Parameter[] parametersWithExactType = this.createParametersWithExactType(abstractMethod, methodReferenceParamTypes);
        String methodRefName = methodReferenceExpression.getMethodName().getText();
        boolean isConstructorReference = StaticTypesMethodReferenceExpressionWriter.isConstructorReference(methodRefName);
        if (isConstructorReference) {
            methodRefName = this.controller.getContext().getNextConstructorReferenceSyntheticMethodName(this.controller.getMethodNode());
            methodRefMethod = this.addSyntheticMethodForConstructorReference(methodRefName, typeOrTargetRefType, parametersWithExactType);
        } else {
            methodRefMethod = this.findMethodRefMethod(methodRefName, parametersWithExactType, typeOrTargetRef, typeOrTargetRefType);
        }
        this.validate(methodReferenceExpression, typeOrTargetRefType, methodRefName, methodRefMethod, parametersWithExactType, StaticTypeCheckingSupport.resolveClassNodeGenerics(GenericsUtils.extractPlaceholders(functionalInterfaceType), null, abstractMethod.getReturnType()));
        if (StaticTypesMethodReferenceExpressionWriter.isExtensionMethod(methodRefMethod)) {
            ExtensionMethodNode extensionMethodNode = (ExtensionMethodNode)methodRefMethod;
            methodRefMethod = extensionMethodNode.getExtensionMethodNode();
            if (extensionMethodNode.isStaticExtension()) {
                methodRefMethod = this.addSyntheticMethodForDGSM(methodRefMethod);
            }
            typeOrTargetRefType = methodRefMethod.getDeclaringClass();
            typeOrTargetRef = StaticTypesMethodReferenceExpressionWriter.makeClassTarget(typeOrTargetRefType, typeOrTargetRef);
        }
        if (!isClassExpression) {
            if (isConstructorReference) {
                this.addFatalError("Constructor reference must be className::new", (ASTNode)methodReferenceExpression);
            } else if (methodRefMethod.isStatic()) {
                typeOrTargetRef = StaticTypesMethodReferenceExpressionWriter.makeClassTarget(typeOrTargetRefType, typeOrTargetRef);
                isClassExpression = true;
            } else {
                typeOrTargetRef.visit((GroovyCodeVisitor)((Object)this.controller.getAcg()));
            }
        }
        int referenceKind = isConstructorReference || methodRefMethod.isStatic() ? 6 : (methodRefMethod.getDeclaringClass().isInterface() ? 9 : 5);
        String methodName = abstractMethod.getName();
        ClassNode classNode2 = functionalInterfaceType.redirect();
        if (isClassExpression) {
            parameterArray = Parameter.EMPTY_ARRAY;
        } else {
            Parameter[] parameterArray2 = new Parameter[1];
            parameterArray = parameterArray2;
            parameterArray2[0] = new Parameter(typeOrTargetRefType, "__METHODREF_EXPR_INSTANCE");
        }
        String methodDesc = BytecodeHelper.getMethodDescriptor((ClassNode)classNode2, (Parameter[])parameterArray);
        Handle bootstrapMethod = this.createBootstrapMethod(classNode.isInterface(), false);
        Object[] bootstrapArgs = this.createBootstrapMethodArguments(this.createMethodDescriptor(abstractMethod), referenceKind, methodRefMethod.getDeclaringClass(), methodRefMethod, parametersWithExactType, false);
        this.controller.getMethodVisitor().visitInvokeDynamicInsn(methodName, methodDesc, bootstrapMethod, bootstrapArgs);
        if (isClassExpression) {
            this.controller.getOperandStack().push(functionalInterfaceType);
        } else {
            this.controller.getOperandStack().replace(functionalInterfaceType, 1);
        }
    }

    private void validate(MethodReferenceExpression methodReference, ClassNode targetType, String methodName, MethodNode methodNode, Parameter[] samParameters, ClassNode samReturnType) {
        if (methodNode == null) {
            String error;
            if (!(methodReference.getExpression() instanceof ClassExpression)) {
                error = "Failed to find method '%s(%s)'";
            } else {
                error = "Failed to find class method '%s(%s)'";
                if (samParameters.length > 0) {
                    error = String.valueOf(error) + " or instance method '%1$s(" + Arrays.stream(samParameters).skip(1L).map(e -> e.getType().toString(false)).collect(Collectors.joining(",")) + ")'";
                }
            }
            error = String.format(String.valueOf(error) + " for the type: %s", methodName, Arrays.stream(samParameters).map(e -> e.getType().toString(false)).collect(Collectors.joining(",")), targetType.toString(false));
            this.addFatalError(error, (ASTNode)methodReference);
        } else if (methodNode.isVoidMethod() && !samReturnType.equals(ClassHelper.VOID_TYPE)) {
            this.addFatalError("Invalid return type: void is not convertible to " + samReturnType.getText(), (ASTNode)methodReference);
        } else if (samParameters.length > 0 && StaticTypesMethodReferenceExpressionWriter.isTypeReferringInstanceMethod(methodReference.getExpression(), methodNode) && !StaticTypeCheckingSupport.isAssignableTo(samParameters[0].getType(), targetType)) {
            throw new RuntimeParserException("Invalid receiver type: " + samParameters[0].getType().getText() + " is not compatible with " + targetType.getText(), (ASTNode)methodReference.getExpression());
        }
    }

    private MethodNode addSyntheticMethodForDGSM(MethodNode mn) {
        Parameter[] parameters = StaticTypesMethodReferenceExpressionWriter.removeFirstParameter(mn.getParameters());
        ArgumentListExpression args = new ArgumentListExpression(parameters);
        args.getExpressions().add(0, GeneralUtils.nullX());
        MethodCallExpression returnValue = GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)mn.getDeclaringClass()), (String)mn.getName(), (Expression)args);
        returnValue.putNodeMetaData(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, mn);
        returnValue.setMethodTarget(mn);
        String methodName = "dgsm$$" + mn.getParameters()[0].getType().getName().replace('.', '$') + "$$" + mn.getName();
        MethodNode delegateMethod = this.addSyntheticMethod(methodName, mn.getReturnType(), returnValue, parameters, mn.getExceptions());
        delegateMethod.putNodeMetaData(StaticCompilationMetadataKeys.STATIC_COMPILE_NODE, Boolean.TRUE);
        return delegateMethod;
    }

    private MethodNode addSyntheticMethodForConstructorReference(String methodName, ClassNode returnType, Parameter[] parametersWithExactType) {
        ArgumentListExpression ctorArgs = new ArgumentListExpression(parametersWithExactType);
        Object returnValue = returnType.isArray() ? new ArrayExpression(returnType.getComponentType(), null, ctorArgs.getExpressions()) : GeneralUtils.ctorX((ClassNode)returnType, (Expression)ctorArgs);
        MethodNode delegateMethod = this.addSyntheticMethod(methodName, returnType, (Expression)returnValue, parametersWithExactType, ClassNode.EMPTY_ARRAY);
        delegateMethod.putNodeMetaData(StaticCompilationMetadataKeys.STATIC_COMPILE_NODE, Boolean.FALSE);
        return delegateMethod;
    }

    private MethodNode addSyntheticMethod(String methodName, ClassNode returnType, Expression returnValue, Parameter[] parameters, ClassNode[] exceptions) {
        return this.controller.getClassNode().addSyntheticMethod(methodName, 26, returnType, parameters, exceptions, GeneralUtils.returnS((Expression)returnValue));
    }

    private Parameter[] createParametersWithExactType(MethodNode abstractMethod, ClassNode[] inferredParamTypes) {
        Parameter[] parameters = GeneralUtils.cloneParams((Parameter[])abstractMethod.getParameters());
        if (inferredParamTypes != null) {
            int i = 0;
            int n = parameters.length;
            while (i < n) {
                ClassNode inferredParamType = inferredParamTypes[i];
                if (inferredParamType != null) {
                    Parameter parameter;
                    Parameter targetParameter = parameter = parameters[i];
                    ClassNode type = this.convertParameterType(targetParameter.getType(), parameter.getType(), inferredParamType);
                    parameter.setOriginType(type);
                    parameter.setType(type);
                }
                ++i;
            }
        }
        return parameters;
    }

    private MethodNode findMethodRefMethod(String methodName, Parameter[] samParameters, Expression typeOrTargetRef, ClassNode typeOrTargetRefType) {
        List<MethodNode> methods = this.findVisibleMethods(methodName, typeOrTargetRefType);
        methods.removeIf(method -> {
            Parameter[] parameters = method.getParameters();
            if (StaticTypesMethodReferenceExpressionWriter.isTypeReferringInstanceMethod(typeOrTargetRef, method)) {
                ClassNode firstParamType = method.getDeclaringClass();
                int n = parameters.length;
                Parameter[] plusOne = new Parameter[n + 1];
                plusOne[0] = new Parameter(firstParamType, "");
                System.arraycopy(parameters, 0, plusOne, 1, n);
                parameters = plusOne;
            }
            return !ParameterUtils.parametersCompatible((Parameter[])samParameters, (Parameter[])parameters);
        });
        return this.chooseMethodRefMethod(methods, typeOrTargetRef, typeOrTargetRefType);
    }

    private MethodNode chooseMethodRefMethod(List<MethodNode> methods, Expression typeOrTargetRef, ClassNode typeOrTargetRefType) {
        if (methods.isEmpty()) {
            return null;
        }
        if (methods.size() == 1) {
            return methods.get(0);
        }
        return methods.stream().max(Comparator.comparingInt(mn -> {
            int score = 9;
            ClassNode cn = typeOrTargetRefType;
            while (cn != null && !cn.equals(mn.getDeclaringClass())) {
                --score;
                cn = cn.getSuperClass();
            }
            if (score < 0) {
                score = 0;
            }
            score *= 10;
            if (typeOrTargetRef instanceof ClassExpression == StaticTypesMethodReferenceExpressionWriter.isStaticMethod(mn)) {
                score += 9;
            }
            return score;
        }).thenComparing(StaticTypesMethodReferenceExpressionWriter::isExtensionMethod)).get();
    }

    private List<MethodNode> findVisibleMethods(String name, ClassNode type) {
        List<MethodNode> methods = type.getMethods(name);
        for (ClassNode cn : GeneralUtils.getInterfacesAndSuperInterfaces((ClassNode)type)) {
            for (MethodNode mn : cn.getDeclaredMethods(name)) {
                if (!mn.isDefault()) continue;
                methods.add(mn);
            }
        }
        methods.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode((ClassLoader)this.controller.getSourceUnit().getClassLoader(), type, name));
        return StaticTypeCheckingSupport.filterMethodsByVisibility(methods, this.controller.getClassNode());
    }

    private void addFatalError(String msg, ASTNode node) {
        this.controller.getSourceUnit().addFatalError(msg, node);
        throw new MultipleCompilationErrorsException(this.controller.getSourceUnit().getErrorCollector());
    }

    private static boolean isConstructorReference(String name) {
        return "new".equals(name);
    }

    private static boolean isExtensionMethod(MethodNode mn) {
        return mn instanceof ExtensionMethodNode;
    }

    private static boolean isStaticMethod(MethodNode mn) {
        return StaticTypesMethodReferenceExpressionWriter.isExtensionMethod(mn) ? ((ExtensionMethodNode)mn).isStaticExtension() : mn.isStatic();
    }

    private static boolean isTypeReferringInstanceMethod(Expression typeOrTargetRef, MethodNode mn) {
        return typeOrTargetRef instanceof ClassExpression && mn != null && !StaticTypesMethodReferenceExpressionWriter.isStaticMethod(mn);
    }

    private static Expression makeClassTarget(ClassNode target, Expression source) {
        ClassExpression expression = GeneralUtils.classX((ClassNode)target);
        expression.setSourcePosition((ASTNode)source);
        return expression;
    }

    private static Parameter[] removeFirstParameter(Parameter[] parameters) {
        return Arrays.copyOfRange(parameters, 1, parameters.length);
    }
}

