/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.classgen.asm.sc.StaticPropertyAccessHelper;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;
import org.codehaus.groovy.transform.sc.ListOfExpressionsExpression;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.sc.TemporaryVariableExpression;
import org.codehaus.groovy.transform.sc.transformers.CompareIdentityExpression;
import org.codehaus.groovy.transform.sc.transformers.CompareToNullExpression;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class BinaryExpressionTransformer {
    private static final MethodNode COMPARE_TO_METHOD = ClassHelper.COMPARABLE_TYPE.getMethods("compareTo").get(0);
    private static final ConstantExpression CONSTANT_MINUS_ONE = GeneralUtils.constX((Object)-1, (boolean)true);
    private static final ConstantExpression CONSTANT_ZERO = GeneralUtils.constX((Object)0, (boolean)true);
    private static final ConstantExpression CONSTANT_ONE = GeneralUtils.constX((Object)1, (boolean)true);
    private int tmpVarCounter;
    private final StaticCompilationTransformer staticCompilationTransformer;

    public BinaryExpressionTransformer(StaticCompilationTransformer staticCompilationTransformer) {
        this.staticCompilationTransformer = staticCompilationTransformer;
    }

    /*
     * WARNING - void declaration
     */
    public Expression transformBinaryExpression(BinaryExpression bin) {
        Expression right;
        Expression left;
        Expression optimized;
        if (bin instanceof DeclarationExpression && (optimized = BinaryExpressionTransformer.transformDeclarationExpression(bin)) != null) {
            return optimized;
        }
        Object[] list = (Object[])bin.getNodeMetaData((Object)StaticCompilationMetadataKeys.BINARY_EXP_TARGET);
        Token operation = bin.getOperation();
        int operationType = operation.getType();
        Expression rightExpression = bin.getRightExpression();
        Expression leftExpression = bin.getLeftExpression();
        if (bin instanceof DeclarationExpression && leftExpression instanceof VariableExpression) {
            ClassNode declarationType = ((VariableExpression)leftExpression).getOriginType();
            if (rightExpression instanceof ConstantExpression) {
                ConstantExpression constant;
                ClassNode unwrapper = ClassHelper.getUnwrapper(declarationType);
                ClassNode wrapper = ClassHelper.getWrapper(declarationType);
                if (!rightExpression.getType().equals(declarationType) && wrapper.isDerivedFrom(ClassHelper.Number_TYPE) && WideningCategories.isDoubleCategory((ClassNode)unwrapper) && !(constant = (ConstantExpression)rightExpression).isNullExpression()) {
                    return BinaryExpressionTransformer.optimizeConstantInitialization(bin, operation, constant, leftExpression, declarationType);
                }
            }
        }
        if (operationType == 100) {
            MethodNode directMCT = (MethodNode)leftExpression.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            if (directMCT != null) {
                left = this.staticCompilationTransformer.transform(leftExpression);
                right = this.staticCompilationTransformer.transform(rightExpression);
                if (left instanceof PropertyExpression) {
                    PropertyExpression pe = (PropertyExpression)left;
                    return BinaryExpressionTransformer.transformAssignmentToSetterCall(pe.getObjectExpression(), directMCT, right, false, pe.isSafe(), pe.getProperty(), (Expression)bin);
                }
                if (left instanceof VariableExpression) {
                    return BinaryExpressionTransformer.transformAssignmentToSetterCall((Expression)GeneralUtils.varX((String)"this"), directMCT, right, true, false, left, (Expression)bin);
                }
            }
        } else if (operationType == 123 || operationType == 120) {
            CompareToNullExpression compareToNullExpression = null;
            if (ExpressionUtils.isNullConstant(leftExpression)) {
                compareToNullExpression = new CompareToNullExpression(this.staticCompilationTransformer.transform(rightExpression), operationType == 123);
            } else if (ExpressionUtils.isNullConstant(rightExpression)) {
                compareToNullExpression = new CompareToNullExpression(this.staticCompilationTransformer.transform(leftExpression), operationType == 123);
            }
            if (compareToNullExpression != null) {
                compareToNullExpression.setSourcePosition((ASTNode)bin);
                return compareToNullExpression;
            }
        } else if (operationType == 121 || operationType == 122) {
            CompareToNullExpression ctn;
            if (ExpressionUtils.isNullConstant(rightExpression)) {
                ctn = new CompareToNullExpression(this.staticCompilationTransformer.transform(leftExpression), operationType == 121);
                ctn.setSourcePosition((ASTNode)bin);
                return ctn;
            }
            if (ExpressionUtils.isNullConstant(leftExpression)) {
                ctn = new CompareToNullExpression(this.staticCompilationTransformer.transform(rightExpression), operationType == 121);
                ctn.setSourcePosition((ASTNode)bin);
                return ctn;
            }
            if (!ClassHelper.isPrimitiveType(this.findType(rightExpression)) && !ClassHelper.isPrimitiveType(this.findType(leftExpression))) {
                CompareIdentityExpression cid = new CompareIdentityExpression(this.staticCompilationTransformer.transform(leftExpression), operationType == 121, this.staticCompilationTransformer.transform(rightExpression));
                cid.setSourcePosition((ASTNode)bin);
                return cid;
            }
        } else if (operationType == 128) {
            ClassNode rightType;
            ClassNode leftType = this.findType(leftExpression);
            if (leftType.equals(rightType = this.findType(rightExpression)) && ClassHelper.isPrimitiveType(leftType) || ClassHelper.isPrimitiveType(rightType)) {
                ClassNode wrapperType = ClassHelper.getWrapper(leftType);
                ArgumentListExpression leftAndRight = GeneralUtils.args((Expression[])new Expression[]{this.staticCompilationTransformer.transform(leftExpression), this.staticCompilationTransformer.transform(rightExpression)});
                MethodCallExpression call = GeneralUtils.callX((Expression)GeneralUtils.classX((ClassNode)wrapperType), (String)"compare", (Expression)leftAndRight);
                call.putNodeMetaData(StaticTypesMarker.INFERRED_TYPE, ClassHelper.int_TYPE);
                call.setMethodTarget(wrapperType.getMethods("compare").get(0));
                call.setImplicitThis(false);
                call.setSourcePosition((ASTNode)bin);
                return call;
            }
        } else if (operationType == 573) {
            return this.staticCompilationTransformer.transform(BinaryExpressionTransformer.convertInOperatorToTernary(bin, rightExpression, leftExpression));
        }
        if (list != null) {
            BinaryExpression binaryExpression;
            MethodCallExpression call;
            left = this.staticCompilationTransformer.transform(leftExpression);
            right = this.staticCompilationTransformer.transform(rightExpression);
            if (operationType == 128 && this.findType(leftExpression).implementsInterface(ClassHelper.COMPARABLE_TYPE) && this.findType(rightExpression).implementsInterface(ClassHelper.COMPARABLE_TYPE)) {
                left = BinaryExpressionTransformer.transformRepeatedReference(left);
                right = BinaryExpressionTransformer.transformRepeatedReference(right);
                call = GeneralUtils.callX((Expression)left, (String)"compareTo", (Expression)GeneralUtils.args((Expression[])new Expression[]{right}));
                call.setImplicitThis(false);
                call.setMethodTarget(COMPARE_TO_METHOD);
                call.setSourcePosition((ASTNode)bin);
                TernaryExpression expr = GeneralUtils.ternaryX((Expression)GeneralUtils.boolX((Expression)new CompareToNullExpression(right, true)), (Expression)CONSTANT_ONE, (Expression)call);
                expr.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, (Object)ClassHelper.int_TYPE);
                expr = GeneralUtils.ternaryX((Expression)GeneralUtils.boolX((Expression)new CompareToNullExpression(left, true)), (Expression)CONSTANT_MINUS_ONE, (Expression)expr);
                expr.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, (Object)ClassHelper.int_TYPE);
                expr = GeneralUtils.ternaryX((Expression)GeneralUtils.boolX((Expression)new CompareIdentityExpression(left, right)), (Expression)CONSTANT_ZERO, (Expression)expr);
                expr.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, (Object)ClassHelper.int_TYPE);
                expr.putNodeMetaData((Object)"classgen.callback", BinaryExpressionTransformer.classgenCallback(right).andThen(BinaryExpressionTransformer.classgenCallback(left)));
                return expr;
            }
            BinaryExpression optimized2 = BinaryExpressionTransformer.tryOptimizeCharComparison(left, right, bin);
            if (optimized2 != null) {
                optimized2.removeNodeMetaData((Object)StaticCompilationMetadataKeys.BINARY_EXP_TARGET);
                optimized2.removeNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                return optimized2;
            }
            String name = (String)list[1];
            MethodNode node = (MethodNode)list[0];
            boolean isAssignment = Types.isAssignment((int)operationType);
            Expression expr = left;
            MethodNode adapter = StaticCompilationTransformer.BYTECODE_BINARY_ADAPTERS.get(operationType);
            if (adapter != null) {
                ClassExpression classExpression = GeneralUtils.classX((ClassNode)StaticCompilationTransformer.BYTECODE_ADAPTER_CLASS);
                call = GeneralUtils.callX((Expression)classExpression, (String)adapter.getName(), (Expression)GeneralUtils.args((Expression[])new Expression[]{expr, right}));
                call.setMethodTarget(adapter);
            } else {
                call = GeneralUtils.callX((Expression)expr, (String)name, (Expression)GeneralUtils.args((Expression[])new Expression[]{right}));
                call.setMethodTarget(node);
            }
            call.setImplicitThis(false);
            if (!isAssignment) {
                call.setSourcePosition((ASTNode)bin);
                return call;
            }
            expr = GeneralUtils.binX((Expression)left, (Token)Token.newSymbol((int)100, (int)operation.getStartLine(), (int)operation.getStartColumn()), (Expression)call);
            if (left instanceof BinaryExpression && (binaryExpression = (BinaryExpression)left).getOperation().getType() == 30) {
                binaryExpression.setLeftExpression(BinaryExpressionTransformer.transformRepeatedReference(binaryExpression.getLeftExpression()));
                binaryExpression.setRightExpression(BinaryExpressionTransformer.transformRepeatedReference(binaryExpression.getRightExpression()));
                expr.putNodeMetaData((Object)"classgen.callback", BinaryExpressionTransformer.classgenCallback(binaryExpression.getRightExpression()).andThen(BinaryExpressionTransformer.classgenCallback(binaryExpression.getLeftExpression())));
            }
            expr.putNodeMetaData((Object)"original.operator", (Object)operation);
            call.setObjectExpression(new ExpressionTransformer(){

                public Expression transform(Expression expression) {
                    if (expression == null) {
                        return null;
                    }
                    Expression transformed = expression.transformExpression((ExpressionTransformer)this);
                    if (transformed.getEnd() > 0 || transformed.getLineNumber() > 0) {
                        if (transformed != expression) {
                            transformed.setStart(0);
                            transformed.setEnd(-1);
                            transformed.setNameStart(0);
                            transformed.setNameEnd(-1);
                            transformed.setLineNumber(-1);
                            transformed.setColumnNumber(-1);
                            transformed.setLastLineNumber(-1);
                            transformed.setLastColumnNumber(-1);
                        } else if (expression instanceof ConstantExpression) {
                            ConstantExpression ce = (ConstantExpression)expression;
                            ConstantExpression copy = new ConstantExpression(ce.getValue());
                            copy.setConstantName(ce.getConstantName());
                            copy.setDeclaringClass(ce.getDeclaringClass());
                            copy.setSynthetic(ce.isSynthetic());
                            copy.setType(ce.getType());
                            copy.copyNodeMetaData((ASTNode)((Object)ce));
                            transformed = copy;
                        } else if (expression instanceof VariableExpression) {
                            VariableExpression ve = (VariableExpression)expression;
                            VariableExpression copy = new VariableExpression(ve.getName(), ve.getOriginType());
                            copy.setAccessedVariable(ve.getAccessedVariable());
                            copy.setClosureSharedVariable(ve.isClosureSharedVariable());
                            copy.setDeclaringClass(ve.getDeclaringClass());
                            if (ve.isDynamicTyped()) {
                                copy.setType(ClassHelper.DYNAMIC_TYPE);
                            }
                            copy.setInStaticContext(ve.isInStaticContext());
                            copy.setModifiers(ve.getModifiers());
                            copy.setSynthetic(ve.isSynthetic());
                            copy.setType(ve.getType());
                            copy.setUseReferenceDirectly(ve.isUseReferenceDirectly());
                            copy.copyNodeMetaData((ASTNode)ve);
                            transformed = copy;
                        }
                    }
                    return transformed;
                }
            }.transform(left));
            expr.setSourcePosition((ASTNode)bin);
            return expr;
        }
        if (operationType == 100 && leftExpression instanceof TupleExpression && rightExpression instanceof ListExpression) {
            ListOfExpressionsExpression cle = new ListOfExpressionsExpression();
            boolean isDeclaration = bin instanceof DeclarationExpression;
            List leftExpressions = ((TupleExpression)leftExpression).getExpressions();
            List rightExpressions = ((ListExpression)rightExpression).getExpressions();
            Iterator leftIt = leftExpressions.iterator();
            Iterator rightIt = rightExpressions.iterator();
            if (isDeclaration) {
                while (leftIt.hasNext()) {
                    Expression left2 = (Expression)leftIt.next();
                    if (!rightIt.hasNext()) continue;
                    Expression right2 = (Expression)rightIt.next();
                    DeclarationExpression bexp = new DeclarationExpression(left2, operation, right2);
                    bexp.setSourcePosition((ASTNode)right2);
                    cle.addExpression((Expression)bexp);
                }
            } else {
                void var16_29;
                int size = rightExpressions.size();
                ArrayList<DeclarationExpression> tmpAssignments = new ArrayList<DeclarationExpression>(size);
                ArrayList<DeclarationExpression> finalAssignments = new ArrayList<DeclarationExpression>(size);
                boolean bl = false;
                int n = Math.min(size, leftExpressions.size());
                while (var16_29 < n) {
                    Expression left3 = (Expression)leftIt.next();
                    Expression right3 = (Expression)rightIt.next();
                    VariableExpression tmpVar = GeneralUtils.varX((String)("$tmpVar$" + this.tmpVarCounter++));
                    DeclarationExpression bexp = new DeclarationExpression(tmpVar, operation, right3);
                    bexp.setSourcePosition((ASTNode)right3);
                    tmpAssignments.add(bexp);
                    bexp = GeneralUtils.binX((Expression)left3, (Token)operation, (Expression)GeneralUtils.varX((Variable)tmpVar));
                    bexp.setSourcePosition((ASTNode)left3);
                    finalAssignments.add(bexp);
                    ++var16_29;
                }
                for (Expression expression : tmpAssignments) {
                    cle.addExpression(expression);
                }
                for (Expression expression : finalAssignments) {
                    cle.addExpression(expression);
                }
            }
            return this.staticCompilationTransformer.transform((Expression)cle);
        }
        return this.staticCompilationTransformer.superTransform((Expression)bin);
    }

    private ClassNode findType(Expression expression) {
        ClassNode classNode = this.staticCompilationTransformer.getClassNode();
        return this.staticCompilationTransformer.getTypeChooser().resolveType(expression, classNode);
    }

    private static BinaryExpression tryOptimizeCharComparison(Expression left, Expression right, BinaryExpression bin) {
        int op = bin.getOperation().getType();
        if (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123 || op == 120) {
            Character cLeft = BinaryExpressionTransformer.tryCharConstant(left);
            Character cRight = BinaryExpressionTransformer.tryCharConstant(right);
            if (cLeft != null || cRight != null) {
                Expression oRight;
                Expression oLeft;
                Object object = oLeft = cLeft == null ? left : GeneralUtils.constX((Object)cLeft, (boolean)true);
                if (oLeft instanceof PropertyExpression && !BinaryExpressionTransformer.hasCharType((PropertyExpression)oLeft)) {
                    return null;
                }
                oLeft.setSourcePosition((ASTNode)left);
                Object object2 = oRight = cRight == null ? right : GeneralUtils.constX((Object)cRight, (boolean)true);
                if (oRight instanceof PropertyExpression && !BinaryExpressionTransformer.hasCharType((PropertyExpression)oRight)) {
                    return null;
                }
                oRight.setSourcePosition((ASTNode)right);
                bin.setLeftExpression(oLeft);
                bin.setRightExpression(oRight);
                return bin;
            }
        }
        return null;
    }

    private static boolean hasCharType(PropertyExpression pe) {
        ClassNode inferredType = (ClassNode)pe.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        return inferredType != null && ClassHelper.Character_TYPE.equals(ClassHelper.getWrapper(inferredType));
    }

    private static Character tryCharConstant(Expression expr) {
        String value;
        if (expr instanceof ConstantExpression && ClassHelper.STRING_TYPE.equals(expr.getType()) && (value = (String)((ConstantExpression)expr).getValue()) != null && value.length() == 1) {
            return Character.valueOf(value.charAt(0));
        }
        return null;
    }

    private static Expression transformDeclarationExpression(BinaryExpression bin) {
        Expression rightExpression;
        Character c;
        Expression leftExpression = bin.getLeftExpression();
        if (leftExpression instanceof VariableExpression && ClassHelper.char_TYPE.equals(((VariableExpression)leftExpression).getOriginType()) && (c = BinaryExpressionTransformer.tryCharConstant(rightExpression = bin.getRightExpression())) != null) {
            ConstantExpression ce = GeneralUtils.constX((Object)c, (boolean)true);
            ce.setSourcePosition((ASTNode)rightExpression);
            bin.setRightExpression((Expression)ce);
            return bin;
        }
        return null;
    }

    private static Expression convertInOperatorToTernary(BinaryExpression bin, Expression rightExpression, Expression leftExpression) {
        MethodCallExpression call = GeneralUtils.callX((Expression)rightExpression, (String)"isCase", (Expression)leftExpression);
        call.setMethodTarget((MethodNode)bin.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
        call.setSourcePosition((ASTNode)bin);
        call.copyNodeMetaData((ASTNode)bin);
        call.setImplicitThis(false);
        if (rightExpression instanceof ListExpression || rightExpression instanceof MapExpression || rightExpression instanceof RangeExpression || rightExpression instanceof ClassExpression || rightExpression instanceof ConstantExpression && !ExpressionUtils.isNullConstant(rightExpression)) {
            return call;
        }
        rightExpression = BinaryExpressionTransformer.transformRepeatedReference(rightExpression);
        call.setObjectExpression(rightExpression);
        TernaryExpression tExp = GeneralUtils.ternaryX((Expression)GeneralUtils.boolX((Expression)GeneralUtils.binX((Expression)rightExpression, (Token)Token.newSymbol((String)"==", (int)-1, (int)-1), (Expression)GeneralUtils.nullX())), (Expression)GeneralUtils.binX((Expression)leftExpression, (Token)Token.newSymbol((String)"==", (int)-1, (int)-1), (Expression)GeneralUtils.nullX()), (Expression)call);
        tExp.putNodeMetaData((Object)"classgen.callback", BinaryExpressionTransformer.classgenCallback(call.getObjectExpression()));
        return tExp;
    }

    private static Expression transformRepeatedReference(Expression exp) {
        if (exp instanceof ConstantExpression || exp instanceof VariableExpression && ((VariableExpression)exp).getAccessedVariable() instanceof Parameter) {
            return exp;
        }
        return new TemporaryVariableExpression(exp);
    }

    private static Consumer<WriterController> classgenCallback(Expression source) {
        return source instanceof TemporaryVariableExpression ? arg_0 -> ((TemporaryVariableExpression)((TemporaryVariableExpression)source)).remove(arg_0) : wc -> {};
    }

    private static DeclarationExpression optimizeConstantInitialization(BinaryExpression originalDeclaration, Token operation, ConstantExpression constant, Expression leftExpression, ClassNode declarationType) {
        ConstantExpression cexp = GeneralUtils.constX((Object)BinaryExpressionTransformer.convertConstant((Number)constant.getValue(), ClassHelper.getWrapper(declarationType)), (boolean)true);
        cexp.setType(declarationType);
        cexp.setSourcePosition((ASTNode)((Object)constant));
        DeclarationExpression result = new DeclarationExpression(leftExpression, operation, (Expression)cexp);
        result.setSourcePosition((ASTNode)originalDeclaration);
        result.copyNodeMetaData((ASTNode)originalDeclaration);
        return result;
    }

    private static Object convertConstant(Number source, ClassNode target) {
        if (ClassHelper.Byte_TYPE.equals(target)) {
            return source.byteValue();
        }
        if (ClassHelper.Short_TYPE.equals(target)) {
            return source.shortValue();
        }
        if (ClassHelper.Integer_TYPE.equals(target)) {
            return source.intValue();
        }
        if (ClassHelper.Long_TYPE.equals(target)) {
            return source.longValue();
        }
        if (ClassHelper.Float_TYPE.equals(target)) {
            return Float.valueOf(source.floatValue());
        }
        if (ClassHelper.Double_TYPE.equals(target)) {
            return source.doubleValue();
        }
        if (ClassHelper.BigInteger_TYPE.equals(target)) {
            return DefaultGroovyMethods.asType((Number)source, BigInteger.class);
        }
        if (ClassHelper.BigDecimal_TYPE.equals(target)) {
            return DefaultGroovyMethods.asType((Number)source, BigDecimal.class);
        }
        throw new IllegalArgumentException("Unsupported conversion");
    }

    private static Expression transformAssignmentToSetterCall(Expression receiver, MethodNode setterMethod, Expression valueExpression, boolean implicitThis, boolean safeNavigation, Expression nameExpression, Expression binaryExpression) {
        PropertyExpression pos = new PropertyExpression(null, nameExpression);
        pos.setSourcePosition((ASTNode)binaryExpression);
        return StaticPropertyAccessHelper.transformToSetterCall(receiver, setterMethod, valueExpression, implicitThis, safeNavigation, false, true, (Expression)pos);
    }
}

