/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import groovy.lang.DelegatesTo;
import groovy.lang.IntRange;
import groovy.lang.Tuple2;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import groovy.transform.TypeChecked;
import groovy.transform.TypeCheckingMode;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.ClosureSignatureConflictResolver;
import groovy.transform.stc.ClosureSignatureHint;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.groovy.util.BeanUtils;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.LambdaExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.MethodReferenceExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.ReturnAdder;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.TokenUtil;
import org.codehaus.groovy.transform.stc.DefaultTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.DelegationMetadata;
import org.codehaus.groovy.transform.stc.EnumTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.Receiver;
import org.codehaus.groovy.transform.stc.SecondPassExpression;
import org.codehaus.groovy.transform.stc.SharedVariableCollector;
import org.codehaus.groovy.transform.stc.SignatureCodec;
import org.codehaus.groovy.transform.stc.SignatureCodecVersion1;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.codehaus.groovy.transform.stc.TraitTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.TypeCheckingContext;
import org.codehaus.groovy.transform.stc.TypeCheckingExtension;
import org.codehaus.groovy.transform.stc.UnionTypeClassNode;
import org.codehaus.groovy.transform.trait.Traits;

public class StaticTypeCheckingVisitor
extends ClassCodeVisitorSupport {
    private static final boolean DEBUG_GENERATED_CODE = Boolean.getBoolean("groovy.stc.debug");
    private static final AtomicLong UNIQUE_LONG = new AtomicLong();
    protected static final Object ERROR_COLLECTOR = ErrorCollector.class;
    protected static final List<MethodNode> EMPTY_METHODNODE_LIST = Collections.emptyList();
    protected static final ClassNode TYPECHECKED_CLASSNODE = ClassHelper.make(TypeChecked.class);
    protected static final ClassNode[] TYPECHECKING_ANNOTATIONS = new ClassNode[]{TYPECHECKED_CLASSNODE};
    protected static final ClassNode DGM_CLASSNODE = ClassHelper.make(DefaultGroovyMethods.class);
    protected static final int CURRENT_SIGNATURE_PROTOCOL_VERSION = 1;
    protected static final Expression CURRENT_SIGNATURE_PROTOCOL = new ConstantExpression(1, true);
    protected static final MethodNode GET_DELEGATE = ClassHelper.CLOSURE_TYPE.getGetterMethod("getDelegate");
    protected static final MethodNode GET_OWNER = ClassHelper.CLOSURE_TYPE.getGetterMethod("getOwner");
    protected static final MethodNode GET_THISOBJECT = ClassHelper.CLOSURE_TYPE.getGetterMethod("getThisObject");
    protected static final ClassNode DELEGATES_TO = ClassHelper.make(DelegatesTo.class);
    protected static final ClassNode DELEGATES_TO_TARGET = ClassHelper.make(DelegatesTo.Target.class);
    protected static final ClassNode LINKEDHASHMAP_CLASSNODE = StaticTypeCheckingSupport.LinkedHashMap_TYPE;
    protected static final ClassNode CLOSUREPARAMS_CLASSNODE = ClassHelper.make(ClosureParams.class);
    protected static final ClassNode NAMED_PARAMS_CLASSNODE = ClassHelper.make(NamedParams.class);
    protected static final ClassNode NAMED_PARAM_CLASSNODE = ClassHelper.make(NamedParam.class);
    protected static final ClassNode ENUMERATION_TYPE = ClassHelper.make(Enumeration.class);
    protected static final ClassNode MAP_ENTRY_TYPE = ClassHelper.make(Map.Entry.class);
    protected static final ClassNode ITERABLE_TYPE = ClassHelper.make(Iterable.class);
    private static final ClassNode STREAM_TYPE = ClassHelper.make(Stream.class);
    private static final ClassNode SET_TYPE = ClassHelper.make(Set.class);
    public static final Statement GENERATED_EMPTY_STATEMENT = EmptyStatement.INSTANCE;
    public static final MethodNode CLOSURE_CALL_NO_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", Parameter.EMPTY_ARRAY);
    public static final MethodNode CLOSURE_CALL_ONE_ARG = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "arg")});
    public static final MethodNode CLOSURE_CALL_VARGS = ClassHelper.CLOSURE_TYPE.getDeclaredMethod("call", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE.makeArray(), "args")});
    protected final ReturnAdder.ReturnStatementListener returnListener = new ReturnAdder.ReturnStatementListener(){

        public void returnStatementAdded(ReturnStatement returnStatement) {
            if (StaticTypeCheckingVisitor.isNullConstant(returnStatement.getExpression())) {
                return;
            }
            ClassNode returnType = StaticTypeCheckingVisitor.this.checkReturnType(returnStatement);
            if (StaticTypeCheckingVisitor.this.typeCheckingContext.getEnclosingClosure() != null) {
                StaticTypeCheckingVisitor.this.addClosureReturnType(returnType);
            } else if (StaticTypeCheckingVisitor.this.typeCheckingContext.getEnclosingMethod() == null) {
                throw new GroovyBugError("Unexpected return statement at " + returnStatement.getLineNumber() + ":" + returnStatement.getColumnNumber() + " " + returnStatement.getText());
            }
        }
    };
    protected final ReturnAdder returnAdder = new ReturnAdder(this.returnListener);
    protected FieldNode currentField;
    protected PropertyNode currentProperty;
    protected DefaultTypeCheckingExtension extension;
    protected TypeCheckingContext typeCheckingContext = new TypeCheckingContext(this);
    private static final List<ClassNode> TUPLE_TYPES = Collections.unmodifiableList(Arrays.stream(ClassHelper.TUPLE_CLASSES).map(ClassHelper::makeWithoutCaching).collect(Collectors.toList()));

    public StaticTypeCheckingVisitor(SourceUnit source, ClassNode classNode) {
        this.typeCheckingContext.pushEnclosingClassNode(classNode);
        this.typeCheckingContext.pushTemporaryTypeInfo();
        this.typeCheckingContext.pushErrorCollector(source.getErrorCollector());
        this.typeCheckingContext.source = source;
        this.extension = new DefaultTypeCheckingExtension(this);
        this.extension.addHandler((TypeCheckingExtension)new EnumTypeCheckingExtension(this));
        this.extension.addHandler((TypeCheckingExtension)new TraitTypeCheckingExtension(this));
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.typeCheckingContext.getSource();
    }

    public void initialize() {
        this.extension.setup();
    }

    public TypeCheckingContext getTypeCheckingContext() {
        return this.typeCheckingContext;
    }

    public void addTypeCheckingExtension(TypeCheckingExtension extension) {
        this.extension.addHandler(extension);
    }

    public void setCompilationUnit(CompilationUnit compilationUnit) {
        this.typeCheckingContext.setCompilationUnit(compilationUnit);
    }

    @Override
    public void visitClass(ClassNode node) {
        if (this.shouldSkipClassNode(node)) {
            return;
        }
        if (!this.extension.beforeVisitClass(node)) {
            Object type = node.getNodeMetaData(StaticTypesMarker.INFERRED_TYPE);
            if (type != null) {
                this.typeCheckingContext.pushErrorCollector();
            }
            this.typeCheckingContext.pushEnclosingClassNode(node);
            Set oldSet = this.typeCheckingContext.alreadyVisitedMethods;
            this.typeCheckingContext.alreadyVisitedMethods = new LinkedHashSet();
            super.visitClass(node);
            node.getInnerClasses().forEachRemaining(this::visitClass);
            this.typeCheckingContext.alreadyVisitedMethods = oldSet;
            this.typeCheckingContext.popEnclosingClassNode();
            if (type != null) {
                this.typeCheckingContext.popErrorCollector();
            }
            node.putNodeMetaData(StaticTypesMarker.INFERRED_TYPE, node);
            node.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
            node.getMethods().forEach(n -> {
                Object object = n.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
            });
            node.getDeclaredConstructors().forEach(n -> {
                Object object = n.putNodeMetaData(StaticTypeCheckingVisitor.class, (Object)Boolean.TRUE);
            });
        }
        this.extension.afterVisitClass(node);
    }

    protected ClassNode[] getTypeCheckingAnnotations() {
        return TYPECHECKING_ANNOTATIONS;
    }

    protected boolean shouldSkipClassNode(ClassNode node) {
        return Boolean.TRUE.equals(node.getNodeMetaData(StaticTypeCheckingVisitor.class)) || this.isSkipMode(node);
    }

    public boolean isSkipMode(AnnotatedNode node) {
        if (node == null) {
            return false;
        }
        ClassNode[] classNodeArray = this.getTypeCheckingAnnotations();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode tca = classNodeArray[n2];
            List<AnnotationNode> annotations = node.getAnnotations(tca);
            if (annotations != null) {
                for (AnnotationNode annotation : annotations) {
                    Expression value = annotation.getMember("value");
                    if (value == null) continue;
                    if (value instanceof ConstantExpression) {
                        ConstantExpression ce = (ConstantExpression)value;
                        if (!TypeCheckingMode.SKIP.toString().equals(ce.getValue().toString())) continue;
                        return true;
                    }
                    if (!(value instanceof PropertyExpression)) continue;
                    PropertyExpression pe = (PropertyExpression)value;
                    if (!TypeCheckingMode.SKIP.toString().equals(pe.getPropertyAsString())) continue;
                    return true;
                }
            }
            ++n2;
        }
        if (node instanceof MethodNode) {
            return this.isSkipMode(node.getDeclaringClass());
        }
        return this.isSkippedInnerClass(node);
    }

    protected boolean isSkippedInnerClass(AnnotatedNode node) {
        MethodNode enclosingMethod;
        ClassNode type;
        return node instanceof ClassNode && (type = (ClassNode)node).getOuterClass() != null && (enclosingMethod = type.getEnclosingMethod()) != null && this.isSkipMode(enclosingMethod);
    }

    public void visitClassExpression(ClassExpression expression) {
        super.visitClassExpression(expression);
        ClassNode cn = (ClassNode)expression.getNodeMetaData(StaticTypesMarker.INFERRED_TYPE);
        if (cn == null) {
            this.storeType(expression, this.getType((ASTNode)((Object)expression)));
        }
    }

    private static ClassNode getOutermost(ClassNode cn) {
        while (cn.getOuterClass() != null) {
            cn = cn.getOuterClass();
        }
        return cn;
    }

    private static void addPrivateFieldOrMethodAccess(Expression source, ClassNode cn, StaticTypesMarker key, ASTNode accessedMember) {
        ((LinkedHashSet)cn.getNodeMetaData(key, x -> new LinkedHashSet())).add(accessedMember);
        source.putNodeMetaData((Object)key, (Object)accessedMember);
    }

    private void checkOrMarkPrivateAccess(Expression source, FieldNode fn, boolean lhsOfAssignment) {
        ClassNode enclosingClass;
        if (fn == null || !fn.isPrivate()) {
            return;
        }
        ClassNode declaringClass = fn.getDeclaringClass();
        if (declaringClass == (enclosingClass = this.typeCheckingContext.getEnclosingClassNode()) && this.typeCheckingContext.getEnclosingClosure() == null) {
            return;
        }
        if (declaringClass == enclosingClass || StaticTypeCheckingVisitor.getOutermost(declaringClass) == StaticTypeCheckingVisitor.getOutermost(enclosingClass)) {
            StaticTypesMarker accessKind = lhsOfAssignment ? StaticTypesMarker.PV_FIELDS_MUTATION : StaticTypesMarker.PV_FIELDS_ACCESS;
            StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, declaringClass, accessKind, (ASTNode)fn);
        }
    }

    private void checkOrMarkPrivateAccess(Expression source, MethodNode mn) {
        ClassNode enclosingClassNode;
        if (mn == null) {
            return;
        }
        ClassNode declaringClass = mn.getDeclaringClass();
        if (declaringClass != (enclosingClassNode = this.typeCheckingContext.getEnclosingClassNode()) || this.typeCheckingContext.getEnclosingClosure() != null) {
            int mods = mn.getModifiers();
            boolean sameModule = declaringClass.getModule() == enclosingClassNode.getModule();
            String packageName = declaringClass.getPackageName();
            if (packageName == null) {
                packageName = "";
            }
            if (Modifier.isPrivate(mods) && sameModule) {
                StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, declaringClass, StaticTypesMarker.PV_METHODS_ACCESS, mn);
            } else if (Modifier.isProtected(mods) && !packageName.equals(enclosingClassNode.getPackageName()) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(enclosingClassNode, declaringClass)) {
                ClassNode cn = enclosingClassNode;
                while ((cn = cn.getOuterClass()) != null) {
                    if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(cn, declaringClass)) continue;
                    StaticTypeCheckingVisitor.addPrivateFieldOrMethodAccess(source, cn, StaticTypesMarker.PV_METHODS_ACCESS, mn);
                    break;
                }
            }
        }
    }

    public void visitVariableExpression(VariableExpression vexp) {
        block46: {
            TypeCheckingContext.EnclosingClosure enclosingClosure;
            Variable accessedVariable;
            String name;
            block43: {
                block44: {
                    super.visitVariableExpression(vexp);
                    if (this.storeTypeForSuper(vexp)) {
                        return;
                    }
                    if (this.storeTypeForThis(vexp)) {
                        return;
                    }
                    name = vexp.getName();
                    accessedVariable = vexp.getAccessedVariable();
                    enclosingClosure = this.typeCheckingContext.getEnclosingClosure();
                    if (accessedVariable == null) {
                        return;
                    }
                    if (!(accessedVariable instanceof DynamicVariable)) break block43;
                    if (enclosingClosure == null) break block44;
                    switch (name) {
                        case "delegate": {
                            DelegationMetadata dm = this.getDelegationMetadata(enclosingClosure.getClosureExpression());
                            if (dm != null) {
                                this.storeType((Expression)vexp, dm.getType());
                                return;
                            }
                        }
                        case "owner": {
                            if (this.typeCheckingContext.getEnclosingClosureStack().size() > 1) {
                                this.storeType((Expression)vexp, ClassHelper.CLOSURE_TYPE);
                                return;
                            }
                        }
                        case "thisObject": {
                            this.storeType((Expression)vexp, this.typeCheckingContext.getEnclosingClassNode());
                            return;
                        }
                        case "parameterTypes": {
                            this.storeType((Expression)vexp, ClassHelper.CLASS_Type.makeArray());
                            return;
                        }
                        case "directive": 
                        case "resolveStrategy": 
                        case "maximumNumberOfParameters": {
                            this.storeType((Expression)vexp, ClassHelper.int_TYPE);
                            return;
                        }
                    }
                }
                if (this.tryVariableExpressionAsProperty(vexp, name)) {
                    return;
                }
                if (!this.extension.handleUnresolvedVariableExpression(vexp)) {
                    this.addStaticTypeError("The variable [" + name + "] is undeclared.", (ASTNode)vexp);
                }
                break block46;
            }
            if (accessedVariable instanceof FieldNode) {
                FieldNode accessedField = (FieldNode)accessedVariable;
                ClassNode temporaryType = this.getInferredTypeFromTempInfo((Expression)vexp, null);
                if (enclosingClosure != null) {
                    this.tryVariableExpressionAsProperty(vexp, name);
                } else if (StaticTypeCheckingVisitor.getOutermost(accessedField.getDeclaringClass()) == StaticTypeCheckingVisitor.getOutermost(this.typeCheckingContext.getEnclosingClassNode()) || !this.tryVariableExpressionAsProperty(vexp, name)) {
                    this.checkOrMarkPrivateAccess((Expression)vexp, accessedField, this.typeCheckingContext.isTargetOfEnclosingAssignment((Expression)vexp));
                    if (temporaryType == null) {
                        this.storeType((Expression)vexp, this.getType((ASTNode)vexp));
                    }
                }
                if (temporaryType != null && !temporaryType.equals(ClassHelper.OBJECT_TYPE)) {
                    vexp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, (Object)temporaryType);
                }
            } else if (accessedVariable instanceof PropertyNode) {
                Expression leftExpression;
                SetterInfo setterInfo;
                BinaryExpression enclosingBinaryExpression;
                if (this.tryVariableExpressionAsProperty(vexp, name) && (enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression()) != null && (setterInfo = StaticTypeCheckingVisitor.removeSetterInfo(leftExpression = enclosingBinaryExpression.getLeftExpression())) != null) {
                    Expression rightExpression = enclosingBinaryExpression.getRightExpression();
                    this.ensureValidSetter((Expression)vexp, leftExpression, rightExpression, setterInfo);
                }
            } else {
                VariableExpression localVariable;
                if (accessedVariable instanceof Parameter) {
                    Parameter prm = (Parameter)accessedVariable;
                    localVariable = new ParameterVariableExpression(prm);
                } else {
                    localVariable = (VariableExpression)accessedVariable;
                }
                ClassNode inferredType = (ClassNode)localVariable.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                inferredType = this.getInferredTypeFromTempInfo((Expression)localVariable, inferredType);
                if (inferredType != null && !inferredType.equals(ClassHelper.OBJECT_TYPE) && !inferredType.equals(accessedVariable.getOriginType())) {
                    vexp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, (Object)inferredType);
                }
            }
        }
    }

    private boolean storeTypeForSuper(VariableExpression vexp) {
        if (vexp == VariableExpression.SUPER_EXPRESSION) {
            return true;
        }
        if (!vexp.isSuperExpression()) {
            return false;
        }
        this.storeType((Expression)vexp, this.makeSuper());
        return true;
    }

    private boolean storeTypeForThis(VariableExpression vexp) {
        if (vexp == VariableExpression.THIS_EXPRESSION) {
            return true;
        }
        if (!vexp.isThisExpression()) {
            return false;
        }
        this.storeType((Expression)vexp, !ClassHelper.OBJECT_TYPE.equals(vexp.getType()) ? vexp.getType() : this.makeThis());
        return true;
    }

    private boolean tryVariableExpressionAsProperty(VariableExpression vexp, String dynName) {
        PropertyExpression pexp = GeneralUtils.thisPropX((boolean)true, (String)dynName);
        if (this.existsProperty(pexp, !this.typeCheckingContext.isTargetOfEnclosingAssignment((Expression)vexp))) {
            vexp.copyNodeMetaData((ASTNode)pexp.getObjectExpression());
            Object[] objectArray = new Object[]{StaticTypesMarker.IMPLICIT_RECEIVER, StaticTypesMarker.READONLY_PROPERTY, StaticTypesMarker.PV_FIELDS_ACCESS, StaticTypesMarker.PV_FIELDS_MUTATION, StaticTypesMarker.DECLARATION_INFERRED_TYPE, StaticTypesMarker.DIRECT_METHOD_CALL_TARGET};
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                Object val = pexp.getNodeMetaData(key);
                if (val != null) {
                    vexp.putNodeMetaData(key, val);
                }
                ++n2;
            }
            vexp.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            if (!DefaultGroovyMethods.asBoolean(this.getTemporaryTypesForExpression((Expression)vexp))) {
                ClassNode type = (ClassNode)pexp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                this.storeType((Expression)vexp, Optional.ofNullable(type).orElseGet(() -> ((PropertyExpression)pexp).getType()));
            }
            String receiver = (String)vexp.getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER);
            Boolean dynamic = (Boolean)pexp.getNodeMetaData((Object)StaticTypesMarker.DYNAMIC_RESOLUTION);
            if ((receiver != null && !receiver.endsWith("owner") || Boolean.TRUE.equals(dynamic)) && !(vexp.getAccessedVariable() instanceof DynamicVariable)) {
                vexp.setAccessedVariable((Variable)new DynamicVariable(dynName, false));
            }
            return true;
        }
        return false;
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        if (this.existsProperty(expression, !this.typeCheckingContext.isTargetOfEnclosingAssignment((Expression)expression))) {
            return;
        }
        if (!this.extension.handleUnresolvedProperty(expression)) {
            Expression objectExpression = expression.getObjectExpression();
            this.addStaticTypeError("No such property: " + expression.getPropertyAsString() + " for class: " + StaticTypeCheckingSupport.prettyPrintTypeName(this.findCurrentInstanceOfClass(objectExpression, this.getType((ASTNode)objectExpression))), (ASTNode)expression);
        }
    }

    public void visitAttributeExpression(AttributeExpression expression) {
        if (this.existsProperty((PropertyExpression)expression, true)) {
            return;
        }
        if (!this.extension.handleUnresolvedAttribute(expression)) {
            Expression objectExpression = expression.getObjectExpression();
            this.addStaticTypeError("No such attribute: " + expression.getPropertyAsString() + " for class: " + StaticTypeCheckingSupport.prettyPrintTypeName(this.findCurrentInstanceOfClass(objectExpression, this.getType((ASTNode)objectExpression))), (ASTNode)expression);
        }
    }

    public void visitRangeExpression(RangeExpression expression) {
        super.visitRangeExpression(expression);
        ClassNode fromType = ClassHelper.getWrapper(this.getType((ASTNode)expression.getFrom()));
        ClassNode toType = ClassHelper.getWrapper(this.getType((ASTNode)expression.getTo()));
        if (ClassHelper.Integer_TYPE.equals(fromType) && ClassHelper.Integer_TYPE.equals(toType)) {
            this.storeType((Expression)expression, ClassHelper.make(IntRange.class));
        } else {
            ClassNode rangeType = ClassHelper.RANGE_TYPE.getPlainNodeReference();
            rangeType.setGenericsTypes(new GenericsType[]{new GenericsType(WideningCategories.lowestUpperBound((ClassNode)fromType, (ClassNode)toType))});
            this.storeType((Expression)expression, rangeType);
        }
    }

    public void visitNotExpression(NotExpression expression) {
        this.typeCheckingContext.pushTemporaryTypeInfo();
        super.visitNotExpression(expression);
        this.typeCheckingContext.popTemporaryTypeInfo();
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        BinaryExpression enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
        this.typeCheckingContext.pushEnclosingBinaryExpression(expression);
        try {
            boolean isEmptyDeclaration;
            ClassNode resultType;
            ClassNode rType;
            int op = expression.getOperation().getType();
            if (op == 162) {
                this.typeCheckingContext.pushTemporaryTypeInfo();
            }
            Expression leftExpression = expression.getLeftExpression();
            Expression rightExpression = expression.getRightExpression();
            leftExpression.visit((GroovyCodeVisitor)((Object)this));
            SetterInfo setterInfo = StaticTypeCheckingVisitor.removeSetterInfo(leftExpression);
            ClassNode lType = null;
            if (setterInfo != null) {
                if (this.ensureValidSetter((Expression)expression, leftExpression, rightExpression, setterInfo)) {
                    if (op == 162) {
                        this.typeCheckingContext.popTemporaryTypeInfo();
                    }
                    return;
                }
                lType = this.getType((ASTNode)leftExpression);
            } else {
                if (op != 100 && op != 217) {
                    lType = this.getType((ASTNode)leftExpression);
                } else {
                    lType = this.getOriginalDeclarationType(leftExpression);
                    if (ClassHelper.isFunctionalInterface(lType)) {
                        this.processFunctionalInterfaceAssignment(lType, rightExpression);
                    } else if (StaticTypeCheckingVisitor.isClosureWithType(lType) && rightExpression instanceof ClosureExpression) {
                        this.storeInferredReturnType((ASTNode)rightExpression, StaticTypeCheckingSupport.getCombinedBoundType(lType.getGenericsTypes()[0]));
                    }
                }
                rightExpression.visit((GroovyCodeVisitor)((Object)this));
            }
            ClassNode classNode = rType = StaticTypeCheckingVisitor.isNullConstant(rightExpression) && !ClassHelper.isPrimitiveType(lType) ? StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE : this.getInferredTypeFromTempInfo(rightExpression, this.getType((ASTNode)rightExpression));
            if (op == 217) {
                ElvisOperatorExpression fullExpression = GeneralUtils.elvisX((Expression)leftExpression, (Expression)rightExpression);
                fullExpression.setSourcePosition((ASTNode)expression);
                fullExpression.visit((GroovyCodeVisitor)((Object)this));
                resultType = this.getType((ASTNode)fullExpression);
                this.storeType(leftExpression, resultType);
            } else if (op == 573 || op == 129) {
                BinaryExpression reverseExpression = GeneralUtils.binX((Expression)rightExpression, (Token)expression.getOperation(), (Expression)leftExpression);
                resultType = this.getResultType(rType, op, lType, reverseExpression);
                if (resultType == null) {
                    resultType = ClassHelper.boolean_TYPE;
                }
                this.storeTargetMethod((Expression)expression, (MethodNode)reverseExpression.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
            } else {
                resultType = this.getResultType(lType, op, rType, expression);
                if (op == 30 && leftExpression instanceof VariableExpression && leftExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE) == null) {
                    this.storeType(leftExpression, lType);
                } else if (op == 162) {
                    this.typeCheckingContext.popTemporaryTypeInfo();
                }
            }
            if (resultType == null) {
                resultType = lType;
            }
            if (leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).isClosureSharedVariable()) {
                this.typeCheckingContext.secondPassExpressions.add(new SecondPassExpression((Expression)expression));
            }
            if (StaticTypeCheckingSupport.isArrayOp(op) && !lType.isArray() && enclosingBinaryExpression != null && enclosingBinaryExpression.getLeftExpression() == expression && StaticTypeCheckingSupport.isAssignment(enclosingBinaryExpression.getOperation().getType())) {
                Expression enclosingBE_rightExpr = enclosingBinaryExpression.getRightExpression();
                if (!(enclosingBE_rightExpr instanceof ClosureExpression)) {
                    enclosingBE_rightExpr.visit((GroovyCodeVisitor)((Object)this));
                }
                ClassNode[] arguments = new ClassNode[]{rType, this.getType((ASTNode)enclosingBE_rightExpr)};
                List<MethodNode> nodes = this.findMethod(lType.redirect(), "putAt", arguments);
                if (nodes.size() == 1) {
                    this.typeCheckMethodsWithGenericsOrFail(lType, arguments, nodes.get(0), enclosingBE_rightExpr);
                } else if (nodes.isEmpty()) {
                    this.addNoMatchingMethodError(lType, "putAt", arguments, (Expression)enclosingBinaryExpression);
                }
            }
            boolean bl = isEmptyDeclaration = expression instanceof DeclarationExpression && (rightExpression instanceof EmptyExpression || rType == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE);
            if (!isEmptyDeclaration && StaticTypeCheckingSupport.isAssignment(op)) {
                if (rightExpression instanceof ConstructorCallExpression) {
                    this.inferDiamondType((ConstructorCallExpression)rightExpression, lType);
                }
                resultType = StaticTypeCheckingVisitor.adjustForTargetType(resultType, lType);
                ClassNode originType = this.getOriginalDeclarationType(leftExpression);
                this.typeCheckAssignment(expression, leftExpression, originType, rightExpression, resultType);
                if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(StaticTypeCheckingVisitor.wrapTypeIfNecessary(resultType), StaticTypeCheckingVisitor.wrapTypeIfNecessary(originType))) {
                    resultType = originType;
                } else if (ClassHelper.isPrimitiveType(originType) && resultType.equals(ClassHelper.getWrapper(originType))) {
                    resultType = originType;
                } else {
                    int modifiers = resultType.getModifiers();
                    ClassNode enclosingType = this.typeCheckingContext.getEnclosingClassNode();
                    if (!(Modifier.isPublic(modifiers) || enclosingType.equals(resultType) || StaticTypeCheckingVisitor.getOutermost(enclosingType).equals(StaticTypeCheckingVisitor.getOutermost(resultType)) || !Modifier.isPrivate(modifiers) && Objects.equals(enclosingType.getPackageName(), resultType.getPackageName()))) {
                        resultType = originType;
                    } else if (GenericsUtils.hasUnresolvedGenerics(resultType)) {
                        Map<GenericsType.GenericsTypeName, GenericsType> enclosing = StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(this.typeCheckingContext);
                        resultType = StaticTypeCheckingSupport.fullyResolveType(resultType, Optional.ofNullable(enclosing).orElseGet(Collections::emptyMap));
                    }
                }
                if (leftExpression instanceof VariableExpression && this.typeCheckingContext.ifElseForWhileAssignmentTracker != null) {
                    Object accessedVariable = ((VariableExpression)leftExpression).getAccessedVariable();
                    if (accessedVariable instanceof Parameter) {
                        accessedVariable = new ParameterVariableExpression((Parameter)accessedVariable);
                    }
                    if (accessedVariable instanceof VariableExpression) {
                        this.recordAssignment((VariableExpression)accessedVariable, resultType);
                    }
                }
                this.storeType(leftExpression, resultType);
                if (leftExpression instanceof VariableExpression) {
                    Variable targetVariable;
                    if (rightExpression instanceof ClosureExpression) {
                        leftExpression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, (Object)((ClosureExpression)rightExpression).getParameters());
                    } else if (rightExpression instanceof VariableExpression && ((VariableExpression)rightExpression).getAccessedVariable() instanceof Expression && ((Expression)((VariableExpression)rightExpression).getAccessedVariable()).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS) != null && (targetVariable = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)leftExpression)) instanceof ASTNode) {
                        ((ASTNode)targetVariable).putNodeMetaData(StaticTypesMarker.CLOSURE_ARGUMENTS, ((Expression)((VariableExpression)rightExpression).getAccessedVariable()).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS));
                    }
                }
            } else if (op == 544) {
                this.pushInstanceOfTypeInfo(leftExpression, rightExpression);
            }
            if (!isEmptyDeclaration) {
                this.storeType((Expression)expression, resultType);
            }
            this.validateResourceInARM(expression, resultType);
        }
        finally {
            this.typeCheckingContext.popEnclosingBinaryExpression();
        }
    }

    private void validateResourceInARM(BinaryExpression expression, ClassNode lType) {
        if (expression instanceof DeclarationExpression && TryCatchStatement.isResource((Expression)expression) && !lType.implementsInterface(ClassHelper.AUTOCLOSEABLE_TYPE)) {
            this.addError("Resource[" + lType.getName() + "] in ARM should be of type AutoCloseable", (ASTNode)expression);
        }
    }

    private void processFunctionalInterfaceAssignment(ClassNode lhsType, Expression rhsExpression) {
        if (rhsExpression instanceof ClosureExpression) {
            this.inferParameterAndReturnTypesOfClosureOnRHS(lhsType, (ClosureExpression)rhsExpression);
        } else if (rhsExpression instanceof MapExpression) {
            List spec = ((MapExpression)rhsExpression).getMapEntryExpressions();
            if (spec.size() == 1 && ((MapEntryExpression)spec.get(0)).getValueExpression() instanceof ClosureExpression && ClassHelper.findSAM(lhsType).getName().equals(((MapEntryExpression)spec.get(0)).getKeyExpression().getText())) {
                this.inferParameterAndReturnTypesOfClosureOnRHS(lhsType, (ClosureExpression)((MapEntryExpression)spec.get(0)).getValueExpression());
            }
        } else if (rhsExpression instanceof MethodReferenceExpression) {
            LambdaExpression lambdaExpression = this.constructLambdaExpressionForMethodReference(lhsType, (MethodReferenceExpression)rhsExpression);
            this.inferParameterAndReturnTypesOfClosureOnRHS(lhsType, (ClosureExpression)lambdaExpression);
            rhsExpression.putNodeMetaData((Object)StaticTypesMarker.CONSTRUCTED_LAMBDA_EXPRESSION, (Object)lambdaExpression);
            rhsExpression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, Arrays.stream(lambdaExpression.getParameters()).map(Parameter::getType).toArray(ClassNode[]::new));
        }
    }

    private void inferParameterAndReturnTypesOfClosureOnRHS(ClassNode lhsType, ClosureExpression rhsExpression) {
        int n;
        Tuple2<ClassNode[], ClassNode> typeInfo = GenericsUtils.parameterizeSAM(lhsType);
        Parameter[] closureParameters = ClosureUtils.getParametersSafe((ClosureExpression)rhsExpression);
        ClassNode[] samParameterTypes = (ClassNode[])typeInfo.getV1();
        if (samParameterTypes.length == 1 && ClosureUtils.hasImplicitParameter((ClosureExpression)rhsExpression)) {
            Variable it = rhsExpression.getVariableScope().getDeclaredVariable("it");
            closureParameters = new Parameter[]{it instanceof Parameter ? (Parameter)it : new Parameter(ClassHelper.DYNAMIC_TYPE, "")};
        }
        if ((n = closureParameters.length) == samParameterTypes.length) {
            int i = 0;
            while (i < n) {
                Parameter parameter;
                if (samParameterTypes[i] != null && (parameter = closureParameters[i]).isDynamicTyped()) {
                    parameter.setType(samParameterTypes[i]);
                }
                ++i;
            }
        } else {
            String descriptor = StaticTypeCheckingSupport.toMethodParametersString(ClassHelper.findSAM(lhsType).getName(), samParameterTypes);
            this.addStaticTypeError("Wrong number of parameters for method target " + descriptor, (ASTNode)rhsExpression);
        }
        this.storeInferredReturnType((ASTNode)rhsExpression, (ClassNode)typeInfo.getV2());
    }

    private boolean ensureValidSetter(Expression expression, Expression leftExpression, Expression rightExpression, SetterInfo setterInfo) {
        MethodNode methodTarget;
        VariableExpression receiver = GeneralUtils.varX((String)"%", (ClassNode)setterInfo.receiverType);
        receiver.setType(setterInfo.receiverType);
        Function<Expression, MethodNode> setterCall = value -> {
            this.typeCheckingContext.pushEnclosingBinaryExpression(null);
            try {
                MethodCallExpression call = GeneralUtils.callX((Expression)receiver, (String)setterInfo.name, (Expression)value);
                call.setImplicitThis(false);
                this.visitMethodCallExpression(call);
                MethodNode methodNode = (MethodNode)call.getNodeMetaData(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                return methodNode;
            }
            finally {
                this.typeCheckingContext.popEnclosingBinaryExpression();
            }
        };
        Function<MethodNode, ClassNode> setterType = setter -> {
            ClassNode type = setter.getParameters()[0].getOriginType();
            if (!setter.isStatic() && !(setter instanceof ExtensionMethodNode) && GenericsUtils.hasUnresolvedGenerics(type)) {
                type = StaticTypeCheckingSupport.applyGenericsContext(StaticTypeCheckingVisitor.extractPlaceHolders(setterInfo.receiverType, setter.getDeclaringClass()), type);
            }
            return type;
        };
        Expression valueExpression = rightExpression;
        if (StaticTypeCheckingVisitor.isCompoundAssignment(expression)) {
            Token op = ((BinaryExpression)expression).getOperation();
            if (op.getType() == 217) {
                valueExpression = GeneralUtils.elvisX((Expression)leftExpression, (Expression)rightExpression);
            } else {
                op = Token.newSymbol((int)TokenUtil.removeAssignment((int)op.getType()), (int)op.getStartLine(), (int)op.getStartColumn());
                valueExpression = GeneralUtils.binX((Expression)leftExpression, (Token)op, (Expression)rightExpression);
            }
        }
        if ((methodTarget = setterCall.apply(valueExpression)) == null && !StaticTypeCheckingVisitor.isCompoundAssignment(expression)) {
            for (MethodNode setter2 : setterInfo.setters) {
                ClassNode lType = setterType.apply(setter2);
                ClassNode rType = this.getDeclaredOrInferredType(valueExpression);
                if (lType.isArray() && valueExpression instanceof ListExpression) {
                    rType = StaticTypeCheckingVisitor.inferLoopElementType(rType).makeArray();
                }
                if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(lType, rType, valueExpression, false) && (methodTarget = setterCall.apply((Expression)GeneralUtils.castX((ClassNode)lType, (Expression)valueExpression))) != null) break;
            }
        }
        if (methodTarget != null) {
            for (MethodNode setter2 : setterInfo.setters) {
                if (setter2 != methodTarget) continue;
                leftExpression.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, (Object)methodTarget);
                leftExpression.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                this.storeType(leftExpression, setterType.apply(methodTarget));
                break;
            }
            return false;
        }
        ClassNode firstSetterType = setterType.apply(setterInfo.setters.get(0));
        this.addAssignmentError(firstSetterType, this.getType((ASTNode)valueExpression), expression);
        return true;
    }

    private static boolean isClosureWithType(ClassNode type) {
        return type.equals(ClassHelper.CLOSURE_TYPE) && Optional.ofNullable(type.getGenericsTypes()).filter(gts -> gts != null && ((GenericsType[])gts).length == 1).isPresent();
    }

    private static boolean isCompoundAssignment(Expression exp) {
        if (exp instanceof BinaryExpression) {
            Token op = ((BinaryExpression)exp).getOperation();
            return StaticTypeCheckingSupport.isAssignment(op.getType()) && op.getType() != 100;
        }
        return false;
    }

    protected ClassNode getOriginalDeclarationType(Expression lhs) {
        if (lhs instanceof VariableExpression) {
            Variable var = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)lhs);
            if (!(var instanceof DynamicVariable) && !(var instanceof PropertyNode)) {
                return var.getOriginType();
            }
        } else if (lhs instanceof FieldExpression) {
            return ((FieldExpression)lhs).getField().getOriginType();
        }
        return this.getType((ASTNode)lhs);
    }

    protected void inferDiamondType(ConstructorCallExpression cce, ClassNode lType) {
        ClassNode cceType = cce.getType();
        ClassNode inferredType = lType;
        if (cceType.getGenericsTypes() != null && cceType.getGenericsTypes().length == 0) {
            ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(cce.getArguments());
            ConstructorNode constructor = (ConstructorNode)cce.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            if (!argumentList.getExpressions().isEmpty() && constructor != null) {
                ClassNode type = GenericsUtils.parameterizeType(cceType, cceType);
                type = this.inferReturnTypeGenerics(type, (MethodNode)constructor, (Expression)argumentList);
                if (lType.getGenericsTypes() != null && (type.toString(false).indexOf(35) > 0 || StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(lType, type, (Expression)cce) && !GenericsUtils.buildWildcardType(lType).isCompatibleWith(type))) {
                    ClassNode pType = GenericsUtils.parameterizeType(lType, type);
                    GenericsType[] lhs = pType.getGenericsTypes();
                    GenericsType[] rhs = type.getGenericsTypes();
                    if (lhs == null || rhs == null || lhs.length != rhs.length) {
                        throw new GroovyBugError("Parameterization failed: " + StaticTypeCheckingSupport.prettyPrintType(pType) + " ~ " + StaticTypeCheckingSupport.prettyPrintType(type));
                    }
                    if (IntStream.range(0, lhs.length).allMatch(i -> GenericsUtils.buildWildcardType(StaticTypeCheckingSupport.getCombinedBoundType(lhs[i])).isCompatibleWith(rhs[i].getType()))) {
                        type = pType;
                    }
                }
                inferredType = type;
            }
            while (inferredType.isGenericsPlaceHolder() && DefaultGroovyMethods.asBoolean((Object[])inferredType.getGenericsTypes())) {
                inferredType = StaticTypeCheckingSupport.getCombinedBoundType(inferredType.getGenericsTypes()[0]);
            }
            this.adjustGenerics(inferredType, cceType);
            this.storeType((Expression)cce, cceType);
        }
    }

    private void adjustGenerics(ClassNode source, ClassNode target) {
        GenericsType[] genericsTypes = source.getGenericsTypes();
        if (genericsTypes == null) {
            genericsTypes = (GenericsType[])target.redirect().getGenericsTypes().clone();
            int i = 0;
            int n = genericsTypes.length;
            while (i < n) {
                GenericsType gt = genericsTypes[i];
                ClassNode cn = gt.getUpperBounds() != null ? gt.getUpperBounds()[0] : gt.getType().redirect();
                genericsTypes[i] = cn.getPlainNodeReference().asGenericsType();
                ++i;
            }
        } else {
            genericsTypes = (GenericsType[])genericsTypes.clone();
            int i = 0;
            int n = genericsTypes.length;
            while (i < n) {
                GenericsType gt = genericsTypes[i];
                genericsTypes[i] = new GenericsType(gt.getType(), gt.getUpperBounds(), gt.getLowerBound());
                genericsTypes[i].setWildcard(gt.isWildcard());
                ++i;
            }
        }
        target.setGenericsTypes(genericsTypes);
    }

    protected void pushInstanceOfTypeInfo(Expression objectOfInstanceOf, Expression typeExpression) {
        List potentialTypes = ((Map)this.typeCheckingContext.temporaryIfBranchTypeInformation.peek()).computeIfAbsent(this.extractTemporaryTypeInfoKey(objectOfInstanceOf), key -> new LinkedList());
        potentialTypes.add(typeExpression.getType());
    }

    private boolean typeCheckMultipleAssignmentAndContinue(Expression leftExpression, Expression rightExpression) {
        block9: {
            block11: {
                block10: {
                    if (!(leftExpression instanceof TupleExpression)) break block9;
                    if (rightExpression instanceof VariableExpression || rightExpression instanceof PropertyExpression) break block10;
                    if (!(rightExpression instanceof MethodCall)) break block11;
                }
                ClassNode inferredType = Optional.ofNullable(this.getType((ASTNode)rightExpression)).orElseGet(() -> ((Expression)rightExpression).getType());
                GenericsType[] genericsTypes = inferredType.getGenericsTypes();
                ListExpression listExpression = new ListExpression();
                listExpression.setSourcePosition((ASTNode)rightExpression);
                int n = TUPLE_TYPES.indexOf(inferredType);
                int i = 0;
                while (i < n) {
                    ClassNode type = genericsTypes != null ? genericsTypes[i].getType() : ClassHelper.OBJECT_TYPE;
                    listExpression.addExpression((Expression)GeneralUtils.varX((String)("v" + (i + 1)), (ClassNode)type));
                    ++i;
                }
                if (!listExpression.getExpressions().isEmpty()) {
                    rightExpression = listExpression;
                }
            }
            if (!(rightExpression instanceof ListExpression)) {
                this.addStaticTypeError("Multiple assignments without list or tuple on the right-hand side are unsupported in static type checking mode", (ASTNode)rightExpression);
                return false;
            }
            TupleExpression tuple = (TupleExpression)leftExpression;
            ListExpression values = (ListExpression)rightExpression;
            List tupleExpressions = tuple.getExpressions();
            List valueExpressions = values.getExpressions();
            if (tupleExpressions.size() > valueExpressions.size()) {
                this.addStaticTypeError("Incorrect number of values. Expected:" + tupleExpressions.size() + " Was:" + valueExpressions.size(), (ASTNode)values);
                return false;
            }
            int i = 0;
            int n = tupleExpressions.size();
            while (i < n) {
                ClassNode targetType;
                ClassNode valueType = this.getType((ASTNode)valueExpressions.get(i));
                if (!StaticTypeCheckingSupport.isAssignableTo(valueType, targetType = this.getType((ASTNode)tupleExpressions.get(i)))) {
                    this.addStaticTypeError("Cannot assign value of type " + StaticTypeCheckingSupport.prettyPrintType(valueType) + " to variable of type " + StaticTypeCheckingSupport.prettyPrintType(targetType), (ASTNode)rightExpression);
                    return false;
                }
                this.storeType((Expression)tupleExpressions.get(i), valueType);
                ++i;
            }
        }
        return true;
    }

    private static ClassNode adjustTypeForSpreading(ClassNode inferredRightExpressionType, Expression leftExpression) {
        ClassNode wrappedRHS = inferredRightExpressionType;
        if (leftExpression instanceof PropertyExpression && ((PropertyExpression)leftExpression).isSpreadSafe()) {
            wrappedRHS = ClassHelper.LIST_TYPE.getPlainNodeReference();
            wrappedRHS.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(inferredRightExpressionType))});
        }
        return wrappedRHS;
    }

    private boolean addedReadOnlyPropertyError(Expression expr) {
        if (expr.getNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY) == null) {
            return false;
        }
        String name = expr instanceof VariableExpression ? ((VariableExpression)expr).getName() : ((PropertyExpression)expr).getPropertyAsString();
        this.addStaticTypeError("Cannot set read-only property: " + name, (ASTNode)expr);
        return true;
    }

    private void addPrecisionErrors(ClassNode leftRedirect, ClassNode lhsType, ClassNode rhsType, Expression rightExpression) {
        ClassNode rightComponentType;
        ClassNode leftComponentType;
        if (ClassHelper.isNumberType(leftRedirect)) {
            if (ClassHelper.isNumberType(rhsType) && StaticTypeCheckingSupport.checkPossibleLossOfPrecision(leftRedirect, rhsType, rightExpression)) {
                this.addStaticTypeError("Possible loss of precision from " + rhsType.toString(false) + " to " + lhsType.toString(false), (ASTNode)rightExpression);
            }
            return;
        }
        if (!leftRedirect.isArray()) {
            return;
        }
        if (rightExpression instanceof ListExpression) {
            ClassNode leftComponentType2 = leftRedirect.getComponentType();
            for (Expression expression : ((ListExpression)rightExpression).getExpressions()) {
                ClassNode rightComponentType2 = this.getType((ASTNode)expression);
                if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType2, rightComponentType2) || StaticTypeCheckingVisitor.isNullConstant(expression) && !ClassHelper.isPrimitiveType(leftComponentType2)) continue;
                this.addStaticTypeError("Cannot assign value of type " + rightComponentType2.toString(false) + " into array of type " + lhsType.toString(false), (ASTNode)rightExpression);
            }
        } else if (rhsType.redirect().isArray() && !StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType = leftRedirect.getComponentType(), rightComponentType = rhsType.redirect().getComponentType())) {
            this.addStaticTypeError("Cannot assign value of type " + rightComponentType.toString(false) + " into array of type " + lhsType.toString(false), (ASTNode)rightExpression);
        }
    }

    private void addListAssignmentConstructorErrors(ClassNode leftRedirect, ClassNode leftExpressionType, ClassNode inferredRightExpressionType, Expression rightExpression, Expression assignmentExpression) {
        if (StaticTypeCheckingSupport.isWildcardLeftHandSide(leftRedirect) && !ClassHelper.CLASS_Type.equals(leftRedirect)) {
            return;
        }
        if (!(StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(ClassHelper.LIST_TYPE, leftRedirect) || leftRedirect.isAbstract() && !leftRedirect.isArray() || StaticTypeCheckingSupport.ArrayList_TYPE.isDerivedFrom(leftRedirect) || StaticTypeCheckingSupport.LinkedHashSet_TYPE.isDerivedFrom(leftRedirect))) {
            ClassNode[] types = this.getArgumentTypes(GeneralUtils.args((List)((ListExpression)rightExpression).getExpressions()));
            MethodNode methodNode = this.checkGroovyStyleConstructor(leftRedirect, types, (ASTNode)assignmentExpression);
            if (methodNode != null) {
                rightExpression.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, (Object)methodNode);
            }
        } else if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, ClassHelper.LIST_TYPE) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, leftRedirect) && !this.extension.handleIncompatibleAssignment(leftExpressionType, inferredRightExpressionType, assignmentExpression)) {
            this.addAssignmentError(leftExpressionType, inferredRightExpressionType, assignmentExpression);
        }
    }

    private void addMapAssignmentConstructorErrors(ClassNode leftRedirect, Expression leftExpression, MapExpression rightExpression) {
        if (!StaticTypeCheckingVisitor.isConstructorAbbreviation(leftRedirect, (Expression)rightExpression) || StaticTypeCheckingSupport.isWildcardLeftHandSide(leftRedirect) && !leftRedirect.equals(ClassHelper.CLASS_Type)) {
            return;
        }
        ClassNode[] argTypes = new ClassNode[]{this.getType((ASTNode)rightExpression)};
        this.checkGroovyStyleConstructor(leftRedirect, argTypes, (ASTNode)rightExpression);
        this.checkGroovyConstructorMap(leftExpression, leftRedirect, rightExpression);
    }

    private void checkTypeGenerics(ClassNode leftExpressionType, ClassNode rightExpressionType, Expression rightExpression) {
        if (!(!leftExpressionType.isUsingGenerics() || StaticTypeCheckingSupport.missesGenericsTypes(rightExpressionType) || rightExpression instanceof ClosureExpression || StaticTypeCheckingVisitor.isNullConstant(rightExpression) || StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE.equals(rightExpressionType) || GenericsUtils.buildWildcardType(leftExpressionType).isCompatibleWith(StaticTypeCheckingVisitor.wrapTypeIfNecessary(rightExpressionType)))) {
            this.addStaticTypeError("Incompatible generic argument types. Cannot assign " + StaticTypeCheckingSupport.prettyPrintType(rightExpressionType) + " to: " + StaticTypeCheckingSupport.prettyPrintType(leftExpressionType), (ASTNode)rightExpression);
        }
    }

    private boolean hasGStringStringError(ClassNode leftExpressionType, ClassNode wrappedRHS, Expression rightExpression) {
        if (StaticTypeCheckingSupport.isParameterizedWithString(leftExpressionType) && StaticTypeCheckingSupport.isParameterizedWithGStringOrGStringString(wrappedRHS)) {
            this.addStaticTypeError("You are trying to use a GString in place of a String in a type which explicitly declares accepting String. Make sure to call toString() on all GString values.", (ASTNode)rightExpression);
            return true;
        }
        return false;
    }

    private static boolean isConstructorAbbreviation(ClassNode leftType, Expression rightExpression) {
        if (rightExpression instanceof ListExpression) {
            return !StaticTypeCheckingSupport.ArrayList_TYPE.isDerivedFrom(leftType) && !StaticTypeCheckingSupport.ArrayList_TYPE.implementsInterface(leftType) && !StaticTypeCheckingSupport.LinkedHashSet_TYPE.isDerivedFrom(leftType) && !StaticTypeCheckingSupport.LinkedHashSet_TYPE.implementsInterface(leftType);
        }
        if (rightExpression instanceof MapExpression) {
            return !StaticTypeCheckingSupport.LinkedHashMap_TYPE.isDerivedFrom(leftType) && !StaticTypeCheckingSupport.LinkedHashMap_TYPE.implementsInterface(leftType);
        }
        return false;
    }

    protected void typeCheckAssignment(BinaryExpression assignmentExpression, Expression leftExpression, ClassNode leftExpressionType, Expression rightExpression, ClassNode rightExpressionType) {
        if (!this.typeCheckMultipleAssignmentAndContinue(leftExpression, rightExpression)) {
            return;
        }
        if (this.addedReadOnlyPropertyError(leftExpression)) {
            return;
        }
        ClassNode rTypeInferred = rightExpression instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(rightExpression) && assignmentExpression.getOperation().getType() == 100 ? this.getInferredReturnType((ASTNode)rightExpression) : rightExpressionType;
        ClassNode rTypeAdjusted = StaticTypeCheckingVisitor.adjustTypeForSpreading(rTypeInferred, leftExpression);
        if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftExpressionType, rTypeAdjusted, rightExpression)) {
            if (!this.extension.handleIncompatibleAssignment(leftExpressionType, rTypeAdjusted, (Expression)assignmentExpression)) {
                this.addAssignmentError(leftExpressionType, rTypeInferred, rightExpression);
            }
        } else {
            ClassNode lTypeRedirect = leftExpressionType.redirect();
            this.addPrecisionErrors(lTypeRedirect, leftExpressionType, rTypeAdjusted, rightExpression);
            if (rightExpression instanceof ListExpression) {
                this.addListAssignmentConstructorErrors(lTypeRedirect, leftExpressionType, rTypeInferred, rightExpression, (Expression)assignmentExpression);
            } else if (rightExpression instanceof MapExpression) {
                this.addMapAssignmentConstructorErrors(lTypeRedirect, leftExpression, (MapExpression)rightExpression);
            }
            if (!this.hasGStringStringError(leftExpressionType, rTypeAdjusted, rightExpression) && !StaticTypeCheckingVisitor.isConstructorAbbreviation(leftExpressionType, rightExpression)) {
                this.checkTypeGenerics(leftExpressionType, rTypeAdjusted, rightExpression);
            }
        }
    }

    protected void checkGroovyConstructorMap(Expression receiver, ClassNode receiverType, MapExpression mapExpression) {
        this.typeCheckingContext.pushEnclosingBinaryExpression(null);
        for (MapEntryExpression entryExpression : mapExpression.getMapEntryExpressions()) {
            Expression keyExpression = entryExpression.getKeyExpression();
            if (!(keyExpression instanceof ConstantExpression)) {
                this.addStaticTypeError("Dynamic keys in map-style constructors are unsupported in static type checking", (ASTNode)keyExpression);
                continue;
            }
            String propName = keyExpression.getText();
            PropertyLookup requestor = new PropertyLookup(receiverType);
            if (!this.existsProperty(GeneralUtils.propX((Expression)GeneralUtils.varX((String)"_", (ClassNode)receiverType), (String)propName), false, requestor)) {
                this.addStaticTypeError("No such property: " + propName + " for class: " + StaticTypeCheckingSupport.prettyPrintTypeName(receiverType), (ASTNode)receiver);
                continue;
            }
            ClassNode targetType = requestor.propertyType;
            Expression valueExpression = entryExpression.getValueExpression();
            ClassNode valueType = this.getType((ASTNode)valueExpression);
            ClassNode resultType = this.getResultType(targetType, 100, valueType, StaticTypeCheckingVisitor.assignX(keyExpression, valueExpression, (ASTNode)entryExpression));
            if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(targetType, resultType, valueExpression) || this.extension.handleIncompatibleAssignment(targetType, valueType, (Expression)entryExpression)) continue;
            this.addAssignmentError(targetType, valueType, (Expression)entryExpression);
        }
        this.typeCheckingContext.popEnclosingBinaryExpression();
    }

    @Deprecated
    protected static boolean hasRHSIncompleteGenericTypeInfo(ClassNode inferredRightExpressionType) {
        boolean replaceType = false;
        GenericsType[] genericsTypes = inferredRightExpressionType.getGenericsTypes();
        if (genericsTypes != null) {
            GenericsType[] genericsTypeArray = genericsTypes;
            int n = genericsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (genericsType.isPlaceholder()) {
                    replaceType = true;
                    break;
                }
                ++n2;
            }
        }
        return replaceType;
    }

    protected MethodNode checkGroovyStyleConstructor(ClassNode node, ClassNode[] arguments, ASTNode source) {
        if (node.equals(ClassHelper.OBJECT_TYPE)) {
            return null;
        }
        List<Object> constructors = node.getDeclaredConstructors();
        if (constructors.isEmpty() && arguments.length == 0) {
            return null;
        }
        constructors = this.findMethod(node, "<init>", arguments);
        if (constructors.isEmpty()) {
            if (StaticTypeCheckingSupport.isBeingCompiled(node) && !node.isAbstract() && arguments.length == 1 && arguments[0].equals(StaticTypeCheckingSupport.LinkedHashMap_TYPE)) {
                return new ConstructorNode(1, new Parameter[]{new Parameter(StaticTypeCheckingSupport.LinkedHashMap_TYPE, "args")}, ClassNode.EMPTY_ARRAY, (Statement)EmptyStatement.INSTANCE);
            }
            this.addStaticTypeError("Cannot find matching constructor " + StaticTypeCheckingSupport.prettyPrintTypeName(node) + StaticTypeCheckingSupport.toMethodParametersString("", arguments), source);
            return null;
        }
        if (constructors.size() > 1) {
            this.addStaticTypeError("Ambiguous constructor call " + StaticTypeCheckingSupport.prettyPrintTypeName(node) + StaticTypeCheckingSupport.toMethodParametersString("", arguments), source);
            return null;
        }
        return (MethodNode)constructors.get(0);
    }

    protected Object extractTemporaryTypeInfoKey(Expression expression) {
        return expression instanceof VariableExpression ? StaticTypeCheckingSupport.findTargetVariable((VariableExpression)expression) : expression.getText();
    }

    protected ClassNode findCurrentInstanceOfClass(Expression expr, ClassNode type) {
        List<ClassNode> nodes;
        if (!this.typeCheckingContext.temporaryIfBranchTypeInformation.isEmpty() && (nodes = this.getTemporaryTypesForExpression(expr)) != null && nodes.size() == 1) {
            return nodes.get(0);
        }
        return type;
    }

    protected boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly) {
        return this.existsProperty(pexp, checkForReadOnly, null);
    }

    protected boolean existsProperty(PropertyExpression pexp, boolean readMode, ClassCodeVisitorSupport visitor) {
        ClassNode receiverType;
        super.visitPropertyExpression(pexp);
        String propertyName = pexp.getPropertyAsString();
        if (propertyName == null) {
            return false;
        }
        Expression objectExpression = pexp.getObjectExpression();
        ClassNode objectExpressionType = this.getType((ASTNode)objectExpression);
        if (objectExpression instanceof ConstructorCallExpression) {
            ClassNode rawType = objectExpressionType.getPlainNodeReference();
            this.inferDiamondType((ConstructorCallExpression)objectExpression, rawType);
        }
        LinkedHashSet<ClassNode> enclosingTypes = new LinkedHashSet<ClassNode>();
        enclosingTypes.add(this.typeCheckingContext.getEnclosingClassNode());
        enclosingTypes.addAll(((ClassNode)enclosingTypes.iterator().next()).getOuterClasses());
        boolean staticOnlyAccess = StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(objectExpressionType);
        if (staticOnlyAccess && "this".equals(propertyName)) {
            ClassNode outer = objectExpressionType.getGenericsTypes()[0].getType();
            ClassNode found = null;
            for (ClassNode enclosingType : enclosingTypes) {
                if (enclosingType.isStaticClass() || !outer.equals(enclosingType.getOuterClass())) continue;
                found = enclosingType;
                break;
            }
            if (found != null) {
                this.storeType((Expression)pexp, outer);
                return true;
            }
        }
        String properName = BeanUtils.capitalize((String)propertyName);
        String isserName = "is" + properName;
        String getterName = "get" + properName;
        String setterName = "set" + properName;
        boolean foundGetterOrSetter = false;
        HashSet<ClassNode> handledNodes = new HashSet<ClassNode>();
        ArrayList<Receiver<String>> receivers = new ArrayList<Receiver<String>>();
        this.addReceivers(receivers, this.makeOwnerList(objectExpression), pexp.isImplicitThis());
        for (Receiver receiver : receivers) {
            ClassNode[] classNodeArray;
            receiverType = receiver.getType();
            if (receiverType.isArray() && "length".equals(propertyName)) {
                pexp.putNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY, (Object)Boolean.TRUE);
                this.storeType((Expression)pexp, ClassHelper.int_TYPE);
                if (visitor != null) {
                    FieldNode length = new FieldNode("length", 17, ClassHelper.int_TYPE, receiverType, null);
                    length.setDeclaringClass(receiverType);
                    visitor.visitField(length);
                }
                return true;
            }
            LinkedList<ClassNode> queue = new LinkedList<ClassNode>();
            queue.add(receiverType);
            if (ClassHelper.isPrimitiveType(receiverType)) {
                queue.add(ClassHelper.getWrapper(receiverType));
            }
            while (!queue.isEmpty()) {
                boolean staticOnly;
                ClassNode current = (ClassNode)queue.remove();
                if (!handledNodes.add(current)) continue;
                FieldNode field = current.getDeclaredField(propertyName);
                if (field == null) {
                    if (current.getSuperClass() != null) {
                        queue.addFirst(current.getSuperClass());
                    }
                    Collections.addAll(queue, current.getInterfaces());
                }
                boolean bl = staticOnly = receiver.getData() == null ? staticOnlyAccess : false;
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(current)) {
                    staticOnly = false;
                }
                field = this.allowStaticAccessToMember(field, staticOnly);
                if (pexp instanceof AttributeExpression) {
                    if (field == null || !this.storeField(field, pexp, receiverType, visitor, (String)receiver.getData(), !readMode)) continue;
                    return true;
                }
                if (field != null && enclosingTypes.contains(current) && this.storeField(field, pexp, receiverType, visitor, (String)receiver.getData(), !readMode)) {
                    return true;
                }
                MethodNode getter = StaticTypeCheckingVisitor.findGetter(current, getterName, pexp.isImplicitThis());
                if ((getter = this.allowStaticAccessToMember(getter, staticOnly)) == null) {
                    getter = StaticTypeCheckingVisitor.findGetter(current, isserName, pexp.isImplicitThis());
                }
                getter = this.allowStaticAccessToMember(getter, staticOnly);
                List<MethodNode> setters = StaticTypeCheckingSupport.findSetters(current, setterName, false);
                setters = this.allowStaticAccessToMember(setters, staticOnly);
                if (readMode && getter != null && visitor != null) {
                    visitor.visitMethod(getter);
                }
                PropertyNode property = current.getProperty(propertyName);
                if ((property = this.allowStaticAccessToMember(property, staticOnly)) == null || !enclosingTypes.contains(receiverType)) {
                    if (readMode) {
                        if (getter != null && StaticTypeCheckingVisitor.hasAccessToMember((ClassNode)enclosingTypes.iterator().next(), getter.getDeclaringClass(), getter.getModifiers())) {
                            ClassNode returnType = this.inferReturnTypeGenerics(current, getter, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
                            this.storeInferredTypeForPropertyExpression(pexp, returnType);
                            this.storeTargetMethod((Expression)pexp, getter);
                            String delegationData = (String)receiver.getData();
                            if (delegationData != null) {
                                pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, (Object)delegationData);
                            }
                            return true;
                        }
                    } else {
                        if (!setters.isEmpty()) {
                            String delegationData;
                            if (visitor != null) {
                                for (MethodNode setter : setters) {
                                    FieldNode virtual = new FieldNode(propertyName, 0, setter.getParameters()[0].getOriginType(), current, null);
                                    virtual.setDeclaringClass(setter.getDeclaringClass());
                                    visitor.visitField(virtual);
                                }
                            }
                            SetterInfo info = new SetterInfo(current, GeneralUtils.getSetterName((String)propertyName), setters);
                            BinaryExpression enclosingBinaryExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
                            if (enclosingBinaryExpression != null) {
                                StaticTypeCheckingVisitor.putSetterInfo(enclosingBinaryExpression.getLeftExpression(), info);
                            }
                            if ((delegationData = (String)receiver.getData()) != null) {
                                pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, (Object)delegationData);
                            }
                            pexp.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
                            return true;
                        }
                        if (getter != null && field == null) {
                            pexp.putNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY, (Object)Boolean.TRUE);
                        }
                    }
                }
                boolean bl2 = foundGetterOrSetter = foundGetterOrSetter || !setters.isEmpty() || getter != null;
                if (property != null && this.storeProperty(property, pexp, receiverType, visitor, (String)receiver.getData())) {
                    return true;
                }
                if (field == null || !this.storeField(field, pexp, receiverType, visitor, (String)receiver.getData(), !readMode)) continue;
                return true;
            }
            if (ClassHelper.isPrimitiveType(receiverType)) {
                ClassNode[] classNodeArray2 = new ClassNode[2];
                classNodeArray2[0] = receiverType;
                classNodeArray = classNodeArray2;
                classNodeArray2[1] = ClassHelper.getWrapper(receiverType);
            } else {
                ClassNode[] classNodeArray3 = new ClassNode[1];
                classNodeArray = classNodeArray3;
                classNodeArray3[0] = receiverType;
            }
            ClassNode[] classNodeArray4 = classNodeArray;
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                List<MethodNode> bestMethods;
                ClassNode dgmReceiver = classNodeArray4[n2];
                Set<MethodNode> methods = StaticTypeCheckingSupport.findDGMMethodsForClassNode((ClassLoader)this.getSourceUnit().getClassLoader(), dgmReceiver, getterName);
                for (MethodNode method2 : StaticTypeCheckingSupport.findDGMMethodsForClassNode((ClassLoader)this.getSourceUnit().getClassLoader(), dgmReceiver, isserName)) {
                    if (!ClassHelper.Boolean_TYPE.equals(ClassHelper.getWrapper(method2.getReturnType()))) continue;
                    methods.add(method2);
                }
                if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(dgmReceiver)) {
                    methods.removeIf(method -> !StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(dgmReceiver, ClassNode.EMPTY_ARRAY, method));
                }
                if (!methods.isEmpty() && (bestMethods = StaticTypeCheckingSupport.chooseBestMethod(dgmReceiver, methods, ClassNode.EMPTY_ARRAY)).size() == 1) {
                    MethodNode getter = bestMethods.get(0);
                    if (visitor != null) {
                        visitor.visitMethod(getter);
                    }
                    ClassNode returnType = this.inferReturnTypeGenerics(dgmReceiver, getter, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
                    this.storeInferredTypeForPropertyExpression(pexp, returnType);
                    if (readMode) {
                        this.storeTargetMethod((Expression)pexp, getter);
                    }
                    return true;
                }
                ++n2;
            }
            if (receiverType.isArray() || ClassHelper.isPrimitiveType(ClassHelper.getUnwrapper(receiverType)) || !pexp.isImplicitThis() || this.typeCheckingContext.getEnclosingClosure() == null) continue;
            MethodNode mopMethod = readMode ? receiverType.getMethod("get", new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name")}) : receiverType.getMethod("set", new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "value")});
            if (mopMethod == null) {
                mopMethod = receiverType.getMethod("propertyMissing", new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "propertyName")});
            }
            if (mopMethod == null || mopMethod.isStatic() || mopMethod.isSynthetic()) continue;
            pexp.putNodeMetaData((Object)StaticTypesMarker.DYNAMIC_RESOLUTION, (Object)Boolean.TRUE);
            pexp.removeNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE);
            pexp.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            visitor.visitMethod(mopMethod);
            return true;
        }
        for (Receiver receiver : receivers) {
            receiverType = receiver.getType();
            ClassNode propertyType = this.getTypeForMapPropertyExpression(receiverType, pexp);
            if (propertyType == null) {
                propertyType = this.getTypeForListPropertyExpression(receiverType, pexp);
            }
            if (propertyType == null) {
                propertyType = this.getTypeForSpreadExpression(receiverType, pexp);
            }
            if (propertyType == null) continue;
            if (visitor != null) {
                PropertyNode node = new PropertyNode(propertyName, 1, propertyType, receiver.getType(), null, null, null);
                node.setDeclaringClass(receiver.getType());
                visitor.visitProperty(node);
            }
            this.storeType((Expression)pexp, propertyType);
            String delegationData = (String)receiver.getData();
            if (delegationData != null) {
                pexp.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, (Object)delegationData);
            }
            return true;
        }
        return foundGetterOrSetter;
    }

    private static boolean hasAccessToMember(ClassNode accessor, ClassNode receiver, int modifiers) {
        if (Modifier.isPublic(modifiers) || accessor.equals(receiver) || accessor.getOuterClasses().contains(receiver)) {
            return true;
        }
        if (!Modifier.isPrivate(modifiers) && Objects.equals(accessor.getPackageName(), receiver.getPackageName())) {
            return true;
        }
        return Modifier.isProtected(modifiers) && accessor.isDerivedFrom(receiver);
    }

    private static MethodNode findGetter(ClassNode current, String name, boolean searchOuterClasses) {
        MethodNode getterMethod = current.getGetterMethod(name);
        if (getterMethod == null && searchOuterClasses && current.getOuterClass() != null) {
            return StaticTypeCheckingVisitor.findGetter(current.getOuterClass(), name, true);
        }
        return getterMethod;
    }

    private ClassNode getTypeForMultiValueExpression(ClassNode compositeType, Expression prop) {
        GenericsType[] gts = compositeType.getGenericsTypes();
        ClassNode itemType = gts != null && gts.length == 1 ? StaticTypeCheckingSupport.getCombinedBoundType(gts[0]) : ClassHelper.OBJECT_TYPE;
        PropertyLookup requestor = new PropertyLookup(itemType);
        if (this.existsProperty(GeneralUtils.propX((Expression)GeneralUtils.varX((String)"{}", (ClassNode)itemType), (Expression)prop), true, requestor)) {
            return GenericsUtils.makeClassSafe0(ClassHelper.LIST_TYPE, new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(requestor.propertyType)));
        }
        return null;
    }

    private ClassNode getTypeForSpreadExpression(ClassNode testClass, PropertyExpression pexp) {
        if (pexp.isSpreadSafe()) {
            MethodCallExpression mce = GeneralUtils.callX((Expression)GeneralUtils.varX((String)"_", (ClassNode)testClass), (String)"iterator");
            mce.setImplicitThis(false);
            mce.visit((GroovyCodeVisitor)((Object)this));
            ClassNode iteratorType = this.getType((ASTNode)((Object)mce));
            if (GeneralUtils.isOrImplements((ClassNode)iteratorType, (ClassNode)ClassHelper.Iterator_TYPE)) {
                return this.getTypeForMultiValueExpression(iteratorType, pexp.getProperty());
            }
        }
        return null;
    }

    private ClassNode getTypeForListPropertyExpression(ClassNode testClass, PropertyExpression pexp) {
        if (GeneralUtils.isOrImplements((ClassNode)testClass, (ClassNode)ClassHelper.LIST_TYPE)) {
            ClassNode listType = testClass.equals(ClassHelper.LIST_TYPE) ? testClass : GenericsUtils.parameterizeType(testClass, ClassHelper.LIST_TYPE);
            return this.getTypeForMultiValueExpression(listType, pexp.getProperty());
        }
        return null;
    }

    private ClassNode getTypeForMapPropertyExpression(ClassNode testClass, PropertyExpression pexp) {
        block13: {
            if (!GeneralUtils.isOrImplements((ClassNode)testClass, (ClassNode)ClassHelper.MAP_TYPE)) break block13;
            ClassNode mapType = testClass.equals(ClassHelper.MAP_TYPE) ? testClass : GenericsUtils.parameterizeType(testClass, ClassHelper.MAP_TYPE);
            GenericsType[] gts = mapType.getGenericsTypes();
            if (gts == null || gts.length != 2) {
                gts = new GenericsType[]{ClassHelper.OBJECT_TYPE.asGenericsType(), ClassHelper.OBJECT_TYPE.asGenericsType()};
            }
            if (!pexp.isSpreadSafe()) {
                return StaticTypeCheckingSupport.getCombinedBoundType(gts[1]);
            }
            switch (pexp.getPropertyAsString()) {
                case "key": {
                    pexp.putNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY, (Object)Boolean.TRUE);
                    ClassNode keyList = ClassHelper.LIST_TYPE.getPlainNodeReference();
                    keyList.setGenericsTypes(new GenericsType[]{gts[0]});
                    return keyList;
                }
                case "value": {
                    GenericsType v = gts[1];
                    if (!v.isWildcard() && !Modifier.isFinal(v.getType().getModifiers()) && this.typeCheckingContext.isTargetOfEnclosingAssignment((Expression)pexp)) {
                        v = GenericsUtils.buildWildcardType(v.getType());
                    }
                    return GenericsUtils.makeClassSafe0(ClassHelper.LIST_TYPE, v);
                }
            }
            this.addStaticTypeError("Spread operator on map only allows one of [key,value]", (ASTNode)pexp);
        }
        return null;
    }

    private <T> T allowStaticAccessToMember(T member, boolean staticOnly) {
        if (member == null || !staticOnly) {
            return member;
        }
        if (member instanceof List) {
            return (T)((List)member).stream().map(m -> this.allowStaticAccessToMember(m, true)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        boolean isStatic = member instanceof FieldNode ? ((FieldNode)member).isStatic() : (member instanceof PropertyNode ? ((PropertyNode)member).isStatic() : this.isStaticInContext((MethodNode)member));
        return (T)(isStatic ? member : null);
    }

    private boolean isStaticInContext(MethodNode method) {
        return method instanceof ExtensionMethodNode ? ((ExtensionMethodNode)method).isStaticExtension() : method.isStatic();
    }

    private void storeWithResolve(ClassNode type, ClassNode receiver, ClassNode declaringClass, boolean isStatic, Expression expressionToStoreOn) {
        if (!isStatic && GenericsUtils.hasUnresolvedGenerics(type)) {
            type = this.resolveGenericsWithContext(StaticTypeCheckingVisitor.extractPlaceHolders(receiver, declaringClass), type);
        }
        if (expressionToStoreOn instanceof PropertyExpression) {
            this.storeInferredTypeForPropertyExpression((PropertyExpression)expressionToStoreOn, type);
        } else {
            this.storeType(expressionToStoreOn, type);
        }
    }

    private boolean storeField(FieldNode field, PropertyExpression expressionToStoreOn, ClassNode receiver, ClassCodeVisitorSupport visitor, String delegationData, boolean lhsOfAssignment) {
        if (visitor != null) {
            visitor.visitField(field);
        }
        this.checkOrMarkPrivateAccess((Expression)expressionToStoreOn, field, lhsOfAssignment);
        boolean accessible = StaticTypeCheckingVisitor.hasAccessToMember(StaticTypeCheckingVisitor.isSuperExpression(expressionToStoreOn.getObjectExpression()) ? this.typeCheckingContext.getEnclosingClassNode() : receiver, field.getDeclaringClass(), field.getModifiers());
        if (expressionToStoreOn instanceof AttributeExpression && !accessible) {
            this.addStaticTypeError("The field " + field.getDeclaringClass().getNameWithoutPackage() + "." + field.getName() + " is not accessible", (ASTNode)expressionToStoreOn.getProperty());
        }
        this.storeWithResolve(field.getOriginType(), receiver, field.getDeclaringClass(), field.isStatic(), (Expression)expressionToStoreOn);
        if (delegationData != null) {
            expressionToStoreOn.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, (Object)delegationData);
        }
        if (field.isFinal()) {
            MethodNode enclosing = this.typeCheckingContext.getEnclosingMethod();
            if (enclosing == null || !enclosing.getName().endsWith("init>")) {
                expressionToStoreOn.putNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY, (Object)Boolean.TRUE);
            }
        } else if (accessible) {
            expressionToStoreOn.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
        }
        return true;
    }

    private boolean storeProperty(PropertyNode property, PropertyExpression expressionToStoreOn, ClassNode receiver, ClassCodeVisitorSupport visitor, String delegationData) {
        if (visitor != null) {
            visitor.visitProperty(property);
        }
        this.storeWithResolve(property.getOriginType(), receiver, property.getDeclaringClass(), property.isStatic(), (Expression)expressionToStoreOn);
        if (delegationData != null) {
            expressionToStoreOn.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, (Object)delegationData);
        }
        if (Modifier.isFinal(property.getModifiers())) {
            expressionToStoreOn.putNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY, (Object)Boolean.TRUE);
        } else {
            expressionToStoreOn.removeNodeMetaData((Object)StaticTypesMarker.READONLY_PROPERTY);
        }
        return true;
    }

    @Deprecated
    protected void storeInferredTypeForPropertyExpression(PropertyExpression pexp, ClassNode flatInferredType) {
        if (pexp.isSpreadSafe()) {
            ClassNode list = ClassHelper.LIST_TYPE.getPlainNodeReference();
            list.setGenericsTypes(new GenericsType[]{new GenericsType(flatInferredType)});
            this.storeType((Expression)pexp, list);
        } else {
            this.storeType((Expression)pexp, flatInferredType);
        }
    }

    @Override
    public void visitProperty(PropertyNode node) {
        boolean osc = this.typeCheckingContext.isInStaticContext;
        try {
            this.typeCheckingContext.isInStaticContext = node.isInStaticContext();
            this.currentProperty = node;
            this.visitAnnotations((AnnotatedNode)node);
            this.visitClassCodeContainer(node.getGetterBlock());
            this.visitClassCodeContainer(node.getSetterBlock());
        }
        finally {
            this.currentProperty = null;
            this.typeCheckingContext.isInStaticContext = osc;
        }
    }

    @Override
    public void visitField(FieldNode node) {
        boolean osc = this.typeCheckingContext.isInStaticContext;
        try {
            this.typeCheckingContext.isInStaticContext = node.isInStaticContext();
            this.currentField = node;
            this.visitAnnotations((AnnotatedNode)node);
            this.visitInitialExpression(node.getInitialExpression(), (Expression)new FieldExpression(node), (ASTNode)node);
        }
        finally {
            this.currentField = null;
            this.typeCheckingContext.isInStaticContext = osc;
        }
    }

    private void visitInitialExpression(Expression value, Expression target, ASTNode position) {
        if (value != null) {
            ClassNode lType = target.getType();
            if (ClassHelper.isFunctionalInterface(lType)) {
                this.processFunctionalInterfaceAssignment(lType, value);
            } else if (StaticTypeCheckingVisitor.isClosureWithType(lType) && value instanceof ClosureExpression) {
                this.storeInferredReturnType((ASTNode)value, StaticTypeCheckingSupport.getCombinedBoundType(lType.getGenericsTypes()[0]));
            }
            this.typeCheckingContext.pushEnclosingBinaryExpression(StaticTypeCheckingVisitor.assignX(target, value, position));
            value.visit((GroovyCodeVisitor)((Object)this));
            ClassNode rType = this.getType((ASTNode)value);
            if (value instanceof ConstructorCallExpression) {
                this.inferDiamondType((ConstructorCallExpression)value, lType);
            }
            BinaryExpression dummy = this.typeCheckingContext.popEnclosingBinaryExpression();
            this.typeCheckAssignment(dummy, target, lType, value, this.getResultType(lType, 100, rType, dummy));
        }
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        HashMap<VariableExpression, ClassNode> varOrigType = new HashMap<VariableExpression, ClassNode>();
        forLoop.getLoopBlock().visit((GroovyCodeVisitor)((Object)new VariableExpressionTypeMemoizer(varOrigType)));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        Expression collectionExpression = forLoop.getCollectionExpression();
        if (collectionExpression instanceof ClosureListExpression) {
            super.visitForLoop(forLoop);
        } else {
            this.visitStatement((Statement)forLoop);
            collectionExpression.visit((GroovyCodeVisitor)((Object)this));
            ClassNode collectionType = collectionExpression instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(collectionExpression) ? this.getInferredReturnType((ASTNode)collectionExpression) : this.getType((ASTNode)collectionExpression);
            ClassNode forLoopVariableType = forLoop.getVariableType();
            ClassNode componentType = ClassHelper.Character_TYPE.equals(ClassHelper.getWrapper(forLoopVariableType)) && ClassHelper.STRING_TYPE.equals(collectionType) ? forLoopVariableType : StaticTypeCheckingVisitor.inferLoopElementType(collectionType);
            if (ClassHelper.getUnwrapper(componentType).equals(forLoopVariableType)) {
                componentType = forLoopVariableType;
            }
            if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(forLoopVariableType, componentType)) {
                this.addStaticTypeError("Cannot loop with element of type " + forLoopVariableType.toString(false) + " with collection of type " + collectionType.toString(false), (ASTNode)forLoop);
            }
            if (forLoopVariableType != ClassHelper.DYNAMIC_TYPE) {
                componentType = forLoopVariableType;
            }
            this.typeCheckingContext.controlStructureVariables.put(forLoop.getVariable(), componentType);
            try {
                forLoop.getLoopBlock().visit((GroovyCodeVisitor)((Object)this));
            }
            finally {
                this.typeCheckingContext.controlStructureVariables.remove(forLoop.getVariable());
            }
        }
        if (this.isSecondPassNeededForControlStructure(varOrigType, oldTracker)) {
            this.visitForLoop(forLoop);
        }
    }

    public static ClassNode inferLoopElementType(ClassNode collectionType) {
        ClassNode componentType = collectionType.getComponentType();
        if (componentType == null) {
            if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(collectionType, ITERABLE_TYPE)) {
                ClassNode col = GenericsUtils.parameterizeType(collectionType, ITERABLE_TYPE);
                componentType = col.getGenericsTypes()[0].getType();
            } else if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(collectionType, ClassHelper.MAP_TYPE)) {
                ClassNode col = GenericsUtils.parameterizeType(collectionType, ClassHelper.MAP_TYPE);
                componentType = MAP_ENTRY_TYPE.getPlainNodeReference();
                componentType.setGenericsTypes(col.getGenericsTypes());
            } else if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(collectionType, STREAM_TYPE)) {
                ClassNode col = GenericsUtils.parameterizeType(collectionType, STREAM_TYPE);
                componentType = StaticTypeCheckingSupport.getCombinedBoundType(col.getGenericsTypes()[0]);
            } else if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(collectionType, ENUMERATION_TYPE)) {
                ClassNode col = GenericsUtils.parameterizeType(collectionType, ENUMERATION_TYPE);
                componentType = col.getGenericsTypes()[0].getType();
            } else {
                componentType = collectionType.equals(ClassHelper.STRING_TYPE) ? ClassHelper.STRING_TYPE : ClassHelper.OBJECT_TYPE;
            }
        }
        return componentType;
    }

    protected boolean isSecondPassNeededForControlStructure(Map<VariableExpression, ClassNode> varOrigType, Map<VariableExpression, List<ClassNode>> oldTracker) {
        for (Map.Entry<VariableExpression, ClassNode> entry : this.popAssignmentTracking(oldTracker).entrySet()) {
            Variable key = StaticTypeCheckingSupport.findTargetVariable(entry.getKey());
            if (!(key instanceof VariableExpression) || !varOrigType.containsKey(key)) continue;
            ClassNode origType = varOrigType.get(key);
            ClassNode newType = entry.getValue();
            if (newType.equals(origType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitWhileLoop(WhileStatement loop) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        super.visitWhileLoop(loop);
        this.popAssignmentTracking(oldTracker);
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        MethodNode mn;
        super.visitBitwiseNegationExpression(expression);
        ClassNode type = this.getType((ASTNode)expression);
        ClassNode typeRe = type.redirect();
        ClassNode resultType = WideningCategories.isBigIntCategory((ClassNode)typeRe) ? type : (typeRe == ClassHelper.STRING_TYPE || typeRe == ClassHelper.GSTRING_TYPE ? ClassHelper.PATTERN_TYPE : (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE ? StaticTypeCheckingSupport.ArrayList_TYPE : (typeRe.equals(ClassHelper.PATTERN_TYPE) ? ClassHelper.PATTERN_TYPE : ((mn = this.findMethodOrFail((Expression)expression, type, "bitwiseNegate", new ClassNode[0])) != null ? mn.getReturnType() : ClassHelper.OBJECT_TYPE))));
        this.storeType((Expression)expression, resultType);
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        super.visitUnaryPlusExpression(expression);
        this.negativeOrPositiveUnary((Expression)expression, "positive");
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        super.visitUnaryMinusExpression(expression);
        this.negativeOrPositiveUnary((Expression)expression, "negative");
    }

    public void visitPostfixExpression(PostfixExpression expression) {
        Expression operand = expression.getExpression();
        int operator = expression.getOperation().getType();
        this.visitPrefixOrPostifExpression((Expression)expression, operand, operator);
    }

    public void visitPrefixExpression(PrefixExpression expression) {
        Expression operand = expression.getExpression();
        int operator = expression.getOperation().getType();
        this.visitPrefixOrPostifExpression((Expression)expression, operand, operator);
    }

    private void visitPrefixOrPostifExpression(Expression origin, Expression operand, int operator) {
        Optional token = TokenUtil.asAssignment((int)operator);
        token.ifPresent(value -> this.typeCheckingContext.pushEnclosingBinaryExpression(GeneralUtils.binX((Expression)operand, (Token)value, (Expression)GeneralUtils.constX((Object)1))));
        try {
            MethodNode node;
            String name;
            operand.visit((GroovyCodeVisitor)((Object)this));
            SetterInfo setterInfo = StaticTypeCheckingVisitor.removeSetterInfo(operand);
            if (setterInfo != null) {
                BinaryExpression rewrite = this.typeCheckingContext.getEnclosingBinaryExpression();
                rewrite.setSourcePosition((ASTNode)origin);
                if (this.ensureValidSetter((Expression)rewrite, operand, rewrite.getRightExpression(), setterInfo)) {
                    return;
                }
            }
            ClassNode operandType = this.getType((ASTNode)operand);
            boolean isPostfix = origin instanceof PostfixExpression;
            String string = operator == 250 ? "next" : (name = operator == 260 ? "previous" : null);
            if (name != null && ClassHelper.isNumberType(operandType)) {
                MethodNode node2;
                if (!ClassHelper.isPrimitiveType(operandType) && (node2 = this.findMethodOrFail((Expression)GeneralUtils.varX((String)"_dummy_", (ClassNode)operandType), operandType, name, new ClassNode[0])) != null) {
                    this.storeTargetMethod(origin, node2);
                    this.storeType(origin, isPostfix ? operandType : StaticTypeCheckingVisitor.getMathWideningClassNode(operandType));
                    return;
                }
                this.storeType(origin, operandType);
                return;
            }
            if (name != null && operandType.isDerivedFrom(ClassHelper.Number_TYPE) && (node = this.findMethodOrFail(operand, operandType, name, new ClassNode[0])) != null) {
                this.storeTargetMethod(origin, node);
                this.storeType(origin, StaticTypeCheckingVisitor.getMathWideningClassNode(operandType));
                return;
            }
            if (name == null) {
                this.addUnsupportedPreOrPostfixExpressionError(origin);
                return;
            }
            node = this.findMethodOrFail(operand, operandType, name, new ClassNode[0]);
            if (node != null) {
                this.storeTargetMethod(origin, node);
                this.storeType(origin, isPostfix ? operandType : this.inferReturnTypeGenerics(operandType, node, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
            }
        }
        finally {
            if (token.isPresent()) {
                this.typeCheckingContext.popEnclosingBinaryExpression();
            }
        }
    }

    private static ClassNode getMathWideningClassNode(ClassNode type) {
        if (ClassHelper.byte_TYPE.equals(type) || ClassHelper.short_TYPE.equals(type) || ClassHelper.int_TYPE.equals(type)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Byte_TYPE.equals(type) || ClassHelper.Short_TYPE.equals(type) || ClassHelper.Integer_TYPE.equals(type)) {
            return ClassHelper.Integer_TYPE;
        }
        if (ClassHelper.float_TYPE.equals(type)) {
            return ClassHelper.double_TYPE;
        }
        if (ClassHelper.Float_TYPE.equals(type)) {
            return ClassHelper.Double_TYPE;
        }
        return type;
    }

    private void negativeOrPositiveUnary(Expression expression, String name) {
        MethodNode mn;
        ClassNode type = this.getType((ASTNode)expression);
        ClassNode typeRe = type.redirect();
        ClassNode resultType = WideningCategories.isDoubleCategory((ClassNode)ClassHelper.getUnwrapper(typeRe)) ? type : (typeRe.equals(StaticTypeCheckingSupport.ArrayList_TYPE) ? StaticTypeCheckingSupport.ArrayList_TYPE : ((mn = this.findMethodOrFail(expression, type, name, new ClassNode[0])) != null ? mn.getReturnType() : type));
        this.storeType(expression, resultType);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.typeCheckingContext.pushEnclosingMethod(node);
        if (!this.isSkipMode(node) && !this.shouldSkipMethodNode(node)) {
            Parameter parameter;
            Parameter[] parameterArray = node.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                parameter = parameterArray[n2];
                for (AnnotationNode annotation : parameter.getAnnotations()) {
                    List<ClassNode[]> signatures;
                    if (!annotation.getClassNode().equals(CLOSUREPARAMS_CLASSNODE) || (signatures = this.getSignaturesFromHint(null, node, annotation.getMember("value"), annotation.getMember("options"))).size() != 1) continue;
                    parameter.putNodeMetaData(StaticTypesMarker.CLOSURE_ARGUMENTS, Arrays.stream(signatures.get(0)).map(t -> new Parameter((ClassNode)t, "")).toArray(Parameter[]::new));
                }
                ++n2;
            }
            super.visitConstructorOrMethod(node, isConstructor);
            if (node.hasDefaultValue()) {
                parameterArray = node.getParameters();
                n = parameterArray.length;
                n2 = 0;
                while (n2 < n) {
                    parameter = parameterArray[n2];
                    if (parameter.hasInitialExpression()) {
                        this.visitInitialExpression(parameter.getInitialExpression(), (Expression)GeneralUtils.varX((Variable)parameter), parameter);
                        parameter.getInitialExpression().visit((GroovyCodeVisitor)new CodeVisitorSupport(){

                            public void visitMethodCallExpression(MethodCallExpression mce) {
                                mce.setMethodTarget(null);
                                super.visitMethodCallExpression(mce);
                            }
                        });
                    }
                    ++n2;
                }
            }
        }
        if (!isConstructor) {
            this.returnAdder.visitMethod(node);
        }
        this.typeCheckingContext.popEnclosingMethod();
    }

    @Override
    protected void visitObjectInitializerStatements(ClassNode node) {
        ConstructorNode init = new ConstructorNode(0, null, null, (Statement)new BlockStatement(node.getObjectInitializerStatements(), null));
        this.typeCheckingContext.pushEnclosingMethod((MethodNode)init);
        super.visitObjectInitializerStatements(node);
        this.typeCheckingContext.popEnclosingMethod();
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement statement) {
        this.typeCheckingContext.pushTemporaryTypeInfo();
        super.visitExpressionStatement(statement);
        this.typeCheckingContext.popTemporaryTypeInfo();
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement) {
        MethodNode method;
        if (this.typeCheckingContext.getEnclosingClosure() == null && (method = this.typeCheckingContext.getEnclosingMethod()) != null && !method.isVoidMethod() && !method.isDynamicReturnType()) {
            ClassNode returnType = method.getReturnType();
            Expression returnValue = statement.getExpression();
            if (ClassHelper.isFunctionalInterface(returnType)) {
                this.processFunctionalInterfaceAssignment(returnType, returnValue);
            } else if (StaticTypeCheckingVisitor.isClosureWithType(returnType) && returnValue instanceof ClosureExpression) {
                this.storeInferredReturnType((ASTNode)returnValue, StaticTypeCheckingSupport.getCombinedBoundType(returnType.getGenericsTypes()[0]));
            }
        }
        super.visitReturnStatement(statement);
        this.returnListener.returnStatementAdded(statement);
    }

    protected ClassNode checkReturnType(ReturnStatement statement) {
        Expression expression = statement.getExpression();
        ClassNode type = expression instanceof VariableExpression && StaticTypeCheckingVisitor.hasInferredReturnType(expression) ? this.getInferredReturnType((ASTNode)expression) : this.getType((ASTNode)expression);
        if (this.typeCheckingContext.getEnclosingClosure() != null) {
            if (this.typeCheckingContext.getEnclosingClosure().getClosureExpression().getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE) != null) {
                return null;
            }
            ClassNode inferredReturnType = this.getInferredReturnType((ASTNode)this.typeCheckingContext.getEnclosingClosure().getClosureExpression());
            if (expression instanceof ConstructorCallExpression) {
                this.inferDiamondType((ConstructorCallExpression)expression, inferredReturnType != null ? inferredReturnType : ClassHelper.DYNAMIC_TYPE);
            }
            if (!(inferredReturnType == null || inferredReturnType.equals(type) || inferredReturnType.equals(ClassHelper.VOID_TYPE) || inferredReturnType.equals(ClassHelper.OBJECT_TYPE) || inferredReturnType.equals(ClassHelper.boolean_TYPE) || GenericsUtils.hasUnresolvedGenerics(inferredReturnType))) {
                if (inferredReturnType.equals(ClassHelper.STRING_TYPE) && StaticTypeCheckingSupport.isGStringOrGStringStringLUB(type)) {
                    type = ClassHelper.STRING_TYPE;
                } else if (GenericsUtils.buildWildcardType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(inferredReturnType)).isCompatibleWith(StaticTypeCheckingVisitor.wrapTypeIfNecessary(type))) {
                    type = inferredReturnType;
                } else if (!type.equals(ClassHelper.VOID_TYPE) && !this.extension.handleIncompatibleReturnType(statement, type)) {
                    String kind = this.typeCheckingContext.getEnclosingClosure().getClosureExpression() instanceof LambdaExpression ? "lambda" : "closure";
                    this.addStaticTypeError("Cannot return value of type " + StaticTypeCheckingSupport.prettyPrintType(type) + " for " + kind + " expecting " + StaticTypeCheckingSupport.prettyPrintType(inferredReturnType), (ASTNode)expression);
                }
            }
            return type;
        }
        MethodNode enclosingMethod = this.typeCheckingContext.getEnclosingMethod();
        if (enclosingMethod != null && !enclosingMethod.isVoidMethod()) {
            ClassNode returnType = enclosingMethod.getReturnType();
            if (!(StaticTypeCheckingVisitor.isNullConstant(expression) || type.equals(ClassHelper.VOID_TYPE) || type.equals(ClassHelper.void_WRAPPER_TYPE) || StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(returnType, type, null, false))) {
                if (!this.extension.handleIncompatibleReturnType(statement, type)) {
                    this.addStaticTypeError("Cannot return value of type " + StaticTypeCheckingSupport.prettyPrintType(type) + " for method returning " + StaticTypeCheckingSupport.prettyPrintType(returnType), (ASTNode)expression);
                }
            } else if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, returnType)) {
                BinaryExpression dummy = StaticTypeCheckingVisitor.assignX((Expression)GeneralUtils.varX((String)"{target}", (ClassNode)returnType), expression, (ASTNode)statement);
                ClassNode resultType = this.getResultType(returnType, 100, type, dummy);
                this.checkTypeGenerics(returnType, resultType, expression);
            }
        }
        return type;
    }

    protected void addClosureReturnType(ClassNode returnType) {
        if (returnType != null && !returnType.equals(ClassHelper.VOID_TYPE)) {
            this.typeCheckingContext.getEnclosingClosure().addReturnType(returnType);
        }
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        Set methods;
        if (!this.extension.beforeMethodCall((MethodCall)call)) {
            MethodNode ctor;
            ClassNode receiver = call.isThisCall() ? this.makeThis() : (call.isSuperCall() ? this.makeSuper() : call.getType());
            Expression arguments = call.getArguments();
            ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(arguments);
            this.checkForbiddenSpreadArgument(argumentList);
            this.visitMethodCallArguments(receiver, argumentList, false, null);
            Object[] argumentTypes = this.getArgumentTypes(argumentList);
            if (this.looksLikeNamedArgConstructor(receiver, (ClassNode[])argumentTypes) && this.findMethod(receiver, "<init>", (ClassNode[])argumentTypes).isEmpty() && this.findMethod(receiver, "<init>", (ClassNode[])DefaultGroovyMethods.init((Object[])argumentTypes)).size() == 1) {
                ctor = this.typeCheckMapConstructor(call, receiver, arguments);
            } else {
                ctor = this.findMethodOrFail((Expression)call, receiver, "<init>", (ClassNode[])argumentTypes);
                if (ctor != null) {
                    Parameter[] parameters = ctor.getParameters();
                    if (this.looksLikeNamedArgConstructor(receiver, (ClassNode[])argumentTypes) && parameters.length == argumentTypes.length - 1) {
                        ctor = this.typeCheckMapConstructor(call, receiver, arguments);
                    } else {
                        Map<GenericsType.GenericsTypeName, GenericsType> context;
                        GenericsType[] typeParameters = ctor.getDeclaringClass().getGenericsTypes();
                        if (typeParameters != null && typeParameters.length > 0 && !(context = this.extractGenericsConnectionsFromArguments(typeParameters, parameters, (Expression)argumentList, receiver.getGenericsTypes())).isEmpty()) {
                            parameters = (Parameter[])Arrays.stream(parameters).map(p -> new Parameter(StaticTypeCheckingSupport.applyGenericsContext(context, p.getType()), p.getName())).toArray(Parameter[]::new);
                        }
                        this.resolvePlaceholdersFromImplicitTypeHints((ClassNode[])argumentTypes, argumentList, parameters);
                        this.typeCheckMethodsWithGenericsOrFail(receiver, (ClassNode[])argumentTypes, ctor, (Expression)call);
                        this.visitMethodCallArguments(receiver, argumentList, true, ctor);
                    }
                }
            }
            if (ctor != null) {
                this.storeTargetMethod((Expression)call, ctor);
            }
        }
        if (call.isUsingAnonymousInnerClass() && !(methods = this.typeCheckingContext.methodsToBeVisited).isEmpty()) {
            this.typeCheckingContext.methodsToBeVisited = Collections.emptySet();
            ClassNode anonType = call.getType();
            this.visitClass(anonType);
            anonType.putNodeMetaData(StaticTypeCheckingVisitor.class, Boolean.TRUE);
            this.typeCheckingContext.methodsToBeVisited = methods;
        }
        this.extension.afterMethodCall((MethodCall)call);
    }

    private boolean looksLikeNamedArgConstructor(ClassNode receiver, ClassNode[] argumentTypes) {
        if (argumentTypes.length == 1 || argumentTypes.length == 2 && argumentTypes[0].equals(receiver.getOuterClass())) {
            return argumentTypes[argumentTypes.length - 1].implementsInterface(ClassHelper.MAP_TYPE);
        }
        return false;
    }

    protected MethodNode typeCheckMapConstructor(ConstructorCallExpression call, ClassNode receiver, Expression arguments) {
        Expression expression;
        TupleExpression texp;
        List expressions;
        ConstructorNode node = null;
        if (arguments instanceof TupleExpression && ((expressions = (texp = (TupleExpression)arguments).getExpressions()).size() == 1 || expressions.size() == 2) && (expression = (Expression)expressions.get(expressions.size() - 1)) instanceof MapExpression) {
            Parameter[] parameterArray;
            MapExpression argList = (MapExpression)expression;
            this.checkGroovyConstructorMap((Expression)call, receiver, argList);
            if (expressions.size() == 1) {
                Parameter[] parameterArray2 = new Parameter[1];
                parameterArray = parameterArray2;
                parameterArray2[0] = new Parameter(ClassHelper.MAP_TYPE, "map");
            } else {
                Parameter[] parameterArray3 = new Parameter[2];
                parameterArray3[0] = new Parameter(receiver.redirect().getOuterClass(), "$p$");
                parameterArray = parameterArray3;
                parameterArray3[1] = new Parameter(ClassHelper.MAP_TYPE, "map");
            }
            Parameter[] params = parameterArray;
            node = new ConstructorNode(1, params, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
            node.setDeclaringClass(receiver);
        }
        return node;
    }

    protected ClassNode[] getArgumentTypes(ArgumentListExpression args) {
        return (ClassNode[])args.getExpressions().stream().map(exp -> StaticTypeCheckingVisitor.isNullConstant(exp) ? StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE : this.getType((ASTNode)exp)).toArray(ClassNode[]::new);
    }

    private ClassNode getInferredTypeFromTempInfo(Expression expression, ClassNode expressionType) {
        List<ClassNode> tempTypes;
        if (expression instanceof VariableExpression && !this.typeCheckingContext.temporaryIfBranchTypeInformation.isEmpty() && (tempTypes = this.getTemporaryTypesForExpression(expression)) != null && !tempTypes.isEmpty()) {
            ArrayList<ClassNode> types = new ArrayList<ClassNode>(tempTypes.size() + 1);
            if (expressionType != null && !expressionType.equals(ClassHelper.OBJECT_TYPE) && tempTypes.stream().noneMatch(t -> StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(t, expressionType))) {
                types.add(expressionType);
            }
            types.addAll(tempTypes);
            if (types.isEmpty()) {
                return ClassHelper.OBJECT_TYPE;
            }
            if (types.size() == 1) {
                return (ClassNode)types.get(0);
            }
            return new UnionTypeClassNode(types.toArray(ClassNode.EMPTY_ARRAY));
        }
        return expressionType;
    }

    public void visitClosureExpression(ClosureExpression expression) {
        HashMap<VariableExpression, Map<StaticTypesMarker, Object>> variableMetadata;
        HashMap<VariableExpression, ClassNode> varTypes = new HashMap<VariableExpression, ClassNode>();
        expression.getCode().visit((GroovyCodeVisitor)((Object)new VariableExpressionTypeMemoizer(varTypes, true)));
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        SharedVariableCollector collector = new SharedVariableCollector(this.getSourceUnit());
        collector.visitClosureExpression(expression);
        Set closureSharedVariables = collector.getClosureSharedExpressions();
        if (!closureSharedVariables.isEmpty()) {
            for (VariableExpression ve : closureSharedVariables) {
                this.getType((ASTNode)ve);
            }
            variableMetadata = new HashMap<VariableExpression, Map<StaticTypesMarker, Object>>();
            this.saveVariableExpressionMetadata(closureSharedVariables, variableMetadata);
        } else {
            variableMetadata = null;
        }
        this.typeCheckingContext.pushEnclosingClosureExpression(expression);
        DelegationMetadata dmd = this.getDelegationMetadata(expression);
        this.typeCheckingContext.delegationMetadata = dmd == null ? new DelegationMetadata(this.typeCheckingContext.getEnclosingClassNode(), 0, this.typeCheckingContext.delegationMetadata) : new DelegationMetadata(dmd.getType(), dmd.getStrategy(), this.typeCheckingContext.delegationMetadata);
        super.visitClosureExpression(expression);
        this.typeCheckingContext.delegationMetadata = this.typeCheckingContext.delegationMetadata.getParent();
        MethodNode node = new MethodNode("dummy", 0, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, expression.getCode());
        this.returnAdder.visitMethod(node);
        TypeCheckingContext.EnclosingClosure enclosingClosure = this.typeCheckingContext.getEnclosingClosure();
        if (!enclosingClosure.getReturnTypes().isEmpty()) {
            ClassNode returnType = WideningCategories.lowestUpperBound((List)enclosingClosure.getReturnTypes());
            ClassNode expectedReturnType = this.getInferredReturnType((ASTNode)expression);
            if (expectedReturnType != null && ClassHelper.isPrimitiveType(returnType) && expectedReturnType.equals(ClassHelper.getWrapper(returnType))) {
                returnType = expectedReturnType;
            }
            this.storeInferredReturnType((ASTNode)expression, returnType);
            ClassNode inferredType = StaticTypeCheckingVisitor.wrapClosureType(returnType);
            this.storeType((Expression)enclosingClosure.getClosureExpression(), inferredType);
        }
        this.typeCheckingContext.popEnclosingClosure();
        if (this.isSecondPassNeededForControlStructure(varTypes, oldTracker)) {
            this.visitClosureExpression(expression);
        }
        this.restoreVariableExpressionMetadata(variableMetadata);
        Parameter[] parameterArray = ClosureUtils.getParametersSafe((ClosureExpression)expression);
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            this.typeCheckingContext.controlStructureVariables.remove(parameter);
            this.visitInitialExpression(parameter.getInitialExpression(), (Expression)GeneralUtils.varX((Variable)parameter), parameter);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        super.visitMethodPointerExpression(expression);
        Expression nameExpr = expression.getMethodName();
        if (nameExpr instanceof ConstantExpression && this.getType((ASTNode)nameExpr).equals(ClassHelper.STRING_TYPE)) {
            String nameText = nameExpr.getText();
            if ("new".equals(nameText)) {
                ClassNode type = this.getType((ASTNode)expression.getExpression());
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(type)) {
                    type = type.getGenericsTypes()[0].getType();
                    this.storeType((Expression)expression, StaticTypeCheckingVisitor.wrapClosureType(type));
                }
                return;
            }
            ArrayList<Receiver<String>> receivers = new ArrayList<Receiver<String>>();
            this.addReceivers(receivers, this.makeOwnerList(expression.getExpression()), false);
            ClassNode receiverType = null;
            List<MethodNode> candidates = EMPTY_METHODNODE_LIST;
            for (Receiver receiver : receivers) {
                receiverType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(receiver.getType());
                candidates = this.findMethodsWithGenerated(receiverType, nameText);
                if (StaticTypeCheckingSupport.isBeingCompiled(receiverType) && !receiverType.isInterface()) {
                    MethodNode generated = StaticTypeCheckingVisitor.findPropertyMethod(receiverType, nameText);
                    if (generated != null && candidates.stream().noneMatch(m -> m.getName().equals(generated.getName()))) {
                        candidates.add(generated);
                    }
                    candidates.addAll(ClassHelper.GROOVY_OBJECT_TYPE.getMethods(nameText));
                }
                candidates.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode((ClassLoader)this.getSourceUnit().getClassLoader(), receiverType, nameText));
                if (candidates.size() > 1) {
                    candidates = this.filterMethodCandidates(candidates, expression.getExpression(), (ClassNode[])expression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS));
                }
                if (!candidates.isEmpty()) break;
            }
            if (candidates.isEmpty()) {
                candidates = this.extension.handleMissingMethod(this.getType((ASTNode)expression.getExpression()), nameText, null, null, null);
            } else if (candidates.size() > 1) {
                candidates = this.extension.handleAmbiguousMethods(candidates, (Expression)expression);
            }
            if (!candidates.isEmpty()) {
                Map<GenericsType.GenericsTypeName, GenericsType> map = GenericsUtils.extractPlaceholders(receiverType);
                candidates.stream().map(candidate -> StaticTypeCheckingSupport.applyGenericsContext(gts, candidate.getReturnType())).reduce(WideningCategories::lowestUpperBound).ifPresent(returnType -> this.storeType((Expression)expression, StaticTypeCheckingVisitor.wrapClosureType(returnType)));
                expression.putNodeMetaData(MethodNode.class, (Object)candidates);
            } else if (!(expression instanceof MethodReferenceExpression)) {
                void var7_13;
                ClassNode classNode = StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.getType((ASTNode)expression.getExpression()));
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(classNode)) {
                    ClassNode classNode2 = classNode.getGenericsTypes()[0].getType();
                }
                this.addStaticTypeError("Cannot find matching method " + StaticTypeCheckingSupport.prettyPrintTypeName((ClassNode)var7_13) + "#" + nameText + ". Please check if the declared type is correct and if the method exists.", (ASTNode)nameExpr);
            }
        }
    }

    private static ClassNode wrapClosureType(ClassNode returnType) {
        ClassNode inferredType = ClassHelper.CLOSURE_TYPE.getPlainNodeReference();
        inferredType.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(returnType))});
        return inferredType;
    }

    private static MethodNode findPropertyMethod(ClassNode type, String name) {
        ClassNode cn = type;
        while (cn != null) {
            for (PropertyNode pn : cn.getProperties()) {
                String getterName = GeneralUtils.getGetterName((PropertyNode)pn);
                if (ClassHelper.boolean_TYPE.equals(pn.getType()) && StaticTypeCheckingVisitor.findGetter(cn, getterName, false) == null) {
                    getterName = "is" + BeanUtils.capitalize((String)pn.getName());
                }
                if (name.equals(getterName)) {
                    MethodNode node = new MethodNode(name, 1 | (pn.isStatic() ? 8 : 0), pn.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
                    node.setDeclaringClass(pn.getDeclaringClass());
                    node.setSynthetic(true);
                    return node;
                }
                if (!name.equals(GeneralUtils.getSetterName((String)pn.getName())) || Modifier.isFinal(pn.getModifiers())) continue;
                MethodNode node = new MethodNode(name, 1 | (pn.isStatic() ? 8 : 0), ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(pn.getType(), pn.getName())}, ClassNode.EMPTY_ARRAY, null);
                node.setDeclaringClass(pn.getDeclaringClass());
                node.setSynthetic(true);
                return node;
            }
            cn = cn.getSuperClass();
        }
        return null;
    }

    private List<MethodNode> filterMethodCandidates(List<MethodNode> candidates, Expression objectOrType, ClassNode[] signature) {
        List<MethodNode> result = StaticTypeCheckingSupport.filterMethodsByVisibility(candidates, this.typeCheckingContext.getEnclosingClassNode());
        if (result.size() > 1 && signature != null) {
            ClassNode type = this.getType((ASTNode)objectOrType);
            if (!StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(type)) {
                result = StaticTypeCheckingSupport.chooseBestMethod(type, result, signature);
            } else {
                type = type.getGenericsTypes()[0].getType();
                Map<Boolean, List<MethodNode>> staticAndNonStatic = result.stream().collect(Collectors.partitioningBy(this::isStaticInContext));
                result = new ArrayList<MethodNode>(result.size());
                result.addAll(StaticTypeCheckingSupport.chooseBestMethod(type, (Collection<MethodNode>)staticAndNonStatic.get(Boolean.TRUE), signature));
                if (!staticAndNonStatic.get(Boolean.FALSE).isEmpty()) {
                    if (signature.length > 0) {
                        signature = Arrays.copyOfRange(signature, 1, signature.length);
                    }
                    result.addAll(StaticTypeCheckingSupport.chooseBestMethod(type, (Collection<MethodNode>)staticAndNonStatic.get(Boolean.FALSE), signature));
                }
            }
        }
        return result;
    }

    protected DelegationMetadata getDelegationMetadata(ClosureExpression expression) {
        return (DelegationMetadata)expression.getNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA);
    }

    protected void restoreVariableExpressionMetadata(Map<VariableExpression, Map<StaticTypesMarker, Object>> typesBeforeVisit) {
        if (typesBeforeVisit != null) {
            for (Map.Entry<VariableExpression, Map<StaticTypesMarker, Object>> entry : typesBeforeVisit.entrySet()) {
                StaticTypesMarker[] staticTypesMarkerArray = StaticTypesMarker.values();
                int n = staticTypesMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StaticTypesMarker marker = staticTypesMarkerArray[n2];
                    if (marker != StaticTypesMarker.INFERRED_TYPE) {
                        Object value = entry.getValue().get(marker);
                        if (value == null) {
                            entry.getKey().removeNodeMetaData((Object)marker);
                        } else {
                            entry.getKey().putNodeMetaData((Object)marker, value);
                        }
                    }
                    ++n2;
                }
                entry.getKey().removeNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE);
            }
        }
    }

    protected void saveVariableExpressionMetadata(Set<VariableExpression> closureSharedExpressions, Map<VariableExpression, Map<StaticTypesMarker, Object>> typesBeforeVisit) {
        for (VariableExpression ve : closureSharedExpressions) {
            Variable v;
            while ((v = ve.getAccessedVariable()) != ve && v instanceof VariableExpression) {
                ve = (VariableExpression)v;
            }
            EnumMap<StaticTypesMarker, Object> metadata = new EnumMap<StaticTypesMarker, Object>(StaticTypesMarker.class);
            StaticTypesMarker[] staticTypesMarkerArray = StaticTypesMarker.values();
            int n = staticTypesMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                StaticTypesMarker marker = staticTypesMarkerArray[n2];
                Object value = ve.getNodeMetaData((Object)marker);
                if (value != null) {
                    metadata.put(marker, value);
                }
                ++n2;
            }
            typesBeforeVisit.put(ve, metadata);
        }
    }

    protected boolean shouldSkipMethodNode(MethodNode node) {
        return Boolean.TRUE.equals(node.getNodeMetaData(StaticTypeCheckingVisitor.class));
    }

    @Override
    public void visitMethod(MethodNode node) {
        if (this.shouldSkipMethodNode(node)) {
            return;
        }
        if (!this.extension.beforeVisitMethod(node)) {
            ErrorCollector collector = (ErrorCollector)node.getNodeMetaData(ERROR_COLLECTOR);
            if (collector != null) {
                this.typeCheckingContext.getErrorCollector().addCollectorContents(collector);
            } else {
                this.startMethodInference(node, this.typeCheckingContext.getErrorCollector());
            }
            node.removeNodeMetaData(ERROR_COLLECTOR);
        }
        this.extension.afterVisitMethod(node);
    }

    @Override
    public void visitConstructor(ConstructorNode node) {
        if (this.shouldSkipMethodNode((MethodNode)node)) {
            return;
        }
        super.visitConstructor(node);
    }

    protected void startMethodInference(MethodNode node, ErrorCollector collector) {
        if (this.isSkipMode(node)) {
            return;
        }
        if ((this.typeCheckingContext.methodsToBeVisited.isEmpty() || this.typeCheckingContext.methodsToBeVisited.contains(node)) && this.typeCheckingContext.alreadyVisitedMethods.add(node)) {
            this.typeCheckingContext.pushErrorCollector(collector);
            boolean osc = this.typeCheckingContext.isInStaticContext;
            try {
                this.typeCheckingContext.isInStaticContext = node.getOriginal().isStatic();
                super.visitMethod(node);
            }
            finally {
                this.typeCheckingContext.isInStaticContext = osc;
            }
            this.typeCheckingContext.popErrorCollector();
            node.putNodeMetaData(ERROR_COLLECTOR, collector);
        }
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        String name = call.getMethod();
        if (name == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", (ASTNode)((Object)call));
            return;
        }
        if (name.equals("$INIT") && call.getOwnerType().isEnum()) {
            FieldExpression target = (FieldExpression)this.typeCheckingContext.getEnclosingBinaryExpression().getLeftExpression();
            ConstructorCallExpression cce = new ConstructorCallExpression(call.getOwnerType(), call.getArguments());
            cce.setSourcePosition((ASTNode)target.getField());
            this.visitConstructorCallExpression(cce);
            MethodNode init = call.getOwnerType().getDeclaredMethods("$INIT").get(0);
            call.putNodeMetaData(StaticTypesMarker.INFERRED_TYPE, init.getReturnType());
            call.putNodeMetaData(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, init);
            return;
        }
        if (this.extension.beforeMethodCall((MethodCall)call)) {
            this.extension.afterMethodCall((MethodCall)call);
            return;
        }
        Expression callArguments = call.getArguments();
        ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(callArguments);
        this.checkForbiddenSpreadArgument(argumentList);
        ClassNode receiver = call.getOwnerType();
        this.visitMethodCallArguments(receiver, argumentList, false, null);
        ClassNode[] args = this.getArgumentTypes(argumentList);
        try {
            List<Receiver> receivers = Collections.singletonList(Receiver.make((ClassNode)receiver));
            List<MethodNode> mn = null;
            Receiver chosenReceiver = null;
            for (Receiver currentReceiver : receivers) {
                mn = this.findMethod(currentReceiver.getType(), name, args);
                if (mn.isEmpty()) continue;
                if (mn.size() == 1) {
                    this.resolvePlaceholdersFromImplicitTypeHints(args, argumentList, mn.get(0).getParameters());
                    this.typeCheckMethodsWithGenericsOrFail(currentReceiver.getType(), args, mn.get(0), call);
                }
                chosenReceiver = currentReceiver;
                break;
            }
            if (mn.isEmpty()) {
                mn = this.extension.handleMissingMethod(receiver, name, argumentList, args, (MethodCall)call);
            }
            boolean callArgsVisited = false;
            if (mn.isEmpty()) {
                this.addNoMatchingMethodError(receiver, name, args, call);
            } else {
                if ((mn = this.disambiguateMethods(mn, receiver, args, call)).size() == 1) {
                    MethodNode directMethodCallCandidate = mn.get(0);
                    ClassNode returnType = this.getType(directMethodCallCandidate);
                    if (returnType.isUsingGenerics() && !returnType.isEnum()) {
                        this.visitMethodCallArguments(receiver, argumentList, true, directMethodCallCandidate);
                        ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver.getType(), directMethodCallCandidate, callArguments);
                        returnType = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, returnType) ? irtg : returnType;
                        callArgsVisited = true;
                    }
                    this.storeType(call, returnType);
                    this.storeTargetMethod(call, directMethodCallCandidate);
                } else {
                    this.addAmbiguousErrorMessage(mn, name, args, call);
                }
                if (!callArgsVisited) {
                    this.visitMethodCallArguments(receiver, argumentList, true, (MethodNode)call.getNodeMetaData(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
                }
            }
        }
        finally {
            this.extension.afterMethodCall((MethodCall)call);
        }
    }

    @Deprecated
    protected void checkClosureParameters(Expression callArguments, ClassNode receiver) {
        if (callArguments instanceof ArgumentListExpression) {
            Parameter param;
            ArgumentListExpression argList = (ArgumentListExpression)callArguments;
            ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
            Parameter[] parameters = closure.getParameters();
            if (parameters.length > 1) {
                this.addStaticTypeError("Unexpected number of parameters for a with call", (ASTNode)argList);
            } else if (parameters.length == 1 && !(param = parameters[0]).isDynamicTyped() && !StaticTypeCheckingSupport.isAssignableTo(receiver, param.getType().redirect())) {
                this.addStaticTypeError("Expected parameter type: " + receiver.toString(false) + " but was: " + param.getType().redirect().toString(false), param);
            }
            closure.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, (Object)new DelegationMetadata(receiver, 1, this.typeCheckingContext.delegationMetadata));
        }
    }

    protected void silentlyVisitMethodNode(MethodNode directMethodCallCandidate) {
        ErrorCollector collector = new ErrorCollector(this.typeCheckingContext.getErrorCollector().getConfiguration());
        this.startMethodInference(directMethodCallCandidate, collector);
    }

    protected void visitMethodCallArguments(ClassNode receiver, ArgumentListExpression arguments, boolean visitClosures, MethodNode selectedMethod) {
        Parameter[] params;
        ArrayList<VariableExpression> expressions = new ArrayList<VariableExpression>();
        if (selectedMethod instanceof ExtensionMethodNode) {
            params = ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode().getParameters();
            expressions.add(GeneralUtils.varX((String)"$self", (ClassNode)receiver));
        } else {
            params = selectedMethod != null ? selectedMethod.getParameters() : Parameter.EMPTY_ARRAY;
        }
        expressions.addAll(arguments.getExpressions());
        int nExpressions = expressions.size();
        int i = 0;
        while (i < nExpressions) {
            Expression expression = (Expression)expressions.get(i);
            if (visitClosures && expression instanceof ClosureExpression || !visitClosures && !(expression instanceof ClosureExpression)) {
                if (i < params.length && visitClosures) {
                    Parameter target = params[i];
                    ClassNode targetType = target.getType();
                    ClosureExpression source = (ClosureExpression)expression;
                    this.checkClosureWithDelegatesTo(receiver, selectedMethod, GeneralUtils.args(expressions), params, (Expression)source, target);
                    if (selectedMethod instanceof ExtensionMethodNode) {
                        if (i > 0) {
                            this.inferClosureParameterTypes(receiver, (Expression)arguments, source, target, selectedMethod);
                        }
                    } else {
                        this.inferClosureParameterTypes(receiver, (Expression)arguments, source, target, selectedMethod);
                    }
                    if (ClassHelper.isFunctionalInterface(targetType)) {
                        this.storeInferredReturnType((ASTNode)source, (ClassNode)GenericsUtils.parameterizeSAM(targetType).getV2());
                    } else if (StaticTypeCheckingVisitor.isClosureWithType(targetType)) {
                        this.storeInferredReturnType((ASTNode)source, StaticTypeCheckingSupport.getCombinedBoundType(targetType.getGenericsTypes()[0]));
                    }
                }
                expression.visit((GroovyCodeVisitor)((Object)this));
                expression.removeNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA);
            }
            ++i;
        }
        if (nExpressions > 0 && expressions.get(0) instanceof MapExpression && params.length > 0) {
            this.checkNamedParamsAnnotation(params[0], (MapExpression)expressions.get(0));
        }
        if (visitClosures) {
            this.inferMethodReferenceType(receiver, arguments, selectedMethod);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkNamedParamsAnnotation(Parameter param, MapExpression args) {
        if (!GeneralUtils.isOrImplements((ClassNode)param.getType(), (ClassNode)ClassHelper.MAP_TYPE)) {
            return;
        }
        List entryExpressions = args.getMapEntryExpressions();
        LinkedHashMap<Object, Expression> entries = new LinkedHashMap<Object, Expression>();
        for (MapEntryExpression entry : entryExpressions) {
            void var7_7;
            Expression expression = entry.getKeyExpression();
            if (expression instanceof ConstantExpression) {
                Object object = ((ConstantExpression)expression).getValue();
            }
            entries.put(var7_7, entry.getValueExpression());
        }
        ArrayList<String> collectedNames = new ArrayList<String>();
        List<AnnotationNode> annotations = param.getAnnotations(NAMED_PARAMS_CLASSNODE);
        if (annotations != null && !annotations.isEmpty()) {
            void var7_11;
            Object var7_10 = null;
            for (AnnotationNode next : annotations) {
                if (!next.getClassNode().getName().equals(NamedParams.class.getName())) continue;
                AnnotationNode annotationNode = next;
            }
            if (var7_11 != null) {
                Expression value = var7_11.getMember("value");
                if (value instanceof AnnotationConstantExpression) {
                    this.processNamedParam((AnnotationConstantExpression)value, entries, (Expression)args, collectedNames);
                } else if (value instanceof ListExpression) {
                    ListExpression le = (ListExpression)value;
                    for (Expression next : le.getExpressions()) {
                        if (!(next instanceof AnnotationConstantExpression)) continue;
                        this.processNamedParam((AnnotationConstantExpression)next, entries, (Expression)args, collectedNames);
                    }
                }
            }
        }
        if ((annotations = param.getAnnotations(NAMED_PARAM_CLASSNODE)) != null && !annotations.isEmpty()) {
            for (AnnotationNode annotationNode : annotations) {
                if (!annotationNode.getClassNode().getName().equals(NamedParam.class.getName())) continue;
                this.processNamedParam(annotationNode, entries, (Expression)args, collectedNames);
            }
        }
        if (!collectedNames.isEmpty()) {
            for (Map.Entry entry : entries.entrySet()) {
                if (collectedNames.contains(entry.getKey())) continue;
                this.addStaticTypeError("unexpected named arg: " + entry.getKey(), (ASTNode)args);
            }
        }
    }

    private void processNamedParam(AnnotationConstantExpression value, Map<Object, Expression> entries, Expression expression, List<String> collectedNames) {
        AnnotationNode namedParam = (AnnotationNode)value.getValue();
        if (!namedParam.getClassNode().getName().equals(NamedParam.class.getName())) {
            return;
        }
        this.processNamedParam(namedParam, entries, expression, collectedNames);
    }

    private void processNamedParam(AnnotationNode namedParam, Map<Object, Expression> entries, Expression expression, List<String> collectedNames) {
        ClassNode argumentType;
        ClassExpression typeX;
        String name = null;
        boolean required = false;
        ClassNode expectedType = null;
        ConstantExpression constX = (ConstantExpression)namedParam.getMember("value");
        if (constX != null) {
            name = (String)constX.getValue();
            collectedNames.add(name);
        }
        if ((constX = (ConstantExpression)namedParam.getMember("required")) != null) {
            required = (Boolean)constX.getValue();
        }
        if ((typeX = (ClassExpression)namedParam.getMember("type")) != null) {
            expectedType = typeX.getType();
        }
        if (!entries.containsKey(name)) {
            if (required) {
                this.addStaticTypeError("required named param '" + name + "' not found.", (ASTNode)expression);
            }
        } else if (expectedType != null && !StaticTypeCheckingSupport.isAssignableTo(argumentType = this.getDeclaredOrInferredType(entries.get(name)), expectedType)) {
            this.addStaticTypeError("argument for named param '" + name + "' has type '" + StaticTypeCheckingSupport.prettyPrintType(argumentType) + "' but expected '" + StaticTypeCheckingSupport.prettyPrintType(expectedType) + "'.", (ASTNode)expression);
        }
    }

    protected void inferClosureParameterTypes(ClassNode receiver, Expression arguments, ClosureExpression expression, Parameter target, MethodNode method) {
        List<AnnotationNode> annotations = target.getAnnotations(CLOSUREPARAMS_CLASSNODE);
        if (annotations != null && !annotations.isEmpty()) {
            for (AnnotationNode annotation : annotations) {
                Expression hintClass = annotation.getMember("value");
                if (!(hintClass instanceof ClassExpression)) continue;
                Expression options = annotation.getMember("options");
                Expression resolverClass = annotation.getMember("conflictResolutionStrategy");
                this.doInferClosureParameterTypes(receiver, arguments, expression, method, hintClass, resolverClass, options);
            }
        } else if (ClassHelper.isSAMType(target.getOriginType())) {
            Parameter[] p;
            GenericsType[] typeParameters;
            Map<GenericsType.GenericsTypeName, GenericsType> context = StaticTypeCheckingVisitor.extractPlaceHoldersVisibleToDeclaration(receiver, method, arguments);
            GenericsType[] genericsTypeArray = typeParameters = method instanceof ConstructorNode ? method.getDeclaringClass().getGenericsTypes() : StaticTypeCheckingSupport.applyGenericsContext(context, method.getGenericsTypes());
            if (typeParameters != null) {
                int n;
                GenericsType[] typeArguments;
                MethodCallExpression mce;
                boolean typeParametersResolved = false;
                Expression emc = this.typeCheckingContext.getEnclosingMethodCall();
                if (emc instanceof MethodCallExpression && ((mce = (MethodCallExpression)emc).getArguments() == arguments || expression.getCode() == GENERATED_EMPTY_STATEMENT) && (typeArguments = mce.getGenericsTypes()) != null && (n = typeParameters.length) == typeArguments.length) {
                    typeParametersResolved = true;
                    int i = 0;
                    while (i < n) {
                        context.put(new GenericsType.GenericsTypeName(typeParameters[i].getName()), typeArguments[i]);
                        ++i;
                    }
                }
                if (!typeParametersResolved) {
                    int i = -1;
                    p = method.getParameters();
                    for (Expression argument : (ArgumentListExpression)arguments) {
                        ++i;
                        if (StaticTypeCheckingVisitor.isNullConstant(argument)) continue;
                        ClassNode pType = p[Math.min(i, p.length - 1)].getType();
                        HashMap<GenericsType.GenericsTypeName, GenericsType> gc = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                        StaticTypeCheckingSupport.extractGenericsConnections(gc, StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.getType((ASTNode)argument)), pType);
                        if (argument == expression || argument instanceof ClosureExpression && ClassHelper.isSAMType(pType)) {
                            Parameter[] q = ClosureUtils.getParametersSafe((ClosureExpression)((ClosureExpression)argument));
                            ClassNode[] r = StaticTypeCheckingVisitor.extractTypesFromParameters(q);
                            ClassNode[] s = (ClassNode[])GenericsUtils.parameterizeSAM(pType).getV1();
                            int j = 0;
                            while (j < r.length && j < s.length) {
                                if (!q[j].isDynamicTyped()) {
                                    StaticTypeCheckingSupport.extractGenericsConnections(gc, r[j], s[j]);
                                }
                                ++j;
                            }
                        }
                        gc.forEach((key, gt) -> {
                            GenericsType[] genericsTypeArray2 = typeParameters;
                            int n = typeParameters.length;
                            int n2 = 0;
                            while (n2 < n) {
                                GenericsType tp = genericsTypeArray2[n2];
                                if (tp.getName().equals(key.getName())) {
                                    context.putIfAbsent((GenericsType.GenericsTypeName)key, (GenericsType)gt);
                                    break;
                                }
                                ++n2;
                            }
                        });
                    }
                    GenericsType[] genericsTypeArray2 = typeParameters;
                    int n2 = typeParameters.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        GenericsType tp = genericsTypeArray2[n3];
                        context.computeIfAbsent(new GenericsType.GenericsTypeName(tp.getName()), x -> StaticTypeCheckingSupport.fullyResolve(tp, context));
                        ++n3;
                    }
                }
            }
            ClassNode[] samParamTypes = (ClassNode[])GenericsUtils.parameterizeSAM(StaticTypeCheckingSupport.applyGenericsContext(context, target.getType())).getV1();
            ClassNode[] paramTypes = (ClassNode[])expression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
            if (paramTypes == null) {
                int n;
                p = expression.getParameters();
                paramTypes = p == null ? ClassNode.EMPTY_ARRAY : ((n = p.length) == 0 ? samParamTypes : Arrays.copyOf(samParamTypes, n));
                expression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, (Object)paramTypes);
                if (paramTypes.length != samParamTypes.length) {
                    this.addError("Incorrect number of parameters. Expected " + samParamTypes.length + " but found " + paramTypes.length, (ASTNode)expression);
                }
            }
        }
    }

    private List<ClassNode[]> getSignaturesFromHint(ClosureExpression expression, MethodNode selectedMethod, Expression hintClass, Expression options) {
        List closureSignatures;
        try {
            ClassLoader transformLoader = this.getTransformLoader();
            Class<?> hint = transformLoader.loadClass(hintClass.getText());
            ClosureSignatureHint hintInstance = (ClosureSignatureHint)hint.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            closureSignatures = hintInstance.getClosureSignatures(selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod, this.typeCheckingContext.getSource(), this.typeCheckingContext.getCompilationUnit(), StaticTypeCheckingVisitor.convertToStringArray(options), (ASTNode)expression);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new GroovyBugError((Exception)e);
        }
        return closureSignatures;
    }

    private List<ClassNode[]> resolveWithResolver(List<ClassNode[]> candidates, ClassNode receiver, Expression arguments, ClosureExpression expression, MethodNode selectedMethod, Expression resolverClass, Expression options) {
        try {
            ClassLoader transformLoader = this.getTransformLoader();
            Class<?> resolver = transformLoader.loadClass(resolverClass.getText());
            ClosureSignatureConflictResolver resolverInstance = (ClosureSignatureConflictResolver)resolver.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return resolverInstance.resolve(candidates, receiver, arguments, expression, selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod, this.typeCheckingContext.getSource(), this.typeCheckingContext.getCompilationUnit(), StaticTypeCheckingVisitor.convertToStringArray(options));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new GroovyBugError((Exception)e);
        }
    }

    private ClassLoader getTransformLoader() {
        return (ClassLoader)Optional.ofNullable(this.typeCheckingContext.getCompilationUnit()).map(CompilationUnit::getTransformLoader).orElseGet(() -> this.getSourceUnit().getClassLoader());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void doInferClosureParameterTypes(ClassNode receiver, Expression arguments, ClosureExpression expression, MethodNode selectedMethod, Expression hintClass, Expression resolverClass, Expression options) {
        block18: {
            closureParams = expression.getParameters();
            if (closureParams == null) {
                return;
            }
            closureSignatures = this.getSignaturesFromHint(expression, selectedMethod, hintClass, options);
            candidates /* !! */  = new LinkedList<ClassNode[]>();
            for (ClassNode[] signature : closureSignatures) {
                inferred = this.resolveGenericsFromTypeHint(receiver, arguments, selectedMethod, signature);
                if (signature.length != closureParams.length && (signature.length != 1 || closureParams.length != 0) && (closureParams.length <= signature.length || !inferred[inferred.length - 1].isArray())) continue;
                candidates /* !! */ .add(inferred);
            }
            if (candidates /* !! */ .size() <= 1) break block18;
            candIt = candidates /* !! */ .iterator();
            while (candIt.hasNext()) {
                inferred = (ClassNode[])candIt.next();
                i = 0;
                n = closureParams.length;
                while (i < n) {
                    block19: {
                        closureParam = closureParams[i];
                        declaredType = closureParam.getOriginType();
                        if (i >= inferred.length - 1 && inferred.length != n) break block19;
                        inferredType = inferred[i];
                        ** GOTO lbl30
                    }
                    lastInferred = inferred[inferred.length - 1];
                    if (!lastInferred.isArray()) {
                        candIt.remove();
                    } else {
                        inferredType = lastInferred.getComponentType();
lbl30:
                        // 2 sources

                        if (!StaticTypeCheckingSupport.typeCheckMethodArgumentWithGenerics(declaredType, inferredType, i == n - 1)) {
                            candIt.remove();
                        }
                    }
                    ++i;
                }
            }
            if (candidates /* !! */ .size() > 1 && resolverClass instanceof ClassExpression) {
                candidates /* !! */  = this.resolveWithResolver(candidates /* !! */ , receiver, arguments, expression, selectedMethod, resolverClass, options);
            }
            if (candidates /* !! */ .size() > 1) {
                this.addError("Ambiguous prototypes for closure. More than one target method matches. Please use explicit argument types.", (ASTNode)expression);
            }
        }
        if (candidates /* !! */ .size() == 1) {
            inferred = (ClassNode[])candidates /* !! */ .get(0);
            if (closureParams.length == 0 && inferred.length == 1) {
                expression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, (Object)inferred);
            } else {
                i = 0;
                n = closureParams.length;
                while (i < n) {
                    closureParam = closureParams[i];
                    declaredType = closureParam.getOriginType();
                    inferredType = ClassHelper.OBJECT_TYPE;
                    if (i < inferred.length - 1 || inferred.length == n) {
                        inferredType = inferred[i];
                    } else {
                        lastInferred = inferred[inferred.length - 1];
                        if (lastInferred.isArray()) {
                            inferredType = lastInferred.getComponentType();
                        } else {
                            this.addError("Incorrect number of parameters. Expected " + inferred.length + " but found " + n, (ASTNode)expression);
                        }
                    }
                    if (!StaticTypeCheckingSupport.typeCheckMethodArgumentWithGenerics(declaredType, inferredType, i == n - 1)) {
                        this.addError("Expected parameter of type " + StaticTypeCheckingSupport.prettyPrintType(inferredType) + " but got " + StaticTypeCheckingSupport.prettyPrintType(declaredType), closureParam.getType());
                    }
                    this.typeCheckingContext.controlStructureVariables.put(closureParam, inferredType);
                    ++i;
                }
            }
        }
    }

    private ClassNode[] resolveGenericsFromTypeHint(ClassNode receiver, Expression arguments, MethodNode selectedMethod, ClassNode[] signature) {
        MethodCallExpression call;
        ClassNode dummyResultNode = new ClassNode("ClForInference$" + UNIQUE_LONG.incrementAndGet(), 0, ClassHelper.OBJECT_TYPE).getPlainNodeReference();
        GenericsType[] genericTypes = new GenericsType[signature.length];
        int i = 0;
        int n = signature.length;
        while (i < n) {
            genericTypes[i] = new GenericsType(signature[i]);
            ++i;
        }
        dummyResultNode.setGenericsTypes(genericTypes);
        MethodNode dummyMN = selectedMethod instanceof ExtensionMethodNode ? ((ExtensionMethodNode)selectedMethod).getExtensionMethodNode() : selectedMethod;
        dummyMN = new MethodNode(dummyMN.getName(), dummyMN.getModifiers(), dummyResultNode, dummyMN.getParameters(), dummyMN.getExceptions(), (Statement)EmptyStatement.INSTANCE);
        dummyMN.setDeclaringClass(selectedMethod.getDeclaringClass());
        dummyMN.setGenericsTypes(selectedMethod.getGenericsTypes());
        if (selectedMethod instanceof ExtensionMethodNode) {
            ExtensionMethodNode orig = (ExtensionMethodNode)selectedMethod;
            dummyMN = new ExtensionMethodNode(dummyMN, dummyMN.getName(), dummyMN.getModifiers(), dummyResultNode, orig.getParameters(), orig.getExceptions(), (Statement)EmptyStatement.INSTANCE, orig.isStaticExtension());
            dummyMN.setDeclaringClass(orig.getDeclaringClass());
            dummyMN.setGenericsTypes(orig.getGenericsTypes());
        }
        GenericsType[] typeArguments = null;
        Expression emc = this.typeCheckingContext.getEnclosingMethodCall();
        if (emc instanceof MethodCallExpression && arguments == (call = (MethodCallExpression)emc).getArguments()) {
            typeArguments = call.getGenericsTypes();
        }
        ClassNode returnType = this.inferReturnTypeGenerics(receiver, dummyMN, arguments, typeArguments);
        GenericsType[] returnTypeGenerics = returnType.getGenericsTypes();
        ClassNode[] inferred = new ClassNode[returnTypeGenerics.length];
        int i2 = 0;
        int n2 = returnTypeGenerics.length;
        while (i2 < n2) {
            GenericsType gt = returnTypeGenerics[i2];
            inferred[i2] = !gt.isPlaceholder() ? StaticTypeCheckingSupport.getCombinedBoundType(gt) : (gt.getUpperBounds() != null ? gt.getUpperBounds()[0] : gt.getType().redirect());
            ++i2;
        }
        return inferred;
    }

    private static String[] convertToStringArray(Expression options) {
        if (options == null) {
            return ResolveVisitor.EMPTY_STRING_ARRAY;
        }
        if (options instanceof ConstantExpression) {
            return new String[]{options.getText()};
        }
        if (options instanceof ListExpression) {
            return (String[])((ListExpression)options).getExpressions().stream().map(ASTNode::getText).toArray(String[]::new);
        }
        throw new IllegalArgumentException("Unexpected options for @ClosureParams:" + options);
    }

    private void checkClosureWithDelegatesTo(ClassNode receiver, MethodNode mn, ArgumentListExpression arguments, Parameter[] params, Expression expression, Parameter param) {
        List<AnnotationNode> annotations = param.getAnnotations(DELEGATES_TO);
        if (annotations != null && !annotations.isEmpty()) {
            for (AnnotationNode annotation : annotations) {
                Expression value = annotation.getMember("value");
                Expression strategy = annotation.getMember("strategy");
                Expression genericTypeIndex = annotation.getMember("genericTypeIndex");
                Expression type = annotation.getMember("type");
                Integer stInt = 0;
                if (strategy != null) {
                    stInt = (Integer)StaticTypeCheckingSupport.evaluateExpression((Expression)GeneralUtils.castX((ClassNode)ClassHelper.Integer_TYPE, (Expression)strategy), this.getSourceUnit().getConfiguration());
                }
                if (value instanceof ClassExpression && !value.getType().equals(DELEGATES_TO_TARGET)) {
                    if (genericTypeIndex != null) {
                        this.addStaticTypeError("Cannot use @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") without @DelegatesTo.Target because generic argument types are not available at runtime", (ASTNode)value);
                    }
                    expression.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, (Object)new DelegationMetadata(value.getType(), stInt.intValue(), this.typeCheckingContext.delegationMetadata));
                    continue;
                }
                if (type != null && !"".equals(type.getText()) && type instanceof ConstantExpression) {
                    String typeString = type.getText();
                    ClassNode[] resolved = GenericsUtils.parseClassNodesFromString(typeString, this.getSourceUnit(), this.typeCheckingContext.getCompilationUnit(), mn, (ASTNode)type);
                    if (resolved == null) continue;
                    if (resolved.length == 1) {
                        resolved = this.resolveGenericsFromTypeHint(receiver, (Expression)arguments, mn, resolved);
                        expression.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, (Object)new DelegationMetadata(resolved[0], stInt.intValue(), this.typeCheckingContext.delegationMetadata));
                        continue;
                    }
                    this.addStaticTypeError("Incorrect type hint found in method " + mn, (ASTNode)type);
                    continue;
                }
                List expressions = arguments.getExpressions();
                int expressionsSize = expressions.size();
                Expression parameter = annotation.getMember("target");
                String parameterName = parameter instanceof ConstantExpression ? parameter.getText() : "";
                int j = 0;
                int paramsLength = params.length;
                while (j < paramsLength) {
                    Parameter methodParam = params[j];
                    List<AnnotationNode> targets = methodParam.getAnnotations(DELEGATES_TO_TARGET);
                    if (targets != null && targets.size() == 1) {
                        String id;
                        AnnotationNode targetAnnotation = targets.get(0);
                        Expression idMember = targetAnnotation.getMember("value");
                        String string = id = idMember instanceof ConstantExpression ? idMember.getText() : "";
                        if (id.equals(parameterName) && j < expressionsSize) {
                            Expression actualArgument = (Expression)expressions.get(j);
                            ClassNode actualType = this.getType((ASTNode)actualArgument);
                            if (genericTypeIndex instanceof ConstantExpression) {
                                int gti = Integer.parseInt(genericTypeIndex.getText());
                                ClassNode paramType = methodParam.getType();
                                GenericsType[] genericsTypes = paramType.getGenericsTypes();
                                if (genericsTypes == null) {
                                    this.addStaticTypeError("Cannot use @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") with a type that doesn't use generics", methodParam);
                                } else if (gti < 0 || gti >= genericsTypes.length) {
                                    this.addStaticTypeError("Index of generic type @DelegatesTo(genericTypeIndex=" + genericTypeIndex.getText() + ") " + (gti < 0 ? "lower" : "greater") + " than those of the selected type", methodParam);
                                } else {
                                    ClassNode pType = GenericsUtils.parameterizeType(actualType, paramType);
                                    GenericsType[] pTypeGenerics = pType.getGenericsTypes();
                                    if (pTypeGenerics != null && pTypeGenerics.length > gti) {
                                        actualType = pTypeGenerics[gti].getType();
                                    } else {
                                        this.addStaticTypeError("Unable to map actual type [" + actualType.toString(false) + "] onto " + paramType.toString(false), methodParam);
                                    }
                                }
                            }
                            expression.putNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA, (Object)new DelegationMetadata(actualType, stInt.intValue(), this.typeCheckingContext.delegationMetadata));
                            break;
                        }
                    }
                    ++j;
                }
                if (expression.getNodeMetaData((Object)StaticTypesMarker.DELEGATION_METADATA) != null) continue;
                this.addError("Not enough arguments found for a @DelegatesTo method call. Please check that you either use an explicit class or @DelegatesTo.Target with a correct id", (ASTNode)annotation);
            }
        }
    }

    protected void addReceivers(List<Receiver<String>> receivers, Collection<Receiver<String>> owners, boolean implicitThis) {
        if (!implicitThis || this.typeCheckingContext.delegationMetadata == null) {
            receivers.addAll(owners);
        } else {
            StaticTypeCheckingVisitor.addReceivers(receivers, owners, this.typeCheckingContext.delegationMetadata, "");
        }
    }

    private static void addReceivers(List<Receiver<String>> receivers, Collection<Receiver<String>> owners, DelegationMetadata dmd, String path) {
        int strategy = dmd.getStrategy();
        switch (strategy) {
            case 1: 
            case 3: {
                StaticTypeCheckingVisitor.addDelegateReceiver(receivers, dmd.getType(), String.valueOf(path) + "delegate");
                if (strategy != 1) break;
                if (dmd.getParent() == null) {
                    receivers.addAll(owners);
                    break;
                }
                StaticTypeCheckingVisitor.addReceivers(receivers, owners, dmd.getParent(), String.valueOf(path) + "owner.");
                break;
            }
            case 0: 
            case 2: {
                if (dmd.getParent() == null) {
                    receivers.addAll(owners);
                } else {
                    StaticTypeCheckingVisitor.addReceivers(receivers, owners, dmd.getParent(), String.valueOf(path) + "owner.");
                }
                if (strategy != 0) break;
                StaticTypeCheckingVisitor.addDelegateReceiver(receivers, dmd.getType(), String.valueOf(path) + "delegate");
            }
        }
    }

    private static void addDelegateReceiver(List<Receiver<String>> receivers, ClassNode delegate, String path) {
        if (receivers.stream().map(Receiver::getType).noneMatch(delegate::equals)) {
            receivers.add((Receiver<String>)new Receiver(delegate, (Object)path));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodCallExpression(MethodCallExpression call) {
        String name = call.getMethodAsString();
        if (name == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", (ASTNode)call.getMethod());
            return;
        }
        if (this.extension.beforeMethodCall((MethodCall)call)) {
            this.extension.afterMethodCall((MethodCall)call);
            return;
        }
        this.typeCheckingContext.pushEnclosingMethodCall((Expression)call);
        Expression objectExpression = call.getObjectExpression();
        objectExpression.visit((GroovyCodeVisitor)((Object)this));
        call.getMethod().visit((GroovyCodeVisitor)((Object)this));
        ClassNode receiver = this.getType((ASTNode)objectExpression);
        if (objectExpression instanceof ConstructorCallExpression) {
            this.inferDiamondType((ConstructorCallExpression)objectExpression, receiver.getPlainNodeReference());
        }
        if (call.isSpreadSafe()) {
            ClassNode componentType = this.inferComponentType(receiver, null);
            if (componentType == null) {
                this.addStaticTypeError("Spread-dot operator can only be used on iterable types", (ASTNode)objectExpression);
            } else {
                MethodCallExpression subcall = GeneralUtils.callX((Expression)GeneralUtils.varX((String)"item", (ClassNode)componentType), (String)name, (Expression)call.getArguments());
                subcall.setLineNumber(call.getLineNumber());
                subcall.setColumnNumber(call.getColumnNumber());
                subcall.setImplicitThis(call.isImplicitThis());
                this.visitMethodCallExpression(subcall);
                this.storeTargetMethod(call, (MethodNode)subcall.getNodeMetaData(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
                this.storeType(call, GenericsUtils.makeClassSafe0(ClassHelper.LIST_TYPE, this.getType((ASTNode)((Object)subcall)).asGenericsType()));
            }
            this.typeCheckingContext.popEnclosingMethodCall();
            return;
        }
        Expression callArguments = call.getArguments();
        ArgumentListExpression argumentList = InvocationWriter.makeArgumentList(callArguments);
        this.checkForbiddenSpreadArgument(argumentList);
        this.visitMethodCallArguments(receiver, argumentList, false, null);
        ClassNode[] args = this.getArgumentTypes(argumentList);
        boolean isCallOnClosure = this.isClosureCall(name, objectExpression, callArguments);
        try {
            Parameter[] parameters;
            boolean callArgsVisited = false;
            if (isCallOnClosure) {
                if (StaticTypeCheckingVisitor.isThisExpression(objectExpression)) {
                    FieldNode field = this.typeCheckingContext.getEnclosingClassNode().getDeclaredField(name);
                    GenericsType[] genericsTypes = field.getType().getGenericsTypes();
                    if (genericsTypes != null) {
                        parameters = (Parameter[])field.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                        if (parameters != null) {
                            this.typeCheckClosureCall(callArguments, args, parameters);
                        }
                        ClassNode classNode = genericsTypes[0].getType();
                        this.storeType(call, classNode);
                    }
                } else if (objectExpression instanceof VariableExpression) {
                    Variable variable = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression);
                    if (variable instanceof ASTNode) {
                        ClassNode type;
                        Object data = ((ASTNode)variable).getNodeMetaData(StaticTypesMarker.CLOSURE_ARGUMENTS);
                        if (data != null) {
                            parameters = (Parameter[])data;
                            this.typeCheckClosureCall(callArguments, args, parameters);
                        }
                        if (ClassHelper.CLOSURE_TYPE.equals(type = this.getType((ASTNode)variable))) {
                            GenericsType[] genericsTypeArray = type.getGenericsTypes();
                            type = genericsTypeArray != null && genericsTypeArray.length == 1 && genericsTypeArray[0].getLowerBound() == null ? StaticTypeCheckingSupport.getCombinedBoundType(genericsTypeArray[0]) : ClassHelper.OBJECT_TYPE;
                        }
                        if (type != null) {
                            this.storeType(call, type);
                        }
                    }
                } else if (objectExpression instanceof ClosureExpression) {
                    ClassNode type;
                    Parameter[] parameters2 = ((ClosureExpression)objectExpression).getParameters();
                    if (parameters2 != null) {
                        this.typeCheckClosureCall(callArguments, args, parameters2);
                    }
                    if ((type = this.getInferredReturnType((ASTNode)objectExpression)) != null) {
                        this.storeType(call, type);
                    }
                }
                int nArgs = 0;
                if (callArguments instanceof ArgumentListExpression) {
                    nArgs = ((ArgumentListExpression)callArguments).getExpressions().size();
                }
                this.storeTargetMethod(call, nArgs == 0 ? CLOSURE_CALL_NO_ARG : (nArgs == 1 ? CLOSURE_CALL_ONE_ARG : CLOSURE_CALL_VARGS));
            } else {
                ArrayList<Receiver<String>> receivers = new ArrayList<Receiver<String>>();
                this.addReceivers(receivers, this.makeOwnerList(objectExpression), call.isImplicitThis());
                List<MethodNode> mn = null;
                Receiver chosenReceiver = null;
                for (Receiver receiver2 : receivers) {
                    ClassNode receiverType = receiver2.getType();
                    mn = this.findMethod(receiverType, name, args);
                    if (!mn.isEmpty() && receiver2.getData() == null && (StaticTypeCheckingVisitor.isThisExpression(objectExpression) || call.isImplicitThis()) && (this.typeCheckingContext.isInStaticContext || Modifier.isStatic(receiverType.getModifiers()))) {
                        LinkedList<MethodNode> accessibleMethods = new LinkedList<MethodNode>();
                        LinkedList<MethodNode> inaccessibleMethods = new LinkedList<MethodNode>();
                        for (MethodNode node : mn) {
                            if (node.isStatic() || !this.typeCheckingContext.isInStaticContext && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(receiverType, node.getDeclaringClass())) {
                                accessibleMethods.add(node);
                                continue;
                            }
                            inaccessibleMethods.add(node);
                        }
                        mn = accessibleMethods;
                        if (accessibleMethods.isEmpty()) {
                            MethodNode inaccessibleMethod = (MethodNode)inaccessibleMethods.get(0);
                            this.addStaticTypeError("Non-static method " + StaticTypeCheckingSupport.prettyPrintTypeName(inaccessibleMethod.getDeclaringClass()) + "#" + inaccessibleMethod.getName() + " cannot be called from static context", (ASTNode)((Object)call));
                        }
                    }
                    if (mn.isEmpty()) continue;
                    chosenReceiver = receiver2;
                    break;
                }
                if (mn.isEmpty() && call.isImplicitThis() && StaticTypeCheckingVisitor.isThisExpression(objectExpression) && this.typeCheckingContext.getEnclosingClosure() != null && !(mn = ClassHelper.CLOSURE_TYPE.getDeclaredMethods(name)).isEmpty()) {
                    chosenReceiver = Receiver.make((ClassNode)ClassHelper.CLOSURE_TYPE);
                    objectExpression.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                }
                if (mn.isEmpty()) {
                    mn = this.extension.handleMissingMethod(receiver, name, argumentList, args, (MethodCall)call);
                }
                if (mn.isEmpty()) {
                    this.addNoMatchingMethodError(receiver, name, args, call);
                } else {
                    if (this.areCategoryMethodCalls(mn, name, args)) {
                        this.addCategoryMethodCallError(call);
                    }
                    if ((mn = this.disambiguateMethods(mn, chosenReceiver != null ? chosenReceiver.getType() : null, args, call)).size() == 1) {
                        MethodNode methodNode = mn.get(0);
                        ClassNode declaringClass = methodNode.getDeclaringClass();
                        if (chosenReceiver == null) {
                            chosenReceiver = Receiver.make((ClassNode)declaringClass);
                        }
                        if (!(methodNode.isStatic() || declaringClass.equals(ClassHelper.CLASS_Type) || declaringClass.equals(ClassHelper.OBJECT_TYPE) || !receiver.equals(ClassHelper.CLASS_Type) || chosenReceiver.getData() != null || Boolean.TRUE.equals(call.getNodeMetaData(StaticTypesMarker.DYNAMIC_RESOLUTION)))) {
                            this.addStaticTypeError("Non-static method " + StaticTypeCheckingSupport.prettyPrintTypeName(declaringClass) + "#" + methodNode.getName() + " cannot be called from static context", (ASTNode)((Object)call));
                        } else if (methodNode.isAbstract() && StaticTypeCheckingVisitor.isSuperExpression(objectExpression)) {
                            this.addStaticTypeError("Abstract method " + StaticTypeCheckingSupport.toMethodParametersString(methodNode.getName(), StaticTypeCheckingVisitor.extractTypesFromParameters(methodNode.getParameters())) + " cannot be called directly", (ASTNode)((Object)call));
                        }
                        ClassNode returnType = this.getType(methodNode);
                        if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(returnType)) {
                            this.visitMethodCallArguments(chosenReceiver.getType(), argumentList, true, methodNode);
                            for (Expression argument : argumentList.getExpressions()) {
                                if (!(argument instanceof ClosureExpression)) continue;
                                args = this.getArgumentTypes(argumentList);
                                break;
                            }
                            callArgsVisited = true;
                            ClassNode irtg = this.inferReturnTypeGenerics(chosenReceiver.getType(), methodNode, callArguments, call.getGenericsTypes());
                            ClassNode classNode = returnType = irtg != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(irtg, returnType) ? irtg : returnType;
                        }
                        if (methodNode == GET_DELEGATE && this.typeCheckingContext.getEnclosingClosure() != null) {
                            DelegationMetadata md = this.getDelegationMetadata(this.typeCheckingContext.getEnclosingClosure().getClosureExpression());
                            returnType = md != null ? md.getType() : this.typeCheckingContext.getEnclosingClassNode();
                        }
                        Parameter[] parameters3 = methodNode.getParameters();
                        if (chosenReceiver.getType().getGenericsTypes() != null && !methodNode.isStatic() && !(methodNode instanceof ExtensionMethodNode)) {
                            Map<GenericsType.GenericsTypeName, GenericsType> context = StaticTypeCheckingVisitor.extractPlaceHoldersVisibleToDeclaration(chosenReceiver.getType(), methodNode, (Expression)argumentList);
                            parameters3 = (Parameter[])Arrays.stream(parameters3).map(p -> new Parameter(StaticTypeCheckingSupport.applyGenericsContext(context, p.getType()), p.getName())).toArray(Parameter[]::new);
                        }
                        this.resolvePlaceholdersFromImplicitTypeHints(args, argumentList, parameters3);
                        if (this.typeCheckMethodsWithGenericsOrFail(chosenReceiver.getType(), args, methodNode, call)) {
                            returnType = StaticTypeCheckingVisitor.adjustWithTraits(methodNode, chosenReceiver.getType(), args, returnType);
                            this.storeType(call, returnType);
                            this.storeTargetMethod(call, methodNode);
                            String data = (String)chosenReceiver.getData();
                            if (data != null) {
                                call.putNodeMetaData(StaticTypesMarker.IMPLICIT_RECEIVER, data);
                            }
                            receiver = chosenReceiver.getType();
                        }
                    } else {
                        this.addAmbiguousErrorMessage(mn, name, args, call);
                    }
                }
            }
            if (StaticTypeCheckingSupport.NUMBER_OPS.containsKey(name) && ClassHelper.isNumberType(receiver) && argumentList.getExpressions().size() == 1 && ClassHelper.isNumberType(this.getType((ASTNode)argumentList.getExpression(0)))) {
                ClassNode right = this.getType((ASTNode)argumentList.getExpression(0));
                ClassNode resultType = StaticTypeCheckingVisitor.getMathResultType(StaticTypeCheckingSupport.NUMBER_OPS.get(name), receiver, right, name);
                if (resultType != null) {
                    this.storeType(call, resultType);
                }
            }
            MethodNode target = (MethodNode)call.getNodeMetaData(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            if (!callArgsVisited) {
                this.visitMethodCallArguments(receiver, argumentList, true, target);
            }
            if (target != null) {
                void var13_26;
                List arguments = argumentList.getExpressions();
                parameters = target.getParameters();
                boolean bl = false;
                int n = Math.min(arguments.size(), parameters.length);
                while (var13_26 < n) {
                    int outgoingStrategy;
                    int incomingStrategy;
                    Expression argument = (Expression)arguments.get((int)var13_26);
                    ClassNode aType = this.getType((ASTNode)argument);
                    ClassNode pType = parameters[var13_26].getType();
                    if (ClassHelper.CLOSURE_TYPE.equals(aType) && ClassHelper.CLOSURE_TYPE.equals(pType) && argument instanceof VariableExpression && ((VariableExpression)argument).getAccessedVariable() instanceof Parameter && (incomingStrategy = this.getResolveStrategy((Parameter)((VariableExpression)argument).getAccessedVariable())) != (outgoingStrategy = this.getResolveStrategy(parameters[var13_26])) && argument.getLineNumber() > 0 && this.typeCheckingContext.reportedErrors.add((long)argument.getLineNumber() << 16 + argument.getColumnNumber())) {
                        String warning = "Closure parameter with resolve strategy " + ClosureUtils.getResolveStrategyName((int)incomingStrategy) + " passed to method with resolve strategy " + ClosureUtils.getResolveStrategyName((int)outgoingStrategy);
                        this.typeCheckingContext.getErrorCollector().addWarning(1, "[Static type checking] - " + warning, (CSTNode)new Token(0, argument.getText(), argument.getLineNumber(), argument.getColumnNumber()), this.getSourceUnit());
                    }
                    ++var13_26;
                }
            }
        }
        finally {
            this.typeCheckingContext.popEnclosingMethodCall();
            this.extension.afterMethodCall((MethodCall)call);
        }
    }

    private int getResolveStrategy(Parameter parameter) {
        Expression strategy;
        List<AnnotationNode> annotations = parameter.getAnnotations(DELEGATES_TO);
        if (annotations != null && !annotations.isEmpty() && (strategy = annotations.get(0).getMember("strategy")) != null) {
            return (Integer)StaticTypeCheckingSupport.evaluateExpression((Expression)GeneralUtils.castX((ClassNode)ClassHelper.Integer_TYPE, (Expression)strategy), this.getSourceUnit().getConfiguration());
        }
        return 0;
    }

    private void inferMethodReferenceType(ClassNode receiver, ArgumentListExpression argumentList, MethodNode selectedMethod) {
        if (receiver == null) {
            return;
        }
        if (argumentList == null) {
            return;
        }
        if (selectedMethod == null) {
            return;
        }
        List argumentExpressions = argumentList.getExpressions();
        if (argumentExpressions == null || argumentExpressions.stream().noneMatch(e -> e instanceof MethodReferenceExpression)) {
            return;
        }
        Parameter[] parameters = selectedMethod.getParameters();
        int nthParameter = parameters.length - 1;
        LinkedList<Integer> methodReferencePositions = new LinkedList<Integer>();
        LinkedList<Object> newArgumentExpressions = new LinkedList<Object>();
        int i = 0;
        int n = argumentExpressions.size();
        while (i < n) {
            Expression argumentExpression = (Expression)argumentExpressions.get(i);
            if (!(argumentExpression instanceof MethodReferenceExpression)) {
                newArgumentExpressions.add(argumentExpression);
            } else {
                Parameter param = parameters[Math.min(i, nthParameter)];
                ClassNode paramType = param.getType();
                if (i >= nthParameter && paramType.isArray()) {
                    paramType = paramType.getComponentType();
                }
                if (!ClassHelper.isFunctionalInterface(paramType.redirect())) {
                    this.addError("The argument is a method reference, but the parameter type is not a functional interface", (ASTNode)argumentExpression);
                    newArgumentExpressions.add(argumentExpression);
                } else {
                    methodReferencePositions.add(i);
                    newArgumentExpressions.add(this.constructLambdaExpressionForMethodReference(paramType, (MethodReferenceExpression)argumentExpression));
                }
            }
            ++i;
        }
        if (methodReferencePositions.isEmpty()) {
            return;
        }
        this.visitMethodCallArguments(receiver, GeneralUtils.args(newArgumentExpressions), true, selectedMethod);
        Iterator iterator = methodReferencePositions.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            Expression lambdaExpression = (Expression)newArgumentExpressions.get(index);
            Expression methodReferenceExpression = (Expression)argumentExpressions.get(index);
            methodReferenceExpression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, lambdaExpression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS));
        }
    }

    private LambdaExpression constructLambdaExpressionForMethodReference(ClassNode functionalInterfaceType, MethodReferenceExpression methodReference) {
        Parameter[] parameters = ClassHelper.findSAM(functionalInterfaceType).getParameters();
        int nParameters = parameters.length;
        if (nParameters > 0) {
            ClassNode objExpType;
            ClassNode firstParamType = ClassHelper.DYNAMIC_TYPE;
            List candidates = (List)methodReference.getNodeMetaData(MethodNode.class);
            if (candidates != null && !candidates.isEmpty() && StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(objExpType = this.getType((ASTNode)methodReference.getExpression())) && candidates.stream().allMatch(mn -> !mn.isStatic())) {
                firstParamType = objExpType.getGenericsTypes()[0].getType();
            }
            parameters = new Parameter[nParameters];
            int i = 0;
            while (i < nParameters) {
                parameters[i] = new Parameter(i == 0 ? firstParamType : ClassHelper.DYNAMIC_TYPE, "p" + i);
                ++i;
            }
        }
        return new LambdaExpression(parameters, GENERATED_EMPTY_STATEMENT);
    }

    private static ClassNode adjustWithTraits(MethodNode directMethodCallCandidate, ClassNode receiver, ClassNode[] args, ClassNode returnType) {
        ExtensionMethodNode emn;
        if (directMethodCallCandidate instanceof ExtensionMethodNode && "withTraits".equals((emn = (ExtensionMethodNode)directMethodCallCandidate).getName()) && "DefaultGroovyMethods".equals(emn.getExtensionMethodNode().getDeclaringClass().getNameWithoutPackage())) {
            LinkedList<ClassNode> nodes = new LinkedList<ClassNode>();
            Collections.addAll(nodes, receiver.getInterfaces());
            ClassNode[] classNodeArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode arg = classNodeArray[n2];
                if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(arg)) {
                    nodes.add(arg.getGenericsTypes()[0].getType());
                } else {
                    nodes.add(arg);
                }
                ++n2;
            }
            return new WideningCategories.LowestUpperBoundClassNode(String.valueOf(returnType.getName()) + "Composed", ClassHelper.OBJECT_TYPE, nodes.toArray(ClassNode.EMPTY_ARRAY));
        }
        return returnType;
    }

    private static void addArrayMethods(List<MethodNode> methods, ClassNode receiver, String name, ClassNode[] args) {
        if (!receiver.isArray()) {
            return;
        }
        if (args == null || args.length != 1) {
            return;
        }
        if (!WideningCategories.isIntCategory((ClassNode)ClassHelper.getUnwrapper(args[0]))) {
            return;
        }
        if ("getAt".equals(name)) {
            MethodNode node = new MethodNode(name, 1, receiver.getComponentType(), new Parameter[]{new Parameter(args[0], "arg")}, null, null);
            node.setDeclaringClass(receiver.redirect());
            methods.add(node);
        } else if ("setAt".equals(name)) {
            MethodNode node = new MethodNode(name, 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(args[0], "arg")}, null, null);
            node.setDeclaringClass(receiver.redirect());
            methods.add(node);
        }
    }

    protected ClassNode getInferredReturnTypeFromWithClosureArgument(Expression callArguments) {
        if (!(callArguments instanceof ArgumentListExpression)) {
            return null;
        }
        ArgumentListExpression argList = (ArgumentListExpression)callArguments;
        ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
        this.visitClosureExpression(closure);
        if (this.getInferredReturnType((ASTNode)closure) != null) {
            return this.getInferredReturnType((ASTNode)closure);
        }
        return null;
    }

    protected List<Receiver<String>> makeOwnerList(Expression objectExpression) {
        ClassNode receiver = this.getType((ASTNode)objectExpression);
        ArrayList<Receiver<String>> owners = new ArrayList<Receiver<String>>();
        if (this.typeCheckingContext.delegationMetadata != null && objectExpression instanceof VariableExpression && ((Variable)objectExpression).getName().equals("owner") && this.typeCheckingContext.delegationMetadata.getParent() != null) {
            List<Receiver<String>> enclosingClass = Collections.singletonList(Receiver.make((ClassNode)this.typeCheckingContext.getEnclosingClassNode()));
            StaticTypeCheckingVisitor.addReceivers(owners, enclosingClass, this.typeCheckingContext.delegationMetadata.getParent(), "owner.");
        } else {
            ClassNode commonType;
            int temporaryTypesCount;
            List<ClassNode> temporaryTypes = this.getTemporaryTypesForExpression(objectExpression);
            int n = temporaryTypesCount = temporaryTypes != null ? temporaryTypes.size() : 0;
            if (temporaryTypesCount > 0 && !(commonType = WideningCategories.lowestUpperBound(temporaryTypes)).equals(ClassHelper.OBJECT_TYPE)) {
                owners.add((Receiver<String>)Receiver.make((ClassNode)commonType));
            }
            if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver)) {
                ClassNode staticType = receiver.getGenericsTypes()[0].getType();
                owners.add((Receiver<String>)Receiver.make((ClassNode)staticType));
                StaticTypeCheckingVisitor.addTraitType(staticType, owners);
                owners.add((Receiver<String>)Receiver.make((ClassNode)receiver));
            } else {
                StaticTypeCheckingVisitor.addBoundType(receiver, owners);
                StaticTypeCheckingVisitor.addSelfTypes(receiver, owners);
                StaticTypeCheckingVisitor.addTraitType(receiver, owners);
                if (receiver.redirect().isInterface()) {
                    owners.add((Receiver<String>)Receiver.make((ClassNode)ClassHelper.OBJECT_TYPE));
                }
            }
            if (this.typeCheckingContext.lastImplicitItType != null && objectExpression instanceof VariableExpression && ((Variable)objectExpression).getName().equals("it")) {
                owners.add((Receiver<String>)Receiver.make((ClassNode)this.typeCheckingContext.lastImplicitItType));
            }
            if (temporaryTypesCount > 1) {
                owners.add((Receiver<String>)Receiver.make((ClassNode)new UnionTypeClassNode(temporaryTypes.toArray(ClassNode.EMPTY_ARRAY))));
            }
        }
        return owners;
    }

    private static void addBoundType(ClassNode receiver, List<Receiver<String>> owners) {
        if (!receiver.isGenericsPlaceHolder() || receiver.getGenericsTypes() == null) {
            owners.add((Receiver<String>)Receiver.make((ClassNode)receiver));
            return;
        }
        GenericsType gt = receiver.getGenericsTypes()[0];
        if (gt.getLowerBound() == null && gt.getUpperBounds() != null) {
            ClassNode[] classNodeArray = gt.getUpperBounds();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode cn = classNodeArray[n2];
                StaticTypeCheckingVisitor.addBoundType(cn, owners);
                StaticTypeCheckingVisitor.addSelfTypes(cn, owners);
                ++n2;
            }
        } else {
            ClassNode cn = gt.getType().redirect();
            owners.add((Receiver<String>)Receiver.make((ClassNode)cn));
        }
    }

    private static void addSelfTypes(ClassNode receiver, List<Receiver<String>> owners) {
        for (ClassNode selfType : Traits.collectSelfTypes(receiver, new LinkedHashSet<ClassNode>())) {
            owners.add((Receiver<String>)Receiver.make((ClassNode)selfType));
        }
    }

    private static void addTraitType(ClassNode receiver, List<Receiver<String>> owners) {
        if (Traits.isTrait(receiver.getOuterClass()) && receiver.getName().endsWith("$Helper")) {
            ClassNode traitType = receiver.getOuterClass();
            owners.add((Receiver<String>)Receiver.make((ClassNode)traitType));
            StaticTypeCheckingVisitor.addSelfTypes(traitType, owners);
        }
    }

    protected void checkForbiddenSpreadArgument(ArgumentListExpression argumentList) {
        for (Expression arg : argumentList.getExpressions()) {
            if (!(arg instanceof SpreadExpression)) continue;
            this.addStaticTypeError("The spread operator cannot be used as argument of method or closure calls with static type checking because the number of arguments cannot be determined at compile time", (ASTNode)arg);
        }
    }

    protected List<ClassNode> getTemporaryTypesForExpression(Expression objectExpression) {
        List classNodes = null;
        int depth = this.typeCheckingContext.temporaryIfBranchTypeInformation.size();
        while (classNodes == null && depth > 0) {
            Map tempo = (Map)this.typeCheckingContext.temporaryIfBranchTypeInformation.get(--depth);
            Object key = objectExpression instanceof ParameterVariableExpression ? ((ParameterVariableExpression)objectExpression).parameter : this.extractTemporaryTypeInfoKey(objectExpression);
            classNodes = (List)tempo.get(key);
        }
        return classNodes;
    }

    protected void storeTargetMethod(Expression call, MethodNode directMethodCallCandidate) {
        call.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, (Object)directMethodCallCandidate);
        if (directMethodCallCandidate != null && directMethodCallCandidate.isStatic() && directMethodCallCandidate.getDeclaringClass().isInterface() && !(directMethodCallCandidate instanceof ExtensionMethodNode)) {
            this.typeCheckingContext.getEnclosingClassNode().putNodeMetaData("_MINIMUM_BYTECODE_VERSION", 52);
        }
        this.checkOrMarkPrivateAccess(call, directMethodCallCandidate);
        this.checkSuperCallFromClosure(call, directMethodCallCandidate);
        this.extension.onMethodSelection(call, directMethodCallCandidate);
    }

    private void checkSuperCallFromClosure(Expression call, MethodNode directCallTarget) {
        Expression objectExpression;
        if (call instanceof MethodCallExpression && this.typeCheckingContext.getEnclosingClosure() != null && StaticTypeCheckingVisitor.isSuperExpression(objectExpression = ((MethodCallExpression)call).getObjectExpression())) {
            ClassNode current = this.typeCheckingContext.getEnclosingClassNode();
            ((LinkedList)current.getNodeMetaData(StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED, x -> new LinkedList())).add(directCallTarget);
            call.putNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED, (Object)current);
        }
    }

    @Deprecated
    protected boolean isClosureCall(String name, Expression objectExpression, Expression arguments) {
        if (objectExpression instanceof ClosureExpression && ("call".equals(name) || "doCall".equals(name))) {
            return true;
        }
        if (StaticTypeCheckingVisitor.isThisExpression(objectExpression)) {
            FieldNode fieldNode = this.typeCheckingContext.getEnclosingClassNode().getDeclaredField(name);
            if (fieldNode != null && ClassHelper.CLOSURE_TYPE.equals(fieldNode.getType()) && !this.typeCheckingContext.getEnclosingClassNode().hasPossibleMethod(name, arguments)) {
                return true;
            }
        } else if (!"call".equals(name) && !"doCall".equals(name)) {
            return false;
        }
        return this.getType((ASTNode)objectExpression).equals(ClassHelper.CLOSURE_TYPE);
    }

    protected void typeCheckClosureCall(Expression arguments, ClassNode[] argumentTypes, Parameter[] parameters) {
        if (StaticTypeCheckingSupport.allParametersAndArgumentsMatchWithDefaultParams(parameters, argumentTypes) < 0 && StaticTypeCheckingSupport.lastArgMatchesVarg(parameters, argumentTypes) < 0) {
            this.addStaticTypeError("Cannot call closure that accepts " + StaticTypeCheckingVisitor.formatArgumentList(StaticTypeCheckingVisitor.extractTypesFromParameters(parameters)) + " with " + StaticTypeCheckingVisitor.formatArgumentList(argumentTypes), (ASTNode)arguments);
        }
    }

    @Override
    public void visitIfElse(IfStatement ifElse) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        try {
            this.typeCheckingContext.pushTemporaryTypeInfo();
            this.visitStatement((Statement)ifElse);
            ifElse.getBooleanExpression().visit((GroovyCodeVisitor)((Object)this));
            ifElse.getIfBlock().visit((GroovyCodeVisitor)((Object)this));
            this.typeCheckingContext.popTemporaryTypeInfo();
            this.restoreTypeBeforeConditional();
            ifElse.getElseBlock().visit((GroovyCodeVisitor)((Object)this));
            Map updates = (Map)ifElse.getElseBlock().getNodeMetaData((Object)"assignments");
            if (updates != null) {
                updates.forEach(this::recordAssignment);
            }
        }
        finally {
            ifElse.putNodeMetaData((Object)"assignments", this.popAssignmentTracking(oldTracker));
        }
        if (!this.typeCheckingContext.enclosingBlocks.isEmpty()) {
            BinaryExpression instanceOfExpression = this.findInstanceOfNotReturnExpression(ifElse);
            if (instanceOfExpression == null) {
                instanceOfExpression = this.findNotInstanceOfReturnExpression(ifElse);
            }
            if (instanceOfExpression != null) {
                this.visitInstanceofNot(instanceOfExpression);
            }
        }
    }

    protected void visitInstanceofNot(BinaryExpression be) {
        BlockStatement currentBlock = (BlockStatement)this.typeCheckingContext.enclosingBlocks.getFirst();
        assert (currentBlock != null);
        if (!this.typeCheckingContext.blockStatements2Types.containsKey(currentBlock)) {
            Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
            this.getTypeCheckingContext().pushTemporaryTypeInfo();
            this.typeCheckingContext.blockStatements2Types.put(currentBlock, oldTracker);
        }
        this.pushInstanceOfTypeInfo(be.getLeftExpression(), be.getRightExpression());
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        if (block != null) {
            this.typeCheckingContext.enclosingBlocks.addFirst(block);
        }
        super.visitBlockStatement(block);
        if (block != null) {
            this.visitClosingBlock(block);
        }
    }

    public void visitClosingBlock(BlockStatement block) {
        BlockStatement peekBlock = (BlockStatement)this.typeCheckingContext.enclosingBlocks.removeFirst();
        boolean found = this.typeCheckingContext.blockStatements2Types.containsKey(peekBlock);
        if (found) {
            Map oldTracker = (Map)this.typeCheckingContext.blockStatements2Types.remove(peekBlock);
            this.getTypeCheckingContext().popTemporaryTypeInfo();
            this.popAssignmentTracking(oldTracker);
        }
    }

    protected BinaryExpression findInstanceOfNotReturnExpression(IfStatement ifElse) {
        Statement elseBlock = ifElse.getElseBlock();
        if (!(elseBlock instanceof EmptyStatement)) {
            return null;
        }
        Expression conditionExpression = ifElse.getBooleanExpression().getExpression();
        if (!(conditionExpression instanceof NotExpression)) {
            return null;
        }
        NotExpression notExpression = (NotExpression)conditionExpression;
        Expression expression = notExpression.getExpression();
        if (!(expression instanceof BinaryExpression)) {
            return null;
        }
        BinaryExpression instanceOfExpression = (BinaryExpression)expression;
        int op = instanceOfExpression.getOperation().getType();
        if (op != 544) {
            return null;
        }
        if (StaticTypeCheckingVisitor.notReturningBlock(ifElse.getIfBlock())) {
            return null;
        }
        return instanceOfExpression;
    }

    protected BinaryExpression findNotInstanceOfReturnExpression(IfStatement ifElse) {
        Statement elseBlock = ifElse.getElseBlock();
        if (!(elseBlock instanceof EmptyStatement)) {
            return null;
        }
        Expression conditionExpression = ifElse.getBooleanExpression().getExpression();
        if (!(conditionExpression instanceof BinaryExpression)) {
            return null;
        }
        BinaryExpression instanceOfExpression = (BinaryExpression)conditionExpression;
        int op = instanceOfExpression.getOperation().getType();
        if (op != 130) {
            return null;
        }
        if (StaticTypeCheckingVisitor.notReturningBlock(ifElse.getIfBlock())) {
            return null;
        }
        return instanceOfExpression;
    }

    private static boolean notReturningBlock(Statement statement) {
        return statement.isEmpty() || !(statement instanceof BlockStatement) || !(DefaultGroovyMethods.last((List)((BlockStatement)statement).getStatements()) instanceof ReturnStatement);
    }

    @Override
    public void visitSwitch(SwitchStatement statement) {
        this.typeCheckingContext.pushEnclosingSwitchStatement(statement);
        try {
            Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
            try {
                super.visitSwitch(statement);
            }
            finally {
                this.popAssignmentTracking(oldTracker);
            }
        }
        finally {
            this.typeCheckingContext.popEnclosingSwitchStatement();
        }
    }

    protected void afterSwitchConditionExpressionVisited(SwitchStatement statement) {
        Expression conditionExpression = statement.getExpression();
        conditionExpression.putNodeMetaData((Object)StaticTypesMarker.TYPE, (Object)this.getType((ASTNode)conditionExpression));
    }

    @Override
    public void visitCaseStatement(CaseStatement statement) {
        Expression expression = statement.getExpression();
        if (expression instanceof ClosureExpression) {
            SwitchStatement switchStatement = this.typeCheckingContext.getEnclosingSwitchStatement();
            ClassNode inf = (ClassNode)switchStatement.getExpression().getNodeMetaData((Object)StaticTypesMarker.TYPE);
            expression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, (Object)new ClassNode[]{inf});
        }
        super.visitCaseStatement(statement);
        this.restoreTypeBeforeConditional();
    }

    private void recordAssignment(VariableExpression lhsExpr, ClassNode rhsType) {
        this.typeCheckingContext.ifElseForWhileAssignmentTracker.computeIfAbsent(lhsExpr, lhs -> {
            ClassNode lhsType = (ClassNode)lhs.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            ArrayList<ClassNode> types = new ArrayList<ClassNode>(2);
            types.add(lhsType);
            return types;
        }).add(rhsType);
    }

    private void restoreTypeBeforeConditional() {
        this.typeCheckingContext.ifElseForWhileAssignmentTracker.forEach((var, types) -> var.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, types.get(0)));
    }

    protected Map<VariableExpression, ClassNode> popAssignmentTracking(Map<VariableExpression, List<ClassNode>> oldTracker) {
        HashMap<VariableExpression, ClassNode> assignments = new HashMap<VariableExpression, ClassNode>();
        this.typeCheckingContext.ifElseForWhileAssignmentTracker.forEach((var, types) -> types.stream().filter(t -> t != null && t != StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE).reduce(WideningCategories::lowestUpperBound).ifPresent(type -> {
            assignments.put((VariableExpression)var, (ClassNode)type);
            this.storeType((Expression)var, (ClassNode)type);
        }));
        this.typeCheckingContext.ifElseForWhileAssignmentTracker = oldTracker;
        return assignments;
    }

    protected Map<VariableExpression, List<ClassNode>> pushAssignmentTracking() {
        Map oldTracker = this.typeCheckingContext.ifElseForWhileAssignmentTracker;
        this.typeCheckingContext.ifElseForWhileAssignmentTracker = new HashMap();
        return oldTracker;
    }

    public void visitArrayExpression(ArrayExpression expression) {
        List expressions;
        ClassNode elementType;
        super.visitArrayExpression(expression);
        if (expression.hasInitializer()) {
            elementType = expression.getElementType();
            expressions = expression.getExpressions();
        } else {
            elementType = ClassHelper.int_TYPE;
            expressions = expression.getSizeExpression();
        }
        for (Expression elementExpr : expressions) {
            if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(elementType, this.getType((ASTNode)elementExpr), elementExpr, false)) continue;
            this.addStaticTypeError("Cannot convert from " + StaticTypeCheckingSupport.prettyPrintType(this.getType((ASTNode)elementExpr)) + " to " + StaticTypeCheckingSupport.prettyPrintType(elementType), (ASTNode)elementExpr);
        }
    }

    public void visitCastExpression(CastExpression expression) {
        ClassNode type = expression.getType();
        Expression target = expression.getExpression();
        if (ClassHelper.isFunctionalInterface(type)) {
            this.processFunctionalInterfaceAssignment(type, target);
        } else if (StaticTypeCheckingVisitor.isClosureWithType(type) && target instanceof ClosureExpression) {
            this.storeInferredReturnType((ASTNode)target, StaticTypeCheckingSupport.getCombinedBoundType(type.getGenericsTypes()[0]));
        }
        target.visit((GroovyCodeVisitor)((Object)this));
        if (!(expression.isCoerce() || this.checkCast(type, target) || this.isDelegateOrOwnerInClosure(target))) {
            this.addStaticTypeError("Inconvertible types: cannot cast " + StaticTypeCheckingSupport.prettyPrintType(this.getType((ASTNode)target)) + " to " + StaticTypeCheckingSupport.prettyPrintType(type), (ASTNode)expression);
        }
    }

    private boolean isDelegateOrOwnerInClosure(Expression exp) {
        return this.typeCheckingContext.getEnclosingClosure() != null && exp instanceof VariableExpression && ("delegate".equals(((VariableExpression)exp).getName()) || "owner".equals(((VariableExpression)exp).getName()));
    }

    protected boolean checkCast(ClassNode targetType, Expression source) {
        boolean sourceIsNull = StaticTypeCheckingVisitor.isNullConstant(source);
        ClassNode expressionType = this.getType((ASTNode)source);
        if (targetType.isArray() && expressionType.isArray()) {
            return this.checkCast(targetType.getComponentType(), (Expression)GeneralUtils.varX((String)"foo", (ClassNode)expressionType.getComponentType()));
        }
        if (!(targetType.equals(ClassHelper.char_TYPE) && expressionType == ClassHelper.STRING_TYPE && source instanceof ConstantExpression && source.getText().length() == 1 || targetType.equals(ClassHelper.Character_TYPE) && (expressionType == ClassHelper.STRING_TYPE || sourceIsNull) && (sourceIsNull || source instanceof ConstantExpression && source.getText().length() == 1) || WideningCategories.isNumberCategory((ClassNode)ClassHelper.getWrapper(targetType)) && (WideningCategories.isNumberCategory((ClassNode)ClassHelper.getWrapper(expressionType)) || ClassHelper.char_TYPE == expressionType) || sourceIsNull && !ClassHelper.isPrimitiveType(targetType) || ClassHelper.char_TYPE == targetType && ClassHelper.isPrimitiveType(expressionType) && ClassHelper.isNumberType(expressionType))) {
            if (sourceIsNull && ClassHelper.isPrimitiveType(targetType) && !ClassHelper.boolean_TYPE.equals(targetType)) {
                return false;
            }
            if (!Modifier.isFinal(expressionType.getModifiers()) && targetType.isInterface()) {
                return true;
            }
            if (!Modifier.isFinal(targetType.getModifiers()) && expressionType.isInterface()) {
                return true;
            }
            if (!StaticTypeCheckingSupport.isAssignableTo(targetType, expressionType) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(expressionType, targetType)) {
                return false;
            }
        }
        return true;
    }

    public void visitTernaryExpression(TernaryExpression expression) {
        ClassNode resultType;
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        this.typeCheckingContext.pushTemporaryTypeInfo();
        if (!(expression instanceof ElvisOperatorExpression)) {
            expression.getBooleanExpression().visit((GroovyCodeVisitor)((Object)this));
        }
        Expression trueExpression = expression.getTrueExpression();
        ClassNode typeOfTrue = this.findCurrentInstanceOfClass(trueExpression, null);
        trueExpression.visit((GroovyCodeVisitor)((Object)this));
        if (typeOfTrue == null) {
            typeOfTrue = this.getType((ASTNode)trueExpression);
        }
        this.typeCheckingContext.popTemporaryTypeInfo();
        Expression falseExpression = expression.getFalseExpression();
        falseExpression.visit((GroovyCodeVisitor)((Object)this));
        ClassNode typeOfFalse = this.getType((ASTNode)falseExpression);
        if (StaticTypeCheckingVisitor.isNullConstant(trueExpression) && StaticTypeCheckingVisitor.isNullConstant(falseExpression)) {
            resultType = this.checkForTargetType(trueExpression, StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE);
        } else if (StaticTypeCheckingVisitor.isNullConstant(trueExpression) || StaticTypeCheckingVisitor.isEmptyCollection(trueExpression) && GeneralUtils.isOrImplements((ClassNode)typeOfTrue, (ClassNode)typeOfFalse)) {
            resultType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.checkForTargetType(falseExpression, typeOfFalse));
        } else if (StaticTypeCheckingVisitor.isNullConstant(falseExpression) || StaticTypeCheckingVisitor.isEmptyCollection(falseExpression) && GeneralUtils.isOrImplements((ClassNode)typeOfFalse, (ClassNode)typeOfTrue)) {
            resultType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.checkForTargetType(trueExpression, typeOfTrue));
        } else {
            typeOfFalse = this.checkForTargetType(falseExpression, typeOfFalse);
            typeOfTrue = this.checkForTargetType(trueExpression, typeOfTrue);
            resultType = WideningCategories.lowestUpperBound((ClassNode)typeOfTrue, (ClassNode)typeOfFalse);
        }
        this.storeType((Expression)expression, resultType);
        this.popAssignmentTracking(oldTracker);
    }

    private ClassNode checkForTargetType(Expression expr, ClassNode type) {
        ClassNode sourceType = type;
        ClassNode targetType = null;
        MethodNode enclosingMethod = this.typeCheckingContext.getEnclosingMethod();
        MethodCall enclosingMethodCall = (MethodCall)this.typeCheckingContext.getEnclosingMethodCall();
        BinaryExpression enclosingExpression = this.typeCheckingContext.getEnclosingBinaryExpression();
        if (enclosingExpression != null && StaticTypeCheckingSupport.isAssignment(enclosingExpression.getOperation().getType()) && StaticTypeCheckingVisitor.isTypeSource(expr, enclosingExpression.getRightExpression())) {
            targetType = this.getDeclaredOrInferredType(enclosingExpression.getLeftExpression());
        } else if (!(enclosingMethodCall != null && InvocationWriter.makeArgumentList(enclosingMethodCall.getArguments()).getExpressions().stream().anyMatch(arg -> StaticTypeCheckingVisitor.isTypeSource(expr, arg)) || enclosingMethod == null || enclosingMethod.isAbstract() || enclosingMethod.isVoidMethod() || !StaticTypeCheckingVisitor.isTypeSource(expr, enclosingMethod))) {
            targetType = enclosingMethod.getReturnType();
        }
        if (targetType == null) {
            targetType = ClassHelper.OBJECT_TYPE;
        }
        if (sourceType == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE) {
            return targetType;
        }
        if (expr instanceof ConstructorCallExpression) {
            this.inferDiamondType((ConstructorCallExpression)expr, targetType);
        }
        return StaticTypeCheckingVisitor.adjustForTargetType(sourceType, targetType);
    }

    private static ClassNode adjustForTargetType(ClassNode resultType, ClassNode targetType) {
        if (targetType.isUsingGenerics() && StaticTypeCheckingSupport.missesGenericsTypes(resultType) && !resultType.isGenericsPlaceHolder()) {
            if (targetType.equals(resultType)) {
                if (!targetType.isGenericsPlaceHolder()) {
                    return targetType;
                }
            } else {
                HashMap<GenericsType.GenericsTypeName, GenericsType> gt = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                StaticTypeCheckingSupport.extractGenericsConnections(gt, resultType, resultType.redirect());
                ClassNode sc = resultType;
                while ((sc = ClassHelper.getNextSuperClass(sc, targetType)) != null && !sc.equals(targetType)) {
                }
                StaticTypeCheckingSupport.extractGenericsConnections(gt, targetType, sc);
                return StaticTypeCheckingSupport.applyGenericsContext(gt, resultType.redirect());
            }
        }
        return resultType;
    }

    private static boolean isTypeSource(Expression expr, Expression right) {
        if (right instanceof TernaryExpression) {
            return StaticTypeCheckingVisitor.isTypeSource(expr, ((TernaryExpression)right).getTrueExpression()) || StaticTypeCheckingVisitor.isTypeSource(expr, ((TernaryExpression)right).getFalseExpression());
        }
        return expr == right;
    }

    private static boolean isTypeSource(final Expression expr, MethodNode mNode) {
        final boolean[] returned = new boolean[1];
        mNode.getCode().visit((GroovyCodeVisitor)new CodeVisitorSupport(){

            public void visitReturnStatement(ReturnStatement returnStatement) {
                if (StaticTypeCheckingVisitor.isTypeSource(expr, returnStatement.getExpression())) {
                    returned[0] = true;
                }
            }

            public void visitClosureExpression(ClosureExpression expression) {
            }
        });
        if (!returned[0]) {
            new ReturnAdder(returnStatement -> {
                if (StaticTypeCheckingVisitor.isTypeSource(expr, returnStatement.getExpression())) {
                    blArray[0] = true;
                }
            }).visitMethod(mNode);
        }
        return returned[0];
    }

    private static boolean isEmptyCollection(Expression expr) {
        return expr instanceof ListExpression && ((ListExpression)expr).getExpressions().isEmpty() || expr instanceof MapExpression && ((MapExpression)expr).getMapEntryExpressions().isEmpty();
    }

    private static boolean hasInferredReturnType(Expression expression) {
        ClassNode type = (ClassNode)expression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        return type != null && !type.getName().equals("java.lang.Object");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitTryCatchFinally(TryCatchStatement statement) {
        catchStatements = statement.getCatchStatements();
        for (CatchStatement catchStatement : catchStatements) {
            exceptionType = catchStatement.getExceptionType();
            this.typeCheckingContext.controlStructureVariables.put(catchStatement.getVariable(), exceptionType);
        }
        try {
            super.visitTryCatchFinally(statement);
        }
        finally {
            ** for (catchStatement : catchStatements)
        }
lbl-1000:
        // 1 sources

        {
            this.typeCheckingContext.controlStructureVariables.remove(catchStatement.getVariable());
            continue;
        }
lbl15:
        // 1 sources

    }

    protected void storeType(Expression exp, ClassNode cn) {
        ClassNode oldValue;
        if (cn == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE) {
            cn = this.getOriginalDeclarationType(exp);
        }
        if (cn != null && ClassHelper.isPrimitiveType(cn)) {
            if (exp instanceof VariableExpression && ((VariableExpression)exp).isClosureSharedVariable()) {
                cn = ClassHelper.getWrapper(cn);
            } else if (exp instanceof MethodCallExpression && ((MethodCallExpression)exp).isSafe()) {
                cn = ClassHelper.getWrapper(cn);
            } else if (exp instanceof PropertyExpression && ((PropertyExpression)exp).isSafe()) {
                cn = ClassHelper.getWrapper(cn);
            }
        }
        if ((oldValue = (ClassNode)exp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, (Object)cn)) != null) {
            ClassNode oldDIT = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE);
            if (oldDIT != null) {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, (Object)(cn == null ? oldDIT : WideningCategories.lowestUpperBound((ClassNode)oldDIT, (ClassNode)cn)));
            } else {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, cn == null ? null : WideningCategories.lowestUpperBound((ClassNode)oldValue, (ClassNode)cn));
            }
        }
        if (exp instanceof VariableExpression) {
            List<ClassNode> temporaryTypesForExpression;
            VariableExpression var = (VariableExpression)exp;
            Variable accessedVariable = var.getAccessedVariable();
            if (accessedVariable instanceof VariableExpression) {
                if (accessedVariable != var) {
                    this.storeType((Expression)((VariableExpression)accessedVariable), cn);
                }
            } else if (accessedVariable instanceof Parameter) {
                ((Parameter)accessedVariable).putNodeMetaData(StaticTypesMarker.INFERRED_TYPE, cn);
            }
            if (cn != null && var.isClosureSharedVariable()) {
                List assignedTypes = this.typeCheckingContext.closureSharedVariablesAssignmentTypes.computeIfAbsent(var, k -> new LinkedList());
                assignedTypes.add(cn);
            }
            if (!this.typeCheckingContext.temporaryIfBranchTypeInformation.isEmpty() && (temporaryTypesForExpression = this.getTemporaryTypesForExpression((Expression)var)) != null && !temporaryTypesForExpression.isEmpty()) {
                temporaryTypesForExpression.clear();
            }
        }
    }

    protected ClassNode getResultType(ClassNode left, int op, ClassNode right, BinaryExpression expr) {
        MethodNode method;
        ClassNode leftRedirect = left.redirect();
        ClassNode rightRedirect = right.redirect();
        Expression leftExpression = expr.getLeftExpression();
        Expression rightExpression = expr.getRightExpression();
        if (op == 100 || op == 217) {
            if (rightRedirect.isDerivedFrom(ClassHelper.CLOSURE_TYPE)) {
                MethodNode abstractMethod;
                ClosureExpression closureExpression = null;
                if (rightExpression instanceof ClosureExpression) {
                    closureExpression = (ClosureExpression)rightExpression;
                } else if (rightExpression instanceof MethodReferenceExpression) {
                    closureExpression = (ClosureExpression)rightExpression.getNodeMetaData((Object)StaticTypesMarker.CONSTRUCTED_LAMBDA_EXPRESSION);
                }
                if (closureExpression != null && (abstractMethod = ClassHelper.findSAM(left)) != null) {
                    return this.inferSAMTypeGenericsInAssignment(left, abstractMethod, right, closureExpression);
                }
            }
            if (leftExpression instanceof VariableExpression) {
                ClassNode initialType = this.getOriginalDeclarationType(leftExpression);
                if (ClassHelper.isPrimitiveType(right) && initialType.isDerivedFrom(ClassHelper.Number_TYPE)) {
                    return ClassHelper.getWrapper(right);
                }
                if (ClassHelper.isPrimitiveType(initialType) && rightRedirect.isDerivedFrom(ClassHelper.Number_TYPE)) {
                    return ClassHelper.getUnwrapper(right);
                }
                if (StaticTypeCheckingSupport.isWildcardLeftHandSide(initialType) && !initialType.equals(ClassHelper.OBJECT_TYPE)) {
                    return initialType;
                }
            }
            if (rightExpression instanceof ListExpression && !leftRedirect.equals(ClassHelper.OBJECT_TYPE)) {
                if (ClassHelper.LIST_TYPE.equals(leftRedirect) || ITERABLE_TYPE.equals(leftRedirect) || StaticTypeCheckingSupport.Collection_TYPE.equals(leftRedirect) || StaticTypeCheckingSupport.ArrayList_TYPE.isDerivedFrom(leftRedirect)) {
                    return StaticTypeCheckingVisitor.getLiteralResultType(left, right, StaticTypeCheckingSupport.ArrayList_TYPE);
                }
                if (SET_TYPE.equals(leftRedirect) || StaticTypeCheckingSupport.LinkedHashSet_TYPE.isDerivedFrom(leftRedirect)) {
                    return StaticTypeCheckingVisitor.getLiteralResultType(left, right, StaticTypeCheckingSupport.LinkedHashSet_TYPE);
                }
            } else if (rightExpression instanceof MapExpression && !leftRedirect.equals(ClassHelper.OBJECT_TYPE) && (ClassHelper.MAP_TYPE.equals(leftRedirect) || StaticTypeCheckingSupport.LinkedHashMap_TYPE.isDerivedFrom(leftRedirect))) {
                return StaticTypeCheckingVisitor.getLiteralResultType(left, right, StaticTypeCheckingSupport.LinkedHashMap_TYPE);
            }
            return right;
        }
        if (StaticTypeCheckingSupport.isBoolIntrinsicOp(op)) {
            return ClassHelper.boolean_TYPE;
        }
        if (op == 90) {
            return StaticTypeCheckingSupport.Matcher_TYPE;
        }
        if (StaticTypeCheckingSupport.isArrayOp(op)) {
            BinaryExpression newExpr = GeneralUtils.binX((Expression)leftExpression, (Token)expr.getOperation(), (Expression)rightExpression);
            newExpr.setSourcePosition((ASTNode)expr);
            MethodNode method2 = this.findMethodOrFail((Expression)newExpr, left.getPlainNodeReference(), "getAt", right.getPlainNodeReference());
            if (method2 != null && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(right, ClassHelper.RANGE_TYPE)) {
                return this.inferReturnTypeGenerics(left, method2, rightExpression);
            }
            return method2 != null ? this.inferComponentType(left, right) : null;
        }
        String operationName = StaticTypeCheckingSupport.getOperationName(op);
        if (operationName == null) {
            throw new GroovyBugError("Unknown result type for binary operator " + op);
        }
        ClassNode mathResultType = StaticTypeCheckingVisitor.getMathResultType(op, leftRedirect, rightRedirect, operationName);
        if (mathResultType != null) {
            return mathResultType;
        }
        if ("equals".equals(operationName) && (left == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE || right == StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE)) {
            return ClassHelper.boolean_TYPE;
        }
        if (leftExpression instanceof ClassExpression) {
            left = ClassHelper.CLASS_Type.getPlainNodeReference();
        }
        if ((method = this.findMethodOrFail((Expression)expr, left, operationName, right)) != null) {
            this.storeTargetMethod((Expression)expr, method);
            this.typeCheckMethodsWithGenericsOrFail(left, new ClassNode[]{right}, method, (Expression)expr);
            if (StaticTypeCheckingSupport.isAssignment(op)) {
                return left;
            }
            if (!"compareTo".equals(operationName)) {
                return this.inferReturnTypeGenerics(left, method, (Expression)GeneralUtils.args((Expression[])new Expression[]{rightExpression}));
            }
        }
        if (StaticTypeCheckingSupport.isCompareToBoolean(op)) {
            return ClassHelper.boolean_TYPE;
        }
        if (op == 128) {
            return ClassHelper.int_TYPE;
        }
        return null;
    }

    private static ClassNode getLiteralResultType(ClassNode targetType, ClassNode sourceType, ClassNode baseType) {
        ClassNode resultType;
        ClassNode classNode = resultType = sourceType.equals(baseType) ? sourceType : GenericsUtils.parameterizeType(sourceType, baseType.getPlainNodeReference());
        if (targetType.getGenericsTypes() != null && !GenericsUtils.buildWildcardType(targetType).isCompatibleWith(resultType)) {
            BiPredicate<GenericsType, GenericsType> isEqualOrSuper = (target, source) -> {
                if (target.isCompatibleWith(source.getType())) {
                    return true;
                }
                if (!target.isPlaceholder() && !target.isWildcard()) {
                    return GenericsUtils.buildWildcardType(StaticTypeCheckingSupport.getCombinedBoundType(target)).isCompatibleWith(source.getType());
                }
                return false;
            };
            GenericsType[] lgt = targetType.getGenericsTypes();
            GenericsType[] rgt = resultType.getGenericsTypes();
            if (IntStream.range(0, lgt.length).allMatch(i -> isEqualOrSuper.test(lgt[i], rgt[i]))) {
                resultType = GenericsUtils.parameterizeType(targetType, baseType.getPlainNodeReference());
            }
        }
        return resultType;
    }

    private static ClassNode getMathResultType(int op, ClassNode leftRedirect, ClassNode rightRedirect, String operationName) {
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
            if (StaticTypeCheckingSupport.isOperationInGroup(op)) {
                if (WideningCategories.isIntCategory((ClassNode)leftRedirect) && WideningCategories.isIntCategory((ClassNode)rightRedirect)) {
                    return ClassHelper.int_TYPE;
                }
                if (WideningCategories.isLongCategory((ClassNode)leftRedirect) && WideningCategories.isLongCategory((ClassNode)rightRedirect)) {
                    return ClassHelper.long_TYPE;
                }
                if (WideningCategories.isFloat((ClassNode)leftRedirect) && WideningCategories.isFloat((ClassNode)rightRedirect)) {
                    return ClassHelper.float_TYPE;
                }
                if (WideningCategories.isDouble((ClassNode)leftRedirect) && WideningCategories.isDouble((ClassNode)rightRedirect)) {
                    return ClassHelper.double_TYPE;
                }
            } else {
                if (StaticTypeCheckingSupport.isPowerOperator(op)) {
                    return ClassHelper.Number_TYPE;
                }
                if (StaticTypeCheckingSupport.isBitOperator(op) || op == 204 || op == 214) {
                    if (WideningCategories.isIntCategory((ClassNode)ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isIntCategory((ClassNode)ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.int_TYPE;
                    }
                    if (WideningCategories.isLongCategory((ClassNode)ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isLongCategory((ClassNode)ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.long_TYPE;
                    }
                    if (WideningCategories.isBigIntCategory((ClassNode)ClassHelper.getUnwrapper(leftRedirect)) && WideningCategories.isBigIntCategory((ClassNode)ClassHelper.getUnwrapper(rightRedirect))) {
                        return ClassHelper.BigInteger_TYPE;
                    }
                } else if (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123 || op == 120) {
                    return ClassHelper.boolean_TYPE;
                }
            }
        } else if (ClassHelper.char_TYPE.equals(leftRedirect) && ClassHelper.char_TYPE.equals(rightRedirect) && (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123 || op == 120)) {
            return ClassHelper.boolean_TYPE;
        }
        if (StaticTypeCheckingSupport.isShiftOperation(operationName) && WideningCategories.isNumberCategory((ClassNode)leftRedirect) && (WideningCategories.isIntCategory((ClassNode)rightRedirect) || WideningCategories.isLongCategory((ClassNode)rightRedirect))) {
            return leftRedirect;
        }
        if (WideningCategories.isNumberCategory((ClassNode)ClassHelper.getWrapper(rightRedirect)) && WideningCategories.isNumberCategory((ClassNode)ClassHelper.getWrapper(leftRedirect)) && (203 == op || 213 == op)) {
            if (WideningCategories.isFloatingCategory((ClassNode)leftRedirect) || WideningCategories.isFloatingCategory((ClassNode)rightRedirect)) {
                if (!ClassHelper.isPrimitiveType(leftRedirect) || !ClassHelper.isPrimitiveType(rightRedirect)) {
                    return ClassHelper.Double_TYPE;
                }
                return ClassHelper.double_TYPE;
            }
            if (203 == op) {
                return ClassHelper.BigDecimal_TYPE;
            }
            return leftRedirect;
        }
        if (StaticTypeCheckingSupport.isOperationInGroup(op) && WideningCategories.isNumberCategory((ClassNode)ClassHelper.getWrapper(leftRedirect)) && WideningCategories.isNumberCategory((ClassNode)ClassHelper.getWrapper(rightRedirect))) {
            return StaticTypeCheckingVisitor.getGroupOperationResultType(leftRedirect, rightRedirect);
        }
        if (WideningCategories.isNumberCategory((ClassNode)ClassHelper.getWrapper(rightRedirect)) && WideningCategories.isNumberCategory((ClassNode)ClassHelper.getWrapper(leftRedirect)) && (205 == op || 215 == op)) {
            return leftRedirect;
        }
        return null;
    }

    private ClassNode inferSAMTypeGenericsInAssignment(ClassNode samType, MethodNode abstractMethod, ClassNode closureType, ClosureExpression closureExpression) {
        GenericsType[] samTypeGenerics = samType.getGenericsTypes();
        GenericsType[] closureGenerics = closureType.getGenericsTypes();
        if (samTypeGenerics == null || closureGenerics == null) {
            return samType;
        }
        HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        StaticTypeCheckingSupport.extractGenericsConnections(connections, StaticTypeCheckingVisitor.wrapTypeIfNecessary(this.getInferredReturnType((ASTNode)closureExpression)), abstractMethod.getReturnType());
        if (closureExpression.isParameterSpecified()) {
            Parameter[] closureParams = closureExpression.getParameters();
            Parameter[] methodParams = abstractMethod.getParameters();
            int i = 0;
            int n = Math.min(closureParams.length, methodParams.length);
            while (i < n) {
                ClassNode closureParamType = closureParams[i].getType();
                ClassNode methodParamType = methodParams[i].getType();
                StaticTypeCheckingSupport.extractGenericsConnections(connections, closureParamType, methodParamType);
                ++i;
            }
        }
        return StaticTypeCheckingSupport.applyGenericsContext(connections, samType.redirect());
    }

    protected static ClassNode getGroupOperationResultType(ClassNode a, ClassNode b) {
        if (WideningCategories.isBigIntCategory((ClassNode)a) && WideningCategories.isBigIntCategory((ClassNode)b)) {
            return ClassHelper.BigInteger_TYPE;
        }
        if (WideningCategories.isBigDecCategory((ClassNode)a) && WideningCategories.isBigDecCategory((ClassNode)b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigDecimal_TYPE.equals(a) || ClassHelper.BigDecimal_TYPE.equals(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigInteger_TYPE.equals(a) || ClassHelper.BigInteger_TYPE.equals(b)) {
            if (WideningCategories.isBigIntCategory((ClassNode)a) && WideningCategories.isBigIntCategory((ClassNode)b)) {
                return ClassHelper.BigInteger_TYPE;
            }
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.double_TYPE.equals(a) || ClassHelper.double_TYPE.equals(b)) {
            return ClassHelper.double_TYPE;
        }
        if (ClassHelper.Double_TYPE.equals(a) || ClassHelper.Double_TYPE.equals(b)) {
            return ClassHelper.Double_TYPE;
        }
        if (ClassHelper.float_TYPE.equals(a) || ClassHelper.float_TYPE.equals(b)) {
            return ClassHelper.float_TYPE;
        }
        if (ClassHelper.Float_TYPE.equals(a) || ClassHelper.Float_TYPE.equals(b)) {
            return ClassHelper.Float_TYPE;
        }
        if (ClassHelper.long_TYPE.equals(a) || ClassHelper.long_TYPE.equals(b)) {
            return ClassHelper.long_TYPE;
        }
        if (ClassHelper.Long_TYPE.equals(a) || ClassHelper.Long_TYPE.equals(b)) {
            return ClassHelper.Long_TYPE;
        }
        if (ClassHelper.int_TYPE.equals(a) || ClassHelper.int_TYPE.equals(b)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Integer_TYPE.equals(a) || ClassHelper.Integer_TYPE.equals(b)) {
            return ClassHelper.Integer_TYPE;
        }
        if (ClassHelper.short_TYPE.equals(a) || ClassHelper.short_TYPE.equals(b)) {
            return ClassHelper.short_TYPE;
        }
        if (ClassHelper.Short_TYPE.equals(a) || ClassHelper.Short_TYPE.equals(b)) {
            return ClassHelper.Short_TYPE;
        }
        if (ClassHelper.byte_TYPE.equals(a) || ClassHelper.byte_TYPE.equals(b)) {
            return ClassHelper.byte_TYPE;
        }
        if (ClassHelper.Byte_TYPE.equals(a) || ClassHelper.Byte_TYPE.equals(b)) {
            return ClassHelper.Byte_TYPE;
        }
        if (ClassHelper.char_TYPE.equals(a) || ClassHelper.char_TYPE.equals(b)) {
            return ClassHelper.char_TYPE;
        }
        if (ClassHelper.Character_TYPE.equals(a) || ClassHelper.Character_TYPE.equals(b)) {
            return ClassHelper.Character_TYPE;
        }
        return ClassHelper.Number_TYPE;
    }

    protected ClassNode inferComponentType(ClassNode containerType, ClassNode indexType) {
        ClassNode componentType = containerType.getComponentType();
        if (componentType == null) {
            MethodCallExpression mce = indexType != null ? GeneralUtils.callX((Expression)GeneralUtils.varX((String)"#", (ClassNode)containerType), (String)"getAt", (Expression)GeneralUtils.varX((String)"selector", (ClassNode)indexType)) : GeneralUtils.callX((Expression)GeneralUtils.varX((String)"#", (ClassNode)containerType), (String)"iterator");
            mce.setImplicitThis(false);
            this.typeCheckingContext.pushErrorCollector();
            try {
                this.visitMethodCallExpression(mce);
            }
            finally {
                this.typeCheckingContext.popErrorCollector();
            }
            if (indexType != null) {
                componentType = this.getType((ASTNode)((Object)mce));
            } else {
                ClassNode iteratorType = this.getType((ASTNode)((Object)mce));
                if (GeneralUtils.isOrImplements((ClassNode)iteratorType, (ClassNode)ClassHelper.Iterator_TYPE) && (iteratorType.getGenericsTypes() != null || !((MethodNode)mce.getNodeMetaData(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET)).getDeclaringClass().equals(ClassHelper.OBJECT_TYPE))) {
                    componentType = Optional.ofNullable(iteratorType.getGenericsTypes()).map(gt -> StaticTypeCheckingSupport.getCombinedBoundType(gt[0])).orElse(ClassHelper.OBJECT_TYPE);
                }
            }
        }
        return componentType;
    }

    protected MethodNode findMethodOrFail(Expression expr, ClassNode receiver, String name, ClassNode ... args) {
        List methods = this.findMethod(receiver, name, args);
        if (methods.isEmpty() && expr instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expr;
            MethodCallExpression call = GeneralUtils.callX((Expression)be.getLeftExpression(), (String)name, (Expression)be.getRightExpression());
            methods = this.extension.handleMissingMethod(receiver, name, GeneralUtils.args((Expression[])new Expression[]{be.getLeftExpression()}), args, (MethodCall)call);
        }
        if (methods.isEmpty()) {
            this.addNoMatchingMethodError(receiver, name, args, expr);
        } else {
            if (this.areCategoryMethodCalls(methods, name, args)) {
                this.addCategoryMethodCallError(expr);
            }
            if ((methods = this.disambiguateMethods(methods, receiver, args, expr)).size() == 1) {
                return methods.get(0);
            }
            this.addAmbiguousErrorMessage(methods, name, args, expr);
        }
        return null;
    }

    private List<MethodNode> disambiguateMethods(List<MethodNode> methods, ClassNode receiver, ClassNode[] argTypes, Expression call) {
        if (methods.size() > 1 && receiver != null && argTypes != null) {
            LinkedList<MethodNode> filteredWithGenerics = new LinkedList<MethodNode>();
            for (MethodNode methodNode : methods) {
                if (!StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(receiver, argTypes, methodNode) || (methodNode.getModifiers() & 0x40) != 0) continue;
                filteredWithGenerics.add(methodNode);
            }
            if (filteredWithGenerics.size() == 1) {
                return filteredWithGenerics;
            }
            methods = this.extension.handleAmbiguousMethods(methods, call);
        }
        if (methods.size() > 1 && call instanceof MethodCall) {
            LinkedList<MethodNode> methodNodeList = new LinkedList<MethodNode>();
            String methodName = ((MethodCall)call).getMethodAsString();
            for (MethodNode methodNode : methods) {
                if (!methodNode.getName().equals(methodName)) continue;
                methodNodeList.add(methodNode);
            }
            methods = methodNodeList;
        }
        return methods;
    }

    protected static String prettyPrintMethodList(List<MethodNode> nodes) {
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        int n = nodes.size();
        while (i < n) {
            MethodNode node = nodes.get(i);
            sb.append(node.getReturnType().toString(false));
            sb.append(" ");
            sb.append(node.getDeclaringClass().toString(false));
            sb.append("#");
            sb.append(StaticTypeCheckingSupport.toMethodParametersString(node.getName(), StaticTypeCheckingVisitor.extractTypesFromParameters(node.getParameters())));
            if (i < n - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    protected boolean areCategoryMethodCalls(List<MethodNode> foundMethods, String name, ClassNode[] args) {
        boolean category = false;
        if ("use".equals(name) && args != null && args.length == 2 && args[1].equals(ClassHelper.CLOSURE_TYPE)) {
            category = true;
            for (MethodNode method : foundMethods) {
                if (method instanceof ExtensionMethodNode && ((ExtensionMethodNode)method).getExtensionMethodNode().getDeclaringClass().equals(DGM_CLASSNODE)) continue;
                category = false;
                break;
            }
        }
        return category;
    }

    protected List<MethodNode> findMethodsWithGenerated(ClassNode receiver, String name) {
        if (receiver.isArray()) {
            if (name.equals("clone")) {
                MethodNode clone = new MethodNode("clone", 1, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
                clone.setDeclaringClass(ClassHelper.OBJECT_TYPE);
                clone.setNodeMetaData(StaticTypesMarker.INFERRED_RETURN_TYPE, receiver);
                return Collections.singletonList(clone);
            }
            return ClassHelper.OBJECT_TYPE.getMethods(name);
        }
        List<MethodNode> methods = receiver.getMethods(name);
        HashSet<ClassNode> done = new HashSet<ClassNode>();
        ClassNode next = receiver;
        while (next != null) {
            done.add(next);
            for (ClassNode face : next.getAllInterfaces()) {
                if (!done.add(face)) continue;
                for (MethodNode mn : face.getDeclaredMethods(name)) {
                    if (!mn.isPublic() || mn.isStatic()) continue;
                    methods.add(mn);
                }
            }
            next = next.getSuperClass();
        }
        if (receiver.isInterface()) {
            methods.addAll(ClassHelper.OBJECT_TYPE.getMethods(name));
        }
        if (!receiver.isResolved() && !methods.isEmpty()) {
            methods = StaticTypeCheckingVisitor.addGeneratedMethods(receiver, methods);
        }
        return methods;
    }

    private static List<MethodNode> addGeneratedMethods(ClassNode receiver, List<? extends MethodNode> methods) {
        LinkedList<MethodNode> result = new LinkedList<MethodNode>();
        for (MethodNode methodNode : methods) {
            result.add(methodNode);
            Parameter[] parameters = methodNode.getParameters();
            int counter = 0;
            int size = parameters.length;
            int i = size - 1;
            while (i >= 0) {
                Parameter parameter = parameters[i];
                if (parameter != null && parameter.hasInitialExpression()) {
                    ++counter;
                }
                --i;
            }
            int j = 1;
            while (j <= counter) {
                Object stubbed;
                Parameter[] newParams = new Parameter[parameters.length - j];
                int index = 0;
                int k = 1;
                Parameter[] parameterArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter parameter = parameterArray[n2];
                    if (k > counter - j && parameter != null && parameter.hasInitialExpression()) {
                        ++k;
                    } else if (parameter != null && parameter.hasInitialExpression()) {
                        newParams[index++] = parameter;
                        ++k;
                    } else {
                        newParams[index++] = parameter;
                    }
                    ++n2;
                }
                if ("<init>".equals(methodNode.getName())) {
                    stubbed = new ConstructorNode(methodNode.getModifiers(), newParams, methodNode.getExceptions(), GENERATED_EMPTY_STATEMENT);
                } else {
                    stubbed = new MethodNode(methodNode.getName(), methodNode.getModifiers(), methodNode.getReturnType(), newParams, methodNode.getExceptions(), GENERATED_EMPTY_STATEMENT);
                    ((MethodNode)stubbed).setGenericsTypes(methodNode.getGenericsTypes());
                }
                ((AnnotatedNode)stubbed).setDeclaringClass(methodNode.getDeclaringClass());
                result.add((MethodNode)stubbed);
                ++j;
            }
        }
        return result;
    }

    protected List<MethodNode> findMethod(ClassNode receiver, String name, ClassNode ... args) {
        MethodNode constructor;
        List<MethodNode> chosen;
        List<MethodNode> methods;
        if (ClassHelper.isPrimitiveType(receiver)) {
            receiver = ClassHelper.getWrapper(receiver);
        }
        if ("<init>".equals(name) && !receiver.isInterface()) {
            methods = StaticTypeCheckingVisitor.addGeneratedMethods(receiver, receiver.getDeclaredConstructors());
            if (methods.isEmpty()) {
                ConstructorNode node = new ConstructorNode(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                node.setDeclaringClass(receiver);
                methods.add((MethodNode)node);
                if (receiver.isArray()) {
                    return methods;
                }
            }
        } else {
            PropertyNode property;
            String pname;
            MethodNode sam;
            methods = this.findMethodsWithGenerated(receiver, name);
            if ("call".equals(name) && receiver.isInterface() && (sam = ClassHelper.findSAM(receiver)) != null) {
                MethodNode callMethod = new MethodNode("call", sam.getModifiers(), sam.getReturnType(), sam.getParameters(), sam.getExceptions(), sam.getCode());
                callMethod.setDeclaringClass(sam.getDeclaringClass());
                callMethod.setSourcePosition(sam);
                methods.add(callMethod);
            }
            if (!receiver.isStaticClass() && receiver.getOuterClass() != null && !receiver.getName().endsWith("$Trait$Helper") && this.typeCheckingContext.getEnclosingClassNodes().contains(receiver)) {
                ClassNode outer = receiver.getOuterClass();
                do {
                    methods.addAll(this.findMethodsWithGenerated(outer, name));
                } while (!outer.isStaticClass() && (outer = outer.getOuterClass()) != null);
            }
            if (methods.isEmpty()) {
                StaticTypeCheckingVisitor.addArrayMethods(methods, receiver, name, args);
            }
            if (args == null || args.length == 0) {
                pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("get", name);
                if (pname == null) {
                    pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("is", name);
                }
                if (pname != null && (property = this.findProperty(receiver, pname)) != null && property.getDeclaringClass().getGetterMethod(name) == null) {
                    MethodNode node = new MethodNode(name, 1 | (property.isStatic() ? 8 : 0), property.getOriginType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                    node.setDeclaringClass(property.getDeclaringClass());
                    node.setSynthetic(true);
                    methods.add(node);
                }
            } else if (args.length == 1 && (methods.isEmpty() || methods.stream().allMatch(MethodNode::isAbstract)) && (pname = StaticTypeCheckingVisitor.extractPropertyNameFromMethodName("set", name)) != null && (property = this.findProperty(receiver, pname)) != null && !Modifier.isFinal(property.getModifiers())) {
                ClassNode type = property.getOriginType();
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(StaticTypeCheckingVisitor.wrapTypeIfNecessary(args[0]), StaticTypeCheckingVisitor.wrapTypeIfNecessary(type))) {
                    MethodNode node = new MethodNode(name, 1 | (property.isStatic() ? 8 : 0), ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(type, name)}, ClassNode.EMPTY_ARRAY, GENERATED_EMPTY_STATEMENT);
                    node.setDeclaringClass(property.getDeclaringClass());
                    node.setSynthetic(true);
                    methods.add(node);
                }
            }
        }
        if (!"<init>".equals(name) && !"<clinit>".equals(name)) {
            methods.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode((ClassLoader)this.getSourceUnit().getClassLoader(), receiver, name));
        }
        if (!(chosen = StaticTypeCheckingSupport.chooseBestMethod(receiver, methods = StaticTypeCheckingSupport.filterMethodsByVisibility(methods, this.typeCheckingContext.getEnclosingClassNode()), args)).isEmpty()) {
            return chosen;
        }
        if (receiver instanceof InnerClassNode && ((InnerClassNode)receiver).isAnonymous() && methods.size() == 1 && args != null && "<init>".equals(name) && (constructor = methods.get(0)).getParameters().length == args.length) {
            return methods;
        }
        if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver) && !(chosen = this.findMethod(receiver.getGenericsTypes()[0].getType(), name, args)).isEmpty()) {
            return chosen;
        }
        if (ClassHelper.GSTRING_TYPE.equals(receiver)) {
            return this.findMethod(ClassHelper.STRING_TYPE, name, args);
        }
        if (StaticTypeCheckingSupport.isBeingCompiled(receiver)) {
            return this.findMethod(ClassHelper.GROOVY_OBJECT_TYPE, name, args);
        }
        return EMPTY_METHODNODE_LIST;
    }

    private PropertyNode findProperty(ClassNode receiver, String name) {
        ClassNode cn = receiver;
        while (cn != null) {
            PropertyNode property = cn.getProperty(name);
            if (property != null) {
                return property;
            }
            if (!cn.isStaticClass() && cn.getOuterClass() != null && this.typeCheckingContext.getEnclosingClassNodes().contains(cn)) {
                ClassNode outer = cn.getOuterClass();
                do {
                    if ((property = outer.getProperty(name)) == null) continue;
                    return property;
                } while (!outer.isStaticClass() && (outer = outer.getOuterClass()) != null);
            }
            cn = cn.getSuperClass();
        }
        return null;
    }

    public static String extractPropertyNameFromMethodName(String prefix, String methodName) {
        String propertyName;
        String result;
        if (prefix == null || methodName == null) {
            return null;
        }
        if (methodName.startsWith(prefix) && prefix.length() < methodName.length() && (result = methodName.substring(prefix.length())).equals(BeanUtils.capitalize((String)(propertyName = BeanUtils.decapitalize((String)result))))) {
            return propertyName;
        }
        return null;
    }

    protected ClassNode getType(ASTNode exp) {
        MethodNode target;
        ClassNode cn = (ClassNode)exp.getNodeMetaData(StaticTypesMarker.INFERRED_TYPE);
        if (cn != null) {
            return cn;
        }
        if (exp instanceof ClassExpression) {
            ClassNode node = ClassHelper.CLASS_Type.getPlainNodeReference();
            node.setGenericsTypes(new GenericsType[]{new GenericsType(((ClassExpression)((Object)exp)).getType())});
            return node;
        }
        if (exp instanceof VariableExpression) {
            VariableExpression vexp = (VariableExpression)exp;
            ClassNode selfTrait = StaticTypeCheckingSupport.isTraitSelf(vexp);
            if (selfTrait != null) {
                return StaticTypeCheckingVisitor.makeSelf(selfTrait);
            }
            if (vexp.isThisExpression()) {
                return this.makeThis();
            }
            if (vexp.isSuperExpression()) {
                return this.makeSuper();
            }
            Variable variable = vexp.getAccessedVariable();
            if (variable instanceof FieldNode) {
                FieldNode fieldNode = (FieldNode)variable;
                ClassNode fieldType = fieldNode.getOriginType();
                if (!fieldNode.isStatic() && GenericsUtils.hasUnresolvedGenerics(fieldType)) {
                    ClassNode declType = fieldNode.getDeclaringClass();
                    ClassNode thisType = this.typeCheckingContext.getEnclosingClassNode();
                    fieldType = this.resolveGenericsWithContext(StaticTypeCheckingVisitor.extractPlaceHolders(thisType, declType), fieldType);
                }
                return fieldType;
            }
            if (variable != vexp && variable instanceof VariableExpression) {
                return this.getType((ASTNode)((Expression)variable));
            }
            if (variable instanceof Parameter) {
                Parameter parameter = (Parameter)variable;
                ClassNode type = null;
                List<ClassNode> temporaryTypesForExpression = this.getTemporaryTypesForExpression((Expression)vexp);
                if (temporaryTypesForExpression == null || temporaryTypesForExpression.isEmpty()) {
                    type = (ClassNode)this.typeCheckingContext.controlStructureVariables.get(parameter);
                }
                if (type == null && temporaryTypesForExpression == null) {
                    type = this.getTypeFromClosureArguments(parameter);
                }
                if (type != null) {
                    this.storeType((Expression)vexp, type);
                    return type;
                }
                return this.getType((Parameter)variable);
            }
            return vexp.getOriginType();
        }
        if (exp instanceof ListExpression) {
            return this.inferListExpressionType((ListExpression)exp);
        }
        if (exp instanceof MapExpression) {
            return this.inferMapExpressionType((MapExpression)exp);
        }
        if (exp instanceof ConstructorCallExpression) {
            return ((ConstructorCallExpression)exp).getType();
        }
        if (exp instanceof MethodNode) {
            if ((exp == GET_DELEGATE || exp == GET_OWNER || exp == GET_THISOBJECT) && this.typeCheckingContext.getEnclosingClosure() != null) {
                return this.typeCheckingContext.getEnclosingClassNode();
            }
            ClassNode ret = this.getInferredReturnType(exp);
            return ret != null ? ret : ((MethodNode)exp).getReturnType();
        }
        if (exp instanceof FieldNode || exp instanceof PropertyNode) {
            return ((Variable)exp).getOriginType();
        }
        if (exp instanceof RangeExpression) {
            ClassNode toType;
            ClassNode plain = ClassHelper.RANGE_TYPE.getPlainNodeReference();
            RangeExpression re = (RangeExpression)exp;
            ClassNode fromType = this.getType((ASTNode)re.getFrom());
            if (fromType.equals(toType = this.getType((ASTNode)re.getTo()))) {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(fromType))});
            } else {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(WideningCategories.lowestUpperBound((ClassNode)fromType, (ClassNode)toType)))});
            }
            return plain;
        }
        if (exp instanceof UnaryPlusExpression) {
            return this.getType((ASTNode)((UnaryPlusExpression)exp).getExpression());
        }
        if (exp instanceof UnaryMinusExpression) {
            return this.getType((ASTNode)((UnaryMinusExpression)exp).getExpression());
        }
        if (exp instanceof BitwiseNegationExpression) {
            return this.getType((ASTNode)((BitwiseNegationExpression)exp).getExpression());
        }
        if (exp instanceof Parameter) {
            return ((Parameter)exp).getOriginType();
        }
        if (exp instanceof ClosureExpression) {
            Parameter[] parameters;
            ClassNode type = ClassHelper.CLOSURE_TYPE.getPlainNodeReference();
            ClassNode returnType = this.getInferredReturnType(exp);
            if (returnType != null) {
                type.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(returnType))});
            }
            int nParameters = (parameters = ((ClosureExpression)exp).getParameters()) == null ? 0 : (parameters.length == 0 ? -1 : parameters.length);
            type.putNodeMetaData(StaticTypesMarker.CLOSURE_ARGUMENTS, nParameters);
            return type;
        }
        if (exp instanceof MethodCall && (target = (MethodNode)exp.getNodeMetaData(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET)) != null) {
            return this.getType(target);
        }
        return ((Expression)exp).getType();
    }

    private ClassNode getTypeFromClosureArguments(Parameter parameter) {
        for (TypeCheckingContext.EnclosingClosure enclosingClosure : this.typeCheckingContext.getEnclosingClosureStack()) {
            Parameter[] parameters;
            ClosureExpression closureExpression = enclosingClosure.getClosureExpression();
            ClassNode[] closureParamTypes = (ClassNode[])closureExpression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
            if (closureParamTypes == null || (parameters = closureExpression.getParameters()) == null) continue;
            int n = parameters.length;
            String parameterName = parameter.getName();
            if (n == 0 && parameterName.equals("it")) {
                return closureParamTypes.length > 0 ? closureParamTypes[0] : null;
            }
            int i = 0;
            while (i < n) {
                if (parameterName.equals(parameters[i].getName())) {
                    return closureParamTypes.length > i ? closureParamTypes[i] : null;
                }
                ++i;
            }
        }
        return null;
    }

    private static ClassNode makeSelf(ClassNode trait) {
        ClassNode selfType = trait;
        LinkedHashSet<ClassNode> selfTypes = Traits.collectSelfTypes(selfType, new LinkedHashSet<ClassNode>());
        if (!selfTypes.isEmpty()) {
            selfTypes.add(selfType);
            selfType = new UnionTypeClassNode(selfTypes.toArray(ClassNode.EMPTY_ARRAY));
        }
        return selfType;
    }

    private ClassNode makeSuper() {
        return StaticTypeCheckingVisitor.makeType(this.typeCheckingContext.getEnclosingClassNode().getUnresolvedSuperClass(), this.typeCheckingContext.isInStaticContext);
    }

    private ClassNode makeThis() {
        return StaticTypeCheckingVisitor.makeType(this.typeCheckingContext.getEnclosingClassNode(), this.typeCheckingContext.isInStaticContext);
    }

    private static ClassNode makeType(ClassNode cn, boolean usingClass) {
        if (usingClass) {
            ClassNode clazzType = ClassHelper.CLASS_Type.getPlainNodeReference();
            clazzType.setGenericsTypes(new GenericsType[]{new GenericsType(cn)});
            return clazzType;
        }
        return cn;
    }

    protected ClassNode storeInferredReturnType(ASTNode node, ClassNode type) {
        if (!(node instanceof ClosureExpression)) {
            throw new IllegalArgumentException("Storing inferred return type is only allowed on closures but found " + node.getClass());
        }
        return (ClassNode)node.putNodeMetaData(StaticTypesMarker.INFERRED_RETURN_TYPE, type);
    }

    protected ClassNode getInferredReturnType(ASTNode exp) {
        return (ClassNode)exp.getNodeMetaData(StaticTypesMarker.INFERRED_RETURN_TYPE);
    }

    protected ClassNode inferListExpressionType(ListExpression list) {
        List expressions = list.getExpressions();
        int nExpressions = expressions.size();
        if (nExpressions == 0) {
            return list.getType();
        }
        ClassNode listType = list.getType();
        GenericsType[] genericsTypes = listType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length == 0 || genericsTypes.length == 1 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType())) {
            ArrayList<ClassNode> nodes = new ArrayList<ClassNode>(nExpressions);
            for (Expression expression : expressions) {
                if (StaticTypeCheckingVisitor.isNullConstant(expression)) continue;
                nodes.add(this.getType((ASTNode)expression));
            }
            if (!nodes.isEmpty()) {
                ClassNode itemType = WideningCategories.lowestUpperBound(nodes);
                listType = listType.getPlainNodeReference();
                listType.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(itemType))});
            }
        }
        return listType;
    }

    protected static boolean isNullConstant(Expression expression) {
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).isNullExpression();
    }

    protected static boolean isThisExpression(Expression expression) {
        return expression instanceof VariableExpression && ((VariableExpression)expression).isThisExpression();
    }

    protected static boolean isSuperExpression(Expression expression) {
        return expression instanceof VariableExpression && ((VariableExpression)expression).isSuperExpression();
    }

    protected ClassNode inferMapExpressionType(MapExpression map) {
        ClassNode mapType = StaticTypeCheckingSupport.LinkedHashMap_TYPE.getPlainNodeReference();
        List entryExpressions = map.getMapEntryExpressions();
        int nExpressions = entryExpressions.size();
        if (nExpressions == 0) {
            return mapType;
        }
        GenericsType[] genericsTypes = mapType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length < 2 || genericsTypes.length == 2 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType()) && ClassHelper.OBJECT_TYPE.equals(genericsTypes[1].getType())) {
            ClassNode keyType;
            ClassNode valueType;
            ArrayList<ClassNode> keyTypes = new ArrayList<ClassNode>(nExpressions);
            ArrayList<ClassNode> valueTypes = new ArrayList<ClassNode>(nExpressions);
            for (MapEntryExpression entryExpression : entryExpressions) {
                valueType = this.getType((ASTNode)entryExpression.getValueExpression());
                if (!(entryExpression.getKeyExpression() instanceof SpreadMapExpression)) {
                    keyType = this.getType((ASTNode)entryExpression.getKeyExpression());
                } else {
                    valueType = GenericsUtils.parameterizeType(valueType, ClassHelper.MAP_TYPE);
                    keyType = StaticTypeCheckingSupport.getCombinedBoundType(valueType.getGenericsTypes()[0]);
                    valueType = StaticTypeCheckingSupport.getCombinedBoundType(valueType.getGenericsTypes()[1]);
                }
                keyTypes.add(keyType);
                valueTypes.add(valueType);
            }
            keyType = WideningCategories.lowestUpperBound(keyTypes);
            valueType = WideningCategories.lowestUpperBound(valueTypes);
            if (!ClassHelper.OBJECT_TYPE.equals(keyType) || !ClassHelper.OBJECT_TYPE.equals(valueType)) {
                mapType.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(keyType)), new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(valueType))});
            }
        }
        return mapType;
    }

    protected ClassNode inferReturnTypeGenerics(ClassNode receiver, MethodNode method, Expression arguments) {
        return this.inferReturnTypeGenerics(receiver, method, arguments, null);
    }

    protected ClassNode inferReturnTypeGenerics(ClassNode receiver, MethodNode method, Expression arguments, GenericsType[] explicitTypeHints) {
        GenericsType[] methodGenericTypes;
        ClassNode returnType;
        ClassNode classNode = returnType = method instanceof ConstructorNode ? method.getDeclaringClass() : method.getReturnType();
        if (!GenericsUtils.hasUnresolvedGenerics(returnType)) {
            if (StaticTypeCheckingSupport.getGenericsWithoutArray(returnType) != null) {
                returnType = StaticTypeCheckingSupport.boundUnboundedWildcards(returnType);
            }
            return returnType;
        }
        if (method instanceof ExtensionMethodNode) {
            ArgumentListExpression args = new ArgumentListExpression();
            VariableExpression vexp = GeneralUtils.varX((String)"$self", (ClassNode)receiver);
            args.addExpression((Expression)vexp);
            if (arguments instanceof TupleExpression) {
                for (Expression argument : (TupleExpression)arguments) {
                    args.addExpression(argument);
                }
            } else {
                args.addExpression(arguments);
            }
            vexp.setNodeMetaData(ExtensionMethodDeclaringClass.class, (Object)method.getDeclaringClass());
            return this.inferReturnTypeGenerics(receiver, ((ExtensionMethodNode)method).getExtensionMethodNode(), (Expression)args, explicitTypeHints);
        }
        Map<GenericsType.GenericsTypeName, GenericsType> context = method.isStatic() || method instanceof ConstructorNode ? null : StaticTypeCheckingVisitor.extractPlaceHoldersVisibleToDeclaration(receiver, method, arguments);
        GenericsType[] genericsTypeArray = methodGenericTypes = method instanceof ConstructorNode ? method.getDeclaringClass().getGenericsTypes() : StaticTypeCheckingSupport.applyGenericsContext(context, method.getGenericsTypes());
        if (methodGenericTypes != null) {
            HashMap<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
            GenericsType[] genericsTypeArray2 = methodGenericTypes;
            int n = methodGenericTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gt = genericsTypeArray2[n2];
                resolvedPlaceholders.put(new GenericsType.GenericsTypeName(gt.getName()), gt);
                ++n2;
            }
            StaticTypeCheckingSupport.applyGenericsConnections(this.extractGenericsConnectionsFromArguments(methodGenericTypes, (Parameter[])Arrays.stream(method.getParameters()).map(param -> new Parameter(StaticTypeCheckingSupport.applyGenericsContext(context, param.getType()), param.getName())).toArray(Parameter[]::new), arguments, explicitTypeHints), resolvedPlaceholders);
            returnType = StaticTypeCheckingSupport.applyGenericsContext(resolvedPlaceholders, returnType);
        }
        if (context != null) {
            returnType = StaticTypeCheckingSupport.applyGenericsContext(context, returnType);
        }
        returnType = StaticTypeCheckingSupport.applyGenericsContext(StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(this.typeCheckingContext), returnType);
        return returnType;
    }

    private Map<GenericsType.GenericsTypeName, GenericsType> extractGenericsConnectionsFromArguments(GenericsType[] methodGenericTypes, Parameter[] parameters, Expression arguments, GenericsType[] explicitTypeHints) {
        HashMap<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        if (DefaultGroovyMethods.asBoolean((Object[])explicitTypeHints)) {
            int n = methodGenericTypes.length;
            if (n == explicitTypeHints.length) {
                int i = 0;
                while (i < n) {
                    resolvedPlaceholders.put(new GenericsType.GenericsTypeName(methodGenericTypes[i].getName()), explicitTypeHints[i]);
                    ++i;
                }
            }
        } else if (parameters.length > 0) {
            List expressions = InvocationWriter.makeArgumentList(arguments).getExpressions();
            boolean isVargs = StaticTypeCheckingSupport.isVargs(parameters);
            int nArguments = expressions.size();
            int nParams = parameters.length;
            if (isVargs ? nArguments >= nParams - 1 : nArguments == nParams) {
                int i = 0;
                while (i < nArguments) {
                    if (!StaticTypeCheckingVisitor.isNullConstant((Expression)expressions.get(i))) {
                        ClassNode paramType = parameters[Math.min(i, nParams - 1)].getType();
                        ClassNode argumentType = this.getDeclaredOrInferredType((Expression)expressions.get(i));
                        if (GenericsUtils.hasUnresolvedGenerics(paramType)) {
                            MethodNode sam;
                            if (isVargs && (i >= nParams || i == nParams - 1 && (nArguments > nParams || !argumentType.isArray()))) {
                                paramType = paramType.getComponentType();
                            }
                            if (StaticTypeCheckingVisitor.isClosureWithType(argumentType) && (sam = ClassHelper.findSAM(paramType)) != null) {
                                argumentType = StaticTypeCheckingVisitor.convertClosureTypeToSAMType((Expression)expressions.get(i), argumentType, sam, paramType);
                            }
                            HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                            StaticTypeCheckingSupport.extractGenericsConnections(connections, StaticTypeCheckingVisitor.wrapTypeIfNecessary(argumentType), paramType);
                            connections.forEach((name, type) -> {
                                GenericsType genericsType = resolvedPlaceholders.merge((GenericsType.GenericsTypeName)name, (GenericsType)type, StaticTypeCheckingSupport::getCombinedGenericsType);
                            });
                        }
                    }
                    ++i;
                }
            }
            StaticTypeCheckingVisitor.extractGenericsConnectionsForBoundTypes(methodGenericTypes, resolvedPlaceholders);
        }
        GenericsType[] genericsTypeArray = methodGenericTypes;
        int n = methodGenericTypes.length;
        int n2 = 0;
        while (n2 < n) {
            GenericsType gt = genericsTypeArray[n2];
            resolvedPlaceholders.computeIfAbsent(new GenericsType.GenericsTypeName(gt.getName()), gtn -> {
                GenericsType xxx = new GenericsType(ClassHelper.makeWithoutCaching("#"), StaticTypeCheckingSupport.applyGenericsContext((Map<GenericsType.GenericsTypeName, GenericsType>)resolvedPlaceholders, gt.getUpperBounds()), StaticTypeCheckingSupport.applyGenericsContext((Map<GenericsType.GenericsTypeName, GenericsType>)resolvedPlaceholders, gt.getLowerBound()));
                xxx.getType().setRedirect(gt.getType().redirect());
                xxx.putNodeMetaData(GenericsType.class, gt);
                xxx.setName("#" + gt.getName());
                xxx.setPlaceholder(true);
                return xxx;
            });
            ++n2;
        }
        return resolvedPlaceholders;
    }

    /*
     * Unable to fully structure code
     */
    private void resolvePlaceholdersFromImplicitTypeHints(ClassNode[] actuals, ArgumentListExpression argumentList, Parameter[] parameterArray) {
        np = parameterArray.length;
        i = 0;
        n = actuals.length;
        while (i < n && np > 0) {
            block13: {
                a = argumentList.getExpression(i);
                p = parameterArray[Math.min(i, np - 1)];
                at = actuals[i];
                pt = p.getOriginType();
                if (!StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(pt)) break block13;
                if (i >= np - 1 && pt.isArray() && !at.isArray()) {
                    pt = pt.getComponentType();
                }
                if (a instanceof ConstructorCallExpression) {
                    this.inferDiamondType((ConstructorCallExpression)a, pt);
                } else if (a instanceof ListExpression) {
                    actuals[i] = StaticTypeCheckingVisitor.getLiteralResultType(pt, at, StaticTypeCheckingSupport.ArrayList_TYPE);
                } else if (a instanceof MapExpression) {
                    actuals[i] = StaticTypeCheckingVisitor.getLiteralResultType(pt, at, StaticTypeCheckingVisitor.LINKEDHASHMAP_CLASSNODE);
                } else if (a instanceof TernaryExpression && at.getGenericsTypes() != null && at.getGenericsTypes().length == 0) {
                    this.typeCheckingContext.pushEnclosingBinaryExpression(StaticTypeCheckingVisitor.assignX((Expression)GeneralUtils.varX((Variable)p), a, (ASTNode)a));
                    a.visit((GroovyCodeVisitor)this);
                    this.typeCheckingContext.popEnclosingBinaryExpression();
                    actuals[i] = this.getType((ASTNode)a);
                }
                if (a instanceof MethodCall && (!(a instanceof MethodCallExpression) || !((MethodCallExpression)a).isUsingGenerics()) && (aNode = (MethodNode)a.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET)) != null && aNode.getGenericsTypes() != null && GenericsUtils.hasUnresolvedGenerics(at)) ** GOTO lbl31
                break block13;
lbl-1000:
                // 1 sources

                {
                    sc = GenericsUtils.getSuperClass(at, pt);
                    at = StaticTypeCheckingSupport.applyGenericsContext(GenericsUtils.extractPlaceholders(at), sc);
lbl31:
                    // 2 sources

                    ** while (!at.equals((Object)pt) && !at.equals((Object)ClassHelper.OBJECT_TYPE) && !StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf((ClassNode)at) && !StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf((ClassNode)pt))
                }
lbl32:
                // 1 sources

                linked = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                source = GenericsUtils.extractPlaceholders(at);
                target = GenericsUtils.extractPlaceholders(pt);
                if (at.isGenericsPlaceHolder()) {
                    target.put(new GenericsType.GenericsTypeName(at.getUnresolvedName()), pt.asGenericsType());
                }
                var18_18 = aNode.getGenericsTypes();
                var17_17 = var18_18.length;
                var16_16 = 0;
                while (var16_16 < var17_17) {
                    placeholder = var18_18[var16_16];
                    for (Map.Entry<GenericsType.GenericsTypeName, GenericsType> e : source.entrySet()) {
                        if (e.getValue().getNodeMetaData(GenericsType.class) != placeholder) continue;
                        Optional.ofNullable(target.get(e.getKey())).filter((Predicate<GenericsType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$63(org.codehaus.groovy.ast.GenericsType org.codehaus.groovy.ast.GenericsType ), (Lorg/codehaus/groovy/ast/GenericsType;)Z)((GenericsType)placeholder)).ifPresent((Consumer<GenericsType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$64(java.util.Map java.util.Map$Entry org.codehaus.groovy.ast.GenericsType ), (Lorg/codehaus/groovy/ast/GenericsType;)V)(linked, e));
                        break;
                    }
                    ++var16_16;
                }
                actuals[i] = StaticTypeCheckingSupport.applyGenericsContext(linked, at);
            }
            ++i;
        }
    }

    private static void extractGenericsConnectionsForBoundTypes(GenericsType[] spec, Map<GenericsType.GenericsTypeName, GenericsType> target) {
        if (spec.length < 2) {
            return;
        }
        GenericsType[] genericsTypeArray = spec;
        int n = spec.length;
        int n2 = 0;
        while (n2 < n) {
            GenericsType.GenericsTypeName key;
            GenericsType value;
            GenericsType tp = genericsTypeArray[n2];
            ClassNode[] bounds = tp.getUpperBounds();
            if (bounds != null && bounds.length != 0 && (value = target.get(key = new GenericsType.GenericsTypeName(tp.getName()))) != null && !value.isPlaceholder() && !value.isWildcard()) {
                HashMap<GenericsType.GenericsTypeName, GenericsType> inner = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                ClassNode[] classNodeArray = bounds;
                int n3 = bounds.length;
                int n4 = 0;
                while (n4 < n3) {
                    ClassNode bound = classNodeArray[n4];
                    StaticTypeCheckingSupport.extractGenericsConnections(inner, value.getType(), bound);
                    ++n4;
                }
                inner.forEach(target::putIfAbsent);
            }
            ++n2;
        }
    }

    private static MethodNode chooseMethod(MethodPointerExpression source, Supplier<ClassNode[]> samSignature) {
        List options = (List)source.getNodeMetaData(MethodNode.class);
        if (options == null || options.isEmpty()) {
            return null;
        }
        ClassNode[] paramTypes = samSignature.get();
        return options.stream().filter(option -> {
            ClassNode[] types = StaticTypeCheckingVisitor.collateMethodReferenceParameterTypes(source, option);
            int n = types.length;
            if (n != paramTypes.length) {
                return false;
            }
            int i = 0;
            while (i < n) {
                if (!StaticTypeCheckingSupport.isAssignableTo(paramTypes[i], types[i]) && !paramTypes[i].isGenericsPlaceHolder()) {
                    return false;
                }
                ++i;
            }
            return true;
        }).findFirst().orElse(null);
    }

    private static ClassNode[] collateMethodReferenceParameterTypes(MethodPointerExpression source, MethodNode target) {
        Parameter[] params;
        if (target instanceof ExtensionMethodNode && !((ExtensionMethodNode)target).isStaticExtension()) {
            params = ((ExtensionMethodNode)target).getExtensionMethodNode().getParameters();
        } else if (!target.isStatic() && source.getExpression() instanceof ClassExpression) {
            ClassNode thisType = ((ClassExpression)source.getExpression()).getType();
            int n = target.getParameters().length;
            params = new Parameter[n + 1];
            params[0] = new Parameter(thisType, "");
            System.arraycopy(target.getParameters(), 0, params, 1, n);
        } else {
            params = target.getParameters();
        }
        return StaticTypeCheckingVisitor.extractTypesFromParameters(params);
    }

    private static ClassNode convertClosureTypeToSAMType(Expression expression, ClassNode closureType, MethodNode sam, ClassNode samType) {
        Map<GenericsType.GenericsTypeName, GenericsType> placeholders = GenericsUtils.extractPlaceholders(samType);
        placeholders.replaceAll((xx, gt) -> Optional.ofNullable(gt.getLowerBound()).map(GenericsType::new).orElse((GenericsType)gt));
        if (StaticTypeCheckingVisitor.isClosureWithType(closureType)) {
            MethodPointerExpression mp;
            MethodNode mn;
            ClassNode closureReturnType = closureType.getGenericsTypes()[0].getType();
            Parameter[] parameters = sam.getParameters();
            if (parameters.length > 0 && expression instanceof MethodPointerExpression && (mn = StaticTypeCheckingVisitor.chooseMethod(mp = (MethodPointerExpression)expression, () -> StaticTypeCheckingSupport.applyGenericsContext(placeholders, StaticTypeCheckingVisitor.extractTypesFromParameters(parameters)))) != null) {
                ClassNode[] pTypes = StaticTypeCheckingVisitor.collateMethodReferenceParameterTypes(mp, mn);
                HashMap<GenericsType.GenericsTypeName, GenericsType> connections = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                int i = 0;
                int n = parameters.length;
                while (i < n) {
                    StaticTypeCheckingSupport.extractGenericsConnections(connections, parameters[i].getOriginType(), pTypes[i]);
                    ++i;
                }
                closureReturnType = StaticTypeCheckingSupport.applyGenericsContext(connections, closureReturnType);
                closureReturnType = StaticTypeCheckingSupport.applyGenericsContext(placeholders, closureReturnType);
                expression = new ClosureExpression((Parameter[])Arrays.stream(pTypes).map(t -> new Parameter((ClassNode)t, "")).toArray(Parameter[]::new), null);
            }
            StaticTypeCheckingSupport.extractGenericsConnections(placeholders, closureReturnType, sam.getReturnType());
            if (parameters.length > 0 && expression instanceof ClosureExpression) {
                ClassNode[] paramTypes = StaticTypeCheckingSupport.applyGenericsContext(placeholders, StaticTypeCheckingVisitor.extractTypesFromParameters(parameters));
                int i = 0;
                Parameter[] parameterArray = ClosureUtils.getParametersSafe((ClosureExpression)((ClosureExpression)expression));
                int n = parameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter p = parameterArray[n2];
                    if (!p.isDynamicTyped()) {
                        StaticTypeCheckingSupport.extractGenericsConnections(placeholders, p.getType(), paramTypes[i++]);
                    }
                    ++n2;
                }
            }
        }
        return StaticTypeCheckingSupport.applyGenericsContext(placeholders, samType.redirect());
    }

    private ClassNode resolveGenericsWithContext(Map<GenericsType.GenericsTypeName, GenericsType> resolvedPlaceholders, ClassNode currentType) {
        Map<GenericsType.GenericsTypeName, GenericsType> placeholdersFromContext = StaticTypeCheckingSupport.extractGenericsParameterMapOfThis(this.typeCheckingContext);
        return StaticTypeCheckingSupport.resolveClassNodeGenerics(resolvedPlaceholders, placeholdersFromContext, currentType);
    }

    private ClassNode getDeclaredOrInferredType(Expression expression) {
        ClassNode declaredOrInferred = expression instanceof Variable && !((Variable)expression).isDynamicTyped() ? this.getOriginalDeclarationType(expression) : this.getType((ASTNode)expression);
        return this.getInferredTypeFromTempInfo(expression, declaredOrInferred);
    }

    private static boolean isGenericsPlaceHolderOrArrayOf(ClassNode cn) {
        if (cn.isArray()) {
            return StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf(cn.getComponentType());
        }
        return cn.isGenericsPlaceHolder();
    }

    /*
     * Could not resolve type clashes
     */
    private static Map<GenericsType.GenericsTypeName, GenericsType> extractPlaceHolders(ClassNode receiver, ClassNode declaringClass) {
        HashMap<GenericsType.GenericsTypeName, GenericsType> result = null;
        ClassNode[] todo = receiver instanceof UnionTypeClassNode ? ((UnionTypeClassNode)receiver).getDelegates() : new ClassNode[]{!ClassHelper.isPrimitiveType(declaringClass) ? StaticTypeCheckingVisitor.wrapTypeIfNecessary(receiver) : receiver};
        ClassNode[] classNodeArray = todo;
        int n = todo.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode type;
            ClassNode current = type = classNodeArray[n2];
            while (current != null) {
                boolean currentIsDeclaring;
                HashMap<GenericsType.GenericsTypeName, GenericsType> placeHolders = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                if (current.getGenericsTypes() != null ? current.getGenericsTypes().length == 0 : current.redirect().getGenericsTypes() != null) {
                    GenericsType[] genericsTypeArray = current.redirect().getGenericsTypes();
                    int n3 = genericsTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        GenericsType gt = genericsTypeArray[n4];
                        ClassNode cn = gt.getUpperBounds() != null ? gt.getUpperBounds()[0] : gt.getType().redirect();
                        placeHolders.put(new GenericsType.GenericsTypeName(gt.getName()), cn.getPlainNodeReference().asGenericsType());
                        ++n4;
                    }
                }
                boolean bl = currentIsDeclaring = current.equals(declaringClass) || StaticTypeCheckingVisitor.isGenericsPlaceHolderOrArrayOf(declaringClass);
                if (currentIsDeclaring) {
                    StaticTypeCheckingSupport.extractGenericsConnections(placeHolders, current, declaringClass);
                } else {
                    GenericsUtils.extractPlaceholders(current, placeHolders);
                }
                if (result != null) {
                    for (Map.Entry entry : placeHolders.entrySet()) {
                        GenericsType referenced;
                        GenericsType gt = (GenericsType)entry.getValue();
                        if (!gt.isPlaceholder() || (referenced = (GenericsType)result.get(new GenericsType.GenericsTypeName(gt.getName()))) == null) continue;
                        entry.setValue(referenced);
                    }
                }
                result = placeHolders;
                if (currentIsDeclaring) break;
                current = (current = ClassHelper.getNextSuperClass(current, declaringClass)) == null && declaringClass.equals(ClassHelper.CLASS_Type) ? declaringClass : StaticTypeCheckingSupport.applyGenericsContext(placeHolders, current);
            }
            ++n2;
        }
        if (result == null) {
            throw new GroovyBugError("Declaring class " + StaticTypeCheckingSupport.prettyPrintTypeName(declaringClass) + " was not matched with receiver " + StaticTypeCheckingSupport.prettyPrintTypeName(receiver) + ". This should not have happened!");
        }
        return result;
    }

    private static Map<GenericsType.GenericsTypeName, GenericsType> extractPlaceHoldersVisibleToDeclaration(ClassNode receiver, MethodNode method, Expression argument) {
        Map<GenericsType.GenericsTypeName, GenericsType> result;
        if (method.isStatic()) {
            result = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
        } else {
            ClassNode cn;
            List arguments;
            ClassNode declaring = method.getDeclaringClass();
            if (argument instanceof TupleExpression && !(arguments = ((TupleExpression)argument).getExpressions()).isEmpty() && (cn = (ClassNode)((Expression)arguments.get(0)).getNodeMetaData(ExtensionMethodDeclaringClass.class)) != null) {
                declaring = cn;
            }
            if (!(result = StaticTypeCheckingVisitor.extractPlaceHolders(receiver, declaring)).isEmpty()) {
                Optional.ofNullable(method.getGenericsTypes()).ifPresent(methodGenerics -> Arrays.stream(methodGenerics).map(gt -> new GenericsType.GenericsTypeName(gt.getName())).forEach(result::remove));
            }
        }
        return result;
    }

    protected boolean typeCheckMethodsWithGenericsOrFail(ClassNode receiver, ClassNode[] arguments, MethodNode candidateMethod, Expression location) {
        if (!StaticTypeCheckingSupport.typeCheckMethodsWithGenerics(receiver, arguments, candidateMethod)) {
            ClassNode r = receiver;
            ClassNode[] at = arguments;
            MethodNode m = candidateMethod;
            if (candidateMethod instanceof ExtensionMethodNode) {
                m = ((ExtensionMethodNode)candidateMethod).getExtensionMethodNode();
                r = m.getDeclaringClass();
                at = new ClassNode[arguments.length + 1];
                at[0] = receiver;
                System.arraycopy(arguments, 0, at, 1, arguments.length);
            }
            Map<GenericsType.GenericsTypeName, GenericsType> spec = StaticTypeCheckingVisitor.extractPlaceHoldersVisibleToDeclaration(r, m, null);
            GenericsType[] gt = StaticTypeCheckingSupport.applyGenericsContext(spec, m.getGenericsTypes());
            GenericsUtils.extractPlaceholders(GenericsUtils.makeClassSafe0(ClassHelper.OBJECT_TYPE, gt), spec);
            Parameter[] parameters = m.getParameters();
            ClassNode[] paramTypes = new ClassNode[parameters.length];
            int i = 0;
            int n = parameters.length;
            while (i < n) {
                paramTypes[i] = StaticTypeCheckingSupport.fullyResolveType(parameters[i].getType(), spec);
                if (i < at.length && this.hasGStringStringError(paramTypes[i], at[i], location)) {
                    return false;
                }
                ++i;
            }
            this.addStaticTypeError("Cannot call " + (gt == null ? "" : GenericsUtils.toGenericTypesString(gt)) + StaticTypeCheckingSupport.prettyPrintTypeName(r) + "#" + StaticTypeCheckingSupport.toMethodParametersString(m.getName(), paramTypes) + " with arguments " + StaticTypeCheckingVisitor.formatArgumentList(at), (ASTNode)location);
            return false;
        }
        return true;
    }

    protected static String formatArgumentList(ClassNode[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return "[]";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        ClassNode[] classNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode node = classNodeArray[n2];
            joiner.add(StaticTypeCheckingSupport.prettyPrintType(node));
            ++n2;
        }
        return joiner.toString();
    }

    private static void putSetterInfo(Expression exp, SetterInfo info) {
        exp.putNodeMetaData(SetterInfo.class, (Object)info);
    }

    private static SetterInfo removeSetterInfo(Expression exp) {
        Object nodeMetaData = exp.getNodeMetaData(SetterInfo.class);
        if (nodeMetaData != null) {
            exp.removeNodeMetaData(SetterInfo.class);
            return (SetterInfo)nodeMetaData;
        }
        return null;
    }

    @Override
    public void addError(String msg, ASTNode expr) {
        Long err = (long)expr.getLineNumber() << 16 + expr.getColumnNumber();
        if (DEBUG_GENERATED_CODE && expr.getLineNumber() < 0 || !this.typeCheckingContext.reportedErrors.contains(err)) {
            this.typeCheckingContext.getErrorCollector().addErrorAndContinue(String.valueOf(msg) + '\n', expr, this.getSourceUnit());
            this.typeCheckingContext.reportedErrors.add(err);
        }
    }

    protected void addStaticTypeError(String msg, ASTNode expr) {
        if (expr.getColumnNumber() > 0 && expr.getLineNumber() > 0) {
            this.addError("[Static type checking] - " + msg, expr);
        } else if (DEBUG_GENERATED_CODE) {
            this.addError("[Static type checking] - Error in generated code [" + expr.getText() + "] - " + msg, expr);
        }
    }

    protected void addNoMatchingMethodError(ClassNode receiver, String name, ClassNode[] args, Expression call) {
        if ("<init>".equals(name)) {
            ClassNode[] actual = receiver.isEnum() && args.length >= 2 ? Arrays.copyOfRange(args, 2, args.length) : args;
            this.addStaticTypeError("Cannot find matching constructor " + StaticTypeCheckingSupport.prettyPrintTypeName(receiver) + StaticTypeCheckingSupport.toMethodParametersString("", actual), (ASTNode)call);
            return;
        }
        if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver)) {
            receiver = receiver.getGenericsTypes()[0].getType();
        }
        this.addStaticTypeError("Cannot find matching method " + StaticTypeCheckingSupport.prettyPrintTypeName(receiver) + "#" + StaticTypeCheckingSupport.toMethodParametersString(name, args) + ". Please check if the declared type is correct and if the method exists.", (ASTNode)call);
    }

    protected void addAmbiguousErrorMessage(List<MethodNode> foundMethods, String name, ClassNode[] args, Expression expr) {
        this.addStaticTypeError("Reference to method is ambiguous. Cannot choose between " + StaticTypeCheckingVisitor.prettyPrintMethodList(foundMethods), (ASTNode)expr);
    }

    protected void addCategoryMethodCallError(Expression call) {
        this.addStaticTypeError("Due to their dynamic nature, usage of categories is not possible with static type checking active", (ASTNode)call);
    }

    protected void addAssignmentError(ClassNode leftType, ClassNode rightType, Expression assignmentExpression) {
        this.addStaticTypeError("Cannot assign value of type " + rightType.toString(false) + " to variable of type " + leftType.toString(false), (ASTNode)assignmentExpression);
    }

    protected void addUnsupportedPreOrPostfixExpressionError(Expression expression) {
        if (expression instanceof PostfixExpression) {
            this.addStaticTypeError("Unsupported postfix operation type [" + ((PostfixExpression)expression).getOperation() + "]", (ASTNode)expression);
        } else if (expression instanceof PrefixExpression) {
            this.addStaticTypeError("Unsupported prefix operation type [" + ((PrefixExpression)expression).getOperation() + "]", (ASTNode)expression);
        } else {
            throw new IllegalArgumentException("Method should be called with a PostfixExpression or a PrefixExpression");
        }
    }

    public void setMethodsToBeVisited(Set<MethodNode> methodsToBeVisited) {
        this.typeCheckingContext.methodsToBeVisited = methodsToBeVisited;
    }

    public void performSecondPass() {
        for (SecondPassExpression wrapper : this.typeCheckingContext.secondPassExpressions) {
            List<MethodNode> method;
            VariableExpression var;
            List classNodes;
            Variable target;
            Expression left;
            Expression expression = wrapper.getExpression();
            if (!(expression instanceof BinaryExpression) || !((left = ((BinaryExpression)expression).getLeftExpression()) instanceof VariableExpression) || !((target = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)left)) instanceof VariableExpression) || (classNodes = (List)this.typeCheckingContext.closureSharedVariablesAssignmentTypes.get(var = (VariableExpression)target)) == null || classNodes.size() <= 1) continue;
            ClassNode lub = WideningCategories.lowestUpperBound((List)classNodes);
            String message = StaticTypeCheckingSupport.getOperationName(((BinaryExpression)expression).getOperation().getType());
            if (message == null || !(method = this.findMethod(lub, message, this.getType((ASTNode)((BinaryExpression)expression).getRightExpression()))).isEmpty()) continue;
            this.addStaticTypeError("A closure shared variable [" + target.getName() + "] has been assigned with various types and the method" + " [" + StaticTypeCheckingSupport.toMethodParametersString(message, this.getType((ASTNode)((BinaryExpression)expression).getRightExpression())) + "]" + " does not exist in the lowest upper bound of those types: [" + lub.toString(false) + "]. In general, this is a bad practice (variable reuse) because the compiler cannot" + " determine safely what is the type of the variable at the moment of the call in a multithreaded context.", (ASTNode)expression);
        }
        this.extension.finish();
    }

    protected static ClassNode[] extractTypesFromParameters(Parameter[] parameters) {
        return (ClassNode[])Arrays.stream(parameters).map(Parameter::getType).toArray(ClassNode[]::new);
    }

    protected static ClassNode wrapTypeIfNecessary(ClassNode type) {
        if (ClassHelper.isPrimitiveType(type)) {
            return ClassHelper.getWrapper(type);
        }
        return type;
    }

    protected static boolean isClassInnerClassOrEqualTo(ClassNode toBeChecked, ClassNode start) {
        if (start == toBeChecked) {
            return true;
        }
        ClassNode outer = start.getOuterClass();
        if (outer != null) {
            return StaticTypeCheckingVisitor.isClassInnerClassOrEqualTo(toBeChecked, outer);
        }
        return false;
    }

    private static BinaryExpression assignX(Expression lhs, Expression rhs, ASTNode pos) {
        BinaryExpression exp = (BinaryExpression)GeneralUtils.assignX((Expression)lhs, (Expression)rhs);
        exp.setSourcePosition(pos);
        return exp;
    }

    private static /* synthetic */ boolean lambda$63(GenericsType genericsType, GenericsType gt) {
        return StaticTypeCheckingSupport.isAssignableTo(gt.getType(), genericsType.getType());
    }

    private static /* synthetic */ void lambda$64(Map map, Map.Entry entry, GenericsType gt) {
        GenericsType genericsType = map.put(new GenericsType.GenericsTypeName(((GenericsType)entry.getValue()).getName()), gt);
    }

    private static class ExtensionMethodDeclaringClass {
        private ExtensionMethodDeclaringClass() {
        }
    }

    private class ParameterVariableExpression
    extends VariableExpression {
        private final Parameter parameter;

        ParameterVariableExpression(Parameter parameter) {
            super((Variable)parameter);
            this.parameter = parameter;
            ClassNode inferredType = (ClassNode)this.getNodeMetaData(StaticTypesMarker.INFERRED_TYPE);
            if (inferredType == null) {
                inferredType = (ClassNode)StaticTypeCheckingVisitor.this.typeCheckingContext.controlStructureVariables.get(parameter);
                if (inferredType == null) {
                    inferredType = StaticTypeCheckingVisitor.this.getTypeFromClosureArguments(parameter);
                }
                this.setNodeMetaData(StaticTypesMarker.INFERRED_TYPE, inferredType != null ? inferredType : parameter.getType());
            }
        }

        public Map getMetaDataMap() {
            return this.parameter.getMetaDataMap();
        }

        public void setMetaDataMap(Map map) {
            this.parameter.setMetaDataMap(map);
        }
    }

    private class PropertyLookup
    extends ClassCodeVisitorSupport {
        ClassNode propertyType;
        ClassNode receiverType;

        PropertyLookup(ClassNode type) {
            this.receiverType = type;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return StaticTypeCheckingVisitor.this.getSourceUnit();
        }

        @Override
        public void visitField(FieldNode node) {
            this.storePropertyType(node.getType(), node.isStatic() ? null : node.getDeclaringClass());
        }

        @Override
        public void visitMethod(MethodNode node) {
            this.storePropertyType(node.getReturnType(), node.isStatic() ? null : node.getDeclaringClass());
        }

        @Override
        public void visitProperty(PropertyNode node) {
            this.storePropertyType(node.getOriginType(), node.isStatic() ? null : node.getDeclaringClass());
        }

        private void storePropertyType(ClassNode type, ClassNode declaringClass) {
            if (declaringClass != null && GenericsUtils.hasUnresolvedGenerics(type)) {
                Map spec = StaticTypeCheckingVisitor.extractPlaceHolders(this.receiverType, declaringClass);
                type = StaticTypeCheckingSupport.applyGenericsContext((Map<GenericsType.GenericsTypeName, GenericsType>)spec, type);
            }
            this.propertyType = type;
        }
    }

    private static class SetterInfo {
        final ClassNode receiverType;
        final String name;
        final List<MethodNode> setters;

        private SetterInfo(ClassNode receiverType, String name, List<MethodNode> setters) {
            this.receiverType = receiverType;
            this.setters = setters;
            this.name = name;
        }
    }

    public static class SignatureCodecFactory {
        public static SignatureCodec getCodec(int version, ClassLoader classLoader) {
            switch (version) {
                case 1: {
                    return new SignatureCodecVersion1(classLoader);
                }
            }
            return null;
        }
    }

    protected class VariableExpressionTypeMemoizer
    extends ClassCodeVisitorSupport {
        private final boolean onlySharedVariables;
        private final Map<VariableExpression, ClassNode> varOrigType;

        public VariableExpressionTypeMemoizer(Map<VariableExpression, ClassNode> varOrigType) {
            this(varOrigType, false);
        }

        public VariableExpressionTypeMemoizer(Map<VariableExpression, ClassNode> varOrigType, boolean onlySharedVariables) {
            this.varOrigType = varOrigType;
            this.onlySharedVariables = onlySharedVariables;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return StaticTypeCheckingVisitor.this.getSourceUnit();
        }

        public void visitVariableExpression(VariableExpression expression) {
            Variable var = StaticTypeCheckingSupport.findTargetVariable(expression);
            if ((!this.onlySharedVariables || var.isClosureSharedVariable()) && var instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)var;
                ClassNode cn = (ClassNode)ve.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                if (cn == null) {
                    cn = ve.getOriginType();
                }
                this.varOrigType.put(ve, cn);
            }
            super.visitVariableExpression(expression);
        }
    }
}

