/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.dialog.OpenProjectDialog;
import com.kms.katalon.composer.project.handlers.CloseProjectHandler;
import com.kms.katalon.composer.project.handlers.SwitchingEditionsOrVersionsHandler;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenProjectHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    @Inject
    private MApplication application;
    @Inject
    private UISynchronize sync;

    @PostConstruct
    public void setup() {
        this.eventBroker.subscribe("PROJECT/OPENED", new EventHandler(){

            public void handleEvent(Event event) {
                OpenProjectHandler.loadTestOpsSettings();
            }
        });
    }

    @Execute
    public void execute(Shell shell) {
        try {
            if (ApplicationInfo.isPlatformStudio()) {
                OpenProjectDialog dialog = new OpenProjectDialog(shell);
                dialog.open();
            } else {
                File projectDirectory;
                DirectoryDialog directoryDialog = new DirectoryDialog(shell);
                String path = directoryDialog.open();
                if (path != null && (projectDirectory = new File(path)) != null && projectDirectory.exists() && projectDirectory.isDirectory()) {
                    File projectFile = OpenProjectHandler.getProjectFile(projectDirectory);
                    if (projectFile != null) {
                        if (!CloseProjectHandler.closeCurrentProject(this.partService, this.modelService, this.application, this.eventBroker)) {
                            return;
                        }
                        this.openProjectEventHandler(shell, projectFile.getAbsolutePath());
                    } else {
                        MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)StringConstants.HAND_WARN_MSG_NO_PROJ_FOUND);
                    }
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_CANNOT_OPEN_PROJ);
        }
    }

    public static File getProjectFile(File projectDirectory) {
        if (projectDirectory == null) {
            return null;
        }
        File[] childFiles = projectDirectory.listFiles();
        if (childFiles == null) {
            return null;
        }
        File[] fileArray = childFiles;
        int n = childFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && (String.valueOf('.') + FilenameUtils.getExtension((String)file.getAbsolutePath())).equals(ProjectEntity.getProjectFileExtension())) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public static List<File> getProjectFiles(File projectDirectory) {
        if (projectDirectory == null || projectDirectory.listFiles() == null) {
            return Collections.emptyList();
        }
        ArrayList<File> childProjectFiles = new ArrayList<File>();
        File[] fileArray = projectDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File projectFile;
            File file = fileArray[n2];
            if (file.isDirectory() && (projectFile = OpenProjectHandler.getProjectFile(file)) != null) {
                childProjectFiles.add(projectFile);
            }
            ++n2;
        }
        return childProjectFiles;
    }

    @Inject
    @Optional
    private void openProjectEventHandler(@Named(value="activeShell") @Named(value="activeShell") Shell shell, @UIEventTopic(value="PROJECT/OPEN") String projectPk) throws InvocationTargetException, InterruptedException {
        boolean forceToOpenProject = new SwitchingEditionsOrVersionsHandler(shell, projectPk).isOpenProjectAnyway();
        if (!forceToOpenProject) {
            return;
        }
        OpenProjectHandler.doOpenProject(shell, projectPk, this.sync, this.eventBroker, this.partService, this.modelService, this.application);
    }

    @Inject
    @Optional
    private void restoreOpenProjectEventHandler(@Named(value="activeShell") @Named(value="activeShell") Shell shell, @UIEventTopic(value="PROJECT/OPEN_LATEST") String projectPk) throws InvocationTargetException, InterruptedException {
        OpenProjectHandler.doOpenProject(shell, projectPk, this.sync, this.eventBroker, this.partService, this.modelService, this.application);
        this.eventBroker.post("PROJECT/RESTORE_SESSION", null);
        OpenProjectHandler.introduceStudioAssistFeature(this.eventBroker);
    }

    public static void doOpenProject(Shell shell, final String projectPk, final UISynchronize syncService, final IEventBroker eventBrokerService, EPartService partService, final EModelService modelService, final MApplication application) throws InvocationTargetException, InterruptedException {
        if (!CloseProjectHandler.closeCurrentProject(partService, modelService, application, eventBrokerService)) {
            return;
        }
        new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
                    monitor.beginTask(StringConstants.HAND_OPENING_PROJ, 10);
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
                    monitor.worked(1);
                    monitor.subTask(StringConstants.HAND_LOADING_PROJ);
                    boolean allowSourceAttachment = featureService.canUse(KSEFeature.SOURCE_CODE_FOR_DEBUGGING);
                    final ProjectEntity project = ProjectController.getInstance().openProjectForUI(projectPk, allowSourceAttachment, (IProgressMonitor)progress.newChild(7, 1));
                    monitor.subTask(StringConstants.HAND_REFRESHING_EXPLORER);
                    syncService.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (project != null) {
                                    OpenProjectHandler.updateProjectTitle(project, modelService, application);
                                    Trackings.trackOpenProject((ProjectEntity)project);
                                    UserProfile userProfile = UserProfileHelper.getCurrentProfile();
                                    userProfile.setDoneCreateFirstProject(true);
                                    userProfile.addCompletedTour("CREATE_FIRST_PROJECT");
                                    UserProfileHelper.saveProfile((UserProfile)userProfile);
                                    project.setFreeLicense(LicenseUtil.isFreeLicense());
                                }
                                eventBrokerService.post("EXPLORER/RELOAD_INPUT", (Object)TreeEntityUtil.getTreeEntities((ProjectEntity)project, (boolean)false));
                                OpenProjectHandler.showProblemView();
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                            }
                        }
                    });
                    eventBrokerService.post("GLOBAL_VARIABLE/REFRESH", null);
                    monitor.worked(1);
                    LauncherManager.refresh();
                    eventBrokerService.post("CONSOLE_LOG/RESET", null);
                    monitor.worked(1);
                    TimeUnit.SECONDS.sleep(1L);
                    eventBrokerService.post("PROJECT/OPENED", null);
                    eventBrokerService.post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
                    eventBrokerService.post("START_PAGE/RELOAD", null);
                    return;
                }
                catch (Exception e) {
                    syncService.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.HAND_ERROR_MSG_CANNOT_OPEN_PROJ, (String)e.getClass().getSimpleName());
                        }
                    });
                    LoggerSingleton.logError((Throwable)e);
                    return;
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private static void loadTestOpsSettings() {
        TestOpsService.switchToDefaultInstance();
        AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        AnalyticsOrganization org = analyticsSettingStore.getOrganizationCloud();
        if (Objects.nonNull(org) && org.isSamlSSO()) {
            try {
                analyticsSettingStore.setOverrideAuthentication(false);
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        TestOpsService overridingTestOpsService = TestOpsService.getOverridingInstance();
        try {
            overridingTestOpsService.abortRenewingTokens();
            overridingTestOpsService.revokeAndClearAllTokens();
        }
        catch (AnalyticsApiException error) {
            LoggerSingleton.logError((Throwable)error);
        }
        ((TestOpsService)((TestOpsService)overridingTestOpsService.setAdminServer(analyticsSettingStore.getServerEndpointOnPremise())).setTestOpsServer(analyticsSettingStore.getServerEndpointOnPremise())).setCredential(analyticsSettingStore.getEmail(), analyticsSettingStore.getPassword());
        try {
            overridingTestOpsService.detectTestOpsServer();
        }
        catch (AnalyticsApiException error) {
            LoggerSingleton.logError((Throwable)error);
        }
        if (analyticsSettingStore.isOverrideAuthentication()) {
            TestOpsService.switchToOverridingInstance();
        }
    }

    private static void introduceStudioAssistFeature(IEventBroker eventBrokerService) {
        UserProfile curProfile = UserProfileHelper.getCurrentProfile();
        if (curProfile.getNumberOfOpenTimes() < 1) {
            eventBrokerService.send("INTRODUCE_STUDIOASSIST", null);
        }
    }

    public static void showProblemView() {
        EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
        MApplication application = ApplicationSingleton.getInstance().getApplication();
        List psList = modelService.findElements((MUIElement)application, null, MPerspectiveStack.class, null);
        MPartStack consolePartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.console", ((MPerspectiveStack)psList.get(0)).getSelectedElement());
        consolePartStack.getTags().remove("Minimized");
        List children = consolePartStack.getChildren();
        MStackElement problemViewStackElement = null;
        for (MStackElement element : children) {
            if (!element.getElementId().equals("org.eclipse.ui.views.ProblemView")) continue;
            problemViewStackElement = element;
            consolePartStack.setSelectedElement((MUIElement)problemViewStackElement);
            consolePartStack.setVisible(true);
            break;
        }
        if (!consolePartStack.isToBeRendered()) {
            consolePartStack.setToBeRendered(true);
        }
    }

    public static void updateProjectTitle(ProjectEntity projectEntity, EModelService modelService, MApplication app) {
        MWindow win = (MWindow)modelService.find("com.kms.katalon.composer.window.main", (MUIElement)app);
        String versionTag = ApplicationInfo.versionTag();
        if (win != null) {
            win.setLabel(String.valueOf(Platform.getProduct().getName()) + " - " + (!StringUtils.isBlank((String)versionTag) ? String.valueOf(versionTag) + " - " : "") + projectEntity.getName() + " - [Location: " + projectEntity.getFolderLocation() + "]");
            win.updateLocalization();
        }
    }
}

