/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.util.groovy;

import com.kms.katalon.core.checkpoint.CheckpointFactory;
import com.kms.katalon.core.keyword.KatalonBuiltInKeywordsUtil;
import com.kms.katalon.core.testcase.TestCaseFactory;
import com.kms.katalon.core.testdata.TestDataFactory;
import com.kms.katalon.core.testobject.ObjectRepository;
import groovy.transform.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.refactoring.actions.TypeSearch;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.JavaCoreUtil;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.groovy.core.util.DepthFirstVisitor;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.search.JavaSearchTypeNameMatch;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class OrganizeGroovyImports {
    private static final Pattern ALIASED_IMPORT = Pattern.compile("\\sas\\s");
    private static final Pattern STATIC_CONSTANT = Pattern.compile("[A-Z][A-Z0-9_]+");
    private static final ClassNode SCRIPT_FIELD_CLASS_NODE = ClassHelper.make(Field.class);
    private static final ImportRewrite.ImportRewriteContext FORCE_RETENTION = new ImportRewrite.ImportRewriteContext(){

        public int findInContext(String qualifier, String name, int kind) {
            return 4;
        }
    };
    private final SubMonitor monitor;
    private IChooseImportQuery query;
    private final GroovyCompilationUnit unit;
    private Map<String, TypeSearch.UnresolvedTypeData> missingTypes;
    private Map<String, ImportNode> importsSlatedForRemoval;
    private Map<String, Boolean> importAlias;

    public OrganizeGroovyImports(GroovyCompilationUnit unit, IChooseImportQuery query) {
        this(unit, query, null);
    }

    public OrganizeGroovyImports(GroovyCompilationUnit unit, IChooseImportQuery query, IProgressMonitor monitor) {
        this.unit = unit;
        this.query = query;
        this.monitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Organize import statements", (int)7);
    }

    public boolean calculateAndApplyMissingImports() throws JavaModelException {
        TextEdit edit = this.calculateMissingImports();
        if (edit != null) {
            this.unit.applyTextEdit(edit, (IProgressMonitor)this.monitor.split(0));
            return true;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public TextEdit calculateMissingImports() {
        String event = null;
        if (GroovyLogManager.manager.hasLoggers()) {
            event = this.unit.getElementName();
            GroovyLogManager.manager.logStart(event);
            GroovyLogManager.manager.log(TraceCategory.ORGANIZE_IMPORTS, event);
        }
        try {
            block48: {
                TextEdit textEdit;
                ModuleNodeMapper.ModuleNodeInfo info = this.unit.getModuleInfo(true);
                if (info.isEmpty() || OrganizeGroovyImports.isUnclean(info, this.unit)) {
                    return null;
                }
                this.missingTypes = new HashMap<String, TypeSearch.UnresolvedTypeData>();
                this.importsSlatedForRemoval = new HashMap<String, ImportNode>();
                this.importAlias = new HashMap<String, Boolean>();
                String fileContents = OrganizeGroovyImports.getFileContens(this.unit.getContents());
                try {
                    List allImports = GroovyUtils.getAllImportNodes((ModuleNode)info.module);
                    ImportRewrite rewriter = CodeStyleConfiguration.createImportRewrite((ICompilationUnit)this.unit, (!OrganizeGroovyImports.isSafeToReorganize(allImports) ? 1 : 0) != 0);
                    rewriter = this.addMissingStaticImport(rewriter, fileContents);
                    HashMap<String, ImportNode> aliasedImportNodes = new HashMap<String, ImportNode>();
                    HashMap<String, ImportNode> removedAliasedNodes = new HashMap<String, ImportNode>();
                    String lastKey = null;
                    ImportNode firstNode = null;
                    for (ImportNode imp : allImports) {
                        if (firstNode == null) {
                            firstNode = imp;
                        }
                        if (imp.isStar()) {
                            if (!imp.isStatic()) {
                                rewriter.addImport(String.valueOf(imp.getPackageName()) + "*");
                                this.importsSlatedForRemoval.put(String.valueOf(imp.getPackageName()) + "*", imp);
                                lastKey = String.valueOf(imp.getPackageName()) + "*";
                            } else {
                                rewriter.addStaticImport(imp.getClassName().replace('$', '.'), "*", true);
                                this.importsSlatedForRemoval.put(String.valueOf(imp.getClassName().replace('$', '.')) + ".*", imp);
                                lastKey = imp.getClassName().replace('$', '.');
                            }
                        } else {
                            String className = imp.getClassName().replace('$', '.');
                            if (!imp.isStatic()) {
                                if (!OrganizeGroovyImports.isAliased(imp)) {
                                    rewriter.addImport(className);
                                    lastKey = className;
                                } else {
                                    rewriter.addImport(String.valueOf(className) + " as " + imp.getAlias(), (ImportRewrite.ImportRewriteContext)(imp.getEnd() > 0 ? FORCE_RETENTION : null));
                                    lastKey = String.valueOf(className) + " as " + imp.getAlias();
                                }
                                if (this.importsSlatedForRemoval.containsKey(lastKey)) {
                                    removedAliasedNodes.put(lastKey, imp);
                                }
                                this.importsSlatedForRemoval.put(lastKey, imp);
                            } else if (!OrganizeGroovyImports.isAliased(imp)) {
                                rewriter.addStaticImport(className, imp.getFieldName(), false);
                                this.importsSlatedForRemoval.put(String.valueOf(className) + "." + imp.getFieldName(), imp);
                                lastKey = String.valueOf(className) + "." + imp.getFieldName();
                            } else {
                                ImportRewrite.ImportRewriteContext context = imp.getEnd() > 0 ? FORCE_RETENTION : null;
                                rewriter.addStaticImport(className, String.valueOf(imp.getFieldName()) + " as " + imp.getAlias(), true, context);
                                this.importsSlatedForRemoval.put(String.valueOf(className) + "." + imp.getFieldName() + " as " + imp.getAlias(), imp);
                                lastKey = String.valueOf(className) + "." + imp.getFieldName() + " as " + imp.getAlias();
                            }
                        }
                        aliasedImportNodes.put(lastKey, imp);
                    }
                    this.monitor.worked(1);
                    for (ClassNode clazz : info.module.getClasses()) {
                        FindUnresolvedReferencesVisitor visitor = new FindUnresolvedReferencesVisitor();
                        visitor.visitClass(clazz);
                    }
                    this.monitor.worked(4);
                    for (ImportNode imp : allImports) {
                        Object key;
                        boolean isDefault;
                        boolean bl = isDefault = !imp.isStatic() && !OrganizeGroovyImports.isAliased(imp) && (ClassHelper.BigDecimal_TYPE.equals((Object)imp.getType()) || ClassHelper.BigInteger_TYPE.equals((Object)imp.getType()));
                        if (!isDefault && (imp.getEnd() >= 1 || imp.isStar() && !imp.isStatic())) continue;
                        if (imp.isStar()) {
                            key = !imp.isStatic() ? String.valueOf(imp.getPackageName()) + "*" : String.valueOf(imp.getClassName().replace('$', '.')) + ".*";
                        } else {
                            key = imp.getClassName().replace('$', '.');
                            if (imp.isStatic()) {
                                key = String.valueOf(key) + "." + imp.getFieldName();
                            }
                            if (OrganizeGroovyImports.isAliased(imp)) {
                                key = String.valueOf(key) + " as " + imp.getAlias();
                            }
                        }
                        this.importsSlatedForRemoval.put((String)key, imp);
                    }
                    for (ImportNode imp : allImports) {
                        if (!imp.isStatic() || !imp.isStar()) continue;
                        for (ImportNode i : allImports) {
                            if (i == imp || !i.isStatic() || OrganizeGroovyImports.isAliased(i) || imp.getType().equals((Object)i.getType()) || !imp.getType().isDerivedFrom(i.getType())) continue;
                            String className = i.getClassName().replace('$', '.');
                            if (i.isStar()) {
                                this.importsSlatedForRemoval.put(String.valueOf(className) + ".*", i);
                            } else {
                                this.importsSlatedForRemoval.put(String.valueOf(className) + "." + i.getFieldName(), i);
                            }
                            if (imp.getEnd() <= 0) continue;
                            this.importsSlatedForRemoval.remove(String.valueOf(imp.getClassName().replace('$', '.')) + ".*");
                        }
                    }
                    for (Map.Entry entry : this.importsSlatedForRemoval.entrySet()) {
                        String key = (String)entry.getKey();
                        ImportNode value = (ImportNode)entry.getValue();
                        if (aliasedImportNodes.containsKey(key) && value != firstNode) {
                            removedAliasedNodes.put(key, (ImportNode)aliasedImportNodes.get(key));
                        }
                        OrganizeGroovyImports.trace("Remove import '%s'", entry.getKey());
                        if (!((ImportNode)entry.getValue()).isStatic()) {
                            rewriter.removeImport((String)entry.getKey());
                            continue;
                        }
                        rewriter.removeStaticImport((String)entry.getKey());
                    }
                    this.monitor.worked(1);
                    if (!removedAliasedNodes.isEmpty()) {
                        ArrayList sortedImportNodes = new ArrayList(removedAliasedNodes.values());
                        sortedImportNodes.sort(new Comparator<ImportNode>(){

                            @Override
                            public int compare(ImportNode o1, ImportNode o2) {
                                return o2.getStart() - o1.getStart();
                            }
                        });
                        MultiTextEdit multiEdits = new MultiTextEdit();
                        for (ImportNode node : sortedImportNodes) {
                            DeleteEdit deleteEdit = null;
                            deleteEdit = node.getEnd() < info.module.getEnd() ? new DeleteEdit(node.getStart(), node.getLength() + 1) : new DeleteEdit(node.getStart(), node.getLength());
                            multiEdits.addChild((TextEdit)deleteEdit);
                        }
                        this.unit.applyTextEdit((TextEdit)multiEdits, (IProgressMonitor)this.monitor.split(1));
                        TextEdit textEdit2 = this.calculateMissingImports();
                        return textEdit2;
                    }
                    if (!this.missingTypes.isEmpty()) {
                        this.pruneMissingTypes(allImports);
                        if (!this.missingTypes.isEmpty()) {
                            this.monitor.subTask("Resolve missing types");
                            this.monitor.setWorkRemaining(this.missingTypes.size() + 1);
                            IType[] iTypeArray = this.resolveMissingTypes((IProgressMonitor)this.monitor.split(1));
                            int n = iTypeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IType type = iTypeArray[n2];
                                OrganizeGroovyImports.trace("Missing type '%s'", type);
                                String aliased = KatalonBuiltInKeywordsUtil.getAliasedByKeywordName((String)type.getTypeQualifiedName());
                                boolean isImportWithAlias = this.importAlias.getOrDefault(type.getTypeQualifiedName(), false);
                                if (aliased != null && isImportWithAlias) {
                                    rewriter.addImport(String.valueOf(type.getFullyQualifiedName('.')) + " as " + aliased);
                                } else {
                                    rewriter.addImport(type.getFullyQualifiedName('.'));
                                }
                                ++n2;
                            }
                        }
                    }
                    TextEdit rewrite = rewriter.rewriteImports((IProgressMonitor)this.monitor.split(1));
                    OrganizeGroovyImports.trace("%s", rewrite);
                    textEdit = rewrite;
                }
                catch (Exception e) {
                    GroovyPlugin.getDefault().logError("Exception thrown when organizing imports for " + this.unit.getElementName(), (Throwable)e);
                    break block48;
                }
                finally {
                    this.importsSlatedForRemoval = null;
                    this.missingTypes = null;
                }
                return textEdit;
            }
            return null;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (event != null) {
                GroovyLogManager.manager.logEnd(event, TraceCategory.ORGANIZE_IMPORTS);
            }
        }
    }

    private void pruneMissingTypes(Iterable<ImportNode> imports) throws JavaModelException {
        LinkedHashSet<String> starImports = new LinkedHashSet<String>();
        LinkedHashSet<String> typeImports = new LinkedHashSet<String>();
        if (this.unit.getModuleNode().getPackageName() != null) {
            starImports.add(this.unit.getModuleNode().getPackageName());
        } else {
            starImports.add("");
        }
        for (ImportNode imp : imports) {
            if (imp.isStatic()) continue;
            if (imp.isStar()) {
                starImports.add(imp.getPackageName());
                continue;
            }
            typeImports.add(imp.getText());
        }
        Iterator<String> it = this.missingTypes.keySet().iterator();
        block1: while (it.hasNext()) {
            String typeName = it.next();
            for (String imp : typeImports) {
                if (!imp.endsWith(String.valueOf(' ') + typeName)) continue;
                it.remove();
                continue block1;
            }
            for (String imp : starImports) {
                IType type = JavaCoreUtil.findType((String)(String.valueOf(imp) + typeName), (IJavaElement)this.unit);
                if (type == null) continue;
                it.remove();
                continue block1;
            }
        }
    }

    private IType[] resolveMissingTypes(IProgressMonitor monitor) throws JavaModelException {
        new TypeSearch().searchForTypes(this.unit, this.missingTypes, monitor);
        ArrayList<TypeNameMatch> missingTypesNoChoiceRequired = new ArrayList<TypeNameMatch>();
        ArrayList<TypeNameMatch[]> missingTypesChoiceRequired = new ArrayList<TypeNameMatch[]>();
        ArrayList<ISourceRange> ranges = new ArrayList<ISourceRange>();
        for (TypeSearch.UnresolvedTypeData data : this.missingTypes.values()) {
            List foundInfos = data.getFoundInfos();
            int foundInfosSize = foundInfos.size();
            if (foundInfosSize == 1) {
                missingTypesNoChoiceRequired.add((TypeNameMatch)foundInfos.get(0));
                continue;
            }
            if (foundInfosSize <= 1) continue;
            missingTypesChoiceRequired.add(foundInfos.toArray(new TypeNameMatch[foundInfosSize]));
            ISourceRange range = (ISourceRange)ReflectionUtils.getPrivateField(TypeNameMatch.class, (String)"range", (Object)data);
            if (range == null) continue;
            ranges.add(range);
        }
        TypeNameMatch[][] missingTypesArr = (TypeNameMatch[][])missingTypesChoiceRequired.toArray((T[])new TypeNameMatch[0][]);
        TypeNameMatch[] chosen = missingTypesArr.length > 0 ? this.query.chooseImports(missingTypesArr, ranges.toArray(new ISourceRange[0])) : new TypeNameMatch[]{};
        if (chosen != null) {
            IType[] typeMatches = new IType[missingTypesNoChoiceRequired.size() + chosen.length];
            int index = 0;
            for (TypeNameMatch typeNameMatch : missingTypesNoChoiceRequired) {
                typeMatches[index++] = typeNameMatch.getType();
            }
            int i = 0;
            int n = chosen.length;
            while (i < n) {
                typeMatches[index++] = ((JavaSearchTypeNameMatch)chosen[i]).getType();
                ++i;
            }
            return typeMatches;
        }
        return new IType[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isUnclean(ModuleNodeMapper.ModuleNodeInfo info, GroovyCompilationUnit unit) {
        try {
            if (info.module.encounteredUnrecoverableError()) return true;
            if (!unit.isConsistent()) {
                return true;
            }
            CategorizedProblem[] problems = info.result.getProblems();
            if (problems == null) return false;
            if (problems.length <= 0) return false;
            CategorizedProblem[] categorizedProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (true) {
                String message;
                if (n2 >= n) {
                    return false;
                }
                CategorizedProblem problem = categorizedProblemArray[n2];
                if (problem.isError() && problem.getCategoryID() == 60 && (message = problem.getMessage()).contains("unexpected token")) {
                    OrganizeGroovyImports.trace("Stopping due to error in compilation unit: %s", message);
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static boolean isSafeToReorganize(Iterable<ImportNode> allImports) {
        for (ImportNode imp : allImports) {
            if (imp.getAnnotations().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean isAliased(ImportNode node) {
        String alias = node.getAlias();
        if (alias == null) {
            return false;
        }
        String fieldName = node.getFieldName();
        if (fieldName != null) {
            return !fieldName.equals(alias);
        }
        String className = node.getClassName();
        if (className != null) {
            boolean aliasIsSameAsClassName = className.endsWith(alias) && (className.length() == alias.length() || className.endsWith("." + alias) || className.endsWith("$" + alias));
            return !aliasIsSameAsClassName;
        }
        return false;
    }

    private static String getTypeName(ClassNode node) {
        ClassNode type = GroovyUtils.getBaseType((ClassNode)node);
        if (!type.getName().matches(".*\\b" + type.getUnresolvedName().replace('$', '.'))) {
            return String.valueOf(type.getName()) + " as " + type.getUnresolvedName().replace('.', '$');
        }
        return type.getName();
    }

    private static void trace(String message, Object ... arguments) {
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.ORGANIZE_IMPORTS, String.format(message, arguments));
        }
    }

    private static String getFileContens(char[] fileContent) {
        return String.valueOf(fileContent);
    }

    private ImportRewrite addMissingStaticImport(ImportRewrite rewriter, String fileContents) {
        if (fileContents.contains("findCheckpoint")) {
            rewriter.addStaticImport(CheckpointFactory.class.getName(), "findCheckpoint", true);
        }
        if (fileContents.contains("findTestCase")) {
            rewriter.addStaticImport(TestCaseFactory.class.getName(), "findTestCase", true);
        }
        if (fileContents.contains("findTestData")) {
            rewriter.addStaticImport(TestDataFactory.class.getName(), "findTestData", true);
        }
        if (fileContents.contains("findTestObject")) {
            rewriter.addStaticImport(ObjectRepository.class.getName(), "findTestObject", true);
        }
        if (fileContents.contains("findWindowsObject")) {
            rewriter.addStaticImport(ObjectRepository.class.getName(), "findWindowsObject", true);
        }
        return rewriter;
    }

    private class FindUnresolvedReferencesVisitor
    extends DepthFirstVisitor {
        private ClassNode current;

        private FindUnresolvedReferencesVisitor() {
        }

        public void visitClass(ClassNode node) {
            ClassNode previous = this.current;
            try {
                this.current = node;
                if (node.getEnd() > 0) {
                    if (FindUnresolvedReferencesVisitor.isNotEmpty((Object[])node.getGenericsTypes())) {
                        this.visitTypeParameters(node.getGenericsTypes(), node.getName());
                    }
                    this.handleTypeReference(node.getUnresolvedSuperClass(), false);
                    ClassNode[] classNodeArray = node.getUnresolvedInterfaces();
                    int n = classNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassNode impls = classNodeArray[n2];
                        this.handleTypeReference(impls, false);
                        ++n2;
                    }
                }
                super.visitClass(node);
            }
            finally {
                this.current = previous;
            }
        }

        public void visitField(FieldNode node) {
            if (node.getEnd() > 0) {
                this.handleTypeReference(node.getType(), false);
                if (node.getOwner().isScript()) {
                    this.handleTypeReference(SCRIPT_FIELD_CLASS_NODE, true);
                }
            }
            super.visitField(node);
        }

        public void visitMethod(MethodNode node) {
            if (node.getEnd() > 0) {
                if (!(node instanceof ConstructorNode) && FindUnresolvedReferencesVisitor.isNotEmpty((Object[])node.getGenericsTypes())) {
                    this.visitTypeParameters(node.getGenericsTypes(), null);
                }
                this.handleTypeReference(node.getReturnType(), false);
                ClassNode[] classNodeArray = node.getExceptions();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode exception = classNodeArray[n2];
                    this.handleTypeReference(exception, false);
                    ++n2;
                }
            }
            super.visitMethod(node);
        }

        public void visitArrayExpression(ArrayExpression expression) {
            if (expression.getEnd() > 0) {
                this.handleTypeReference(expression.getType(), false);
            }
            super.visitArrayExpression(expression);
        }

        public void visitCastExpression(CastExpression expression) {
            if (expression.getEnd() > 0) {
                this.handleTypeReference(expression.getType(), false);
            }
            super.visitCastExpression(expression);
        }

        public void visitClassExpression(ClassExpression expression) {
            if (expression.getEnd() > 0) {
                this.handleTypeReference(expression.getType(), false);
            }
            super.visitClassExpression(expression);
        }

        public void visitConstantExpression(ConstantExpression expression) {
            if (expression.getEnd() > 0 && expression instanceof AnnotationConstantExpression) {
                this.handleTypeReference(expression.getType(), true);
            }
            super.visitConstantExpression(expression);
        }

        public void visitConstructorCallExpression(ConstructorCallExpression expression) {
            if (expression.getEnd() > 0 && !expression.isSpecialCall() && !expression.isUsingAnonymousInnerClass()) {
                this.handleTypeReference(expression.getType(), false);
            }
            super.visitConstructorCallExpression(expression);
        }

        public void visitMethodCallExpression(MethodCallExpression expression) {
            if (expression.getEnd() > 0) {
                if (expression.isImplicitThis()) {
                    MethodNode methodTarget = expression.getMethodTarget();
                    if (methodTarget != null && methodTarget.isStatic()) {
                        String staticImport = String.valueOf(methodTarget.getDeclaringClass().getName().replace('$', '.')) + "." + expression.getMethodAsString();
                        Object alias = expression.getNodeMetaData((Object)"static.import.alias");
                        if (alias != null && !alias.equals(expression.getMethodAsString())) {
                            staticImport = String.valueOf(staticImport) + " as " + alias;
                        }
                        this.doNotRemoveImport(staticImport);
                    }
                } else if (FindUnresolvedReferencesVisitor.isNotEmpty((Object[])expression.getGenericsTypes())) {
                    this.visitTypeParameters(expression.getGenericsTypes(), null);
                }
            }
            super.visitMethodCallExpression(expression);
        }

        public void visitPropertyExpression(PropertyExpression expression) {
            Object alias;
            if (expression.getEnd() > 0 && !expression.isStatic() && (alias = expression.getNodeMetaData((Object)"static.import.alias")) != null) {
                String staticImport = expression.getText().replace('$', '.');
                if (!alias.equals(expression.getPropertyAsString())) {
                    staticImport = String.valueOf(staticImport) + " as " + alias;
                }
                this.doNotRemoveImport(staticImport);
            }
            super.visitPropertyExpression(expression);
        }

        public void visitStaticMethodCallExpression(StaticMethodCallExpression expression) {
            if (expression.getEnd() > 0) {
                String staticImport = String.valueOf(expression.getOwnerType().getName().replace('$', '.')) + "." + expression.getMethod();
                Object alias = expression.getNodeMetaData((Object)"static.import.alias");
                if (alias != null && !alias.equals(expression.getMethod())) {
                    staticImport = String.valueOf(staticImport) + " as " + alias;
                }
                this.doNotRemoveImport(staticImport);
            }
            super.visitStaticMethodCallExpression(expression);
        }

        public void visitVariableExpression(VariableExpression expression) {
            if (expression.getEnd() > 0) {
                String name;
                if (expression.getAccessedVariable() == expression) {
                    this.handleTypeReference(expression.getType(), false);
                }
                if ((expression.getAccessedVariable() instanceof DynamicVariable || expression.isDynamicTyped()) && !this.checkRetainImport(expression.getName()) && !OrganizeGroovyImports.this.missingTypes.containsKey(name = expression.getName()) && Character.isUpperCase(name.charAt(0))) {
                    String keywordPackage = KatalonBuiltInKeywordsUtil.getKeywordNameByAliased((String)name);
                    if (keywordPackage != null) {
                        OrganizeGroovyImports.this.missingTypes.put(keywordPackage, new TypeSearch.UnresolvedTypeData(keywordPackage, false, (ISourceRange)new SourceRange(expression.getStart(), expression.getEnd() - expression.getStart())));
                        OrganizeGroovyImports.this.importAlias.put(keywordPackage, true);
                    } else {
                        OrganizeGroovyImports.this.missingTypes.put(name, new TypeSearch.UnresolvedTypeData(name, false, (ISourceRange)new SourceRange(expression.getStart(), expression.getEnd() - expression.getStart())));
                    }
                }
            }
            super.visitVariableExpression(expression);
        }

        protected void visitAnnotation(AnnotationNode annotation) {
            if (annotation.getEnd() > 0) {
                this.handleTypeReference(annotation.getClassNode(), true);
            }
            super.visitAnnotation(annotation);
        }

        protected void visitParameter(Parameter parameter) {
            if (parameter != null && parameter.getEnd() > 0) {
                this.handleTypeReference(parameter.getOriginType(), false);
            }
            super.visitParameter(parameter);
        }

        protected void visitTypeParameters(GenericsType[] generics, String typeName) {
            GenericsType[] genericsTypeArray = generics;
            int n = generics.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType generic = genericsTypeArray[n2];
                if (generic.getStart() >= 1) {
                    if (!generic.isPlaceholder() && !generic.isWildcard()) {
                        this.handleTypeReference(generic.getType(), false);
                    }
                    if (generic.getLowerBound() != null) {
                        this.handleTypeReference(generic.getLowerBound(), false);
                    }
                    if (generic.getUpperBounds() != null) {
                        ClassNode[] classNodeArray = generic.getUpperBounds();
                        int n3 = classNodeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ClassNode upper = classNodeArray[n4];
                            if (!upper.getName().equals(typeName)) {
                                this.handleTypeReference(upper, false);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }

        private void handleTypeReference(ClassNode node, boolean isAnnotation) {
            Matcher m;
            ClassNode type = GroovyUtils.getBaseType((ClassNode)node);
            if (ClassHelper.isPrimitiveType((ClassNode)type)) {
                return;
            }
            String name = OrganizeGroovyImports.getTypeName(type);
            Object[] generics = type.getGenericsTypes();
            int start = node.getNameStart();
            int until = node.getNameEnd() + 1;
            if (until <= 1) {
                start = node.getStart();
                until = node.getEnd();
                if (until > 0 && FindUnresolvedReferencesVisitor.isNotEmpty((Object[])generics)) {
                    if (generics[0].getStart() > 0) {
                        until = generics[0].getStart() - 1;
                    }
                } else if (node.isArray() && type.getEnd() > 0) {
                    assert (start <= type.getStart());
                    assert (until <= 0 || type.getEnd() < until);
                    start = type.getStart();
                    until = type.getEnd();
                }
            }
            int length = until - start;
            if (FindUnresolvedReferencesVisitor.isNotEmpty((Object[])generics)) {
                this.visitTypeParameters((GenericsType[])generics, name);
            }
            if ((m = ALIASED_IMPORT.matcher(name)).find()) {
                int i = name.indexOf(36, m.end());
                if (i > 0) {
                    name = name.replaceAll(String.valueOf(Pattern.quote(name.substring(i))) + "(?= |$)", "");
                }
                this.doNotRemoveImport(name.replace('$', '.'));
            } else if (!this.current.getModule().getClasses().contains(node)) {
                if (!node.isResolved()) {
                    Object[] parts = name.split("\\.");
                    if (Character.isUpperCase(name.charAt(0))) {
                        name = parts[0];
                    } else if (length < name.length()) {
                        this.doNotRemoveImport(name);
                        name = (String)ArrayUtils.lastElement((Object[])parts);
                    }
                    if (!OrganizeGroovyImports.this.missingTypes.containsKey(name)) {
                        SourceRange range = new SourceRange(node.getStart(), node.getEnd() - node.getStart());
                        OrganizeGroovyImports.this.missingTypes.put(name, new TypeSearch.UnresolvedTypeData(name, isAnnotation, (ISourceRange)range));
                    }
                } else if (length > 0 && length < name.length()) {
                    char[] chars = this.current.getModule().getContext().readSourceRange(start, length);
                    if (chars != null) {
                        String partialName;
                        int i = 0;
                        while (i < chars.length && Character.isJavaIdentifierPart(chars[i])) {
                            ++i;
                        }
                        m = Pattern.compile("(?:\\A|\\$|\\.)" + String.valueOf(chars, 0, i) + "(?=\\$|$)").matcher(name);
                        if (m.find() && !this.isInnerOfSuper(partialName = name.substring(0, m.end()))) {
                            this.doNotRemoveImport(partialName.replace('$', '.'));
                        }
                    } else {
                        String partialName = name.replace('$', '.');
                        int end = name.length();
                        do {
                            partialName = partialName.substring(0, end);
                            this.doNotRemoveImport(partialName);
                        } while ((end = partialName.lastIndexOf(46)) > -1);
                    }
                } else if (length > name.length()) {
                    GroovyPlugin.getDefault().logError(String.format("Expected a fully-qualified name for %s at [%d..%d] line %d, but source length (%d) > name length (%d)%n", name, start, until, node.getLineNumber(), length, name.length()), (Throwable)new Exception());
                }
            }
        }

        private boolean isInnerOfSuper(String name) {
            if (name.lastIndexOf(36) > 0) {
                ClassNode node;
                ClassNode node2 = this.current.getSuperClass();
                while (node2 != null && !node2.equals((Object)ClassHelper.OBJECT_TYPE)) {
                    Iterator it = node2.redirect().getInnerClasses();
                    while (it.hasNext()) {
                        if (!((ClassNode)it.next()).getName().equals(name)) continue;
                        return true;
                    }
                    node2 = node2.getSuperClass();
                }
                ArrayDeque todo = new ArrayDeque();
                Collections.addAll(todo, this.current.getInterfaces());
                LinkedHashSet<ClassNode> done = new LinkedHashSet<ClassNode>();
                while ((node = (ClassNode)todo.poll()) != null) {
                    if (!done.add(node)) continue;
                    Iterator it = node.redirect().getInnerClasses();
                    while (it.hasNext()) {
                        if (!((ClassNode)it.next()).getName().equals(name)) continue;
                        return true;
                    }
                    Collections.addAll(todo, node.getInterfaces());
                }
            }
            return false;
        }

        private boolean checkRetainImport(String name) {
            if (!(OrganizeGroovyImports.this.importsSlatedForRemoval.isEmpty() || "this".equals(name) || "super".equals(name))) {
                String suffix = String.valueOf('.') + name;
                for (Map.Entry<String, ImportNode> entry : OrganizeGroovyImports.this.importsSlatedForRemoval.entrySet()) {
                    if (!entry.getValue().isStatic() || !entry.getKey().endsWith(suffix)) continue;
                    this.doNotRemoveImport(entry.getKey());
                    return true;
                }
            }
            return false;
        }

        private void doNotRemoveImport(String which) {
            int index;
            OrganizeGroovyImports.this.importsSlatedForRemoval.remove(which);
            if (!which.contains(" as ") && (index = which.lastIndexOf(46)) > 0) {
                OrganizeGroovyImports.this.importsSlatedForRemoval.remove(String.valueOf(which.substring(0, index + 1)) + "*");
            }
        }
    }

    @FunctionalInterface
    public static interface IChooseImportQuery {
        public TypeNameMatch[] chooseImports(TypeNameMatch[][] var1, ISourceRange[] var2);
    }
}

