/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.requestor;

import java.beans.Introspector;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedBinaryField;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedBinaryMethod;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedBinaryType;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedSourceField;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedSourceMethod;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedSourceType;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.transform.trait.Traits;
import org.codehaus.jdt.groovy.ast.MethodNodeWithNamedParams;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTFieldNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTMethodNode;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.JavaCoreUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.SourceType;

public class CodeSelectRequestor
implements ITypeRequestor {
    private ASTNode nodeToLookFor;
    private final Region nodeRegion;
    private final Region selectRegion;
    private final GroovyCompilationUnit gunit;
    private ASTNode requestedNode;
    private final List<IJavaElement> requestedElements = new ArrayList<IJavaElement>();

    public CodeSelectRequestor(ASTNode node, GroovyCompilationUnit unit) {
        this(node, null, new Region(Integer.MIN_VALUE, 0), unit);
    }

    public CodeSelectRequestor(ASTNode node, Region nodeRegion, Region selectRegion, GroovyCompilationUnit unit) {
        this.nodeToLookFor = node;
        this.nodeRegion = nodeRegion;
        this.selectRegion = selectRegion;
        this.gunit = unit;
    }

    public ASTNode getRequestedNode() {
        return this.requestedNode;
    }

    public IJavaElement[] getRequestedElements() {
        return this.requestedElements.toArray(new IJavaElement[this.requestedElements.size()]);
    }

    private void putRequestedElement(IJavaElement requestedElement) {
        this.requestedElements.add(Objects.requireNonNull(requestedElement));
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        boolean found = false;
        try {
            if (!this.isInterestingElement(enclosingElement)) {
                return ITypeRequestor.VisitStatus.CANCEL_MEMBER;
            }
            if (node instanceof ImportNode && node != this.nodeToLookFor && (node = ((ImportNode)node).getType()) == null) {
                return ITypeRequestor.VisitStatus.CONTINUE;
            }
            boolean bl = found = node == this.nodeToLookFor;
            if (!found && node.getEnd() > 0) {
                boolean bl2 = found = node.getStart() == this.nodeToLookFor.getStart() && node.getEnd() == this.nodeToLookFor.getEnd() && this.typeOf(node).equals(this.typeOf(this.nodeToLookFor));
            }
            if (found) {
                this.handleMatch(result, enclosingElement);
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)("Problem with code selection for ASTNode: " + node), (Throwable)e);
        }
        return !found ? ITypeRequestor.VisitStatus.CONTINUE : ITypeRequestor.VisitStatus.STOP_VISIT;
    }

    private boolean isInterestingElement(IJavaElement enclosingElement) throws JavaModelException {
        switch (enclosingElement.getElementType()) {
            case 8: {
                if (!"Qjava.lang.Object;".equals(((IField)enclosingElement).getTypeSignature())) break;
                return true;
            }
            case 9: {
                if (!this.isInitializerMethod((IMethod)enclosingElement)) break;
                return true;
            }
            case 10: {
                return true;
            }
        }
        if (enclosingElement instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)enclosingElement).getSourceRange();
            int start = range.getOffset();
            int until = range.getOffset() + range.getLength();
            boolean covers = start <= this.nodeToLookFor.getStart() && until >= this.nodeToLookFor.getEnd();
            covers = covers || start <= this.selectRegion.getOffset() && until >= this.selectRegion.getEnd();
            return covers;
        }
        return false;
    }

    private boolean isInitializerMethod(IMethod method) throws JavaModelException {
        if (method.isConstructor()) {
            return true;
        }
        if (!Flags.isStatic((int)method.getFlags())) {
            IAnnotation[] iAnnotationArray = method.getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                String name = annotation.getElementName();
                if (name.endsWith("PostConstruct")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void handleMatch(TypeLookupResult result, IJavaElement enclosingElement) throws JavaModelException {
        this.requestedNode = result.declaration;
        if (!(this.requestedNode instanceof ClassNode)) ** GOTO lbl9
        classNode = (ClassNode)this.requestedNode;
        if (!GroovyUtils.getBaseType((ClassNode)classNode).isGenericsPlaceHolder()) {
            this.requestedNode = classNode.redirect();
        } else {
            this.putRequestedElement((IJavaElement)this.findTypeParam(GroovyUtils.getBaseType((ClassNode)classNode).getUnresolvedName(), enclosingElement));
            return;
lbl9:
            // 1 sources

            if (this.requestedNode instanceof ConstructorNode) {
                this.requestedNode = this.nodeToLookFor instanceof ConstructorCallExpression && this.isSelectionInArguments((ConstructorCallExpression)this.nodeToLookFor) ? null : ((ConstructorNode)this.requestedNode).getDeclaringClass();
            } else if (this.requestedNode instanceof PropertyNode) {
                if (((PropertyNode)this.requestedNode).isSynthetic()) {
                    this.requestedNode = null;
                }
            } else if (this.requestedNode instanceof ImportNode && (importNode = (ImportNode)this.requestedNode).getType() != null) {
                this.requestedNode = importNode.getType().redirect();
            }
        }
        if (this.requestedNode != null) {
            if (this.nodeToLookFor instanceof PackageNode) {
                start = this.nodeToLookFor.getStart();
                if (start < (until = this.selectRegion.getEnd())) {
                    pack = this.gunit.getSource().substring(start, until);
                    root = this.gunit.getPackageFragmentRoot();
                    this.putRequestedElement((IJavaElement)root.getPackageFragment(pack));
                }
            } else if (this.nodeToLookFor instanceof ImportNode && ((ImportNode)this.nodeToLookFor).isStar() && !((ImportNode)this.nodeToLookFor).isStatic()) {
                start = this.nodeToLookFor.getStart();
                if (start < (until = this.selectRegion.getEnd())) {
                    pack = this.gunit.getSource().substring(start, until).replaceFirst("^import\\s+", "");
                    var9_21 = this.gunit.getJavaProject().getPackageFragmentRoots();
                    var8_22 = var9_21.length;
                    var7_23 = 0;
                    while (var7_23 < var8_22) {
                        root = var9_21[var7_23];
                        fragment = root.getPackageFragment(pack);
                        if (fragment != null && fragment.exists()) {
                            this.putRequestedElement((IJavaElement)fragment);
                            break;
                        }
                        ++var7_23;
                    }
                }
            } else if (result.declaration instanceof Parameter) {
                parameter = (Parameter)result.declaration;
                start = parameter.getNameStart();
                until = parameter.getNameEnd();
                type = result.type != null ? result.type : parameter.getType();
                signature = GroovyUtils.getTypeSignature((ClassNode)type, (boolean)true, (boolean)false);
                this.putRequestedElement((IJavaElement)new LocalVariable((JavaElement)enclosingElement, parameter.getName(), start, until, start, until, signature, null, parameter.getModifiers(), true));
            } else if (result.declaration instanceof VariableExpression) {
                variable = (VariableExpression)result.declaration;
                start = variable.getStart();
                until = variable.getEnd() - 1;
                type = result.type != null ? result.type : variable.getType();
                signature = GroovyUtils.getTypeSignature((ClassNode)type, (boolean)true, (boolean)false);
                this.putRequestedElement((IJavaElement)new LocalVariable((JavaElement)enclosingElement, variable.getName(), start, until, start, until, signature, null, variable.getModifiers(), false));
            } else {
                qualifier = this.checkQualifiedType(result, enclosingElement);
                declaringType = this.findDeclaringType(result);
                if (declaringType != null) {
                    type = (IType)enclosingElement.getAncestor(7);
                    if (type == null || !type.getFullyQualifiedName().equals(declaringType.getName())) {
                        if (!CodeSelectRequestor.$assertionsDisabled && GroovyUtils.isAnonymous((ClassNode)declaringType)) {
                            throw new AssertionError((Object)"Anonymous type here!");
                        }
                        type = JavaCoreUtil.findType((String)declaringType.getName(), (IJavaElement)enclosingElement);
                    }
                    if (type == null && !this.gunit.isOnBuildPath() && !(type = this.gunit.getType(declaringType.getNameWithoutPackage())).exists()) {
                        type = null;
                    }
                    if (type != null) {
                        if (qualifier == null) {
                            maybeRequested = this.findRequestedElement(result.declaration, declaringType, type);
                            this.putRequestedElement(this.resolveRequestedElement(maybeRequested, result));
                        } else {
                            candidate = this.gunit.getJavaProject().findType(qualifier);
                            if (candidate != null) {
                                this.putRequestedElement((IJavaElement)candidate);
                            } else {
                                root = type instanceof BinaryType != false ? (IPackageFragmentRoot)((BinaryType)type).getPackageFragment().getParent() : (IPackageFragmentRoot)((SourceType)type).getPackageFragment().getParent();
                                this.putRequestedElement((IJavaElement)root.getPackageFragment(qualifier));
                            }
                            this.requestedNode = this.nodeToLookFor;
                        }
                    }
                } else {
                    message = "Could not proceed due to null declaring type for " + this.requestedNode;
                    if (GroovyLogManager.manager.hasLoggers()) {
                        GroovyLogManager.manager.log(TraceCategory.CODE_SELECT, message);
                    } else {
                        System.err.println(String.valueOf(this.getClass().getSimpleName()) + ": " + message);
                    }
                }
            }
        }
        if (this.nodeToLookFor instanceof MethodNode && ((MethodNode)this.nodeToLookFor).hasDefaultValue()) {
            ntlf = this.nodeToLookFor;
            rn = this.requestedNode;
            try {
                if (this.nodeToLookFor instanceof ConstructorNode) {
                    nodes = result.declaringType.getDeclaredConstructors().stream().filter((Predicate<ConstructorNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$0(org.codehaus.groovy.ast.ASTNode org.codehaus.groovy.ast.ConstructorNode ), (Lorg/codehaus/groovy/ast/ConstructorNode;)Z)((ASTNode)ntlf));
                } else {
                    methodName = ((MethodNode)this.nodeToLookFor).getName();
                    nodes = result.declaringType.getDeclaredMethods(methodName).stream().filter((Predicate<MethodNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$1(org.codehaus.groovy.ast.ASTNode org.codehaus.groovy.ast.MethodNode ), (Lorg/codehaus/groovy/ast/MethodNode;)Z)((ASTNode)ntlf));
                }
                var9_21 = (TypeLookupResult[])nodes.map((Function<MethodNode, TypeLookupResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$2(org.eclipse.jdt.groovy.search.TypeLookupResult org.codehaus.groovy.ast.MethodNode ), (Lorg/codehaus/groovy/ast/MethodNode;)Lorg/eclipse/jdt/groovy/search/TypeLookupResult;)((TypeLookupResult)result)).toArray((IntFunction<TypeLookupResult[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$3(int ), (I)[Lorg/eclipse/jdt/groovy/search/TypeLookupResult;)());
                var8_22 = var9_21.length;
                var7_27 = 0;
                while (var7_27 < var8_22) {
                    tlr = var9_21[var7_27];
                    this.nodeToLookFor = tlr.declaration;
                    this.handleMatch(tlr, enclosingElement);
                    ++var7_27;
                }
            }
            finally {
                this.nodeToLookFor = ntlf;
                this.requestedNode = rn;
            }
        }
    }

    private String checkQualifiedType(TypeLookupResult result, IJavaElement enclosingElement) throws JavaModelException {
        if (result.declaration instanceof ClassNode || result.declaration instanceof ImportNode || result.declaration instanceof ConstructorNode) {
            ClassNode type = result.type;
            if (result.declaration instanceof ImportNode) {
                type = ((ImportNode)result.declaration).getType();
            }
            int typeStart = this.startOffset(type);
            int typeEnd = this.endOffset(type);
            type = GroovyUtils.getBaseType((ClassNode)type);
            if (typeStart >= 0 && typeEnd > typeStart) {
                String gunitSource = this.gunit.getSource();
                if (typeEnd == gunitSource.length() + 1) {
                    typeEnd = gunitSource.length();
                } else if (typeEnd > gunitSource.length()) {
                    return null;
                }
                String source = gunitSource.substring(typeStart, typeEnd);
                int nameStart = typeStart + source.indexOf(GroovyUtils.splitName((ClassNode)type)[1]);
                if (nameStart > typeStart && nameStart > this.selectRegion.getEnd() && this.selectRegion.getEnd() > typeStart) {
                    String selected = gunitSource.substring(typeStart, this.selectRegion.getEnd());
                    selected = selected.replaceAll("\\.$", "");
                    String qualifier = GroovyUtils.splitName((ClassNode)type)[0].replace('$', '.');
                    Pattern pattern = Pattern.compile("^" + Pattern.quote(selected) + "\\p{javaJavaIdentifierPart}*");
                    Matcher matcher = pattern.matcher(qualifier);
                    if (matcher.find()) {
                        return matcher.group();
                    }
                    pattern = Pattern.compile("\\b" + Pattern.quote(selected) + "(?:\\b|$)");
                    matcher = pattern.matcher(qualifier);
                    if (matcher.find()) {
                        return qualifier.substring(0, matcher.end());
                    }
                    ImportNode alias = this.findImportAlias(selected, enclosingElement);
                    if (alias != null && (matcher = (pattern = Pattern.compile("\\b" + Pattern.quote(selected = selected.replace(alias.getAlias(), alias.getType().getNameWithoutPackage())) + "(?:\\b|$)")).matcher(qualifier)).find()) {
                        return qualifier.substring(0, matcher.end());
                    }
                }
            }
        }
        return null;
    }

    private ClassNode findDeclaringType(TypeLookupResult result) {
        ClassNode declaringType = null;
        if (result.declaringType != null) {
            declaringType = result.declaringType;
        } else if (result.declaration instanceof ClassNode) {
            declaringType = GroovyUtils.getBaseType((ClassNode)((ClassNode)result.declaration));
        } else if (result.declaration instanceof FieldNode) {
            declaringType = ((FieldNode)result.declaration).getDeclaringClass();
        } else if (result.declaration instanceof MethodNode) {
            declaringType = ((MethodNode)result.declaration).getDeclaringClass();
        } else if (result.declaration instanceof PropertyNode) {
            declaringType = ((PropertyNode)result.declaration).getDeclaringClass();
        } else if (result.declaration instanceof ImportNode) {
            declaringType = ((ImportNode)result.declaration).getType();
        } else if (result.declaration instanceof DeclarationExpression) {
            declaringType = GroovyUtils.getBaseType((ClassNode)((DeclarationExpression)result.declaration).getLeftExpression().getType());
        }
        return declaringType;
    }

    private ImportNode findImportAlias(String name, IJavaElement enclosingElement) {
        IJavaElement elem = enclosingElement;
        while (!(elem instanceof GroovyCompilationUnit)) {
            elem = elem.getParent();
        }
        int dot = name.indexOf(46);
        return ((GroovyCompilationUnit)elem).getModuleNode().getImport(dot < 0 ? name : name.substring(0, dot));
    }

    private ITypeParameter findTypeParam(String name, IJavaElement enclosingElement) throws JavaModelException {
        ITypeParameter typeParam = null;
        if (enclosingElement instanceof IType) {
            ITypeParameter[] iTypeParameterArray = ((IType)enclosingElement).getTypeParameters();
            int n = iTypeParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeParameter tp = iTypeParameterArray[n2];
                if (tp.getElementName().equals(name)) {
                    typeParam = tp;
                    break;
                }
                ++n2;
            }
        } else if (enclosingElement instanceof IMethod) {
            ITypeParameter[] iTypeParameterArray = ((IMethod)enclosingElement).getTypeParameters();
            int n = iTypeParameterArray.length;
            int n3 = 0;
            while (n3 < n) {
                ITypeParameter tp = iTypeParameterArray[n3];
                if (tp.getElementName().equals(name)) {
                    typeParam = tp;
                    break;
                }
                ++n3;
            }
        }
        if (typeParam == null && enclosingElement.getParent() != null) {
            typeParam = this.findTypeParam(name, enclosingElement.getParent());
        }
        return typeParam;
    }

    private IJavaElement findRequestedElement(ASTNode declaration, ClassNode declaringType, IType jdtDeclaringType) throws JavaModelException {
        IType maybeRequested = null;
        if (declaration instanceof ClassNode) {
            maybeRequested = jdtDeclaringType;
        } else if (jdtDeclaringType.getTypeRoot() != null) {
            PropertyNode node;
            String name = null;
            if (declaration instanceof PropertyNode) {
                node = (PropertyNode)declaration;
                name = node.getName();
                if (this.nodeToLookFor instanceof VariableExpression && ((VariableExpression)this.nodeToLookFor).getAccessedVariable() != declaration && ((VariableExpression)this.nodeToLookFor).getAccessedVariable() instanceof ASTNode) {
                    declaration = (ASTNode)((VariableExpression)this.nodeToLookFor).getAccessedVariable();
                } else if (this.existsOnlyInGroovyModel(node.getField(), name, declaringType, jdtDeclaringType)) {
                    assert (jdtDeclaringType instanceof SourceType);
                    return jdtDeclaringType.getField(name);
                }
            }
            if (declaration instanceof FieldNode) {
                node = (FieldNode)declaration;
                name = node.getName();
                for (AnnotationNode anno : node.getAnnotations()) {
                    if (!anno.getClassNode().getNameWithoutPackage().equals("Lazy") || name.charAt(0) != '$') continue;
                    name = name.substring(1);
                }
                if (this.existsOnlyInGroovyModel((FieldNode)node, name, declaringType, jdtDeclaringType)) {
                    assert (jdtDeclaringType instanceof SourceType);
                    return jdtDeclaringType.getField(name);
                }
            } else if (declaration instanceof MethodNode) {
                node = (MethodNode)declaration;
                name = node.getName();
                if ("<init>".equals(name)) {
                    name = jdtDeclaringType.getElementName();
                }
                if (this.existsOnlyInGroovyModel((MethodNode)node, name, declaringType, jdtDeclaringType)) {
                    assert (jdtDeclaringType instanceof SourceType);
                    return jdtDeclaringType.getMethod(name, GroovyUtils.getParameterTypeSignatures((MethodNode)node, (boolean)true));
                }
            }
            if (declaration.getEnd() > 0 && name != null) {
                int start = declaration.getStart();
                int until = declaration.getEnd();
                IJavaElement[] iJavaElementArray = jdtDeclaringType.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    ISourceRange range = ((ISourceReference)child).getSourceRange();
                    if (range.getOffset() <= start && range.getOffset() + range.getLength() >= until && child.getElementName().equals(name)) {
                        maybeRequested = child;
                        break;
                    }
                    if (start + until < range.getOffset()) break;
                    ++n2;
                }
            }
            if (maybeRequested == null) {
                if (name != null) {
                    Parameter[] parameters = null;
                    if (declaration instanceof MethodNode) {
                        name = ((MethodNode)declaration).getName();
                        parameters = declaration instanceof MethodNodeWithNamedParams ? ((MethodNodeWithNamedParams)declaration).getPositionalParams() : ((MethodNode)declaration).getParameters();
                    }
                    maybeRequested = CodeSelectRequestor.findElement(jdtDeclaringType, name, parameters);
                }
                if (maybeRequested == null) {
                    maybeRequested = jdtDeclaringType;
                }
            }
        }
        return maybeRequested;
    }

    private boolean existsOnlyInGroovyModel(FieldNode node, String name, ClassNode declaringType, IType jdtDeclaringType) throws JavaModelException {
        if (node.getEnd() > 0 && node.getDeclaringClass().isScript()) {
            return true;
        }
        if (!node.isFinal() && !node.isStatic() && Traits.isTrait((ClassNode)node.getDeclaringClass())) {
            return true;
        }
        List traitFields = (List)declaringType.redirect().getNodeMetaData((Object)"trait.fields");
        if (traitFields != null) {
            for (FieldNode traitField : traitFields) {
                if (traitField != node) continue;
                return true;
            }
        }
        if (node.getEnd() < 1 && !(node instanceof JDTFieldNode) && declaringType.getField(name) != null && CodeSelectRequestor.findElement(jdtDeclaringType, name, null) == null) {
            return true;
        }
        return GroovyUtils.isAnonymous((ClassNode)node.getDeclaringClass());
    }

    private boolean existsOnlyInGroovyModel(MethodNode node, String name, ClassNode declaringType, IType jdtDeclaringType) throws JavaModelException {
        List traitMethods = (List)declaringType.redirect().getNodeMetaData((Object)"trait.methods");
        if (traitMethods != null) {
            for (MethodNode traitMethod : traitMethods) {
                if (traitMethod != node) continue;
                return true;
            }
        }
        if (node.getEnd() < 1 && !(node instanceof JDTMethodNode) && !declaringType.getMethods(name).isEmpty() && CodeSelectRequestor.findElement(jdtDeclaringType, name, node.getParameters()) == null) {
            return true;
        }
        return GroovyUtils.isAnonymous((ClassNode)node.getDeclaringClass());
    }

    private boolean isSelectionInArguments(ConstructorCallExpression expr) {
        List args;
        int selectOffset = this.selectRegion.getOffset();
        int startOffset = Integer.MAX_VALUE;
        if (expr.getArguments().getStart() > 0) {
            startOffset = expr.getArguments().getStart();
        } else if (expr.getArguments() instanceof TupleExpression && !(args = ((TupleExpression)expr.getArguments()).getExpressions()).isEmpty() && ((Expression)args.get(0)).getStart() > 0) {
            startOffset = ((Expression)args.get(0)).getStart();
        }
        return selectOffset >= startOffset;
    }

    private IJavaElement resolveRequestedElement(IJavaElement maybeRequested, TypeLookupResult result) {
        IJavaElement candidate;
        AnnotatedNode declaration = (AnnotatedNode)result.declaration;
        if (declaration instanceof PropertyNode) {
            if (maybeRequested.getElementType() == 9) {
                String methodName = maybeRequested.getElementName();
                List methods = declaration.getDeclaringClass().getMethods(methodName);
                if (!methods.isEmpty()) {
                    declaration = (AnnotatedNode)methods.get(0);
                }
            } else {
                declaration = ((PropertyNode)declaration).getField();
            }
        } else if (declaration instanceof ConstructorNode && maybeRequested.getElementType() == 7) {
            declaration = declaration.getDeclaringClass();
        }
        String uniqueKey = CodeSelectRequestor.createUniqueKey(declaration, maybeRequested, result);
        switch (maybeRequested.getElementType()) {
            case 8: {
                if (maybeRequested.isReadOnly()) {
                    candidate = new GroovyResolvedBinaryField((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), uniqueKey, result.extraDoc, (ASTNode)declaration);
                    break;
                }
                candidate = new GroovyResolvedSourceField((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), uniqueKey, result.extraDoc, (ASTNode)declaration);
                break;
            }
            case 9: {
                if (maybeRequested.isReadOnly()) {
                    candidate = new GroovyResolvedBinaryMethod((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), ((IMethod)maybeRequested).getParameterTypes(), uniqueKey, result.extraDoc, (ASTNode)declaration);
                    break;
                }
                candidate = new GroovyResolvedSourceMethod((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), ((IMethod)maybeRequested).getParameterTypes(), uniqueKey, result.extraDoc, (ASTNode)declaration);
                break;
            }
            case 7: {
                if (maybeRequested.isReadOnly()) {
                    candidate = new GroovyResolvedBinaryType((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), uniqueKey, result.extraDoc, (ASTNode)declaration);
                    break;
                }
                candidate = new GroovyResolvedSourceType((JavaElement)maybeRequested.getParent(), maybeRequested.getElementName(), uniqueKey, result.extraDoc, (ASTNode)declaration);
                break;
            }
            default: {
                candidate = maybeRequested;
            }
        }
        return candidate;
    }

    private static String createUniqueKey(AnnotatedNode declaration, IJavaElement maybeRequested, TypeLookupResult result) {
        ClassNode resolvedDeclaringType = result.declaringType;
        if (resolvedDeclaringType == null && (resolvedDeclaringType = declaration.getDeclaringClass()) == null) {
            resolvedDeclaringType = VariableScope.OBJECT_CLASS_NODE;
        }
        if (resolvedDeclaringType.getGenericsTypes() != null) {
            boolean isStatic = false;
            if (declaration instanceof ClassNode) {
                isStatic = Flags.isStatic((int)((ClassNode)declaration).getModifiers());
            } else if (declaration instanceof FieldNode) {
                isStatic = ((FieldNode)declaration).isStatic();
            } else if (declaration instanceof MethodNode) {
                isStatic = ((MethodNode)declaration).isStatic();
            }
            if (isStatic) {
                resolvedDeclaringType = resolvedDeclaringType.getPlainNodeReference();
            }
        }
        StringBuilder sb = new StringBuilder();
        if (declaration instanceof ClassNode) {
            CodeSelectRequestor.appendUniqueKeyForResolvedType(sb, result.type);
        } else {
            GenericsType[] typeParams;
            String declType = GroovyUtils.getTypeSignatureWithoutGenerics((ClassNode)resolvedDeclaringType, (boolean)true, (boolean)true).replace('.', '/');
            sb.append(declType);
            if (resolvedDeclaringType.isPrimaryClassNode() && (typeParams = resolvedDeclaringType.getGenericsTypes()) != null) {
                sb.setCharAt(sb.length() - 1, '<');
                GenericsType[] genericsTypeArray = typeParams;
                int n = typeParams.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericsType tp = genericsTypeArray[n2];
                    sb.append('T').append(tp.getName()).append(';');
                    ++n2;
                }
                sb.append('>').append(';');
            }
            if (declaration instanceof FieldNode) {
                sb.append('.').append(maybeRequested.getElementName()).append(')');
                CodeSelectRequestor.appendUniqueKeyForResolvedType(sb, result.type);
            } else if (declaration instanceof MethodNode) {
                MethodNode node = (MethodNode)declaration;
                if (maybeRequested.getElementType() == 8) {
                    sb.append('.').append(maybeRequested.getElementName()).append(')');
                    CodeSelectRequestor.appendUniqueKeyForResolvedType(sb, AccessorSupport.isSetter((MethodNode)node) ? node.getParameters()[0].getType() : result.type);
                } else {
                    int p;
                    CodeSelectRequestor.appendUniqueKeyForMethod(sb, node, result.type, resolvedDeclaringType);
                    String q = String.valueOf(declType) + ':';
                    do {
                        if ((p = sb.indexOf(q)) <= 0) continue;
                        sb.replace(p, p + q.length(), "");
                    } while (p > 0);
                }
            }
        }
        return sb.toString();
    }

    private static void appendUniqueKeyForMethod(StringBuilder sb, MethodNode node, ClassNode returnType, ClassNode declaringType) {
        Parameter[] parameters;
        int n;
        String methodName = node.getName();
        if ("<init>".equals(methodName)) {
            methodName = node.getDeclaringClass().getNameWithoutPackage();
        }
        if (methodName.indexOf(36) != methodName.lastIndexOf(36)) {
            methodName = methodName.replace('$', '_');
        }
        sb.append('.').append(methodName);
        Function<ClassNode, String> signer = type -> GroovyUtils.getTypeSignature((ClassNode)type, (boolean)true, (boolean)true).replace('.', '/');
        GenericsType[] generics = GroovyUtils.getGenericsTypes((MethodNode)node);
        if (generics.length > 0) {
            sb.append('<');
            GenericsType[] genericsTypeArray = generics;
            n = generics.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gt = genericsTypeArray[n2];
                ClassNode lower = gt.getLowerBound();
                ClassNode[] upper = gt.getUpperBounds();
                sb.append(gt.getName());
                sb.append(':');
                sb.append(':');
                if (lower != null) {
                    sb.append(signer.apply(lower));
                } else if (upper != null && upper.length > 0) {
                    int i = 0;
                    while (i < upper.length) {
                        if (i > 0) {
                            sb.append(':');
                        }
                        sb.append(signer.apply(upper[i]));
                        ++i;
                    }
                }
                ++n2;
            }
            sb.append('>');
        }
        sb.append('(');
        Parameter[] parameterArray = parameters = node instanceof MethodNodeWithNamedParams ? ((MethodNodeWithNamedParams)node).getPositionalParams() : node.getParameters();
        int n3 = parameters.length;
        n = 0;
        while (n < n3) {
            Parameter p = parameterArray[n];
            sb.append(signer.apply(p.getType()));
            ++n;
        }
        sb.append(')');
        sb.append(signer.apply(returnType));
        if (generics.length > 0) {
            GenericsMapper mapper = GenericsMapper.gatherGenerics((List)GroovyUtils.getParameterTypes((Parameter[])parameters), (ClassNode)declaringType, (MethodNode)node.getOriginal(), (GenericsType[])new GenericsType[0]);
            sb.append('%');
            sb.append('<');
            GenericsType[] genericsTypeArray = generics;
            int n4 = generics.length;
            n3 = 0;
            while (n3 < n4) {
                GenericsType gt = genericsTypeArray[n3];
                gt = VariableScope.clone((GenericsType)gt, (int)0);
                ClassNode rt = VariableScope.resolveTypeParameterization((GenericsMapper)mapper, (GenericsType)gt, (ClassNode)gt.getType());
                sb.append(GroovyUtils.getTypeSignatureWithoutGenerics((ClassNode)rt, (boolean)true, (boolean)true).replace('.', '/'));
                ++n3;
            }
            sb.append('>');
        }
        if (node.getExceptions() != null) {
            ClassNode[] classNodeArray = node.getExceptions();
            n3 = classNodeArray.length;
            int n5 = 0;
            while (n5 < n3) {
                ClassNode exception = classNodeArray[n5];
                sb.append('|').append(signer.apply(exception));
                ++n5;
            }
        }
    }

    private static void appendUniqueKeyForResolvedType(StringBuilder sb, ClassNode resolvedType) {
        GenericsType[] generics;
        String signature = GroovyUtils.getTypeSignatureWithoutGenerics((ClassNode)resolvedType, (boolean)true, (boolean)true).replace('.', '/');
        sb.append(signature);
        ClassNode baseType = GroovyUtils.getBaseType((ClassNode)resolvedType);
        if (!baseType.isGenericsPlaceHolder() && (generics = baseType.getGenericsTypes()) != null) {
            sb.setCharAt(sb.length() - 1, '<');
            int i = 0;
            int n = generics.length;
            while (i < n) {
                GenericsType gt = generics[i];
                if (!gt.isWildcard()) {
                    CodeSelectRequestor.appendUniqueKeyForResolvedType(sb, gt.getType());
                } else {
                    sb.append(signature).append('{').append(i).append('}');
                    if (gt.getLowerBound() != null) {
                        sb.append('-');
                        CodeSelectRequestor.appendUniqueKeyForResolvedType(sb, gt.getLowerBound());
                    } else if (gt.getUpperBounds() != null && gt.getUpperBounds().length == 1) {
                        sb.append('+');
                        CodeSelectRequestor.appendUniqueKeyForResolvedType(sb, gt.getUpperBounds()[0]);
                    } else {
                        sb.append('*');
                    }
                }
                ++i;
            }
            sb.append('>').append(';');
        }
    }

    private static IJavaElement findElement(IType type, String text, Parameter[] parameters) throws JavaModelException {
        String prefix;
        if (text.equals(type.getElementName())) {
            return type;
        }
        if ("<init>".equals(text)) {
            text = type.getElementName();
        }
        StringBuilder checked = new StringBuilder();
        IMethod closestMatch = null;
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals(text)) {
                    closestMatch = method;
                    if (parameters != null && parameters.length == method.getParameterTypes().length) {
                        checked.append("\n\t").append(text).append('(');
                        int i = 0;
                        int n3 = parameters.length;
                        while (i < n3) {
                            String jdtMethodParam = Signature.getTypeErasure((String)method.getParameterTypes()[i]);
                            String astMethodParam = GroovyUtils.getTypeSignatureWithoutGenerics((ClassNode)parameters[i].getOriginType(), (jdtMethodParam.indexOf(46) > 0 ? 1 : 0) != 0, (boolean)type.isBinary());
                            checked.append(jdtMethodParam).append(' ');
                            if (astMethodParam.equals(jdtMethodParam)) {
                                ++i;
                                continue;
                            }
                            break block14;
                        }
                        return method;
                    }
                }
            }
            ++n2;
        }
        if (closestMatch != null) {
            String message = String.format("CodeSelectRequestor.findElement: no exact match found for %s(%s); options considered:%s", text, parameters == null ? "" : GroovyUtils.getParameterTypes((Parameter[])parameters), checked);
            if (GroovyLogManager.manager.hasLoggers()) {
                GroovyLogManager.manager.log(TraceCategory.CODE_SELECT, message);
            } else {
                System.err.println(message);
            }
            return closestMatch;
        }
        IField field = type.getField(text);
        if (!field.exists() && (prefix = CodeSelectRequestor.extractPrefix(text)) != null) {
            String newName = Introspector.decapitalize(text.substring(prefix.length()));
            field = type.getField(newName);
        }
        if (field.exists()) {
            return field;
        }
        String isMethod = AccessorSupport.ISSER.createAccessorName(text);
        String getMethod = AccessorSupport.GETTER.createAccessorName(text);
        String setMethod = AccessorSupport.SETTER.createAccessorName(text);
        IMethod[] iMethodArray2 = type.getMethods();
        int n4 = iMethodArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            IMethod method = iMethodArray2[n5];
            String methodName = method.getElementName();
            if (methodName.equals(isMethod) || methodName.equals(getMethod) || methodName.equals(setMethod)) {
                return method;
            }
            ++n5;
        }
        return null;
    }

    private static String extractPrefix(String text) {
        if (text.startsWith("is")) {
            if (text.length() > 2) {
                return "is";
            }
        } else if (text.startsWith("get")) {
            if (text.length() > 3) {
                return "get";
            }
        } else if (text.startsWith("set") && text.length() > 3) {
            return "set";
        }
        return null;
    }

    private int startOffset(ClassNode type) {
        int start = type.getStart();
        if (type.getEnd() < 1) {
            start = this.nodeRegion != null ? this.nodeRegion.getOffset() : this.nodeToLookFor.getStart();
        }
        return start;
    }

    private int endOffset(ClassNode type) {
        int end = type.getEnd();
        if (end < 1) {
            end = this.nodeRegion != null ? this.nodeRegion.getEnd() : this.nodeToLookFor.getEnd();
        }
        return end;
    }

    private Object typeOf(ASTNode node) {
        if (node instanceof ClassNode) {
            return ((ClassNode)node).getNameWithoutPackage();
        }
        return node.getClass();
    }

    private static /* synthetic */ boolean lambda$0(ASTNode aSTNode, ConstructorNode cn) {
        return cn != aSTNode && cn.getOriginal() == aSTNode;
    }

    private static /* synthetic */ boolean lambda$1(ASTNode aSTNode, MethodNode mn) {
        return mn != aSTNode && mn.getOriginal() == aSTNode;
    }

    private static /* synthetic */ TypeLookupResult lambda$2(TypeLookupResult typeLookupResult, MethodNode mn) {
        return new TypeLookupResult(typeLookupResult.type, typeLookupResult.declaringType, (ASTNode)mn, typeLookupResult);
    }

    private static /* synthetic */ TypeLookupResult[] lambda$3(int n) {
        return new TypeLookupResult[n];
    }
}

