/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.folder.dialogs;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewRootFolderDialog
extends CustomTitleAreaDialog {
    private Text txtName;
    private String name;
    private List<String> siblingFileNames;

    public NewRootFolderDialog(Shell parentShell) {
        super(parentShell);
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        try {
            this.siblingFileNames = FolderController.getInstance().getRootFileOrFolderNames(project);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            this.siblingFileNames = new ArrayList<String>();
        }
    }

    protected Composite createContentArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new GridLayout(2, false));
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblName = new Label(body, 0);
        lblName.setLayoutData((Object)new GridData(16384, 128, false, false));
        lblName.setText(GlobalMessageConstants.NAME);
        this.txtName = new Text(body, 2048);
        this.txtName.setLayoutData((Object)new GridData(4, 128, true, false));
        return body;
    }

    protected void registerControlModifyListeners() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewRootFolderDialog.this.checkNewName(NewRootFolderDialog.this.txtName.getText());
            }
        });
    }

    private void checkNewName(String newName) {
        if (this.isNameDuplicated(newName)) {
            this.setMessage(StringConstants.DIA_NAME_EXISTED, 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        try {
            EntityNameController.getInstance().validateName(newName);
            this.setMessage(StringConstants.DIA_MSG_CREATE_NEW_FOLDER, 1);
            this.getButton(0).setEnabled(true);
        }
        catch (Exception e) {
            this.setMessage(e.getMessage(), 3);
            this.getButton(0).setEnabled(false);
        }
    }

    private boolean isNameDuplicated(String newName) {
        return this.siblingFileNames.stream().filter(n -> n.equalsIgnoreCase(newName)).findAny().isPresent();
    }

    protected void setInput() {
        this.txtName.setText(this.getSuggestion("New Folder"));
        this.setMessage(StringConstants.DIA_MSG_CREATE_NEW_FOLDER, 1);
    }

    private String getSuggestion(String suggestion) {
        String newName = String.format("%s", suggestion);
        int index = 0;
        while (this.isNameDuplicated(newName)) {
            newName = String.format("%s %d", suggestion, ++index);
        }
        return newName;
    }

    protected void okPressed() {
        this.name = this.txtName.getText();
        super.okPressed();
    }

    public String getNewFolderName() {
        return this.name;
    }

    protected Point getInitialSize() {
        return new Point(400, 250);
    }
}

