/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.components;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.components.AbstractKeywordNodeTooltip;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.util.TypeUtil;
import com.kms.katalon.util.jdt.JdtUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.infoviews.JavadocView;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class CustomKeywordNodeTooltip
extends AbstractKeywordNodeTooltip
implements IPropertyChangeListener {
    private static final long LABEL_FLAGS = 4787310288012503L;
    private BrowserInformationControl iControl;
    private String fgStyleSheet;
    private String keywordClass;
    private String keywordName;
    private String[] parameterTypes;

    public CustomKeywordNodeTooltip(Control control, String keywordName, String[] parameterTypes) {
        this.control = control;
        this.keywordClass = "CustomKeywords";
        this.keywordName = keywordName;
        this.parameterTypes = parameterTypes;
    }

    @Override
    protected void initComponents(Composite parent) {
        String font = "org.eclipse.jdt.ui.javadocfont";
        this.iControl = new BrowserInformationControl(this.tip, font, ""){

            public IInformationControlCreator getInformationPresenterControlCreator() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage activePage = activeWindow.getActivePage();
                IWorkbenchPart activePart = activePage.getActivePart();
                return new JavadocHover.PresenterControlCreator((IWorkbenchSite)activePart.getSite());
            }

            public boolean isResizable() {
                return true;
            }
        };
        this.iControl.setInput((Object)this.getHoverInfo());
        this.iControl.setLocation(this.location);
        this.iControl.setVisible(true);
        Point size = this.getBestSizeForKeywordDescriptionPopup();
        this.iControl.setSize(size.x, size.y);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        CustomKeywordNodeTooltip.addLinkListener(this.iControl);
    }

    private BrowserInformationControlInput getHoverInfo() {
        String content;
        StringBuffer buffer = new StringBuffer();
        IMethod method = this.getKeywordMethod();
        if (method != null) {
            HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)this.getInfoText((IJavaElement)method, true));
            buffer.append("<br>");
        }
        StringReader reader = null;
        try {
            content = JavadocContentAccess2.getHTMLContent((IJavaElement)method, (boolean)true);
        }
        catch (CoreException e) {
            LoggerSingleton.logError((Throwable)e);
            content = "";
        }
        if (content != null) {
            reader = new StringReader(content);
            HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
        }
        if (buffer.length() > 0) {
            ColorRegistry registry = JFaceResources.getColorRegistry();
            RGB fgRGB = registry.getRGB("org.eclipse.jdt.ui.Javadoc.foregroundColor");
            RGB bgRGB = registry.getRGB("org.eclipse.jdt.ui.Javadoc.backgroundColor");
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (RGB)fgRGB, (RGB)bgRGB, (String)this.getStyleSheet());
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            final String javadoc = buffer.toString();
            return new JavadocBrowserInformationControlInput(null, (IJavaElement)method, javadoc, 200){

                public String getHtml() {
                    return javadoc;
                }

                public Object getInputElement() {
                    return javadoc;
                }

                public String getInputName() {
                    return "";
                }

                public int getLeadingImageWidth() {
                    return 20;
                }
            };
        }
        return null;
    }

    private static void addLinkListener(final BrowserInformationControl browserInfoControl) {
        browserInfoControl.addLocationListener(JavaElementLinks.createLocationListener((JavaElementLinks.ILinkHandler)new JavaElementLinks.ILinkHandler(){

            public void handleJavadocViewLink(IJavaElement linkTarget) {
                browserInfoControl.notifyDelayedInputChange(null);
                browserInfoControl.setVisible(false);
                browserInfoControl.dispose();
                try {
                    JavadocView view = (JavadocView)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.JavadocView");
                    view.setInput(linkTarget);
                }
                catch (PartInitException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            public void handleInlineJavadocLink(IJavaElement linkTarget) {
                JavadocBrowserInformationControlInput hoverInfo = JavadocHover.getHoverInfo((IJavaElement[])new IJavaElement[]{linkTarget}, null, null, (JavadocBrowserInformationControlInput)((JavadocBrowserInformationControlInput)browserInfoControl.getInput()));
                if (browserInfoControl.hasDelayedInputChangeListener()) {
                    browserInfoControl.notifyDelayedInputChange((Object)hoverInfo);
                } else {
                    browserInfoControl.setInput((Object)hoverInfo);
                }
            }

            public void handleDeclarationLink(IJavaElement linkTarget) {
                browserInfoControl.notifyDelayedInputChange(null);
                browserInfoControl.dispose();
                try {
                    CustomKeywordNodeTooltip.openDeclaration(linkTarget);
                }
                catch (PartInitException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                catch (JavaModelException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            public boolean handleExternalLink(URL url, Display display) {
                browserInfoControl.notifyDelayedInputChange(null);
                browserInfoControl.dispose();
                OpenBrowserUtil.open((URL)url, (Display)display);
                return true;
            }

            public void handleTextSet() {
            }
        }));
    }

    public static IEditorPart openDeclaration(IJavaElement element) throws PartInitException, JavaModelException {
        Object[] nonJavaResources;
        if (!(element instanceof IPackageFragment)) {
            return JavaUI.openInEditor((IJavaElement)element);
        }
        IPackageFragment packageFragment = (IPackageFragment)element;
        IPackageFragmentRoot root = (IPackageFragmentRoot)packageFragment.getAncestor(3);
        Object typeRoot = root.getKind() == 2 ? packageFragment.getClassFile("package-info.class") : packageFragment.getCompilationUnit("package-info.java");
        if (typeRoot.exists()) {
            return JavaUI.openInEditor((IJavaElement)typeRoot);
        }
        Object[] objectArray = nonJavaResources = packageFragment.getNonJavaResources();
        int n = nonJavaResources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            Object nonJavaResource = objectArray[n2];
            if (nonJavaResource instanceof IFile && (file = (IFile)nonJavaResource).exists() && "package.html".equals(file.getName())) {
                return EditorUtility.openInEditor((Object)file, (boolean)true);
            }
            ++n2;
        }
        PackageExplorerPart view = (PackageExplorerPart)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.PackageExplorer");
        view.tryToReveal((Object)packageFragment);
        return null;
    }

    private IMethod getKeywordMethod() {
        try {
            IProject project = GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject());
            IMethod method = JdtUtil.findMethodWithLooseParamTypesMatching((IProject)project, (String)this.keywordClass, (String)this.keywordName, (String[])TypeUtil.toReadableTypes((String[])this.parameterTypes));
            if (method == null) {
                method = JdtUtil.findMethod((IProject)project, (String)this.keywordClass, (String)this.keywordName, (int)this.parameterTypes.length);
            }
            return method;
        }
        catch (IllegalArgumentException | ExecutionException | JavaModelException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    private String getInfoText(IJavaElement element, boolean allowImage) {
        long flags = 4787310288012503L;
        StringBuffer label = new StringBuffer(JavaElementLinks.getElementLabel((IJavaElement)element, (long)flags));
        return this.getImageAndLabel(element, allowImage, label.toString());
    }

    public String getImageAndLabel(IJavaElement element, boolean allowImage, String label) {
        String imageSrcPath;
        StringBuilder buf = new StringBuilder();
        int imageWidth = 16;
        int imageHeight = 16;
        int labelLeft = 20;
        int labelTop = 2;
        buf.append("<div style='word-wrap: break-word; position: relative; ");
        String string = imageSrcPath = allowImage ? this.getImageURL(element) : null;
        if (imageSrcPath != null) {
            buf.append("margin-left: ").append(labelLeft).append("px; ");
            buf.append("padding-top: ").append(labelTop).append("px; ");
        }
        buf.append("'>");
        if (imageSrcPath != null) {
            if (element != null) {
                try {
                    String uri = JavaElementLinks.createURI((String)"eclipse-open", (IJavaElement)element);
                    buf.append("<a href='").append(uri).append("'>");
                }
                catch (URISyntaxException uRISyntaxException) {
                    element = null;
                }
            }
            StringBuffer imageStyle = new StringBuffer("border:none; position: absolute; ");
            imageStyle.append("width: ").append(imageWidth).append("px; ");
            imageStyle.append("height: ").append(imageHeight).append("px; ");
            imageStyle.append("left: ").append(-labelLeft - 1).append("px; ");
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            String tooltip = element == null ? "" : "alt='" + ComposerTestcaseMessageConstants.JavadocHover_openDeclaration + "' ";
            buf.append("<span ").append(tooltip).append("style=\"").append(imageStyle).append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(imageSrcPath).append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img ").append(tooltip).append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img ").append(tooltip).append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<![endif]-->\n");
            if (element != null) {
                buf.append("</a>");
            }
        }
        buf.append(label);
        buf.append("</div>");
        return buf.toString();
    }

    private String getImageURL(IJavaElement element) {
        String imageName = null;
        URL imageUrl = JavaPlugin.getDefault().getImagesOnFSRegistry().getImageURL(element);
        if (imageUrl != null) {
            imageName = imageUrl.toExternalForm();
        }
        return imageName;
    }

    private String getStyleSheet() {
        String css;
        if (this.fgStyleSheet == null) {
            this.fgStyleSheet = CustomKeywordNodeTooltip.loadStyleSheet("/JavadocHoverStyleSheet.css");
        }
        if ((css = this.fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    public static String loadStyleSheet(String styleSheetName) {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry(styleSheetName);
        if (styleSheetURL == null) {
            return null;
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
        StringBuilder buffer = new StringBuilder(1500);
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line);
            buffer.append('\n');
            line = reader.readLine();
        }
        FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
        String string = HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException ex) {
            try {
                LoggerSingleton.logError((Throwable)ex);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return "";
        }
    }

    private void setHoverColors() {
        ColorRegistry registry = JFaceResources.getColorRegistry();
        Color fgRGB = registry.get("org.eclipse.jdt.ui.Javadoc.foregroundColor");
        Color bgRGB = registry.get("org.eclipse.jdt.ui.Javadoc.backgroundColor");
        this.iControl.setForegroundColor(fgRGB);
        this.iControl.setBackgroundColor(bgRGB);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (this.iControl != null && (property.equals("org.eclipse.jdt.ui.Javadoc.foregroundColor") || property.equals("org.eclipse.jdt.ui.Javadoc.backgroundColor"))) {
            this.setHoverColors();
        }
    }

    @Override
    public synchronized void hide() {
        if (this.iControl != null) {
            this.iControl.dispose();
        }
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
    }
}

